/*
SYSTEM SNIFFER - GRAPH.H
Copyright (C) Tero Ripattila 1996-1998
*/

#ifndef _GRAPH_H
#define _GRAPH_H

#ifndef _BASEDEFS_H
	#include "basedefs.h"
#endif
#ifndef _CONIO_H
	#include <conio.h>
#endif
#ifndef _STDIO_H
	#include <stdio.h>
#endif

//
// Some necessary constants and global variables
//
const float PII = 3.141592653589793;
byte chr = 0,at = 0,c = 0,r = 0;

//
// Required prototypes for functions
//
void DrawPixel(byte color,word col,word row);
byte GetVMode(void);
void SetVMode(word mode);
void _SetVMode(byte mode);
void SetXYPosT(byte col,byte row);
void SetXYPosG(byte col,byte row);
byte GetXPosT(void);
byte GetYPosG(void);
byte GetXPosG(void);
void SetCurSize(byte uscl,byte dscl);
void SelDisPage(byte page);
void ScrlScrUp(byte uc,byte ur,byte dc,byte dr,byte attr);
void ScrlScrDown(byte uc,byte ur,byte dc,byte dr,byte attr);
void SetPalette(byte palid);
void CnvDACToGrey(word rnum,word crnum);
void SetDACReg(word rnum,byte green,byte blue,byte red);
void GetDACReg(byte rnum);
void SetBorder(byte col,byte page);
void SetBorder256(byte col);
byte GetBorder(void);
byte StrLen(const byte *Txt);
void SetChAttr( byte x,byte y,byte chr,byte at,word num );
void GetChAttr( byte x,byte y );
void Center( const byte *Txt );
void _Center( byte X1,byte X2,byte row,const byte *Txt );
byte GetYPosT(void);

//
// Put a pixel onto screen
//
void DrawPixel(byte color,word col,word row)
{
	asm	mov ah,0x0c
	asm	mov bh,0x00
	asm	mov al,color
	asm	mov cx,col
	asm	mov dx,row
	asm	int 0x10
}

//
// Get current video mode
//
byte GetVMode(void)
{
	asm	mov ah,0x0F
	asm	int 0x10

	return(_AL);
}

//
// Set current video mode
//
void SetVMode(word mode)
{
	asm	mov ax,mode
	asm	int 0x10
}

//
// Set current video mode
//
void _SetVMode(byte mode)
{
	asm	mov ah,0x00
	asm	mov al,mode
	asm	int 0x10
}

//
// Set a location for the cursor in textmode
//
void SetXYPosT(byte col,byte row)
{
	byte c = 0,r = 0;
	c = col - 1;
	r = row - 1;

	asm	mov ah,0x02
	asm	mov bh,0x00                   // Sivun numero (0 - 3)
	asm	mov dh,r                      // Rivin numero
	asm	mov dl,c                      // Kolumnin numero
	asm	int 0x10
}

//
// Set a location for the cursor in gfx mode
//
void SetXYPosG(byte col,byte row)
{
	asm	mov ah,0x02
	asm	mov bh,0x00                   // Sivun numero (0 - 3)
	asm	mov dh,row                    // Rivin numero
	asm	mov dl,col                    // Kolumnin numero
	asm	int 0x10
}

//
// Get cursor's horizontal location in text mode
//
byte GetXPosT(void)
{
	asm	mov ah,0x03
	asm	mov bh,0x00                   // Sivun numero (0 - 3)
	asm	int 0x10

	return(_DL + 1);
}

//
// Get cursor's horizontal location in gfx mode
//
byte GetXPosG(void)
{
	asm	mov ah,0x04
	asm	mov bh,0x00                   // Sivun numero
	asm	int 0x10

	return(_CL);
}

//
// Get cursor's vertical location in gfx mode
//
byte GetYPosG(void)
{
	asm	mov ah,0x04
	asm	mov bh,0x00                   // Sivun numero
	asm	int 0x10

	return(_CH);
}

//
// Set cursor size in text mode
//
void SetCurSize(byte uscl,byte dscl)
{
	asm	mov ah,0x01
	asm	mov ch,uscl                   // Asetetaan ylrivi
	asm	mov al,dscl                   // Asetetaan alarivi
	asm	int 0x10
}

//
// Select display page in text mode
//
void SelDisPage(byte page)
{
	asm	mov ah,0x05                   // Valitse sivunumero (0 - 3)
	asm	mov al,page
	asm	int 0x10
}

//
// Scroll screen up in text mode
//
void ScrlScrUp(byte uc,byte ur,byte dc,byte dr,byte attr)
{
	byte lines = 0;
	lines = dr - ur;

	asm	mov ah,0x06
	asm	mov al,lines                  // Vieritettvien rivien mr
	asm	mov bh,attr                   // Tyhjien rivien attribuutti
	asm	mov ch,ur                     // Ikkunan vas. ylkulman rivi
	asm	mov cl,uc                     // Ikkunan vas. ylkulman kolumni
	asm	mov dh,dr                     // Ikkunan oik. alakulman rivi
	asm	mov dl,dc                     // Ikkunan oik. alakulman kolumni
	asm	int 0x10
}

//
// Scroll screen down in text mode
//
void ScrlScrDown(byte uc,byte ur,byte dc,byte dr,byte attr)
{
	byte lines = 0;
	lines = dr - ur;

	asm	mov ah,0x07
	asm	mov al,lines                  // Vieritettvien rivien mr
	asm	mov bh,attr                   // Tyhjien rivien attribuutti
	asm	mov ch,ur                     // Ikkunan vas. ylkulman rivi
	asm	mov cl,uc                     // Ikkunan vas. ylkulman kolumni
	asm	mov dh,dr                     // Ikkunan oik. alakulman rivi
	asm	mov dl,dc                     // Ikkunan oik. alakulman kolumni
	asm	int 0x10
}

//
// Set border color for screen in text mode
//
void SetBorder(byte col,byte page)
{
	asm	mov ah,0x0b
	asm	mov bh,page                   // Sivun numero (0 - 3)
	asm	mov bl,col
	asm	int 0x10
}

//
// Set border color for screen in gfx mode
//
void SetBorder256(byte col)
{
	asm	mov ax,0x1001
	asm	mov bh,col
	asm	int 0x10
}

//
// Get border color
//
byte GetBorder(void)
{
	asm	mov ax,0x1008
	asm	int 0x10

	return(_BL);
}

//
// Set DAC register's values
//
void SetDACReg(word rnum,byte green,byte blue,byte red)
{
	asm	mov ax,0x1010
	asm	mov bx,rnum                   // Rekisterin numero
	asm	mov ch,green                  // Uusi vihren arvo (0-63)
	asm	mov cl,blue                   // Uusi sinisen arvo (0-63)
	asm	mov dh,red                    // Uusi punaisen arvo (0-63)
	asm	int 0x10
}

//
// Get DAC register's values
//
void GetDACReg(byte rnum)
{
	byte reg[3] = {0,0,0};

	asm	mov ax,0x1015
	asm	mov bl,rnum
	asm	int 0x10

	reg[0] = _DH;
	reg[1] = _CH;
	reg[2] = _CL;
}

//
// Select palette to be used
//
void SetPalette(byte palid)
{
	asm	mov ah,0x0b
	asm	mov bh,0x01
	asm	mov bl,palid
	asm	int 0x10
}

//
// Convert DAC register's values to greyscale values
//
void CnvDACToGrey(word rnum,word crnum)
{
	asm	mov ax,0x101b
	asm	mov bx,rnum                   // Aloitus paletti-rekisteri
	asm	mov cx,crnum                  // Konvertoitavien rekist. lkm
	asm	int 0x10
}

//
// Count lenght of given string
//
byte StrLen(const byte *Txt)
{
	byte i = 0;

	do {
	 i++;
	 } while(Txt[i] != '\0');

	return(i);
}

//
// Get cursor's vertical location in text mode
//
byte GetYPosT(void)
{
	asm	mov ah,0x03
	asm	mov bh,0x00                   // Sivun numero (0 - 3)
	asm	int 0x10

	return( _DH + 1 );
}

//
// Get attributes of given char in the text mode
//
void GetChAttr(byte x,byte y)
{
	byte c = 0,r = 0;
	at = chr = 0;
	c = x - 1;
	r = y - 1;

	asm	mov ah,0x02                   // Siirrytaan haluttuun kohtaan ruudulla
	asm	mov bh,0x00                   // Sivun numero
	asm	mov dh,r                      // Rivin numero
	asm	mov dl,c                      // Kolumnin numero
	asm	int 0x10

	asm	mov ah,0x08                   // Luetaan merkki/attribuutti kursorin kohdalta
	asm	mov bh,0x00                   // Sivun numero
	asm	int 0x10
	asm	mov at,ah                     // Merkin atribuutti talteen
	asm	mov chr,al                    // Merkki talteen
}

//
// Set attributes for given char in text mode
//
void SetChAttr(byte x,byte y,byte chr,byte at,word num)
{
	byte c = 0,r = 0;
	c = x - 1;
	r = y - 1;

	asm	mov ah,0x02                   // Siirrytaan haluttuun kohtaan ruudulla
	asm	mov bh,0x00                   // Sivun numero
	asm	mov dh,r                      // Rivin numero
	asm	mov dl,c                      // Kolumnin numero
	asm	int 0x10

	asm	mov ah,0x09                   // Laitetaan merkki/attribuutti kursorin kohdalle
	asm	mov al,chr                    // Tulostettava merkki
	asm	mov bh,0x00                   // Sivun numero
	asm	mov bl,at                     // Merkin attribuutti
	asm	mov cx,num                    // Tulostettavien kertojen mr
	asm	int 0x10
}

//
// Center given string in text mode
//
void Center(const byte *Txt)
{
	byte StrLenght = 0,XPos = 0,YPos = 0;

	StrLenght = strlen(Txt);
	XPos = ((80 - StrLenght) / 2) + 1;
	YPos = GetYPosT();

	gotoxy(XPos,YPos);
	 puts( Txt );
	 YPos++;
}

//
// Center given string in given area in text mode
//
void _Center(byte X1,byte X2,byte row,const byte *Txt)
{
	byte StrLenght = 0,XPos = 0;

	StrLenght = strlen(Txt);
	XPos = ((((X2 - X1) - StrLenght) / 2) + 1) + X1;

	gotoxy(XPos,row);
	 cprintf("%s",Txt);
}

#endif
