/*
SYSTEM SNIFFER - COUNTRY.CPP
Copyright (C) Tero Ripattila 1996-1998
*/

struct COUNTRYINFO {
 word DateFormat;                             // Pivmrn muoto
 byte CurSymbolStr[5];                        // Currency symbol string
 byte ThousandSep[2];                         // Tuhat -eroitin
 byte DecimalSep[2];                          // Desimaali -eroitin
 byte DateSep[2];                             // Date -eroitin
 byte TimeSep[2];                             // Time -eroitin
 byte CurForm;                                // Currency format
 byte DigAftDec;                              // Number of digits after decimal in currency
 byte TimeFormat;                             // Kellonajan muoto
 dword CaseMapAdd;                            // Address of case map routine
 byte DataListSep[2];                         // Datalist separator
 };

void SnifferSWare::GetCountryInfo(void)
{
	static const byte *CurDateMsg[3] = { "USA (MM-DD-YY)","Europe (DD-MM-YY)","Japan (YY-MM-DD)" };
	static const byte *CurFormMsg[4] = { "$100.00","100.00$","$ 100.00","100.00 $" };

	byte *Countries[0x3e3];
	word countrycflag = 0;
	COUNTRYINFO CountryInfo;

	for(word a=0x00; a<=0x3E3; a++) Countries[a]="Unknown country";
		  Countries[0x0001]="United States";
		  Countries[0x0002]="Canadian-French";
		  Countries[0x0003]="Latin America";
		  Countries[0x0014]="Egypt";
		  Countries[0x001B]="South Africa";
		  Countries[0x001E]="Greece";
		  Countries[0x001F]="Netherlands";
		  Countries[0x0020]="Belgium";
		  Countries[0x0021]="France";
		  Countries[0x0022]="Spain";
		  Countries[0x0024]="Hungary";
		  Countries[0x0026]="Yugoslavia";
		  Countries[0x0027]="Italy or San Marino or Vatican City";
		  Countries[0x0028]="Romania";
		  Countries[0x0029]="Switzerland or Liechtenstein";
		  Countries[0x002A]="Czechoslovakia or Tjekia";
		  Countries[0x002B]="Austria";
		  Countries[0x002C]="United Kingdom";
		  Countries[0x002D]="Denmark";
		  Countries[0x002E]="Sweden";
		  Countries[0x002F]="Norway";
		  Countries[0x0030]="Poland";
		  Countries[0x0031]="Germany";
		  Countries[0x0033]="Peru";
		  Countries[0x0034]="Mexico";
		  Countries[0x0035]="Cuba";
		  Countries[0x0036]="Argentina";
		  Countries[0x0037]="Brazil";
		  Countries[0x0038]="Chile";
		  Countries[0x0039]="Columbia";
		  Countries[0x003A]="Venezuela";
		  Countries[0x003C]="Malaysia";
		  Countries[0x003D]="Intern. English or Australia";
		  Countries[0x003E]="Indonesia or East Timor";
		  Countries[0x003F]="Philippines";
		  Countries[0x0040]="New Zealand";
		  Countries[0x0041]="Singapore";
		  Countries[0x0051]="Japan";
		  Countries[0x0052]="South Korea";
		  Countries[0x0054]="Vietnam";
		  Countries[0x0056]="China";
		  Countries[0x0058]="Taiwan";
		  Countries[0x005A]="Turkey";
		  Countries[0x005B]="India";
		  Countries[0x005C]="Pakistan";
		  Countries[0x005D]="Afghanistan";
		  Countries[0x005E]="Sri Lanka";
		  Countries[0x0062]="Iran";
		  Countries[0x0063]="Asian English";
		  Countries[0x0070]="Belarus";
		  Countries[0x00C8]="Thailand";
		  Countries[0x00D4]="Morocco";
		  Countries[0x00D5]="Algeria";
		  Countries[0x00D8]="Tunisia";
		  Countries[0x00DA]="Libya";
		  Countries[0x00DC]="Gambia";
		  Countries[0x00DD]="Senegal";
		  Countries[0x00DE]="Maruitania";
		  Countries[0x00DF]="Mali";
		  Countries[0x00E0]="African Guinea";
		  Countries[0x00E1]="Ivory Coast";
		  Countries[0x00E2]="Burkina Faso";
		  Countries[0x00E3]="Niger";
		  Countries[0x00E4]="Togo";
		  Countries[0x00E5]="Benin";
		  Countries[0x00E6]="Mauritius";
		  Countries[0x00E7]="Liberia";
		  Countries[0x00E8]="Sierra Leone";
		  Countries[0x00E9]="Ghana";
		  Countries[0x00EA]="Nigeria";
		  Countries[0x00EB]="Chad";
		  Countries[0x00EC]="Centra African Republic";
		  Countries[0x00ED]="Cameroon";
		  Countries[0x00EE]="Cape Verde Islands";
		  Countries[0x00EF]="Sao Tome and Principe";
		  Countries[0x00F0]="Equatorial Guinea";
		  Countries[0x00F1]="Gabon";
		  Countries[0x00F2]="Congo";
		  Countries[0x00F3]="Zaire";
		  Countries[0x00F4]="Angola";
		  Countries[0x00F5]="Guinea-Bissau";
		  Countries[0x00F6]="Diego Garcia";
		  Countries[0x00F7]="Ascension Isle";
		  Countries[0x00F8]="Seychelles";
		  Countries[0x00F9]="Sudan";
		  Countries[0x00FA]="Rwhanda";
		  Countries[0x00FB]="Ethiopia";
		  Countries[0x00FC]="Somalia";
		  Countries[0x00FD]="Djibouti";
		  Countries[0x00FE]="Kenya";
		  Countries[0x00FF]="Tanzania";
		  Countries[0x0100]="Uganda";
		  Countries[0x0101]="Burundi";
		  Countries[0x0103]="Mozambique";
		  Countries[0x0104]="Zambia";
		  Countries[0x0105]="Madagascar";
		  Countries[0x0106]="Reunion Island";
		  Countries[0x0107]="Zimbabwe";
		  Countries[0x0108]="Namibia";
		  Countries[0x0109]="Malawi";
		  Countries[0x010A]="Lesotho";
		  Countries[0x010B]="Botswana";
		  Countries[0x010C]="Swaziland";
		  Countries[0x010D]="Comoros";
		  Countries[0x010E]="Mayotte";
		  Countries[0x0122]="St. Helena";
		  Countries[0x0129]="Aruba";
		  Countries[0x012A]="Faroe Islands";
		  Countries[0x012B]="Greenland";
		  Countries[0x015E]="Gibraltar";
		  Countries[0x015F]="Portugal";
		  Countries[0x0160]="Luxembourg";
		  Countries[0x0161]="Ireland";
		  Countries[0x0162]="Iceland";
		  Countries[0x0163]="Albania";
		  Countries[0x0164]="Malta";
		  Countries[0x0165]="Cyprus";
		  Countries[0x0166]="Finland";
		  Countries[0x0167]="Bulgaria";
		  Countries[0x0172]="Lithuania";
		  Countries[0x0173]="Latvia";
		  Countries[0x0174]="Estonia";
		  Countries[0x0175]="Moldova";
		  Countries[0x017D]="Serbia or Montenegro";
		  Countries[0x0181]="Croatia";
		  Countries[0x0182]="Slovenia";
		  Countries[0x0183]="Bosnia-Herzegovina (Lat)";
		  Countries[0x0184]="Bosnia-Herzegovina (Cyr)";
		  Countries[0x0185]="FYR Macedonia";
		  Countries[0x01A5]="Czech Republic";
		  Countries[0x01A6]="Slovakia";
		  Countries[0x01F4]="Falkland Islands";
		  Countries[0x01F5]="Belize";
		  Countries[0x01F6]="Guatemala";
		  Countries[0x01F7]="El Salvador";
		  Countries[0x01F8]="Honduras";
		  Countries[0x01F9]="Nicraragua";
		  Countries[0x01FA]="Costa Rica";
		  Countries[0x01FB]="Panama";
		  Countries[0x01FC]="St. Pierre and Miquelon";
		  Countries[0x01FD]="Haiti";
		  Countries[0x024E]="Guadeloupe";
		  Countries[0x024F]="Bolivia";
		  Countries[0x0250]="Guyana";
		  Countries[0x0251]="Ecuador";
		  Countries[0x0252]="rench Guiana";
		  Countries[0x0253]="Paraguay";
		  Countries[0x0254]="Martinique or French Antilles";
		  Countries[0x0255]="Suriname";
		  Countries[0x0256]="Uruguay";
		  Countries[0x0257]="Netherland Antilles";
		  Countries[0x029E]="Saipan or N. Mariana Island";
		  Countries[0x029F]="Guam";
		  Countries[0x02A0]="Norfolk Island/Christmas Island/Cocos Islands/Antartica";
		  Countries[0x02A1]="Brunei Darussalam";
		  Countries[0x02A2]="Nauru";
		  Countries[0x02A3]="Papua New Guinea";
		  Countries[0x02A4]="Tonga Islands";
		  Countries[0x02A5]="Solomon Islands";
		  Countries[0x02A6]="Vanuatu";
		  Countries[0x02A7]="Fiji";
		  Countries[0x02A8]="Palau";
		  Countries[0x02A9]="Wallis & Futuna";
		  Countries[0x02AA]="Cook Islands";
		  Countries[0x02AB]="Niue";
		  Countries[0x02AC]="American Samoa";
		  Countries[0x02AD]="Western Samoa";
		  Countries[0x02AE]="Kiribati";
		  Countries[0x02AF]="New Caledonia";
		  Countries[0x02B0]="Tuvalu";
		  Countries[0x02B1]="French Polynesia";
		  Countries[0x02B2]="Tokealu";
		  Countries[0x02B3]="Micronesia";
		  Countries[0x02B4]="Marshall Islands";
		  Countries[0x0311]="Middle East, Saudi Arabia";
		  Countries[0x0324]="Ukraine";
		  Countries[0x0329]="Antigua/Barbuda/Anguilla/Bahamas/Barbados/Bermuda/"
				    "British Virgin Islands/Cayman Islands/Dominica/"
				    "Dominican Republ./Grenada/Jamaica/Montserra/"
				    "St. Kitts and Nevis/St. Lucia/",
				    "St. Vincent and Grenadines/Trinidad and Tobago/",
				    " Turks and Caicos";
		  Countries[0x0352]="North Korea";
		  Countries[0x0354]="Hong Kong";
		  Countries[0x0355]="Macao";
		  Countries[0x0357]="Cambodia";
		  Countries[0x0358]="Laos";
		  Countries[0x0370]="Bangladesh";
		  Countries[0x03C0]="Maldives";
		  Countries[0x03C1]="Lebanon";
		  Countries[0x03C2]="Jordan";
		  Countries[0x03C3]="Syrian Arab Republic";
		  Countries[0x03C4]="Ireq";
		  Countries[0x03C5]="Kuwait";
		  Countries[0x03C6]="Saudi Arabia";
		  Countries[0x03C7]="Yemen";
		  Countries[0x03C8]="Oman";
		  Countries[0x03CB]="United Arab Emirates";
		  Countries[0x03CC]="Israel";
		  Countries[0x03CD]="Bahrain";
		  Countries[0x03CE]="Qatar";
		  Countries[0x03CF]="Bhutan";
		  Countries[0x03D0]="Mongolia";
		  Countries[0x03D1]="Nepal";
		  Countries[0x03E3]="Myanmar";

	inregs.x.ax = 0x3800;
	segregs.ds = FP_SEG(&CountryInfo);
	inregs.x.dx = FP_OFF(&CountryInfo);
	int86x(0x21,&inregs,&outregs,&segregs);
	countrycflag = _BX;

	textbackground( BG_BG );

	gotoxy(SCR_BEG,row);
	 textcolor(BG_TXT),cprintf(" Country spec.info.: ");
	 textcolor(ANSWER_TXT);

	 if(!outregs.x.cflag) {
	  gotoxy(SCR_BEG + 20,row++);
	   textcolor(BG_TXT),    cprintf(" Country           : ");
	   textcolor(ANSWER_TXT);
	    if( countrycflag && countrycflag <= 0x3E2 )
	     cprintf("%s",Countries[countrycflag]);
	    else
	     cprintf("Unknown");
	  gotoxy(SCR_BEG + 20,row++);
	   textcolor(BG_TXT),    cprintf(" Thousand separator: ");
	   textcolor(ANSWER_TXT),cprintf("(%c) \n",CountryInfo.ThousandSep[0]);
	  gotoxy(SCR_BEG + 20,row++);
	   textcolor(BG_TXT),    cprintf(" Desimal separator : ");
	   textcolor(ANSWER_TXT),cprintf("(%c) \n",CountryInfo.DecimalSep[0]);
	  gotoxy(SCR_BEG + 20,row++);
	   textcolor(BG_TXT),    cprintf(" Date separator    : ");
	   textcolor(ANSWER_TXT),cprintf("(%c) \n",CountryInfo.DateSep[0]);
	  gotoxy(SCR_BEG + 20,row++);
	   textcolor(BG_TXT),    cprintf(" Time separator    : ");
	   textcolor(ANSWER_TXT),cprintf("(%c) \n",CountryInfo.TimeSep[0]);
	  gotoxy(SCR_BEG + 20,row++);
	   textcolor(BG_TXT),    cprintf(" Datalist separator: ");
	   textcolor(ANSWER_TXT),cprintf("(%c) \n",CountryInfo.DataListSep[0]);
	  gotoxy(SCR_BEG + 20,row++);
	   textcolor(BG_TXT),    cprintf(" Date format       : ");
	   textcolor(ANSWER_TXT),cprintf("%s",CurDateMsg[CountryInfo.DateFormat]);
	  gotoxy(SCR_BEG + 20,row++);
	   textcolor(BG_TXT),cprintf(" Time format       : ");
	   textcolor(ANSWER_TXT);
	   if( !CountryInfo.TimeFormat &0x01 )
	    cprintf("12-hour clock \n");
	   else if( CountryInfo.TimeFormat &0x01 )
	    cprintf("24-hour clock \n");
	   else
	    cprintf("Unknown \n");
	  gotoxy(SCR_BEG + 20,row++);
	   textcolor(BG_TXT),    cprintf(" Currency format   : ");
	   textcolor(ANSWER_TXT),cprintf("%s",CurFormMsg[CountryInfo.CurForm]);
	  gotoxy(SCR_BEG + 20,row++);
	   textcolor(BG_TXT),    cprintf(" Currency symbol   : ");
	   textcolor(ANSWER_TXT),cprintf("%s",CountryInfo.CurSymbolStr);
	  } else cprintf("Error [%04Xh]",_AX);
}
