/*
SYSTEM SNIFFER - MEMMAN.CPP
Copyright (C) Tero Ripattila 1996-1998

Tunnistettavat muistinhallintaohjelmat:
 - RM386
 - QEMM-386 V4.23+
 - Micronics Expanded Memory Manager
 - Microsoft Expanded Memory Manager 386 V4.20+
 - VIDMEM.SYS V1.31+
 - Qualitas 386MAX V7.0
*/

enum EMM386_MASKS {
	EMM386_ACTIVE = 0x00,
	EMM386_NOTACTIVE  = 0x01,             // 00000001b
	EMM386_AUTOMODE = 0x02,               // 00000010b
	EMM386_UNKNOWN = 0x03 };

bool SnifferMem::ChkQEMM(void)
{
	asm	mov ah,0x3F
	asm	mov cx,0x5145
	asm	mov dx,0x4D4D
	asm	int 0x67

	return( _AH ? FALSE : TRUE );
}

bool SnifferMem::ChkMicEMM(void)
{
	asm	mov ax,0x5BF0
	asm	int 0x67

	return( _AH ? FALSE : TRUE );
}

bool SnifferMem::ChkRM386(void)
{
	asm	mov ax,0x5BF0
	asm	int 0x67

	return( _AH ? FALSE : TRUE );
}

bool SnifferMem::ChkEMM386(void)
{
	asm	mov ax,0xFFA5
	asm	int 0x67

	if( _AX == 0x845A || _AX == 0x84A5 )
	 return( TRUE );
	else
	 return( FALSE );
}

void SnifferMem::AnalyseEMM386(void)
{
	static const byte *EMM386Messages[4] = { "Active","Not active","AUTO-mode","Unknown" };
	byte EMMStatus = 0;
	dword EMMClAddress = 0;

	asm	mov ax,0xFFA5
	asm	int 0x67

	asm	mov [word ptr EMMClAddress],bx
	asm	mov [word ptr EMMClAddress + 2],cx

	asm	mov ah,0x00
	asm	call [dword ptr EMMClAddress]

	if( !_AH )                            // Otetaan selv onko EMM386:n tila ON
	 EMMStatus = EMM386_ACTIVE;
	if( _AH &EMM386_NOTACTIVE )           // Otetaan selv onko EMM386:n tila OFF
	 EMMStatus = EMM386_NOTACTIVE;
	if( _AH &EMM386_AUTOMODE )            // Otetaan selv onko EMM386:n tila AUTO
	 EMMStatus = EMM386_AUTOMODE;
	else                                  // EMM386:n tilan selvitys ei onnistunut
	 EMMStatus = EMM386_UNKNOWN;

	textbackground(BG_BG);

	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),    cprintf(" Microsoft EMM386.EXE...: ");
	 textcolor(ANSWER_TXT),cprintf("%s",EMM386Messages[EMMStatus]);
}

bool SnifferMem::ChkVIDEMS(void)
{
	asm	mov ax,0x2763
	asm	mov cl,0x01
	asm	mov bx,offset 0xAAFF
	asm	int 0x67

	return( _AH ? FALSE : TRUE );
}

void SnifferMem::AnalyseVIDEMS(void)
{
	asm	mov ax,0x2763
	asm	mov cl,0x01
	asm	mov bx,offset 0xAAFF
	asm	int 0x67

	textbackground(BG_BG);

	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),    cprintf(" VIDEMS.................: ");
	 textcolor(ANSWER_TXT),cprintf("80286 optimization");
	 _CH ? cprintf("not used") : cprintf("used");
	 cprintf("V%u.%02U, r%u",_DH,_DL,_CL);
}

bool SnifferMem::Chk386MAX(void)
{
	TempB = 0;

	asm	push ax
	asm	mov ah,0x1E
	asm	int 0x67
	asm	mov TempB,ah
	asm	pop ax

	return( TempB ? FALSE : TRUE );
}