/*
SYSTEM SNIFFER - GUI.CPP
Copyright (C) Tero Ripattila 1996-1998
*/

struct CALENDAR {
 short year,day,month,wday;
 short hour,min,sec;
 };

SnifferGUI::SnifferGUI(void)
{
}

SnifferGUI::~SnifferGUI(void)
{
}

void SnifferGUI::PrepareSniffer( void )
{
	CBFlagState = GetCBFlagState();            // Otetaan selville CTRL+BREAK -tila
	LockState = peekb(0x0040,0x0017);          // Otetaan selville ..LOCK -nppinten tilat

	textmode( 0x03 );                          // Laitetaan tavallinen tekstitila plle ( 80 x 25 )

	SetCBFlagState( OFF );                     // Estetn CTRL+BREAK tyyppiset ohjelmanlopetukset

	pokeb(0x0040,0x0017, LockState &0x0E);     // Nollataan kaikki ..LOCK -nppinten ledit
	pokeb(0x0040,0x0017, LockState |0x20);     // Laitetaan vain NUMLOCK plle
}

void SnifferGUI::GetDateAndTime(void)
{
	CALENDAR *Cal;
	static const byte *WDays[7] = { "Sun","Mon","Tue","Wed","Thu","Fri","Sat" };
	static const byte *Months[13] = { "???","Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec" };
	byte day = 0,wday = 0,month = 0,hour = 0,min = 0,sec = 0;
	word year = 0;

	asm	mov ah,0x2A
	asm	int 0x21
	asm	mov year,cx
	asm	mov day,dl
	asm	mov wday,al
	asm	mov month,dh
	asm	mov ah,0x2C
	asm	int 0x21
	asm	mov hour,ch
	asm	mov min,cl
	asm	mov sec,dh

	Cal->year = year;
	Cal->day = day;
	Cal->wday = wday;
	Cal->month = month;
	Cal->hour = hour;
	Cal->min = min;
	Cal->sec = sec;

	gotoxy(SCR_BEG + 38,25);
	textbackground(BAR_BG),textcolor(BAR_TXT);
	cprintf(" %03s %02u-%03s-%04u %02u:%02u:%02u",WDays[Cal->wday],
		Cal->day,Months[Cal->month],Cal->year,Cal->hour,Cal->min,Cal->sec);
}

void SnifferGUI::ChkKbd(void)
{
	byte *TempS = "";

	if(inportb(0x60) < 0x80) {
	 switch(inportb(0x60)) {
	  case U_ARROW:
	   if(Scr==HARDWARE) {
	    textbackground(BG_BG),textcolor(PROGNAME_TXT);
	     _Center(MENU_X1,MENU_X2,Scr,ProgNames[Scr]);
	    textbackground(HIGHLI_BG),textcolor(HIGHLI_TXT);
	     _Center(MENU_X1,MENU_X2,QUIT,ProgNames[QUIT]);
	    SGui->QuitReally();
	    }
	   else {
	    textbackground(BG_BG),textcolor(PROGNAME_TXT);
	     _Center(MENU_X1,MENU_X2,Scr,ProgNames[Scr]);
	    textbackground(HIGHLI_BG),textcolor(HIGHLI_TXT);
	     _Center(MENU_X1,MENU_X2,Scr - 1,ProgNames[Scr - 1]);
	    switch(Scr - 1) {
	     case HARDWARE: SHWare->GetHardwareInfo(); break;
	     case SOFTWARE: SSWare->GetOSInfo();       break;
	     case MEMORY:   SMem->GetMemoryInfo();     break;
	     case VIDEO:    SVideo->GetVideoInfo();    break;
	     case DISK:     SDisk->GetDiskInfo();      break;
	     case PORTS:    SPorts->GetPortInfo();     break;
	     case IRQ:      SPorts->GetIRQInfo();      break;
	     case CMOS:     SCmos->GetCMOSInfo();      break;
	     case NETWORK:  SNWork->GetNetworkInfo();  break;
	     case HELP:     SGui->ShowHelpInfo();      break;
	     case ABOUT:    SGui->ShowAboutInfo();     break;
	     case QUIT:     SGui->QuitReally();        break;
	     default:                                  break;
	     } delay(KBD_WAIT);
	    } break;
	  case D_ARROW:
	   if(Scr==QUIT) {
	    textbackground(BG_BG),textcolor(PROGNAME_TXT);
	     _Center(MENU_X1,MENU_X2,Scr,ProgNames[Scr]);
	    textbackground(HIGHLI_BG),textcolor(HIGHLI_TXT);
	     _Center(MENU_X1,MENU_X2,HARDWARE,ProgNames[HARDWARE]);
	    SHWare->GetHardwareInfo();
	    } else {
	    textbackground(BG_BG),textcolor(PROGNAME_TXT);
	     _Center(MENU_X1,MENU_X2,Scr,ProgNames[Scr]);
	    textbackground(HIGHLI_BG),textcolor(HIGHLI_TXT);
	     _Center(MENU_X1,MENU_X2,Scr + 1,ProgNames[Scr + 1]);
	    switch(Scr + 1) {
	     case HARDWARE: SHWare->GetHardwareInfo(); break;
	     case SOFTWARE: SSWare->GetOSInfo();       break;
	     case MEMORY:   SMem->GetMemoryInfo();     break;
	     case VIDEO:    SVideo->GetVideoInfo();    break;
	     case DISK:     SDisk->GetDiskInfo();      break;
	     case PORTS:    SPorts->GetPortInfo();     break;
	     case IRQ:      SPorts->GetIRQInfo();      break;
	     case CMOS:     SCmos->GetCMOSInfo();      break;
	     case NETWORK:  SNWork->GetNetworkInfo();  break;
	     case HELP:     textbackground(BG_BG),textcolor(PROGNAME_TXT);
			     _Center(MENU_X1,MENU_X2,Scr,ProgNames[Scr]);
			    textbackground(HIGHLI_BG),textcolor(HIGHLI_TXT);
			     _Center(MENU_X1,MENU_X2,HELP,ProgNames[HELP]);
			    SGui->ShowHelpInfo();      break;
	     case ABOUT:    textbackground(BG_BG),textcolor(PROGNAME_TXT);
			     _Center(MENU_X1,MENU_X2,Scr,ProgNames[Scr]);
			    textbackground(HIGHLI_BG),textcolor(HIGHLI_TXT);
			     _Center(MENU_X1,MENU_X2,ABOUT,ProgNames[ABOUT]);
			    SGui->ShowAboutInfo();     break;
	     case QUIT:     SGui->QuitReally();        break;
	     default:                                  break;
	     } delay(KBD_WAIT);
	    } break;
	  case F1_KEY:  textbackground(BG_BG),textcolor(PROGNAME_TXT);
			 _Center(MENU_X1,MENU_X2,Scr,ProgNames[Scr]);
			textbackground(HIGHLI_BG),textcolor(HIGHLI_TXT);
			 _Center(MENU_X1,MENU_X2,HELP,ProgNames[HELP]);
			SGui->ShowHelpInfo();         // <F1> Help-ruutu
			break;
	  case F2_KEY:  textbackground(BG_BG),textcolor(PROGNAME_TXT);
			 _Center(MENU_X1,MENU_X2,Scr,ProgNames[Scr]);
			textbackground(HIGHLI_BG),textcolor(HIGHLI_TXT);
			 _Center(MENU_X1,MENU_X2,ABOUT,ProgNames[ABOUT]);
			SGui->ShowAboutInfo();        // <F2> About-ruutu
			break;
	  case F10_KEY: SGui->QuitReally();    break; // <F10> Lopeta
	  default:      FlushKbdBuf();         break;
	  }
	 } else FlushKbdBuf();
}

void SnifferGUI::PutCaptionAndMsg(byte prog)
{
	TempB = 0;
	Scr = prog;

	GetChAttr(1,24);
	for(TempB = 3; TempB <= 23; TempB++)
	 SetChAttr(16,TempB,chr,at,63);

	gotoxy(SCR_BEG + 1,2);
	 textbackground(BG_BG),textcolor(BG_TXT);
	 if( ProgCaptions[Scr] )
	  cprintf( "%s",ProgCaptions[Scr] );
	 else
	  cprintf( "Unknown" );

	gotoxy(SCR_BEG - 14,25);
	 textbackground(BAR_BG),textcolor(MSG_TXT);
	 if( ProgMessages[Scr] )
	  cprintf( "%s",ProgMessages[Scr] );
	 else
	  cprintf( "Unknown" );
}

void SnifferGUI::ShowAboutInfo(void)
{
	SGui->PutCaptionAndMsg(ABOUT);

	char *TempS = "";
   sprintf( TempS, "You reach me by e-mail: %s", EMAIL_ADDR );

	textbackground(BG_BG),textcolor(BG_TXT);
	_Center(SCR_X1,SCR_X2,3,VERSION_MSG);
	_Center(SCR_X1,SCR_X2,4,REL_DATE_MSG);
	_Center(SCR_X1,SCR_X2,5,_CRIGHT_MSG);
	_Center(SCR_X1,SCR_X2,6,"All rights reserved.");
	_Center(SCR_X1,SCR_X2,8,"Please tell me ideas how I could make this program better");
	_Center(SCR_X1,SCR_X2,9,"and if you find bugs or you think that something does not");
	_Center(SCR_X1,SCR_X2,10,"work properly. Please let *me* also know about it.");
	_Center(SCR_X1,SCR_X2,12,TempS );
	_Center(SCR_X1,SCR_X2,14,"Credits goes to Steve Grant, Andrew Rossmann,");
	_Center(SCR_X1,SCR_X2,15,"S.H.Smith and Arto Juutilainen.");
}

void SnifferGUI::ShowHelpInfo(void)
{
	row = 3;

	SGui->PutCaptionAndMsg(HELP);

	textbackground(BG_BG);

	gotoxy(SCR_BEG,row++);
	 textcolor(ANSWER_TXT),cprintf( " No help available. \n" ),
	gotoxy(SCR_BEG,row++);
	 textcolor(ANSWER_TXT),cprintf( " Contact author for the latest version of SS. \n" );
}

void SnifferGUI::TurnPage(void)
{
	textbackground(BG_BG);

	gotoxy(SCR_BEG + 33,23);
	 textcolor(SPCL_TXT),cprintf("Press <Page Down> to continue.");

	while(inportb(0x60) != PDOWN_KEY);

	SGui->PutCaptionAndMsg(Scr);
	row = 3;
}

void SnifferGUI::QuitReally(void)
{
	row = 10;
	byte *TempS = "";

	if( Scr > QUIT || Scr < HARDWARE ) {
	 sprintf( TempS,"\nError in %s at line %u", strupr( __FILE__ ),__LINE__ );
	 puts( TempS );
	 ExitProgram( FAILED );
	 }

	textbackground(BG_BG),textcolor(PROGNAME_TXT);
	 _Center(MENU_X1,MENU_X2,Scr,ProgNames[Scr]);
	textbackground(HIGHLI_BG),textcolor(HIGHLI_TXT);
	 _Center(MENU_X1,MENU_X2,QUIT,ProgNames[QUIT]);

	SGui->PutCaptionAndMsg(QUIT);

	textbackground(BG_BG),textcolor(SPCL_TXT);

	_Center(SCR_X1,SCR_X2,row++,"Do you really want to quit System Sniffer?");
	_Center(SCR_X1,SCR_X2,row++,"Press <Y> to quit this program");
	_Center(SCR_X1,SCR_X2,row++,"Press <N> to return back to SS");

	GetKey:
	 switch(inportb(0x60)) {
	  case Y_KEY:
	   SGui->ExitProgram( SUCCESFULL );
	   break;
	  case N_KEY:
	   asm	jmp Exit
	   break;
	  default:
	   asm	jmp GetKey;
	   break;
	  }
	Exit:
}

void SnifferGUI::ExitProgram( byte opt )
{
	TempB = 0;

	switch( opt ) {
		case SUCCESFULL:
		  gotoxy(SCR_BEG - 15,25);
		  textbackground(DOS_BG),textcolor(DOS_TXT);
		  cprintf(" ");
		  GetChAttr(1,25);
		  SetChAttr(1,25,chr,at,80);
		  gotoxy(1,24);
		  TempB = SUCCESFULL;
		  break;
		 case FAILED:
		  gotoxy(SCR_BEG - 15,25);
		  textbackground(DOS_BG),textcolor(DOS_TXT);
		  cprintf(" ");
		  GetChAttr(1,25);
		  SetChAttr(1,25,chr,at,80);
		  puts( "System Sniffer terminated by internal error!" );
		  TempB = FAILED;
		  break;
		 case HALTED:
		  puts( "System Sniffer terminated by user!" );
		  TempB = HALTED;
		  break;
		}

	SetCBFlagState( CBFlagState );             // Palautetaan alk.per. CTRL+BREAK -tila
	pokeb(0x0040,0x0017, LockState);           // Palautetaan alk.per. ..LOCK -nppinten tilat

	FlushKbdBuf();

   textmode( LASTMODE );                      // Palautetaan ask.per. tekstitila
	exit( TempB );                             // Palataan DOS:in kehotteelle
}