/*
SYSTEM SNIFFER - POWERMAN.CPP
Copyright (C) Tero Ripattila 1996-1998
*/

enum APM_FLAGS {
	_16AND32BIT_PMODE_SUP = 0x03,         // 00000011b
	_16BIT_PMODE_SUP = 0x01,              // 00000001b
	_32BIT_PMODE_SUP = 0x02,              // 00000010b
	_CPU_IDLE_RSPEED = 0x04,              // 00000100b
	_BIOSPM_DISABLED = 0x08,              // 00001000b
	_BIOSPM_DISENGAGED = 0x10 };          // 00010000b

bool SnifferSWare::ChkPowerMan(word& version)
{
	TempB = 0;

	asm	mov ax,0x5300
	asm	mov bx,0x0000
	asm	int 0x15
	asm	jnc Return                    // Otetaan selv onko PM asennettu
	asm	mov TempB,TRUE

      Return:
	asm	mov version,ax                // Otetaan versionumero talteen

	return( TempB ? FALSE : TRUE );
}

void SnifferSWare::AnalysePowerMan(void)
{
	byte ErrorCode = 0;
	word Flags = 0;
	version = 0;

	asm	mov ax,0x5300
	asm	mov bx,0x0000
	asm	int 0x15
	asm	jnc PMPresent
	asm	mov ErrorCode,ah              // Otetaan virhekoodi selville
	asm	jmp Exit

      PMPresent:
	asm	mov version,ax                // Otetaan versionumero selville
	asm	mov Flags,cx                  // Otetaan liput talteen
	asm	jmp Exit

      Exit:
	textbackground( BG_BG );

	if( ErrorCode ) {
	 textcolor( ERROR_TXT );
	 switch( ErrorCode ) {
	  case 0x01: cprintf( "PM functionality disabled" );              break;
	  case 0x02: cprintf( "Interface connection already in effect" ); break;
	  case 0x03: cprintf( "Interface not connected" );                break;
	  case 0x04: cprintf( "Real-mode interface not connected" );      break;
	  case 0x05: cprintf( "16-bit PMI already connected" );           break;
	  case 0x06: cprintf( "16-bit PMI not supported" );               break;
	  case 0x07: cprintf( "32-bit PMI already connected" );           break;
	  case 0x08: cprintf( "32-bit PMI not supported" );               break;
	  case 0x09: cprintf( "Unrecognized device ID" );                 break;
	  case 0x0A: cprintf( "Invalid parameter value in CX" );          break;
	  case 0x0B: cprintf( "Interface not engaged" );                  break;
	  case 0x0C: cprintf( "Function not supported" );                 break;
	  case 0x0D: cprintf( "Resume Timer disabled" );                  break;
	  case 0x60: cprintf( "Can't enter requested state" );            break;
	  case 0x80: cprintf( "No power management events pending" );     break;
	  case 0x86: cprintf( "APM not present" );                        break;
	  case 0xFF: cprintf( "Undefined error" );                        break;
	  }
	 }

	textcolor(ANSWER_TXT);
	 if( Flags &_16AND32BIT_PMODE_SUP )
	  cprintf( "16/32-bit PMI supported" );
	 else if( Flags &_16BIT_PMODE_SUP )
	  cprintf( "16-bit PMI supported" );
	 else if( Flags &_32BIT_PMODE_SUP )
	  cprintf( "32-bit PMI supported" );
	 else if( Flags &_CPU_IDLE_RSPEED )
	  cprintf( "CPU idle call reduces processor speed" );
	 else if( Flags &_BIOSPM_DISABLED )
	  cprintf( "BIOS PM disabled" );
	 else if( Flags &_BIOSPM_DISENGAGED )
	  cprintf( "BIOS PM disengaged" );
	 else
	  cprintf( "Unknown" );

    if( version ) {
     cprintf(", V");
     ShowBCD( version );
     }
}

bool SnifferSWare::ChkPOWER( word& version )
{
	TempB = 0;

	asm	mov ax,0x5400
	asm	int 0x15
	asm	jnc POWERPresent              // Otetaan selv onko POWER.EXE
	asm	mov TempB,TRUE               // asennettu
	asm	jmp Return

      POWERPresent:
	asm	cmp bx,0x504D                 // Tehdn viel toinen tarkistus
	asm	je  Return
	asm	mov TempB,TRUE

      Return:
	asm	mov version,ax                // Otetaan versionumero talteen

	return( TempB ? FALSE : TRUE );
}

bool SnifferSWare::ChkAPMDriver(word APMVersion,word& APMCVersion)
{
	byte ErrorCode = 0;
	major = minor = TempB = 0;

	major = HiWord( APMVersion );
	minor = LoWord( APMVersion );

	asm	mov ax,0x530E
	asm	mov bx,0x0000
	asm	mov ch,major                  // APM:n versionnumero
	asm	mov cl,minor                  // APM:n versionnumero
	asm	jnc APMCPresent               // Otetaan selv onko APMC asennettu
	asm	mov TempB,TRUE
	asm	mov ErrorCode,ah              // Otetaan virhekoodi talteen

      APMCPresent:
	asm	mov APMCVersion,ax            // APM Connection:in versionumero

	if( !ErrorCode && !TempB )
	 return( TRUE );
	else
	 return( FALSE );
}

void SnifferSWare::GetPowerManInfo(void)
{
	word PMVersion = 0,POWERVersion = 0;
	version = 0;

	textbackground( BG_BG );

	if( ChkPowerMan(PMVersion) ) {
	 gotoxy(SCR_BEG,row++);
	  textcolor(BG_TXT),    cprintf( " APM...............: " );
	  AnalysePowerMan();
	 }
	if( ChkPOWER(POWERVersion) ) {
	 gotoxy(SCR_BEG,row++);
	  textcolor(BG_TXT),    cprintf( " POWER.EXE.........: " );
	  textcolor(ANSWER_TXT);
     if( POWERVersion )
      cprintf( "V%u.%02u",POWERVersion );
     else
      cprintf( "Present" );
	 }
	if( ChkAPMDriver(PMVersion,version) ) {
	 gotoxy(SCR_BEG,row++);
	  textcolor(BG_TXT),    cprintf( " APM Connection....: " );
	  textcolor(ANSWER_TXT);
     if( version ) {
      cprintf( "V" );
      ShowBCD( version );
      }
     else
      cprintf( "Present" );
	 }
}