/*
SYSTEM SNIFFER - PORTS.CPP
Copyright (C) Tero Ripattila 1996-1998
*/

SnifferPorts::SnifferPorts(void)
{
}

SnifferPorts::~SnifferPorts(void)
{
}

void SnifferPorts::GetPortInfo(void)
{
	row = 3;

	SGui->PutCaptionAndMsg(PORTS);

	textbackground( BG_BG );

	SPorts->GetCOMPortInfo();
	SGui->TurnPage();
	SPorts->GetLPTPortInfo();
	SPorts->GetGameIOInfo();
}

void SnifferPorts::GetCOMPortInfo(void)
{
	word x = 0,y = 0,i = 0,Equip = 0,TempW = 0,_TempW = 0;
	byte TempB = 0;

	asm	int 0x11
	asm	mov Equip,ax
	Equip &= 0x0E00;
	Equip >>= 9;

	textbackground( BG_BG );

	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),cprintf(" Serial ports......: ");

	if( Equip ) {
	 if( Equip > 4 )
	  Equip = 4;
	 cprintf("Device....: ");
	 gotoxy(SCR_BEG + 21,row++),cprintf("Base port.: ");
	 gotoxy(SCR_BEG + 21,row++),cprintf("UART......: ");
	 gotoxy(SCR_BEG + 21,row++),cprintf("Timeout...: ");
	 gotoxy(SCR_BEG + 21,row++),cprintf("Baud rate.: ");
	 gotoxy(SCR_BEG + 21,row++),cprintf("Data bits.: ");
	 gotoxy(SCR_BEG + 21,row++),cprintf("Parity....: ");
	 gotoxy(SCR_BEG + 21,row++),cprintf("Stop bits.: ");
	 gotoxy(SCR_BEG + 21,row++),cprintf("Break.....: ");
	 gotoxy(SCR_BEG + 21,row++),cprintf("RLSD......: ");
	 gotoxy(SCR_BEG + 21,row++),cprintf("RI........: ");
	 gotoxy(SCR_BEG + 21,row++),cprintf("DSR.......: ");
	 gotoxy(SCR_BEG + 21,row++),cprintf("CTS.......: ");
	 gotoxy(SCR_BEG + 21,row++),cprintf("dRLSD.....: ");
	 gotoxy(SCR_BEG + 21,row++),cprintf("-dRI......: ");
	 gotoxy(SCR_BEG + 21,row++),cprintf("dDSR......: ");
	 gotoxy(SCR_BEG + 21,row++),cprintf("dCTS......: ");

	 y = row - 17;
	 x = 49;

	 textcolor(ANSWER_TXT);

	 for(i = 1; i <= Equip; i++) {
	  gotoxy(x,y++),cprintf("COM%u \n",i);
	  TempW = peek(0x0040,2 * i - 2);
	  if(!TempW)
	   gotoxy(x,y++),cprintf("N/A \n");
	  else {
	   gotoxy(x,y++),cprintf("%04Xh \n",TempW);
	   TempB = inportb(TempW + 7);
	   outportb(TempW + 7,0x5A);
	   if(inportb(TempW + 7) != 0x5A)
	    gotoxy(x,y++),cprintf("8250 \n");
	   else {
	    outportb(TempW + 7,0xA5);
	    if(inportb(TempW + 7) != 0xA5)
	     gotoxy(x,y++),cprintf("8250 \n");
	    else {
	     outportb(TempW + 7,TempB);
	     TempB = inportb(TempW + 2);
	     outportb(TempW + 2,1);
	      if(TempB &0xC0)
	       gotoxy(x,y++),cprintf("16550A \n");
	      else if(TempB &0x80)
	       gotoxy(x,y++),cprintf("16550 \n");
	      else
	       gotoxy(x,y++),cprintf("16450 \n");
	      }
	     }
	  outportb(TempW + 2,0);
	  gotoxy(x,y++),cprintf("%u \n",peekb(0x0040,0x007B + i));
	  TempB = inportb(TempW + 3);
	  outportb(TempW + 3,TempB |0x80);
	  _TempW = cbw(inportb(TempW),inportb(TempW + 1));
	  if(!_TempW)
	   gotoxy(x,y++),cprintf("N/A \n");
	  else {
	   gotoxy(x,y++),cprintf("%lu \n",115200 / _TempW);
	   outportb(TempW + 3,TempB);
	   gotoxy(x,y++),cprintf("%u \n",(TempB &0x03 + 5));
	   switch(TempB &0x38) {
	    case 0x00:
	    case 0x10:
	    case 0x20:
	    case 0x30: gotoxy(x,y++),cprintf("None \n");  break;
	    case 0x08: gotoxy(x,y++),cprintf("Odd \n");   break;
	    case 0x18: gotoxy(x,y++),cprintf("Even \n");  break;
	    case 0x28: gotoxy(x,y++),cprintf("Mark \n");  break;
	    case 0x38: gotoxy(x,y++),cprintf("Space \n"); break;
	    }
	   switch(TempB &0x07) {
	    case 0x00:
	    case 0x01:
	    case 0x02:
	    case 0x03: gotoxy(x,y++),cprintf("1 \n");   break;
	    case 0x04: gotoxy(x,y++),cprintf("1.5 \n"); break;
	    case 0x05:
	    case 0x06:
	    case 0x07: gotoxy(x,y++),cprintf("2 \n");   break;
	    }
	   gotoxy(x,y++);
	   if(TempB &0x40) cprintf("Yes \n");
	   else cprintf("No \n");
	   asm	mov ah,0x03
	   asm	mov dx, i - 1
	   asm	int 0x14
	   if(_AL &0x80) gotoxy(x,y++),cprintf("Yes \n");
	    else gotoxy(x,y++),cprintf("No \n");
	   if(_AL &0x40) gotoxy(x,y++),cprintf("Yes \n");
	    else gotoxy(x,y++),cprintf("No \n");
	   if(_AL &0x20) gotoxy(x,y++),cprintf("Yes \n");
	    else gotoxy(x,y++),cprintf("No \n");
	   if(_AL &0x10) gotoxy(x,y++),cprintf("Yes \n");
	    else gotoxy(x,y++),cprintf("No \n");
	   if(_AL &0x08) gotoxy(x,y++),cprintf("Yes \n");
	    else gotoxy(x,y++),cprintf("No \n");
	   if(_AL &0x04) gotoxy(x,y++),cprintf("Yes \n");
	    else gotoxy(x,y++),cprintf("No \n");
	   if(_AL &0x02) gotoxy(x,y++),cprintf("Yes \n");
	    else gotoxy(x,y++),cprintf("No \n");
	   if(_AL &0x01) gotoxy(x,y++),cprintf("Yes \n");
	    else gotoxy(x,y++),cprintf("No \n");
	   x += 6;
	   y = row - 17;
	   }
	 }
       }
     }
}

void SnifferPorts::GetLPTPortInfo(void)
{
	word x = 0,y = 0,i = 0,Equip = 0;

	asm	int 0x11
	asm     mov Equip,ax
	Equip &= 0xC000;
	Equip >>= 14;

	textbackground( BG_BG );

	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),cprintf(" Parallel ports.: ");

	if( Equip ) {
	 cprintf("Device....: ");
	 gotoxy(SCR_BEG + 18,row++),cprintf("Base Port.: ");
	 gotoxy(SCR_BEG + 18,row++),cprintf("Timeout...: ");
	 gotoxy(SCR_BEG + 18,row++),cprintf("Busy......: ");
	 gotoxy(SCR_BEG + 18,row++),cprintf("ACK.......: ");
	 gotoxy(SCR_BEG + 18,row++),cprintf("Paper out.: ");
	 gotoxy(SCR_BEG + 18,row++),cprintf("Selected..: ");
	 gotoxy(SCR_BEG + 18,row++),cprintf("I/O error.: ");
	 gotoxy(SCR_BEG + 18,row++),cprintf("Timed out.: ");

	 x = 46;
	 y = row - 9;

	 textcolor(ANSWER_TXT);

	 for(i = 1; i <= Equip; i++) {
	  gotoxy(x,y++),cprintf("LPT%u \n",i);
	  gotoxy(x,y++),cprintf("%04Xh \n",peek(0x0040,2 * i + 6));
	  gotoxy(x,y++),cprintf("%u \n",peekb(0x0040,0x0077 + i));
	  asm	mov ah,0x02
	  asm	mov dx,i
	  asm	int 0x17
	  gotoxy(x,y++);
	   if(!_AH &0x80) cprintf("Yes");
	   else cprintf("No");
	  gotoxy(x,y++);
	   if(_AH &0x40) cprintf("Yes");
	   else cprintf("No");
	  gotoxy(x,y++);
	   if(_AH &0x20) cprintf("Yes");
	   else cprintf("No");
	  gotoxy(x,y++);
	   if(_AH &0x10) cprintf("Yes");
	   else cprintf("No");
	  gotoxy(x,y++);
	   if(_AH &0x08) cprintf("Yes");
	   else cprintf("No");
	  gotoxy(x,y++);
	   if(_AH &0x01) cprintf("Yes");
	   else cprintf("No");
	  x += 6;
	  y = row - 9;
	  }
	 }
}

word SnifferPorts::BIOSEquipW(void)
{
	word Equip = 0;

	asm int 0x11
	asm mov Equip,ax

	return( Equip );
}

void SnifferPorts::GetGameIOInfo(void)
{
	word TempW = 0;
	byte Found = 0;

	textbackground( BG_BG );

	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),cprintf(" Gameport.......: ");
	 textcolor(ANSWER_TXT);

	outportb(0x201,1);
	if((inportb(0x201) &0x0F))
	 Found = FALSE;
	else {
	 do {
	  if((inportb(0x201) &0x0F))
	   Found = TRUE;
	  TempW++;
	  }while( TempW <= 0xF00 || Found);
	 }

	if(Found)
	 cprintf("Present/");
	else
	 cprintf("Not present/");
	if((BIOSEquipW() &0x1000))
	 cprintf("Present \n");
	else
	 cprintf("Not present \n");
}