/*
SYSTEM SNIFFER - IRQ.CPP
Copyright (C) Tero Ripattila 1996-1998
*/

void SnifferPorts::GetIRQInfo(void)
{
	row = 3;
	SGui->PutCaptionAndMsg(IRQ);
	textbackground(BG_BG);

	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),cprintf(" IRQ H Address   H Description    IRQ Description \n");
	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),cprintf(" --- ----------- ---------------- -----------------------------");
	 textcolor(ANSWER_TXT);
	 for(int i = 0; i <= 15; i++)
	  SPorts->DispIntVector(i);
}

void SnifferPorts::DispIntVector(word IRQ)
{
	word Seg = 0,Off = 0;

	Seg = HiWord( (dword)getvect(IRQ) );
	Off = LoWord( (dword)getvect(IRQ) );

	if(Seg && Off) {
	 gotoxy(SCR_BEG,row++),cprintf("  %02u %04Xh:%04Xh ",IRQ,Seg,Off);
	  switch(Seg) {
	   case 0x0000: cprintf("Int Vectors      "); break;
	   case 0x0040: cprintf("ROM BIOS         "); break;
	   case 0x0050: cprintf("DOS Data         "); break;
	   case 0x0070: cprintf("IO.SYS           "); break;
	   case 0xC800: cprintf("Fixed Disk ROM   "); break;
	   case 0xF000: cprintf("System ROM       "); break;
	   case 0xFC00: cprintf("BIOS ROM         "); break;
	   default:
	    if(Seg == _CS)
	     cprintf("User program     ");
	    else if(Seg == HiWord( (dword)getvect(0x20) ) )
	     cprintf("DOS              ");
	    else if(Seg == HiWord( (dword)getvect(0x21) ) )
	     cprintf("DOS enhancement  ");
	    else if(Seg == HiWord( (dword)getvect(0x24) ) )
	     cprintf("COMMAND.COM      ");
	    else if(Seg < _CS && Seg > HiWord( (dword)getvect(0x20) ) )
	     cprintf("Resident utility ");
	    else
	     cprintf("Unknown          ");
	    break;
	   } switch(IRQ) {
	      case 0x00:  cprintf("Division by zero");                             break;
	      case 0x01:  cprintf("Single step");                                  break;
	      case 0x02:  cprintf("Non-maskable interrupt");                       break;
	      case 0x03:  cprintf("DEBUG breakpoint");                             break;
	      case 0x04:  cprintf("Arithmetic overflow");                          break;
	      case 0x05:  cprintf("Print screen");                                 break;
	      case 0x08:  cprintf("Hardware clock tick");                          break;
	      case 0x09:  cprintf("Kbd action");                                   break;
	      case 0x0d:  cprintf("Vertical retrace");                             break;
	      case 0x0e:  cprintf("Diskette attention");              	           break;
	      case 0x0f:  cprintf("Printer control");                              break;
	      case 0x10:  cprintf("Video display services");                       break;
	      case 0x11:  cprintf("Equipment list services");                      break;
	      case 0x12:  cprintf("Memory size services");                         break;
	      case 0x13:  cprintf("Diskette services");                            break;
	      case 0x14:  cprintf("Communication services");                       break;
	      case 0x15:  cprintf("Cassette tape services");                       break;
	      case 0x16:  cprintf("Standard keyboard services");                   break;
	      case 0x17:  cprintf("Printer services");                             break;
	      case 0x18:  cprintf("Activate ROM basic");                           break;
	      case 0x19:  cprintf("Boot-strap start-up");                          break;
	      case 0x1a:  cprintf("Time and date services");                       break;
	      case 0x1b:  cprintf("Keyboard break handler");                       break;
	      case 0x1c:  cprintf("Clock tick handler");                           break;
	      case 0x1d:  cprintf("Video control parameter tbl");                  break;
	      case 0x1e:  cprintf("Disk base tbl");                                break;
	      case 0x1f:  cprintf("High video graphics character tbl");            break;
	      case 0x20:  cprintf("DOS program terminate service");                break;
	      case 0x21:  cprintf("DOS function call services");                   break;
	      case 0x22:  cprintf("User program terminate handler");               break;
	      case 0x23:  cprintf("User keyboard break handler");                  break;
	      case 0x24:  cprintf("User critical error handler");                  break;
	      case 0x25:  cprintf("DOS absolute disk read");                       break;
	      case 0x26:  cprintf("DOS absolute disk cprintf");                    break;
	      case 0x27:  cprintf("DOS terminate and stay resident");              break;
	      case 0x44:  cprintf("Low video graphics character tbl");    	   break;
	      case 0x48:  cprintf("Translate PCjr keyboard");                      break;
	      case 0x49:  cprintf("Kbd-supplement device translation tbl");        break;
	      default:    cprintf("Unknown   ");                                   break;
	      }
	  }
}