/*
SYSTEM SNIFFER - IOHNDL.H
Copyright (C) Tero Ripattila 1996-1998
*/

#ifndef _IOHNDL_H
#define _IOHNDL_H

#ifndef _BASEDEFS_H
	#include "basedefs.h"
#endif
#ifndef _CONIO_H
	#include <conio.h>
#endif

//
// Required prototypes for functions
//
byte   GetCh(void);
void   Exit(byte errno);
void   FlushKbdBuf(void);
byte   GetCBFlagState(void);
byte   SetCBFlagState(byte st);
void   ShowBCD(word val);
inline byte UnBCD(byte val);
inline word cbw(byte a,byte b);
inline byte Min(byte a,byte b);
inline byte Max(byte a,byte b);
inline unsigned LoByte( byte Val );
inline unsigned HiByte( byte Val );
inline byte LoWord( word Val );
inline byte HiWord( word Val );
inline word LoDword( dword Val );
inline word HiDword( dword Val );

//
// Get a char from input
//
byte GetCh(void)
{
	asm	mov ah,0x08
	asm	int 0x21

	return(_AL);
}

//
// Return to DOS prompt and set error lever ErrNo
//
void Exit(byte ErrNo)
{
	asm	mov ah,0x4C
	asm	mov al,ErrNo
	asm	int 0x21
}

//
// Flush keyboard buffer
//
void FlushKbdBuf(void)
{
	asm	mov ah,0x0C
	asm	mov al,0x00
	asm	int 0x21
}

//
// Get state of CRTL-C flag
//
byte GetCBFlagState(void)
{
	asm	mov ah,0x33
	asm	mov al,0x00
	asm	int 0x21

	if(!_DL) return(OFF);
	else if(_DL == 0x01) return(ON);
	else return(FAILED);
}

//
// Set state of CTRL-C flag
//
byte SetCBFlagState(byte State)
{
	asm	mov ah,0x33
	asm	mov al,0x01
	asm	mov dl,State
	asm	int 0x21

	if(GetCBFlagState() != State) return(FAILED);
	else return(SUCCESFULL);
}

//
// Show word sized BCD-packed numbers
//
void ShowBCD(word val)
{
	byte c = 0;

	c = (val >>12) + 0;
	if(c != 0) cprintf("%u",c);
	cprintf("%u.%u%u",((val &0x0f00) >>8) + 0,
			  ((val &0x00f0) >>4) + 0,
			  (val &0x000f) + 0);
}

//
// Show byte sized BCD-packed numbers
//
inline byte UnBCD(byte val)
{
	return((val &0x000F) + ((val >>4) * 10));
}

//
// Return the smaller number of given two numbers
//
inline byte Min(byte a,byte b)
{
	return( ( a < b ) ? a : b );
}

//
// Return the greater number of given two numbers
//
inline byte Max(byte a,byte b)
{
	return( ( a > b ) ? a : b );
}

//
// Return the lower part of given BYTE
//
inline unsigned LoByte( byte Val )
{
	return( Val &0x0F );
}

//
// Return the higher part of given BYTE
//
inline unsigned HiByte( byte Val )
{
	return( ( ( Val &0xF0 ) >> 4 ) );
}

//
// Return the lower part of given WORD
//
inline byte LoWord( word Val )
{
	return( Val &0x00FF );
}

//
// Return the higher part of given WORD
//
inline byte HiWord( word Val )
{
	return( ( ( Val &0xFF00 ) >> 8 ) );
}

//
// Return the lower part of given DWORD
//
inline word LoDword( dword Val )
{
	return( Val &0x0000FFFF );
}

//
// Return the higher part of given DWORD
//
inline word HiDword( dword Val )
{
	return( ( ( Val &0xFFFF0000 ) >> 16 ) );
}

inline word cbw(byte a,byte b)
{
	return((b <<= 8) + a);
}

#endif