/*
SYSTEM SNIFFER - SS.CPP
Copyright (C) Tero Ripattila 1996-1998

Revision history
	PRE-RELEASE VERSIONS
	- V0.9.8b 29-Oct-1997
	- V0.9.8e 10-Feb-1998
	- V0.9.9a 16-Feb-1998
	- V0.9.9b 16-Feb-1998
	- V0.9.9c 25-Feb-1998
	- V0.9.9d 10-Apr-1998
	- V0.9.9e 13-Apr-1998

	FINAL VERSIONS
	- V1.00	 16-Apr-1998
	- V1.01   20-Apr-1998
	- V1.02   30-Apr-1998
	- V1.03   10-May-1998

	FULL SOURCECODE INCLUDED
	- V1.04   01-Oct-1998
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <dos.h>

#include "ss.h"
#include "graph.h"
#include "iohndl.h"

union REGS regs,inregs,outregs;
struct SREGS segregs;

#include "gui.cpp"
#include "disk.cpp"
#include "software.cpp"
#include "mem.cpp"
#include "video.cpp"
#include "ports.cpp"
#include "hardware.cpp"
#include "network.cpp"
#include "cmos.cpp"
#include "irq.cpp"

void main( int argc,char *argv[] )
{
	if( argc ) {
	 for( int i = 1; i < argc; i++ ) {
	  if( argv[i][0] == '/' ||
			argv[i][0] == '-' ) {
		if( argv[i][1] == 'D' ||
			 argv[i][1] == 'd' ) {
		 switch( argv[i][2] ) {
		  case 'd':
		  case 'D':
			DFlags->DisableDPMI = TRUE;     // Estetn DPMI-muistin tutkinta
			break;
		  case 'e':
		  case 'E':
			DFlags->DisableEMS = TRUE;      // Estetn EMS-muistin tutkinta
			break;
		  case 'o':
		  case 'O':
			DFlags->DisableOS = TRUE;       // Estetn kyttjrjestelmn tutkinta
			break;
		  case 's':
		  case 'S':
			DFlags->DisableSWare = TRUE;    // Estetn ohjelmiston tutkinta
			break;
		  case 'v':
		  case 'V':
			DFlags->DisableVESA = TRUE;     // Estetn VESA:n tutkinta
			break;
		  }
		 }
		else if( argc == 1 &&
			 argv[i][1] == '?' ||
			 argv[i][1] == 'H' ||
			 argv[i][1] == 'h' ) {
		 puts( VERSION_MSG );
		 puts( _CRIGHT_MSG );
		 puts( EMAIL_ADDR );
		 puts( "\nAvailable commandline arguments: <Drive:> -D[d/e/s/v] -V -H/?" );
		 puts( "    <Drive:> Drive to be checked e.g. A:, C:, D: etc.." );
		 puts( "    -Dd      Disable DPMI-memory detection." );
		 puts( "    -De      Disable EMS-memory detection." );
		 puts( "    -Do      Disable operating system detection." );
		 puts( "    -Ds      Disable detection of installed software." );
		 puts( "    -Dv      Disable VESA detection." );
		 puts( "    -V       Use direct video RAM instead of BIOS calls." );
		 puts( "    -H/?     Show available commandline arguments." );
		 exit( SUCCESFULL );
		 }
		else if( argv[i][1] == 'V' ||
			 argv[i][1] == 'v' )
		 directvideo = TRUE;
		else {
		 puts( VERSION_MSG );
		 puts( _CRIGHT_MSG );
		 puts( EMAIL_ADDR );
		 printf( "\nInvalid commandline argument - %s. \n\n",argv[i] );
		 puts( "Available commandline arguments: <Drive:> -D[d/e/s/v] -V -H/?" );
		 puts( "    <Drive:> Drive to be checked e.g. A:, C:, D: etc.." );
		 puts( "    -Dd      Disable DPMI-memory detection." );
		 puts( "    -De      Disable EMS-memory detection." );
		 puts( "    -Do      Disable operating system detection." );
		 puts( "    -Ds      Disable detection of installed software." );
		 puts( "    -Dv      Disable VESA detection." );
		 puts( "    -V       Use direct video RAM instead of BIOS calls." );
		 puts( "    -H/?     Show available commandline arguments." );
		 exit( FAILED );
		 }
		}
	  if( argv[i][0] >= 'A' &&
			argv[i][0] <= 'Z' &&
			argv[i][1] == ':' )
		DFlags->UDefinedDrive = argv[i][0];
	  if( argv[i][0] >= 'a' &&
			argv[i][0] <= 'z' &&
			argv[i][1] == ':' )
		DFlags->UDefinedDrive = argv[i][0];
	  }
	 }

	SGui->PrepareSniffer();               // Tehdn tarvittavat alkuvalmistelut

	if( SSWare->_GetWindowsInfo() ) {     // Otetaan selville onko Windows kynniss
	 puts( VERSION_MSG );
	 puts( _CRIGHT_MSG );
	 puts( EMAIL_ADDR );

	 puts( "\nSystem Sniffer might not work properly under Microsoft Windows." );
	 puts( "Your system might hang, crash or you might get fault results. \n" );
	 puts( "Press <I> to ignore or <A> to abort this program." );

	 do {
	  switch( inportb(0x60) ) {
		case A_KEY:                        // <A> Lopettaa
		 SGui->ExitProgram( HALTED );
		 break;
		case I_KEY:                        // <I> Jatkaa
		 asm   jmp Begin
		 break;
		 }
		} while(inportb(0x60) != I_KEY || inportb(0x60) != A_KEY);
	 }

	Begin:
	 clrscr();
	 _setcursortype(_NOCURSOR);

	 gotoxy(SCR_BEG - 15,1);
	 textbackground(BAR_BG),textcolor(BAR_TXT);
	  cprintf(" ");
	  GetChAttr(1,1); SetChAttr(1,1,chr,at,80);
	  GetChAttr(1,1); SetChAttr(1,25,chr,at,80);
	  _Center(1,80,1,CRIGHT_MSG);

	 textbackground(BG_BG),textcolor(BG_TXT);
	  for(TempB = SCR_TOP; TempB < SCR_BOT; TempB++)
		gotoxy(SCR_BEG - 15,TempB),cprintf("%s",SnifferScreen[TempB]);

	 textbackground(BG_BG),textcolor(PROGNAME_TXT);
	  for(TempB = HARDWARE; TempB <= QUIT; TempB++)
		_Center(MENU_X1,MENU_X2,TempB,ProgNames[TempB]);

	 SGui->ShowAboutInfo();               // Laitetaan About-ruutu ruudulle
	 delay(WAIT);                         // Annetaan aikaa sen lukemiseen

	 textbackground(HIGHLI_BG),textcolor(HIGHLI_TXT);
	 _Center(MENU_X1,MENU_X2,HARDWARE,ProgNames[HARDWARE]);
	 SHWare->GetHardwareInfo();           // Laitetaan mielivaltainen ruutu ruudulle

	 do {
	  SGui->GetDateAndTime();             // Laitetaan kello ja pvm ruudulle
	  SGui->ChkKbd();                     // Luetaan nppist
	  } while(inportb(0x60) != F10_KEY);  // <F10> lopettaa

	 SGui->QuitReally();                  // Mahdollistetaan lopetuksen peruutus
}
