/*
SYSTEM SNIFFER - SOFTWARE.CPP
Copyright (C) Tero Ripattila 1996-1998

Tunnistettavat ohjelmat ja toiminnot:
 - DESQview
 - pcANYWHERE III
 - pcANYWHERE IV/LAN
 - DOSKey
 - SmartDrive
 - DISPLAY.SYS
 - KEYB.COM
 - GRAFTABL.COM
 - APPEND
 - DoubleDOS
 - PC-CACHE.SYS
 - PRINT
 - ASSIGN
 - DRIVER.SYS
 - SHARE
 - NLSFUNC.COM
 - AVATAR.SYS
 - EGA.SYS
 - ANSI.SYS
*/

#include "dosext.cpp"
#include "country.cpp"
#include "powerman.cpp"

const STANDARD = 0x0002;
const ENHANCED = 0x0003;

enum DOS_INFO {
	_REVISION = 0x07,                     // 00000111b
	_DOS_ROM = 0x08,                      // 00001000b
        _DOS_HMA = 0x10 };                    // 00010000b

SnifferSWare::SnifferSWare(void)
{
}

SnifferSWare::~SnifferSWare(void)
{
}

void SnifferSWare::GetOSInfo(void)
{
        row = 3;
        SGui->PutCaptionAndMsg(SOFTWARE);

        if( !DFlags->DisableOS )
         SSWare->GetDOSInfo();
        SSWare->GetWindowsInfo();
        if( !DFlags->DisableSWare )
	 SSWare->GetSoftwareInfo();
        SSWare->GetPowerManInfo();
        SSWare->GetDOSEInfo();
        SSWare->GetCountryInfo();
}

void SnifferSWare::GetDOSInfo(void)
{
        byte OEMNumber = 0, Revision = 0, VerFlag = 0;
        word WIN95Flag = 0;
        major = minor = version = 0;
/*
        asm     push ds
        asm     push dx
        asm     push si
        asm     push di
*/
         asm    mov ax,0x4A33
         asm    int 0x2f
         asm    mov WIN95Flag,ax
/*
        asm     pop ds
        asm     pop dx
        asm     pop si
        asm     pop di
*/
        asm     mov ax,0x3000
        asm     int 0x21
        asm     mov OEMNumber,bh              // DOS:in OEMnumero talteen

        asm     mov ax,0x3306
        asm     int 0x21
        asm     mov version,bx                // Otetaan Tod DOS ver.num. talteen
        asm     mov Revision,dl               // Otetaan DOS:in pivitysnumero talteen
        asm     mov VerFlag,dh                // Otetaan versiolippu talteen

        textbackground(BG_BG);

        gotoxy(SCR_BEG,row++);
         textcolor(BG_TXT),cprintf(" Operating System..: ");
	 textcolor(ANSWER_TXT);
         major = LoWord( version );
         minor = HiWord( version );

         if(!major)
          cprintf("DOS \n");
         else if(major >= 0x0A)
          cprintf("OS/2 V%u.%02u \n",major / 10,minor);
         else if(major==0x32 && minor==0x05)
          cprintf("Windows NT \n");
         else if(major==0x06 && minor==0x00 && OEMNumber==0x00)
          cprintf("IBM DOS V6.10 \n");
         else if(major==0x06 && minor==0x10 && OEMNumber==0xef)
          cprintf("Novell DOS V7.00 \n");
         else if(!WIN95Flag)
          cprintf("Windows95, MS-DOS V%u.%02u \n",major,minor);
         else {
          cprintf("DOS V%u.%02u%c", major, minor, ( ( Revision &_REVISION ) + 'A' ) );
          if( VerFlag &_DOS_HMA )
           cprintf( " in HMA \n" );
	  else if( VerFlag &_DOS_ROM )
           cprintf( " in ROM \n" );
          gotoxy(SCR_BEG,row++);
           textcolor(BG_TXT),cprintf(" OEM number........: ");
           textcolor(ANSWER_TXT);
           switch(OEMNumber) {
            case 0x00: cprintf("IBM");                             break;
            case 0x01: cprintf("Compaq");                          break;
            case 0x02: cprintf("MS Packaged Product");             break;
            case 0x04: cprintf("AT&T");                            break;
            case 0x05: cprintf("ZDS");                             break;
            case 0x06: cprintf("Hewlett-Packard");                 break;
            case 0x07: cprintf("ZDS");                             break;
            case 0x0D: cprintf("Packard-Bell");                    break;
            case 0x16: cprintf("DEC");                             break;
            case 0x23: cprintf("Olivetti");                        break;
            case 0x28: cprintf("Texas Instruments");               break;
            case 0x29: cprintf("Toshiba");                         break;
            case 0x33: cprintf("Novell");                          break;
            case 0x34: cprintf("MS Multimedia Systems");           break;
	    case 0x35: cprintf("MS Multimedia Systems");           break;
            case 0x4d: cprintf("Hewlett-Packard");                 break;
            case 0x5e: cprintf("RxDOS");                           break;
            case 0x66: cprintf("PhysTechSoft");                    break;
            case 0x99: cprintf("General Software's Embedded DOS"); break;
            case 0xee: cprintf("DR DOS");                          break;
            case 0xef: cprintf("Novell");                          break;
            case 0xfd: cprintf("FreeDOS");                         break;
            case 0xff: cprintf("Microsoft or Phoenix");            break;
            default:   cprintf("Unknown [%02Xh]",OEMNumber);       break;
            }
          }
}

word SnifferSWare::_GetWindowsInfo(void)
{
        word modeflag = 0;

        asm     mov ax,0x160A
        asm     int 0x2F
	asm     mov modeflag,cx

        if(modeflag != STANDARD && modeflag != ENHANCED)
         modeflag = 0;

        return( modeflag );
}

void SnifferSWare::GetWindowsInfo(void)
{
        word modeflag = 0;
        version = 0;

        textbackground(BG_BG);

        asm     mov ax,0x160A
        asm     int 0x2F
        asm     mov version,bx                // Otetaan versionumero talteen
        asm     mov modeflag,cx               // Otetaan moodi talteen


        if(modeflag == STANDARD) {
         gotoxy(SCR_BEG,row++);
         textcolor(BG_TXT),    cprintf(" Microsoft Windows.: ");
         textcolor(ANSWER_TXT);
         if( HiWord( version ) == 4 )
          cprintf("Windows95 in standard mode \n");
         else
          cprintf("V%u.%02u in standard mode \n", HiWord( version ),
                  LoWord( version ) );
         }
        else if(modeflag == ENHANCED) {
         gotoxy(SCR_BEG,row++);
         textcolor(BG_TXT);    cprintf(" Microsoft Windows.: ");
         textcolor(ANSWER_TXT);
         if( HiWord( version ) == 4 )
          cprintf("Windows95 in enhanced mode \n");
	 else
	  cprintf("V%u.%02u in enhanced mode \n", HiWord( version ),
		  LoWord( version ) );
	 }
}

void SnifferSWare::GetSoftwareInfo(void)
{
	byte DESQState = 0,KMapState = 0,DDOSState = 0,AvatarState = 0,EGARNo = 0;
	word Any3state = 0,Any4state = 0,smarts = 0,smartv = 0,PCCacheState = 0,
	     PCCacheSeg = 0,PCCacheVer = 0,fcache = 0,csize = 0,oesize = 0,neuwin = 0,
	     KVersion = 0,AVersion = 0,AvatarProLev = 0,
	     AvatarDrvTyp = 0,EGAIState = 0;
	version = major = minor = 0;

	textbackground( BG_BG );

	asm     mov ah,0x2b
	asm     mov cx,0x4445
	asm     mov dx,0x5351
	asm     int 0x21
	asm     mov DESQState,al              // Onko DESQview asennettu
	asm     mov ah,0x2b
	asm     mov cx,0x4445
	asm     mov dx,0x5351
	asm     mov al,0x01
	asm     int 0x21
	asm     mov version,bx                // Ota DESQview:in versionumero talteen
	if(DESQState != 0xff) {
	 gotoxy(SCR_BEG,row++);
	  textcolor(BG_TXT),    cprintf(" DESQview..........: ");
	  textcolor(ANSWER_TXT),cprintf("V%u.%02u \n", HiWord( version ),
					LoWord( version ) );
	 }

	asm     mov ah,0x79
	asm     int 0x16
	asm     mov Any3state,ax              // Onko pcANYWHERE III asennettu
	if(Any3state >= 0xFFFC && Any3state < 0xFFFF) {
	 gotoxy(SCR_BEG,row++);
	  textcolor(BG_TXT),    cprintf(" pcANYWHERE III....: ");
	  textcolor(ANSWER_TXT);
	  switch(Any3state) {
	   case 0xFFFC: cprintf("In Automatic mode \n");       break;
	   case 0xFFFD: cprintf("In Memory Resident mode \n"); break;
	   case 0xFFFE: cprintf("Resident but not active \n"); break;
	   case 0xFFFF: cprintf("Resident and active \n");     break;
	   }
	 }

	asm     mov ax,0x2b44
	asm     mov bx,0x4d41
	asm     mov cx,0x7063
	asm     mov dx,0x4157
	asm     int 0x21
	asm     mov Any4state,ax              // Onko pcANYWHERE IV/LAN asennettu
	if(Any4state == 0x4F4B || Any4state == 0x6F6B) {
	 gotoxy(SCR_BEG,row++);
	  textcolor(BG_TXT),    cprintf(" pcANYWHERE IV/LAN.: ");
	  textcolor(ANSWER_TXT);
	  if(Any4state==0x4F4B)
	   cprintf("Large host resident \n");
	  else if(Any4state==0x6F6B)
	   cprintf("Small host resident \n");
	 }

	asm     mov ax,0x4800
	asm     int 0x2f
	if( _AL ) {
	 gotoxy(SCR_BEG,row++);
          textcolor(BG_TXT),    cprintf(" DOSKey............: ");
          textcolor(ANSWER_TXT),cprintf("Installed \n");
         }

        asm     mov ax,0x4a10
	asm     mov bx,0x0000
	asm     mov cx,0xebab
	asm     mov smarts,ax                 // Onko SmartDrive asennettu
	asm     mov smartv,bp                 // Ota SmartDriven versionumero talteen
	asm     mov ax,0x4a10
	asm     mov bx,0x0004
	asm     int 0x2f
	asm     mov fcache,ax                 // Koko cachen koko elementtein
	asm     mov csize,bx                  // Kytss oleva koko elementtein
	asm     mov oesize,cx                 // Yhden elementin koko tavuina
	asm     mov neuwin,dx                 // Elementtien mr Windows:in alla
	if(smarts == 0xbabe) {
	  gotoxy(16,row++);
	   textcolor(BG_TXT),    cprintf(" SmartDrive........: ");
	   textcolor(ANSWER_TXT),cprintf("V%u.%02u \n", HiWord( smartv ),
					 LoWord( smartv ) );
/*
	gotoxy(SCR_BEG + 21,12),cprintf("Size of full-sized cache     : %uB \n",fcache*oesize);
	gotoxy(SCR_BEG + 21,13),cprintf("Size of current size         : %uB \n",csize*oesize);
	gotoxy(SCR_BEG + 21,14),cprintf("Number of cache under Windows: %uB \n",neuwin*oesize);
	fcache = size in elements of full-sized cache
	csize  = current size in elements
	oesize = size of one element in bytes
	neuwin = number of elements under Windows
*/
	}

	asm     mov ax,0xAD00
	asm     int 0x2F
	if( _AL == 0xFF ) {
	 gotoxy(SCR_BEG,row++);
	  textcolor(BG_TXT),    cprintf( " DISPLAY.SYS.......: " );
	  textcolor(ANSWER_TXT),cprintf( "Installed \n" );
	 }

	asm     mov ax,0xad80
	asm     int 0x2f
	if( _AL == 0xFF ) {
		asm     mov KVersion,bx       // Ota versionumero talteen
		asm     mov ax,0xad83
		asm     int 0x2f
		asm     mov KMapState,bl      // Ota KBD MAPPING -tila selville
		gotoxy(SCR_BEG,row++);
		 textcolor(BG_TXT),    cprintf(" KEYB.COM..........: ");
		 textcolor(ANSWER_TXT),cprintf("V%u.%02u", HiWord( KVersion ),
					LoWord( KVersion ) );
		if( !KMapState )
		 cprintf(", US kbd \n");
		else if( KMapState == 0xFF )
		 cprintf(", NonUS kbd \n");
		}

	asm     mov ax,0xb000
	asm     int 0x2f
	if( _AL == 0xFF) {
	 gotoxy(SCR_BEG,row++);
	  textcolor(BG_TXT),    cprintf(" GRAFTABL.COM......: ");
	  textcolor(ANSWER_TXT),cprintf("Installed \n");
	 }

	asm     mov ax,0xb700
	asm     int 0x2f
	if( _AL == 0xFF ) {
		asm     mov ax,0xb702
		asm     int 0x2f
		asm     mov AVersion,ax       // Ota versionnumero talteen
		gotoxy(SCR_BEG,row++);
		 textcolor(BG_TXT),    cprintf(" APPEND............: ");
		 textcolor(ANSWER_TXT),cprintf("V%u.%02u \n", LoWord( AVersion ),
				       HiWord( AVersion ) );
		}

	asm     mov ax,0xe400
	asm     int 0x21
	if( _AL ) {
	 gotoxy(SCR_BEG,row++);
	  textcolor(BG_TXT),    cprintf(" DoubleDOS.........: ");
	  textcolor(ANSWER_TXT);
	  if( DDOSState == 0x01 )
	   cprintf("Running under visible DoubleDOS partition");
	  else if( DDOSState == 0x02 )
	   cprintf("Running under invisible DoubleDOS partition");
	 }

	asm     mov al,0xff
	asm     mov si,0x4358
	asm     int 0x25
	asm     mov PCCacheState,si           // Onko PC-CACHE.SYS asennettu
	asm     mov PCCacheSeg,cx             // Otetaan ajurin segmentti talteen
	asm     mov PCCacheVer,dx             // Otetaan versionumero talteen
	if(PCCacheState == 0x6378) {
	 gotoxy(SCR_BEG,row++);
	  textcolor(BG_TXT),    cprintf(" PC-CACHE.SYS......: ");
	  textcolor(ANSWER_TXT),cprintf("V%u.%02u, Segment: %04Xh \n",
					HiWord( PCCacheVer ),
					LoWord( PCCacheVer ),
					PCCacheSeg);
	 }

	asm     mov ax,0x0100
	asm     int 0x2f
	if( _AL == 0xFF ) {
	 gotoxy(SCR_BEG,row++);
	  textcolor(BG_TXT),    cprintf(" PRINT.............: ");
	  textcolor(ANSWER_TXT),cprintf("Installed \n");
	 }

	asm     mov ax,0x0600
	asm     int 0x2f
	if( _AL == 0xFF ) {
	 gotoxy(SCR_BEG,row++);
	  textcolor(BG_TXT),    cprintf(" ASSIGN............: ");
	  textcolor(ANSWER_TXT),cprintf("Installed \n");
	 }

	asm     mov ax,0x1400
	asm     int 0x2f
	if( _AL == 0xFF ) {
	 gotoxy(SCR_BEG,row++);
	  textcolor(BG_TXT),    cprintf(" NLSFUNC.COM.......: ");
	  textcolor(ANSWER_TXT),cprintf("Installed \n");
	 }

	asm     mov ax,0x1a00
	asm     mov bx,0x4156
	asm     mov cx,0x4154
	asm     mov dx,0x4152
	asm     int 0x2f
	asm     mov AvatarState,al            // Otetaan selville onko AVATAR asennettu
	asm     mov AvatarProLev,bx           // Otetaan selville mik protokolla taso on tuettu
	asm     mov AvatarDrvTyp,cx           // Otetaan selville ajurin tyyppi
	if(AvatarState == 0xFF) {
	 gotoxy(SCR_BEG,row++);
	  textcolor(BG_TXT),    cprintf(" AVATAR.SYS........: ");
	  textcolor(ANSWER_TXT),cprintf("Installed \n");
/*
	cprintf("Driver type: ");
	if(!AvatarDrvTyp)
	 cprintf("AVATAR.SYS");
	else if(AvatarDrvTyp==0x4456)
	 cprintf("DVAVATAR.COM");
	cprintf(", Protocol lev.sup.: %u",AvatarProLev);
*/
	 }

	asm     mov ax,0xBC00
	asm     int 0x2F
	if( _AL == 0xFF ) {
		asm     mov ax,0xBC06
		asm     int 0x2F
		asm     mov EGAIState,bx      // Otetaan talteen "tarkistuskirjaimet"
		asm     mov major,ch          // Otetaan versionumero talteen
		asm     mov minor,cl
		asm     mov EGARNo,dl         // Otetaan pivitysnumero talteen
		gotoxy(SCR_BEG,row++);
		 textcolor(BG_TXT),    cprintf(" EGA.SYS...........: ");
		 textcolor(ANSWER_TXT),cprintf("V%u.%02u r%u \n",major,minor,EGARNo);
		}

	asm	mov ax,0x1000
	asm	int 0x2F
	if( _AL == 0xFF ) {
	 gotoxy(SCR_BEG,row++);
	  textcolor(BG_TXT),    cprintf(" SHARE.............: ");
	  textcolor(ANSWER_TXT),cprintf("Installed \n");
	 }

	asm     mov ax,0x1A00
	asm     int 0x2F
	if( _AL == 0xFF ) {
	 gotoxy(SCR_BEG,row++);
	  textcolor(BG_TXT),    cprintf(" ANSI.SYS..........: ");
	  textcolor(ANSWER_TXT),cprintf("Installed \n");
	 }
}

void SnifferSWare::GetDOSEInfo(void)
{
        word *TempW;
        const byte *PLDOSEStr[5]= { NULL,"286DOSX SDK","286DOSX RTK","386DOSX SDK","386DOSX RTK" };

        textbackground( BG_BG );

        if(ChkDOS4GW())  {
         gotoxy(SCR_BEG,row++);
          textcolor(BG_TXT),    cprintf(" DOS/4GW...........: ");
          textcolor(ANSWER_TXT),cprintf("Installed \n");
         }
        if(ChkDOS16M())  {
         gotoxy(SCR_BEG,row++);
          textcolor(BG_TXT),    cprintf(" DOS/16M...........: ");
          textcolor(ANSWER_TXT),cprintf("Installed \n");
         }
        if(ChkDOS4G())  {
         gotoxy(SCR_BEG,row++);
          textcolor(BG_TXT),    cprintf(" DOS/4G............: ");
          textcolor(ANSWER_TXT),cprintf("Installed \n");
         }
        TempW = ChkPLDOSE();
        if(*TempW) {
         gotoxy(SCR_BEG,row++);
          textcolor(BG_TXT),    cprintf(" Phar Lap DOS/Ext..: ");
          textcolor(ANSWER_TXT);
			 for(TempB = _PLDE_286DOSX_SDK; TempB <= _PLDE_386DOSX_RTK; TempB++) {
           if( TempW[TempB] && PLDOSEStr[TempB] )
            cprintf("%s V%u.%02u \n",PLDOSEStr[TempB],
                    HiWord( TempW[TempB] ), LoWord( TempW[TempB] ) );
           else
            cprintf("Unknown");
           }
          }
        if(ChkDOSE()) {
         gotoxy(SCR_BEG,row++);
          textcolor(BG_TXT),    cprintf(" Phar Lap DOS/Ext..: ");
          textcolor(ANSWER_TXT),cprintf("Installed \n");
         }
}
