/*
SYSTEM SNIFFER - MEM.CPP
Copyright (C) Tero Ripattila 1996-1998
*/

#include "memman.cpp"

typedef struct {                              // DPMS=DOS Protected Mode Services
 byte	DPMSString[4];                        // "DPMS" -merkint
 word	DPMSVersion;                          // Versionumero
 byte	OEMString[8];                         // OEM -nimi
 word	OEMVersion;                           // OEM versionumero
 word	Flags;                                // DPMS liput
 byte	CPU;                                  // Prosessorin tyyppi
 } DPMSINFO;

SnifferMem::SnifferMem(void)
{
}

SnifferMem::~SnifferMem(void)
{
}

void SnifferMem::GetMemoryInfo(void)
{
	row = 3;
	SGui->PutCaptionAndMsg(MEMORY);

	textbackground(BG_BG);

	SMem->GetA20HandlerInfo();
	SMem->GetXMSMemInfo();
	if( !DFlags->DisableEMS )
	 SMem->GetEMSMemInfo();
	SMem->GetVCPIInfo();
	if( !DFlags->DisableDPMI )
	 SMem->GetDPMIInfo();
	SMem->GetDPMSInfo();
}

void SnifferMem::GetA20HandlerInfo(void)
{
	static const byte *A20SwitchMsg[3] = { "Medium","Fast","Slow" };
	byte A20State = 0,A20Switch = 0,hnum = 0;
	word FreeHMA = 0,HMASeg = 0,HMAOff = 0;

	asm	mov ax,0x4308
	asm	int 0x2f
	asm	mov A20State,al               // Onko A20:n kytt mahdollista
	asm	mov hnum,bl                   // A20 ksittelijn numero
	asm	mov A20Switch,bh              // A20 switch -aika
	asm	mov ax,0x4a01
	asm	int 0x2f
	asm	mov FreeHMA,bx                // HMA:n vapaa tila
	asm	mov HMASeg,es                 // HMA:n segmentti
	asm	mov HMAOff,di                 // HMA:n siirros

	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),cprintf(" DMA support............: ");
	 textcolor(ANSWER_TXT);
	 if( SPorts->BIOSEquipW() &0x0009 )
	  cprintf("Enabled");
	 else
	  cprintf("Disabled");

	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),    cprintf( " Base memory............: Total: ");
	 textcolor(ANSWER_TXT),cprintf( "%03u KB (%06lu B) \n",
					peek( 0x0040,0x0013 ),
					(long)peek( 0x0040,0x0013 ) << 10 );
/*
	gotoxy(SCR_BEG + 26,row++);
	 textcolor(BG_TXT),    cprintf( "Available: " );
	 textcolor(ANSWER_TXT),cprintf( "%03u KB (%06lu B) \n",
					GetAvailBMem() / 1024,
					GetAvailBMem() );
*/
	 if(A20State == 0x43) {
	  gotoxy(SCR_BEG,row++);
	   textcolor(BG_TXT),    cprintf(" A20 handler............: Handler number: ");
	   textcolor(ANSWER_TXT);
	   if( A20SwitchMsg[A20Switch] )
	    cprintf( "%u [%s] \n",hnum,A20SwitchMsg[A20Switch] );
	   else
	    cprintf( "%u [Unknown] \n",hnum );
	  }
	gotoxy(SCR_BEG,row);
	 textcolor(BG_TXT),cprintf(" High Memory Area (HMA).: ");
	 if(FreeHMA) {
	  gotoxy(SCR_BEG + 26,row++);
	   textcolor(BG_TXT),    cprintf("Available memory: ");
	   textcolor(ANSWER_TXT),cprintf("%u B \n",FreeHMA);
	  gotoxy(SCR_BEG + 26,row++);
	   textcolor(BG_TXT),    cprintf("Start address: ");
	   textcolor(ANSWER_TXT),cprintf("%04Xh:%04Xh \n",HMASeg,HMAOff);
	  }
	 else {
	  gotoxy(SCR_BEG + 26,row++);
	  textcolor(ANSWER_TXT),cprintf("DOS is not using HMA \n");
	  }
}

bool SnifferMem::ChkXMSMem(void)
{
	asm	mov ax,0x4300
	asm	int 0x2F

	if(_AL == 0x80)
	 return( TRUE );
	else
	 return( FALSE );
}

void SnifferMem::GetXMSMemInfo(void)
{
	byte ecode = 0,errcode = 0;
	dword XMSCallAddress = 0;
	word XMSVersion = 0,DrvVersion = 0,hmaflag = 0,AllMem = 0,FreeMem = 0,A20Flag = 0;
	byte *XMSErrors[0xB2];

	XMSErrors[0x00] = "Successful";
	XMSErrors[0x80] = "Function not implemented";
	XMSErrors[0x81] = "Vdisk was detected";
	XMSErrors[0x82] = "An A20 error occurred";
	XMSErrors[0x8e] = "A general driver error";
	XMSErrors[0x8f] = "Unrecoverable driver error";
	XMSErrors[0x90] = "HMA does not exist or is not managed by XMS provider";
	XMSErrors[0x91] = "HMA is already in use";
	XMSErrors[0x92] = "DX is less than the /HMAMIN= parameter";
	XMSErrors[0x93] = "HMA is not allocated";
	XMSErrors[0x94] = "A20 line still enabled";
	XMSErrors[0xa0] = "All extended memory is allocated";
	XMSErrors[0xa1] = "All available extended memory handles are allocated";
	XMSErrors[0xa2] = "Invalid handle";
	XMSErrors[0xa3] = "Source handle is invalid";
	XMSErrors[0xa4] = "Source offset is invalid";
	XMSErrors[0xa5] = "Destination handle is invalid";
	XMSErrors[0xa6] = "Destination offset is invalid";
	XMSErrors[0xa7] = "Length is invalid";
	XMSErrors[0xa8] = "Move has an invalid overlap";
	XMSErrors[0xa9] = "Parity error occurred";
	XMSErrors[0xaa] = "Block is not locked";
	XMSErrors[0xab] = "Block is locked";
	XMSErrors[0xac] = "Block lock count overflowed";
	XMSErrors[0xad] = "Lock failed";
	XMSErrors[0xb0] = "Only a smaller UMB is available";
	XMSErrors[0xb1] = "No UMB's are available";
	XMSErrors[0xb2] = "UMB segment number is invalid";

	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),cprintf(" Extended memory (XMS)..: ");
	 textcolor(ANSWER_TXT);

	 if(SMem->ChkXMSMem()) {
	  asm	mov  ax,0x4310                           // XMS -kutsuosoite talteen
	  asm	int  0x2f
	  asm	mov  [word ptr XMSCallAddress],bx        // Segmentti talteen
	  asm	mov  [word ptr XMSCallAddress+2],es	 // Siirros talteen
	  asm	mov  ah,0x00
	  asm	call [dword ptr XMSCallAddress]
	  asm	mov  XMSVersion,ax                       // Versionumero (XMS) talteen
	  asm	mov  DrvVersion,bx                       // Versionumero (XMM) talteen
	  asm	mov  hmaflag,dx                          // Lytyyk HMA:ta?
	  asm	mov  ah,0x07
	  asm	call [dword ptr XMSCallAddress]
	  asm	mov  A20Flag,ax                          // Otetaan A20:n tila selville
	  asm	mov  ecode,bl                            // Virhekoodi talteen
	  asm	mov  ah,0x08
	  asm	call [dword ptr XMSCallAddress]
	  asm	mov  FreeMem,ax                          // Suurin yhteninen alue
	  asm	mov  AllMem,dx                           // Koko XMS-mr
	  asm	mov  errcode,bl                          // Virhekoodi talteen

	  if(errcode == 0x80)
	   cprintf("%s",XMSErrors[1]);
	  else if(errcode == 0x81)
	   cprintf("%s",XMSErrors[2]);
	  else if(errcode == 0xa0)
	   cprintf("%s",XMSErrors[11]);
	  else if(errcode != 0x80 &&
		  errcode != 0x81 &&
		  errcode != 0xa0 ) {       // Ei esiintynyt virheit
	    textcolor(BG_TXT),    cprintf("Total: ");
	    textcolor(ANSWER_TXT),cprintf("%u KB \n",AllMem);
	   gotoxy(SCR_BEG + 26,row++);
	    textcolor(BG_TXT),    cprintf("Largest block: ");
	    textcolor(ANSWER_TXT),cprintf("%u KB",FreeMem);
	   gotoxy(SCR_BEG + 26,row++);
	    textcolor(BG_TXT),    cprintf("XMS version: ");
	    textcolor(ANSWER_TXT),ShowBCD(XMSVersion);
	   gotoxy(SCR_BEG + 26,row++);
	    textcolor(BG_TXT),    cprintf("XMM version: ");
	    textcolor(ANSWER_TXT),ShowBCD(DrvVersion);
	    }
	   }
	  else
	   cprintf("Not present \n");
}

bool SnifferMem::ChkEMSMem(void)
{
	word EMMSeg = 0,EMMOff = 0;
	byte EMMStr[8] = "";

	EMMSeg = HiDword( (dword)getvect(0x67) );
	EMMOff = 0x000A;

	for( int i = 0; i < 8; i++ )
	 EMMStr[i] = peekb( EMMSeg,EMMOff++ );

	EMMStr[8] = '\0';

	return( !memcmp( EMMStr,"EMMXXXX0",8 ) ? TRUE : FALSE );
}

void SnifferMem::GetEMSMemInfo(void)
{
	byte EMMVersion = 0;
	word PageFrame = 0,AllPages = 0,FreePages = 0;

	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),cprintf(" Expanded memory (EMS)..: ");
	 textcolor(ANSWER_TXT);

	if(SMem->ChkEMSMem()) {
	 asm	mov ah,0x41
	 asm	int 0x67
	 asm	mov PageFrame,bx              // EMS-ikkunan sijainti
	 asm	mov ah,0x42
	 asm	int 0x67
	 asm	mov FreePages,bx              // Vapaiden EMS-sivujen (16KB) mr
	 asm	mov AllPages,dx               // Kaikkien EMS-sivujen (16KB) mr
	 asm	mov ah,0x46
	 asm	int 0x67
	 asm	mov EMMVersion,al     	      // Versionumero

	  textcolor(BG_TXT),    cprintf("Total: ");
	  textcolor(ANSWER_TXT),cprintf("%u KB \n",AllPages*16);
	 gotoxy(SCR_BEG + 26,row++);
	  textcolor(BG_TXT),    cprintf("Available: ");
	  textcolor(ANSWER_TXT),cprintf("%u KB \n",FreePages*16);
	 gotoxy(SCR_BEG + 26,row++);
	  textcolor(BG_TXT),    cprintf("EMM version: ");
	  textcolor(ANSWER_TXT),cprintf("%u.%02u \n",HiByte( EMMVersion ),
					LoByte( EMMVersion ) );
	 gotoxy(SCR_BEG + 26,row++);
	  textcolor(BG_TXT),    cprintf("Page frame: ");
	  textcolor(ANSWER_TXT),cprintf("%04Xh \n",PageFrame);

	if(ChkQEMM()) {
	 gotoxy(SCR_BEG,row++);
	  textcolor(BG_TXT),    cprintf( " QEMM-386...............: " );
	  textcolor(ANSWER_TXT),cprintf( "Present \n" );
	  }
	if(ChkMicEMM()) {
	 gotoxy(SCR_BEG,row++);
	  textcolor(BG_TXT),    cprintf( " Micronics EMM..........: " );
	  textcolor(ANSWER_TXT),cprintf( "Present \n" );
	  }
	if(ChkRM386()) {
	 gotoxy(SCR_BEG,row++);
	  textcolor(BG_TXT),    cprintf( " RM386..................: " );
	  textcolor(ANSWER_TXT),cprintf( "Present \n" );
	 }
	if(ChkEMM386()) {
	 gotoxy(SCR_BEG,row++);
	  textcolor(BG_TXT),    cprintf( " Microsoft EMM386.EXE...: " );
	  textcolor(ANSWER_TXT),cprintf( "Present \n" );
/*
	  SMem->AnalyseEMM386();
*/
	  }
	if(ChkVIDEMS()) {
	 gotoxy(SCR_BEG,row++);
	  textcolor(BG_TXT),    cprintf( " VIDEMS.SYS.............: " );
	  SMem->AnalyseVIDEMS();
	  }
	if(Chk386MAX()) {
	 gotoxy(SCR_BEG,row++);
	  textcolor(BG_TXT),    cprintf( " Qualitas 386MAX........: " );
	  textcolor(ANSWER_TXT),cprintf( "Present \n" );
	 }
	} else cprintf("Not present \n");
}

void SnifferMem::GetVCPIInfo(void)
{
	byte VCPIState = 0;
	word FreePages = 0;
	version = major = minor = 0;

	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),cprintf(" VCPI...................: ");
	 textcolor(ANSWER_TXT);

	if( SMem->ChkEMSMem() ) {
	 asm	mov ax,0xde00
	 asm	int 0x67                      // VCPI = Virtual Control Program Interface
	 asm	mov VCPIState,ah              // Otetaan selv onko VCPI asennettu
	 asm	mov version,bx                // Otetaan versionumero talteen
	 asm	mov ax,0xde03
	 asm	int 0x67
	 asm	mov FreePages,dx              // Otetaan vapaiden sivujen (4KB) lkm

	 if(!VCPIState) {
	   textcolor(ANSWER_TXT),cprintf("V%u.%02u", HiWord( version ),
					  LoWord( version ) );
	   textcolor(BG_TXT),    cprintf(", Available: " );
	   textcolor(ANSWER_TXT),cprintf("%u KB \n",FreePages * 4);
	   } else textcolor(ANSWER_TXT),cprintf("Not present \n");
	  } else textcolor(ANSWER_TXT),cprintf("Not present \n");
}

void SnifferMem::GetDPMIInfo(void)
{
	static const byte *DPMICPU[5] = { "?????","?????","80286","80386","80486" };
	byte cpu = 0;
	word SwitchSeg = 0,SwitchOff = 0,DPMIState = 0,DPMIMode = 0;
	version = 0;

	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),cprintf(" DPMI...................: ");

	asm	mov ax,0x1686
	asm	int 0x2f
	asm	mov DPMIMode,ax               // Otetaan kytss oleva tila selville
	asm	mov ax,0x1687
	asm	int 0x2f
	asm	mov ax,DPMIState              // Onko DPMI asennettu
	asm	mov version,dx                // Otetaan versionumero talteen
	asm	mov cpu,cl                    // Mik prosessori on kytss
	asm	mov SwitchSeg,es              // Otetaan SwitchModeEntry -segmentti
	asm	mov SwitchOff,di              // Otetaan SwitchModeEntry -siirros

	if(!DPMIState) {
	  textcolor(ANSWER_TXT),cprintf("V%u.%02u", HiWord( version ),
					LoWord( version ) );
	  if(!DPMIMode)
	   cprintf(", protected mode \n");
	  else
	   cprintf(", Real/V86 mode \n");
	 gotoxy(SCR_BEG + 26,row++);
	  textcolor(BG_TXT),    cprintf("Processor: ");
	  textcolor(ANSWER_TXT);
	  if( DPMICPU[cpu] )
	   cprintf( "%s \n",DPMICPU[cpu] );
	  else
	   cprintf( "Unknown \n" );
	 gotoxy(SCR_BEG + 26,row++);
	  textcolor(BG_TXT),    cprintf("Switch mode entry: ");
	  textcolor(ANSWER_TXT),cprintf("%04Xh:%04Xh \n",SwitchSeg,SwitchOff);
	 } else textcolor(ANSWER_TXT),cprintf("Not present \n");
}

void SnifferMem::GetDPMSInfo(void)
{
	DPMSINFO *DPMSInfo;
	byte _major = 0,_minor = 0;
	major = 0,minor = 0;

	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),cprintf(" DPMS server............: ");

	inregs.x.ax = 0x43e0;
	inregs.x.bx = 0x0000;
	inregs.x.cx = 0x4450;
	inregs.x.dx = 0x4d53;
	inregs.x.di = FP_OFF( DPMSInfo );
	segregs.es  = FP_SEG( DPMSInfo );
	int86x(0x2f,&inregs,&outregs,&segregs);

	if( !memcmp( DPMSInfo->DPMSString,"DPMS",4 ) ) {
	 major = HiWord( DPMSInfo->DPMSVersion );
	 minor = LoWord( DPMSInfo->DPMSVersion );
	 _major = HiWord( DPMSInfo->OEMVersion );
	 _minor = LoWord( DPMSInfo->OEMVersion );
	  textcolor(ANSWER_TXT),cprintf("V%u.%02u \n",major,minor);
	 gotoxy(SCR_BEG + 26,row++);
	  textcolor(BG_TXT),    cprintf("OEM id: ");
	  textcolor(ANSWER_TXT),cprintf("%s \n",DPMSInfo->OEMString);
	 gotoxy(SCR_BEG + 26,row++);
	  textcolor(BG_TXT),    cprintf("OEM version: ");
	  textcolor(ANSWER_TXT),cprintf("%u.%02u \n",_major,_minor);
	 } else textcolor(ANSWER_TXT),cprintf("Not present \n");
}

long SnifferMem::GetAvailBMem( void )
{
	asm	mov ah,0x48
	asm	mov bx,0xFFFF
	asm	int 0x21

        return( _BX * 16L );
}
