/*
SYSTEM SNIFFER - CMOS.CPP
Copyright (C) Tero Ripattila 1996-1998
*/

static const byte *WDay[8] = { "???","Sunday","Monday","Tuesday","Wednesday",
		       "Thursday","Friday","Saturday" };
static const byte *Month[13] = { "???","January","February","March","April",
		       "May","June","July","August","September",
		       "October","November","December" };
static const byte *Screen[4] = { "EGA/VGA","CGA 40col","CGA 80col","Monochrome" };
static const byte *Floppy[6] = { "None installed","5.25inch 360KB","5.25inch 1.2MB",
		       "3.5inch 720KB","3.5inch 1.44MB","3.5inch 2.88MB" };

struct CMOS_INFO {
 byte VideoType;
 byte AFloppyType,BFloppyType;
 };

struct CMOS_DATE {
 byte Date,Month,Year,Century;
 byte Hour,Min,Sec,pmFlag;
 };

struct CMOS_DISK {
 word Cylinders,Heads,PreComp,LZ,Sectors;
 byte Floppy,HD0,HD1,HDType;
 };

byte PS2Flag = 0,PhoenixFlag = 0;
word ComputedChksum = 0,CMOSChksum = 0,CMOSSeg = 0,CMOSOff = 0,i = 0;

SnifferCMOS::SnifferCMOS(void)
{
}

SnifferCMOS::~SnifferCMOS(void)
{
}

void SnifferCMOS::GetCMOSInfo(void)
{
	CMOS_DATE *Cal;
	CMOS_DISK *Disk;
	CMOS_INFO *CInfo;

	row = 3;

	SGui->PutCaptionAndMsg(CMOS);

	textbackground(BG_BG);

	regs.h.ah = 0xC0;
	int86(0x15,&regs,&regs);
	CMOSSeg = _ES;
	CMOSOff = _BX;

	if(!outregs.x.cflag || peek(0xFFFF,0x0E) < 0xFD) {
	 if(peek(CMOSSeg,CMOSOff + 2) == 0xF8)
	  PS2Flag = TRUE;
	 if(peekb(CMOSSeg,CMOSOff + 0x0D) == 'P' &&
	    peekb(CMOSSeg,CMOSOff + 0x0E) == 'T' &&
	    peekb(CMOSSeg,CMOSOff + 0x0F) == 'L')
	  PhoenixFlag=TRUE;

	 gotoxy(SCR_BEG,row++);
	  textcolor(BG_TXT),cprintf(" Battery status..: ");
	  textcolor(ANSWER_TXT);
	  if(SCmos->ReadCMOS(0x0D) &0x80)
	   cprintf("OK \n");
	  else
	   cprintf("Dead/Disconnected \n");

	 gotoxy(SCR_BEG,row++);
	  textcolor(BG_TXT),cprintf(" Diagnostics.....: ");
	  textcolor(ANSWER_TXT);
	  if(!SCmos->ReadCMOS(0x0E)) cprintf("OK \n");
	   else {
	    if(SCmos->ReadCMOS(0x0E) &0x80)
	     cprintf("Clock lost power \n");
	    if(SCmos->ReadCMOS(0x0E) &0x40)
	     gotoxy(SCR_BEG + 17,row++),cprintf("Incorrect checksum \n");
	    if(SCmos->ReadCMOS(0x0E) &0x20)
	     gotoxy(SCR_BEG + 17,row++),cprintf("Equipment config incorrect \n");
	    if(SCmos->ReadCMOS(0x0E) &0x10)
	     gotoxy(SCR_BEG + 17,row++),cprintf("Memory size error \n");
	    if(SCmos->ReadCMOS(0x0E) &0x08)
	     gotoxy(SCR_BEG + 17,row++),cprintf("Disk drive/controller initialization failed \n");
	    if(SCmos->ReadCMOS(0x0E) &0x04)
	     gotoxy(SCR_BEG + 17,row++),cprintf("Invalid time \n");
	    if(SCmos->ReadCMOS(0x0E) &0x02)
	     gotoxy(SCR_BEG + 17,row++),cprintf("Incorrect adaptor config \n");
	    if(SCmos->ReadCMOS(0x0E) &0x01)
	     gotoxy(SCR_BEG + 17,row++),cprintf("Timeout while reading adaptor ID \n");
	    }

	 SCmos->GetCMOSDate(Cal);
	 SCmos->GetCMOSTime(Cal);

	 gotoxy(SCR_BEG,row++);
	  textcolor(BG_TXT),cprintf(" Video type......: ");
	  textcolor(ANSWER_TXT);
	   CInfo->VideoType = (SCmos->ReadCMOS(0x14) >>4) &0x03;
	   if( Screen[CInfo->VideoType] )
	    cprintf( "%s \n",Screen[CInfo->VideoType] );
	   else
	    cprintf( "Unknown [%02Xh] \n",CInfo->VideoType );

	 gotoxy(SCR_BEG,row++);
	  textcolor(BG_TXT),cprintf(" Co-processor....: ");
	  textcolor(ANSWER_TXT);
	  if(SCmos->ReadCMOS(0x14) &0x02)
	   cprintf("Installed \n");
	  else
	   cprintf("None installed \n");

	 gotoxy(SCR_BEG,row++);
	  textcolor(BG_TXT),cprintf(" Floppy drive A..: ");
	  textcolor(ANSWER_TXT);
	   CInfo->AFloppyType = SCmos->ReadCMOS(0x10) >>4;
	   if( Floppy[CInfo->AFloppyType] )
	    cprintf( "%s \n",Floppy[CInfo->AFloppyType] );
	   else
	    cprintf( "Unknown [%02Xh] \n",CInfo->AFloppyType );

	 gotoxy(SCR_BEG,row++);
	  textcolor(BG_TXT),cprintf(" Floppy drive B..: ");
	  textcolor(ANSWER_TXT);
	   CInfo->BFloppyType = SCmos->ReadCMOS(0x10) &0x0F;
	   if( Floppy[CInfo->BFloppyType] )
	    cprintf( "%s \n",Floppy[CInfo->BFloppyType] );
	   else
	    cprintf( "Unknown [%02Xh] \n",CInfo->BFloppyType );

	 gotoxy(SCR_BEG,row++);
	  textcolor(BG_TXT),cprintf(" 1st Hard disk...: ");
	  textcolor(ANSWER_TXT);

	  if(!PS2Flag) {
	   Disk->HD0 = SCmos->ReadCMOS(0x12) >>4;
	   Disk->HD1 = SCmos->ReadCMOS(0x12) &0x0F;
	   if(Disk->HD0 == 0x0F)
	    Disk->HD0 = SCmos->ReadCMOS(0x19);
	   if(Disk->HD1 == 0x0F)
	    Disk->HD1 = SCmos->ReadCMOS(0x1A);
	   }
	  else {
	   Disk->HD0 = SCmos->ReadCMOS(0x11);
	   Disk->HD1 = SCmos->ReadCMOS(0x12);
	   }

	  if(!Disk->HD0)
	   cprintf("None installed \n");
	  else {
	   if(Disk->HD0 < 47) {
	    Disk->HDType = Disk->HD0;
	    SCmos->GetHDValues(Disk);
	    SCmos->ShowHDValues(Disk);
	    }
	   else if(PhoenixFlag && Disk->HD0 >= 48) {
	    Disk->Cylinders = ((word)SCmos->ReadCMOS(0x21) <<8) + SCmos->ReadCMOS(0x20);
	    Disk->Heads     = SCmos->ReadCMOS(0x22);
	    Disk->PreComp   = ((word)SCmos->ReadCMOS(0x24) <<8) + SCmos->ReadCMOS(0x23);
	    Disk->LZ        = ((word)SCmos->ReadCMOS(0x26) <<8) + SCmos->ReadCMOS(0x25);
	    Disk->Sectors   = SCmos->ReadCMOS(0x27);
	    Disk->HDType    = Disk->HD0;
	    SCmos->ShowHDValues(Disk);
	    }
	   else
	    cprintf("Type: %u \n",Disk->HD0);
	   }

	 gotoxy(SCR_BEG,row++);
	  textcolor(BG_TXT),cprintf(" 2nd Hard disk...: ");
	  textcolor(ANSWER_TXT);

	  if(!Disk->HD1)
	   cprintf ("None installed \n");
	  else {
	   if(Disk->HD1 < 47) {
	    Disk->HDType = Disk->HD1;
	    SCmos->GetHDValues(Disk);
	    SCmos->ShowHDValues(Disk);
	    }
	   else if(PhoenixFlag && Disk->HD1 >= 48) {
	    Disk->Cylinders = ((word)SCmos->ReadCMOS(0x36) <<8) + SCmos->ReadCMOS(0x35);
	    Disk->Heads     = SCmos->ReadCMOS(0x37);
	    Disk->PreComp   = ((word)SCmos->ReadCMOS(0x39) <<8) + SCmos->ReadCMOS(0x38);
	    Disk->LZ        = ((word)SCmos->ReadCMOS(0x3B) <<8) + SCmos->ReadCMOS(0x3A);
	    Disk->Sectors   = SCmos->ReadCMOS(0x3C);
	    Disk->HDType    = Disk->HD1;
	    SCmos->ShowHDValues(Disk);
	    }
	   else
	    cprintf("Type: %u \n",Disk->HD1);
	    }

	 gotoxy(SCR_BEG,row++);
	  textcolor(BG_TXT),    cprintf(" Base Memory.....: ");
	  textcolor(ANSWER_TXT),cprintf("%u KB",((word)SCmos->ReadCMOS(0x16)<<8) + SCmos->ReadCMOS(0x15));

	 gotoxy(SCR_BEG,row++);
	  textcolor(BG_TXT),    cprintf(" XMS Memory......: ");
	  textcolor(ANSWER_TXT),cprintf("%u KB",((word)SCmos->ReadCMOS(0x18)<<8) + SCmos->ReadCMOS(0x17));

	 gotoxy(SCR_BEG,row++);
	  textcolor(BG_TXT),cprintf(" CMOS Chksum.....: ");
	  textcolor(ANSWER_TXT);

	  if(!PS2Flag) {
	   for(i = 0x10; i <= 0x2D; i++) {
	    ComputedChksum += SCmos->ReadCMOS(i);
	    CMOSChksum = ((word)SCmos->ReadCMOS(0x2E) <<8) + SCmos->ReadCMOS(0x2F);
	    }
	   }
	  else {
	   for(i = 0x10; i <= 0x31; i++) {
	    ComputedChksum += SCmos->ReadCMOS(i);
	    CMOSChksum = ((word)SCmos->ReadCMOS(0x33) <<8) + SCmos->ReadCMOS(0x32);
	    }
	   }

	  if(ComputedChksum == CMOSChksum)
	   cprintf("OK \n");
	  else
	   cprintf("Error: %04Xh *should be* %04Xh \n",CMOSChksum,ComputedChksum);
	 }
	else
	 cprintf("*Nonstandard* CMOS detected \n");
}

byte SnifferCMOS::ReadCMOS(byte Addr)
{
	asm cli;
	outportb(0x70,Addr);
	asm sti;

	return( inportb(0x71) );
}

void SnifferCMOS::WriteCMOS(byte Addr,byte Data)
{
	asm cli;
	outportb(0x70,Addr);
	outportb(0x71,Data);
	asm sti;
}

void SnifferCMOS::GetCMOSDate(struct CMOS_DATE *Cal)
{
/*
	if(!SCmos->ReadCMOS(0x0B) &0x04) {          // Kytetn BCD -lukuja
	 Cal->Date  = UnBCD(SCmos->ReadCMOS(0x07));
	 Cal->Month = UnBCD(SCmos->ReadCMOS(0x08));
	 Cal->Year  = UnBCD(SCmos->ReadCMOS(0x09));
	 if(PS2Flag) Cal->Century = UnBCD(SCmos->ReadCMOS(0x37));
	  else Cal->Century = UnBCD(SCmos->ReadCMOS(0x32));
	 } else {                                     // Ei kytet BCD -lukuja
	 Cal->Date  = SCmos->ReadCMOS(0x07);
	 Cal->Month = SCmos->ReadCMOS(0x08);
	 Cal->Year  = SCmos->ReadCMOS(0x09);
	 if(PS2Flag) Cal->Century = SCmos->ReadCMOS(0x37);
	  else Cal->Century = SCmos->ReadCMOS(0x32);
	 }
*/
	Cal->Date  = UnBCD(SCmos->ReadCMOS(0x07));
	Cal->Month = UnBCD(SCmos->ReadCMOS(0x08));
	Cal->Year  = UnBCD(SCmos->ReadCMOS(0x09));

	if(PS2Flag)
	 Cal->Century = UnBCD(SCmos->ReadCMOS(0x37));
	else
	 Cal->Century = UnBCD(SCmos->ReadCMOS(0x32));

	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),    cprintf(" Date:...........: ");
	 textcolor(ANSWER_TXT);
	  if( Cal->Month && Cal->Month <= 12 )
	   cprintf("%02u %s, %02u%02u",Cal->Date,Month[Cal->Month],
		   Cal->Century,Cal->Year);
	  else
	   cprintf("Unknown");
}

void SnifferCMOS::GetCMOSTime(struct CMOS_DATE *Cal)
{
/*
	if(!SCmos->ReadCMOS(0x0B) &0x04) {          // Kytetn BCD -lukuja
	 Cal->Hour = UnBCD(SCmos->ReadCMOS(0x04));
	 Cal->Min  = UnBCD(SCmos->ReadCMOS(0x02));
	 Cal->Sec  = UnBCD(SCmos->ReadCMOS(0x00));
	 } else {                                     // Ei kytet BCD -lukuja
	 Cal->Hour = SCmos->ReadCMOS(0x04);
	 Cal->Min  = SCmos->ReadCMOS(0x02);
	 Cal->Sec  = SCmos->ReadCMOS(0x00);
	 }
*/
	Cal->Hour = UnBCD(SCmos->ReadCMOS(0x04));
	Cal->Min  = UnBCD(SCmos->ReadCMOS(0x02));
	Cal->Sec  = UnBCD(SCmos->ReadCMOS(0x00));

	if(!SCmos->ReadCMOS(0x0B) &0x02) {            // Kytss on 12h kello (oletus on 24h)
	 if( Cal->Hour > 12 )
	  Cal->Hour = (Cal->Hour - 128) + 11;
	 else
	  Cal->Hour--;
	 }
	else {
	 if( !Cal->Hour )
	  Cal->Hour = 12;
	 else if( Cal->Hour >= 1 && Cal->Hour <= 11 )
	  Cal->Hour = Cal->Hour;
	 else if( Cal->Hour == 12 )
	  Cal->pmFlag = TRUE;
	 else if( Cal->Hour >= 13 && Cal->Hour <= 23) {
	  Cal->pmFlag = TRUE;
	  Cal->Hour = Cal->Hour - 12;
	  }
	 }
	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),    cprintf(" Time:...........: ");
	 textcolor(ANSWER_TXT),cprintf("%02u:%02u:%02u",Cal->Hour,Cal->Min,Cal->Sec);
	 if(Cal->pmFlag)
	  cprintf(" PM");
	 else
	  cprintf(" AM");
}

void SnifferCMOS::GetHDValues(struct CMOS_DISK *Disk)
{
	word HDOffs = 0;

	HDOffs = 0xE401 + ((Disk->HDType-1) * 16);
	Disk->Cylinders = peek(0xF000,HDOffs);
	Disk->Heads = peek(0xF000,HDOffs + 0x02);
	Disk->PreComp = peek(0xF000,HDOffs + 0x05);
	Disk->LZ = peek(0xF000,HDOffs + 0x0C);
	Disk->Sectors = peek(0xF000,HDOffs + 0x0E);
}

void SnifferCMOS::ShowHDValues(struct CMOS_DISK *Disk)
{
	gotoxy(SCR_BEG + 18,row);
	 textcolor(BG_TXT),    cprintf(" Cylinders: ");
	 textcolor(ANSWER_TXT),cprintf("%u \n",Disk->Cylinders);
	gotoxy(SCR_BEG + 18, row++);
	 textcolor(BG_TXT),    cprintf(" Heads    : ");
	 textcolor(ANSWER_TXT),cprintf("%u \n",Disk->Heads);
	gotoxy(SCR_BEG + 18, row++);
	 textcolor(BG_TXT),    cprintf(" Sectors  : ");
	 textcolor(ANSWER_TXT),cprintf("%u \n",Disk->Sectors);
	gotoxy(SCR_BEG + 18, row++);
	 textcolor(BG_TXT),    cprintf(" LZ       : ");
	 textcolor(ANSWER_TXT),cprintf("%u \n",Disk->LZ);
	gotoxy(SCR_BEG + 18, row++);
	 textcolor(BG_TXT),    cprintf(" PreComp  : ");
	 textcolor(ANSWER_TXT),cprintf("%u \n",Disk->PreComp);
}