/*
SYSTEM SNIFFER - SS.H
Copyright (C) Tero Ripattila 1996-1998
*/

#ifndef _SS_H
#define _SS_H

#ifndef _BASEDEFS_H
	#include "basedefs.h"
#endif

//
// Basic application information
//
#define SS_VERSION   "1.03"
#define CRIGHT_MSG   "SYSTEM SNIFFER " SS_VERSION  " Copyright (C) Tero Ripattila 1996-1998"
#define _CRIGHT_MSG  "Copyright (C) Tero Ripattila 1996-1998"
#define VERSION_MSG  "SYSTEM SNIFFER, version " SS_VERSION
#define REL_DATE_MSG "Release date " __DATE__
#define EMAIL_ADDR   "tero.ripattila@kolumbus.fi"

//
// Menu delays
//
const WAIT = 1250;
const KBD_WAIT = 125;

//
// GUI color definitions
//
enum SNIFFER_COLOR_DEFS {
	BG_BG = 9,
	BG_TXT = 7,
	BAR_BG = 7,
	BAR_TXT = 0,
	ANSWER_TXT = 13,
	MSG_TXT = 1,
	SPCL_TXT = 15,
	ERROR_TXT = 4,
	PROGNAME_TXT = 11,
	HIGHLI_BG = 3,
	HIGHLI_TXT = 5,
	DOS_BG = 0,
	DOS_TXT = 7 };

//
// GUI area definitions
//
enum SNIFFER_POS_DEFS {
	MENU_X1 = 1,
	MENU_X2 = 13,
	SCR_X1 = 15,
	SCR_X2 = 80,
	SCR_BEG = 16,
	SCR_TOP = 2,
	SCR_BOT = 25 };

//
// Key definitions
//
enum SNIFFER_KEY_DEFS {
	T_KEY = 0x14,
	Y_KEY = 0x15,
	I_KEY = 0x17,
	ENTER_KEY = 0x1C,
	A_KEY = 0x1E,
	C_KEY = 0x2E,
	N_KEY = 0x31,
	F1_KEY = 0x3B,
	F2_KEY = 0x3C,
	F10_KEY = 0x44,
	U_ARROW = 0x48,
	L_ARROW = 0x4B,
	R_ARROW = 0x4D,
	D_ARROW = 0x50,
	PDOWN_KEY = 0x51 };

//
// Available screens
//
enum SNIFFER_SCREENS {
	HARDWARE = 3,
	SOFTWARE,
	MEMORY,
	VIDEO,
	DISK,
	PORTS,
	IRQ,
	CMOS,
	NETWORK,
	HELP,
	ABOUT,
	QUIT };

//
// Commandline management
//
struct DISABLE_FLAGS {
 byte DisableEMS,
		DisableDPMI,
		DisableOS,
		DisableSWare,
		DisableVESA,
		UDefinedDrive;
 };

DISABLE_FLAGS *DFlags;

static word version = 0;
static byte major = 0,minor = 0,row = 0,Scr = 0,TempB = 0;
static byte CBFlagState, LockState;

//
// Captions for main window
//
static const char *ProgCaptions[15] = { NULL,NULL,NULL,
	"[Hardware]","[Software]","[Memory]","[Video]",
	"[Disk]","[Ports]","[IRQ]","[CMOS]",
	"[Network]","[Help]","[About]","[Quit]" };

//
// Captions for menu bar
//
static const char *ProgNames[15] = { NULL,NULL,NULL,
	" Hardware "," Software "," Memory   "," Video    ",
	" Disk     "," Ports    "," IRQ      "," CMOS     ",
	" Network  "," Help     "," About    "," Quit     " };

//
// Descriptions for status bar
//
static const char *ProgMessages[15] = { NULL,NULL,NULL,
	"Information on CPU, FPU, mouse etc.     ",
	"Information on installed software etc.  ",
	"Information on XMS- and EMS-memory etc. ",
	"Information on videoadapter etc.        ",
	"Information on disks, CD-ROM drives etc.",
	"Information on COM- and LPT-ports etc.  ",
	"Information on IRQs.                    ",
	"Information on CMOS.                    ",
	"Information on network systems, etc.    ",
	"Briefly help how to use this program.   ",
	"Briefly information on this program.    ",
	"Quits this program and returns to OS.   " };

//
// The main screen
//
static const char *SnifferScreen[25] = { NULL,NULL,
	"[Options]Ŀ Ŀ",
	"                                                                            ",
	"                                                                            ",
	"                                                                            ",
	"                                                                            ",
	"                                                                            ",
	"                                                                            ",
	"                                                                            ",
	"                                                                            ",
	"                                                                            ",
	"                                                                            ",
	"                                                                            ",
	"                                                                            ",
	"                                                                 ",
	"[HotKeys]Ŀ                                                                 ",
	" F1  Help                                                                   ",
	" F2  About                                                                  ",
	" F10 Quit                                                                   ",
	"                                                                 ",
	"                                                                              ",
	"                                                                              ",
	"                                                                              ",
	"              " };

//
// Class definitions
//
class SnifferDisk {
 private:
  byte GetDefDrive( void );
  byte SetDefDrive( byte Drive );
  void GetDiskSpace(byte drive);
  void GetCurDir(byte drive);
 public:
  SnifferDisk(void);
  ~SnifferDisk(void);
  void GetDiskInfo(void);
 };

class SnifferGUI {
 private:
 public:
  SnifferGUI(void);
  ~SnifferGUI(void);
  void PrepareSniffer( void  );
  void ExitProgram( byte opt );
  void PutCaptionAndMsg(byte prog);
  void TurnPage(void);
  void QuitReally(void);
  void ShowAboutInfo(void);
  void ShowHelpInfo(void);
  void GetDateAndTime(void);
  void ChkKbd(void);
 };

class SnifferHWare {
 private:
  bool ChkLTMouse(void);
  byte *GetLTMouseVer(void);
  void GetProcessorInfo(void);
  void GetMouseInfo(void);
  void GetSysFlags( void );
 public:
  SnifferHWare(void);
  ~SnifferHWare(void);
  void GetHardwareInfo(void);
 };

class SnifferPorts {
 private:
  void GetGameIOInfo(void);
  void GetCOMPortInfo(void);
  void GetLPTPortInfo(void);
  void DispIntVector(word IRQ);
 public:
  SnifferPorts(void);
  ~SnifferPorts(void);
  void GetPortInfo(void);
  void GetIRQInfo(void);
  word BIOSEquipW(void);
 };

class SnifferMachine {
 private:
  void GetROMDate( char Date[8] );
  void GetBIOSDate( char Date[8] );
  bool ChkDELL(void);
  bool ChkHP(void);
  bool ChkCompaq(void);
  bool ChkTandy(void);
  bool ChkAST(void);
  bool ChkToshiba(void);
  void AnalyseDELL(void);
  void AnalyseHP(void);
  void AnalyseCompaq(void);
  void AnalyseTandy(void);
  void AnalyseAST(void);
  void AnalyseToshiba(void);
 public:
  SnifferMachine(void);
  ~SnifferMachine(void);
  void GetMachineInfo(void);
 };

class SnifferMem {
 private:
  long GetAvailBMem( void );
  bool ChkQEMM(void);
  bool ChkMicEMM(void);
  bool ChkRM386(void);
  bool ChkEMM386(void);
  void AnalyseEMM386(void);
  bool ChkVIDEMS(void);
  void AnalyseVIDEMS(void);
  bool Chk386MAX(void);
  void GetA20HandlerInfo(void);
  bool ChkXMSMem(void);
  void GetXMSMemInfo(void);
  bool ChkEMSMem(void);
  void GetEMSMemInfo(void);
  void GetVCPIInfo(void);
  void GetDPMIInfo(void);
  void GetDPMSInfo(void);
 public:
  SnifferMem(void);
  ~SnifferMem(void);
  void GetMemoryInfo(void);
 };

class SnifferNWork {
 private:
  word TenNetIChk(void);
  void TenNetAnalyse(word NetCompo);
  bool ConManIChk(void);
  bool DosNetIChk(void);
  bool EasyNetIChk(void);
  bool NetworkIChk(void);
  byte *NetwareIChk(void);
 public:
  SnifferNWork(void);
  ~SnifferNWork(void);
  void GetNetworkInfo(void);
 };

class SnifferSWare {
 private:
  void GetCountryInfo(void);
  void GetDOSInfo(void);
  void GetWindowsInfo(void);
  void GetSoftwareInfo(void);
  void GetPowerManInfo(void);
  bool ChkPowerMan(word& version);
  void AnalysePowerMan(void);
  bool ChkPOWER(word& version);
  bool ChkAPMDriver(word APMVersion,word& APMCVersion);
  void GetDOSEInfo(void);
  bool ChkDOS4GW(void);
  bool ChkDOS16M(void);
  bool ChkDOS4G(void);
  word *ChkPLDOSE(void);
  bool ChkDOSE(void);
 public:
  SnifferSWare(void);
  ~SnifferSWare(void);
  void GetOSInfo(void);
  word _GetWindowsInfo(void);
 };

class SnifferVideo {
 private:
  void GetVESAInfo(void);
  void GetVESAPMInfo(void);
  void GetAdapInfo(void);
  void GetCirrusLogicInfo(void);
 public:
  SnifferVideo(void);
  ~SnifferVideo(void);
  void GetVideoInfo(void);
 };

class SnifferCMOS {
 private:
  byte ReadCMOS(byte Addr);
  void WriteCMOS(byte Addr,byte Data);
  void GetCMOSTime(struct CMOS_DATE *Cal);
  void GetCMOSDate(struct CMOS_DATE *Cal);
  void GetHDValues(struct CMOS_DISK *Disk);
  void ShowHDValues(struct CMOS_DISK *Disk);
 public:
  SnifferCMOS(void);
  ~SnifferCMOS(void);
  void GetCMOSInfo(void);
 };

//
// External modules written in pure ASM
//
extern "C" {
 void GetCPUId(void);
 void GetFPUId(void);
 void Print(void);
 };

//
// Pointers to classes
//
SnifferPorts   *SPorts;
SnifferDisk    *SDisk;
SnifferGUI     *SGui;
SnifferHWare   *SHWare;
SnifferMachine *SMachine;
SnifferMem     *SMem;
SnifferNWork   *SNWork;
SnifferSWare   *SSWare;
SnifferVideo   *SVideo;
SnifferCMOS    *SCmos;

#endif