program textsearchandreplace;
uses dos;
const
     ProgData = 'SSWITCH- Free DOS utility: text file search and replace.';
     ProgDat2 = 'V1.00: July 14, 1993. (c) 1993 by David Daniel Anderson - Reign Ware.';

      usage = 'Usage:  SSWITCH source_file new_destination_file';
      usag2 = '    You must use the DOS command SET as follows:';
      usag3 = '        set switch_s=search_text';
      usag4 = '        set switch_r=replace_text';
var
   ps1, ps2,
   stext, rtext,
   line_current           : string;
   source_file,dest_file  : text;

procedure showusage;
begin
        writeln(usage);
        writeln(usag2);
        writeln(usag3);
        writeln(usag4);
        halt;
end;

procedure initvars;
begin
     writeln(progdata);
     writeln(progdat2);
     writeln;
     if paramcount < 2 then
        showusage;
     ps1 := paramstr(1);
     ps2 := paramstr(2);
     stext := getenv('switch_s');
     if stext = '' then begin
        writeln('!!! switch_s is not SET !!!');
        showusage;
     end;
     rtext := getenv('switch_r');
     if rtext = '' then begin
        writeln('!!! switch_r is not SET !!!');
        showusage;
     end;
     writeln('Old string: ',stext,' - New string: ',rtext,'.');
end;

procedure openfiles;
begin
     assign(source_file,ps1);
{$i-} reset(source_file); {$i+}                    { check if file exists.}
     if (ioresult <> 0) then                       { if it                }
     begin                                         {    doesn't, then     }
         writeln('Unable to open "', PS1, '".');   {  quit with message.  }
         showusage;
     end;

     assign(dest_file,ps2);
{$i-} reset(dest_file);  {$i+}
      if (ioresult <> 0) then
         rewrite(dest_file)
      else begin
writeln('Destination "',PS2,'" exists!  Rename, delete, or specify alternate.');
         showusage;
      end;
      writeln('Old file: ',PS1,' - New file: ',PS2,'.');
end;

function replstr(theline,thesearch,thereplace : string) : string;
var
   stridx, slength  : integer;
begin
     stridx  := 300;
     slength := length(thesearch);
     while (pos(thesearch,theline) <> 0) do begin
           stridx := (pos(thesearch,theline));
           delete (theline,stridx,slength);
           insert (thereplace,theline,stridx);
     end;
     replstr := theline;
end;

begin
     initvars;
     openfiles;
     while not eof(source_file) do
     begin
          readln(source_file,line_current);
          if (pos(stext,line_current) <> 0) then
             line_current := replstr(line_current,stext,rtext);
          writeln(dest_file,line_current);
     end;
     close(source_file);
     close(dest_file);
end.
