/*

Print Share Client TSR, startup code

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <dos.h>
#include <io.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <limits.h>
#include <direct.h>
#include <process.h>
#include <conio.h>
#include <ctype.h>



#include "common.h"
#include "psc.h"



LPGLOBALS   gl;






LPBYTE   MK_FP(unsigned s,unsigned o){
   LPBYTE p1;

   _asm {
      mov   ax,o;
      mov   word ptr p1,ax;
      mov   ax,s;
      mov   word ptr p1+2,ax;
   }
   return p1;
}








void  ecbInit(void){
   BYTE  immedAddr[6];
   int   i;

   IPXGetLocalTarget( (LPBYTE)&gl->addrServer, immedAddr, &i);

   gl->pktTxSize = NWWordSwap( sizeof(IPXHeader)+NBLEN_CMD );
   gl->pktRxSize = NWWordSwap( sizeof(IPXHeader)+NBLEN_ACK );


   for(i=0; i<3; i++){
      if( gl->ports[i].remotePort != 0xffff ){

         gl->ports[i].ecbRx.ESRAddress = NULL;   /* (void (far *)())esrRx; */
         gl->ports[i].ecbRx.inUseFlag = 0;
         gl->ports[i].ecbRx.socketNumber  = *((LPWORD)gl->addrMe.socket);
         memcpy( gl->ports[i].ecbRx.immediateAddress, immedAddr,6);
         gl->ports[i].ecbRx.fragmentCount = 2;
         gl->ports[i].ecbRx.fragmentDescriptor[0].address = (void far *)&gl->ports[i].hdrRx;
         gl->ports[i].ecbRx.fragmentDescriptor[0].size    = sizeof(IPXHeader);
         gl->ports[i].ecbRx.fragmentDescriptor[1].address = (void far *)&gl->ports[i].dataRx;
         gl->ports[i].ecbRx.fragmentDescriptor[1].size    = NBLEN_ACK;

         gl->ports[i].hdrRx.checkSum   = 0;
         gl->ports[i].hdrRx.length     = gl->pktRxSize;
         gl->ports[i].hdrRx.packetType = 4;
         memcpy( (LPBYTE)&gl->ports[i].hdrRx.destination, (LPBYTE)&gl->addrMe,   sizeof(IPXAddress));
         memcpy( (LPBYTE)&gl->ports[i].hdrRx.source,      (LPBYTE)&gl->addrServer,        sizeof(IPXAddress));




         gl->ports[i].ecbTx.ESRAddress = NULL;  /* (void (far *)())esrTx; */
         gl->ports[i].ecbTx.inUseFlag = 0;
         gl->ports[i].ecbTx.socketNumber  = *((LPWORD)gl->addrMe.socket);
         memcpy( gl->ports[i].ecbTx.immediateAddress, immedAddr,6);
         gl->ports[i].ecbTx.fragmentCount = 2;
         gl->ports[i].ecbTx.fragmentDescriptor[0].address = (void far *)&gl->ports[i].hdrTx;
         gl->ports[i].ecbTx.fragmentDescriptor[0].size    = sizeof(IPXHeader);
         gl->ports[i].ecbTx.fragmentDescriptor[1].address = (void far *)&gl->ports[i].dataTx;
         gl->ports[i].ecbTx.fragmentDescriptor[1].size    = NBLEN_CMD;

         gl->ports[i].hdrTx.checkSum   = 0;
         gl->ports[i].hdrTx.length     = gl->pktTxSize;
         gl->ports[i].hdrTx.packetType = 4;
         memcpy( (LPBYTE)&gl->ports[i].hdrTx.destination, (LPBYTE)&gl->addrServer,        sizeof(IPXAddress));
         memcpy( (LPBYTE)&gl->ports[i].hdrTx.source,      (LPBYTE)&gl->addrMe,   sizeof(IPXAddress));
      }
   }

   gl->ecbTimer.ESRAddress = (void (far *)())esrTimer;
   gl->ecbTimer.inUseFlag = 0;
   gl->ecbTimer.socketNumber  = *((LPWORD)gl->addrMe.socket);
   gl->timeBase = 0;
   gl->timerOn  = TRUE;

   esrTimer();
   return;
}







void  ecbCancel(LPGLOBALS tmpgl){
   int   i;

   tmpgl->timerOn  = FALSE;

   for(i=0; i<3; i++){
      if( tmpgl->ports[i].remotePort != 0xffff ){
         if( tmpgl->ports[i].ecbTx.inUseFlag ) IPXCancelEvent( &tmpgl->ports[i].ecbTx );
         if( tmpgl->ports[i].ecbRx.inUseFlag ) IPXCancelEvent( &tmpgl->ports[i].ecbRx );
      }
   }

   while( tmpgl->ecbTimer.inUseFlag )
      IPXCancelEvent( &tmpgl->ecbTimer );


   IPXCloseSocket( *((LPWORD)tmpgl->addrMe.socket) );
   IPXDisconnectFromTarget( (LPBYTE)&tmpgl->addrServer );

   return;
}



















BOOL  svrPing(void){
   LPCMD cmd;
   int   i;

   for(i=0; i<3; i++){
      if( gl->ports[i].remotePort != 0xffff ) break;
   }

   cmd = (LPCMD)&gl->ports[i].dataTx;
   cmd->cmd = CMD_PING;

   return svrTransact(i,2);
}





















void sysStartup(void){

   Chain21 = (LPBYTE)(void far *) (gl->old21= _dos_getvect( 0x21 ));
   _dos_setvect( 0x21, int21stub );

   Chain2F = (LPBYTE)(void far *) (gl->old2F= _dos_getvect( 0x2F ));
   _dos_setvect( 0x2F, int2Fstub );

   Chain17 = (LPBYTE)(void far *) (gl->old17= _dos_getvect( 0x17 ));
   _dos_setvect( 0x17, int17stub );

   gl->Resident21 = (LPBYTE)((void *)int21stub);
   gl->Resident2F = (LPBYTE)((void *)int2Fstub);
   gl->Resident17 = (LPBYTE)((void *)int17stub);

   return;
}








void  sysShutdown(void){
   union REGS  ir, or;
   LPGLOBALS   tmpgl;

   ir.x.ax = gl->systemID;
   ir.x.bx = SYS_STOPNET;
   int86(0x2f,&ir,&or);


   ir.x.ax = gl->systemID;
   ir.x.bx = SYS_GETINFO;
   int86(0x2f,&ir,&or);
   tmpgl = (LPGLOBALS) MK_FP( or.x.cx, or.x.dx );

   ecbCancel(tmpgl);

   return;
}








extern (far UnloadTSR)(void);



void Deinstall(void){
   union REGS  ireg, oreg;
   WORD        MyPSP;
   LPGLOBALS   tmpgl;

   MyPSP= gl->MyPSP;

   ireg.x.ax = gl->systemID;
   ireg.x.bx = SYS_GETINFO;
   int86(0x2f,&ireg,&oreg);
   tmpgl = (LPGLOBALS) MK_FP( oreg.x.cx, oreg.x.dx );

   _dos_setvect( 0x21, tmpgl->old21 );
   _dos_setvect( 0x2F, tmpgl->old2F );
   _dos_setvect( 0x17, tmpgl->old17 );
   

   _asm{
      mov   ax,[word ptr oreg.x.bx]
      mov   cx,[word ptr MyPSP]
      call  UnloadTSR
   }

   return;
}










BOOL  InitConfigs(int aCount, LPBYTE *argDat ){
   BOOL     retVal = TRUE;
   int      i,j,p,c;
   BYTE     buff[64],work[64],disp[64];
   LPBYTE   p1;



   IPXGetInternetworkAddress( (LPBYTE)&gl->addrMe );


   if( strlen(argDat[1]) > 47 ){
      printf("Maximum length of server name is 47 chars.\n\n");
      return FALSE;
   }

   strcpy(work, argDat[1]);
   strupr(work);

   i= upgConnect(gl,work,SERVER_TYPE,&gl->addrServer);
   
   if( i< 0 ){
      printf(" failed.\n\n\n");
      return FALSE;
   }
   else if( i>0 ){
      printf(" Done.\n\n");
      exit(255);
   }
   printf(" ok.\n\n");



   gl->defaultPort = 0;
   for(i=0; i<3; i++){
      gl->ports[i].remotePort    = 0xffff;
      gl->ports[i].isConnected   = FALSE;
      gl->ports[i].txLen         = 0;
      gl->ports[i].sessionCode   = 0;

      gl->ports[i].isRedirected  = FALSE;
      gl->ports[i].isInUse       = FALSE;
   }
   for(i=2; i< aCount; i++){
      strcpy( buff, argDat[i] );
      strupr(buff);
      strcpy(disp,buff);

      if( strlen(buff) != 5 ){
         printf("Invalid Printer assignment.\n\n");
         return FALSE;
      }

      if( (p1= strchr(buff,'=')) != NULL ){
         *p1=0, p1++;

         if( buff[0] != 'L'|| buff[1]< '1' || buff[1]>'3' ){
            printf("Invalid Local printer assignment: %s\n\n",disp);
            return FALSE;
         }
         p = buff[1]-'1';

         if( gl->ports[p].remotePort != 0xffff ){
            printf("Local port LPT%c already assigned.\n\n",p+'1');
            return FALSE;
         }

         if( p1[0] != 'R' || p1[1]< '1' || p1[1]>'3' ){
            printf("Invalid Remote printer assignment: %s\n\n",disp);
            return FALSE;
         }
         c = p1[1] - '1';
         gl->ports[p].remotePort = c;
      }
      else{
         printf("Invalid Printer assignment.\n\n");
         return FALSE;
      }
   }


   *((LPWORD)gl->addrMe.socket) = 0;
   if( (j=IPXOpenSocket( (LPBYTE)gl->addrMe.socket ,LONG_LIVED)) != SUCCESSFUL ){
      printf("Open Socket Failed!\n\n");
      retVal = FALSE;
   }


   printf("Remote Node ");
   for(i=0; i<4; i++) printf( "%02X", gl->addrServer.network[i] );
   printf(":");
   for(i=0; i<6; i++) printf( "%02X", gl->addrServer.node[i] );
   printf(":");
   for(i=0; i<2; i++) printf( "%02X", gl->addrServer.socket[i] );
   printf("\n");

   printf(" Local Node ");
   for(i=0; i<4; i++) printf( "%02X", gl->addrMe.network[i] );
   printf(":");
   for(i=0; i<6; i++) printf( "%02X", gl->addrMe.node[i] );
   printf( ":");
   for(i=0; i<2; i++) printf( "%02X", gl->addrMe.socket[i] );
   printf("\n\n");






   for(i=0; i<3; i++){
      printf("   Local LPT%c --> ",i+'1' );

      if( gl->ports[i].remotePort != 0xffff )
         printf("Remote LPT%c\n",gl->ports[i].remotePort+'1');
      else
         printf("   (local)\n");
   }

   printf("\nPinging Server ...");

   ecbInit();
   if( !svrPing() ){
      ecbCancel(gl);
      printf("Failed!\n\n");
      printf("Couldn't communicate w/ specified server.\n\n");

      IPXCloseSocket( *((LPWORD)gl->addrMe.socket) );
      IPXDisconnectFromTarget( (LPBYTE)&gl->addrServer );
      retVal = FALSE;
   }
   else printf(" Online!\n\n");


   return retVal;
}














void  help(void){

   printf("Command Format:\n");
   printf("  PSC serverName Lx=Ry [[Lx2=Ry2] ... [Lxn=Ryn]]\n\n");
   printf(" Where serverName is the name of the Print Share server.\n");
   printf("       Lx=Ry - Local LPTx assigned to Remote LPTy\n");
   printf("               Local & Remote ports are 1 thru 3,\n\n");
   printf("After PSC is resident, run again to unload.\n\n");

   return;
}






extern   (far  IPXGetAddr)(void);



void  main(int argc,LPBYTE *argv){
   union REGS  ir, or;
   WORD        wSize,retVal = 0,tseg,o;
   LPBYTE      p1;
   LPGLOBALS   tmpgl;

   gl = &glob;
   strcpy( gl->mySignature, PSC_INTERNAL_ID );

   gl->MyPSP       = _psp;
   gl->systemID    = INT2F_SYSTEMID;
   gl->txSerial    = 0;


   printf("\nPrinter Share Client [%s]     2/96, Gregm.\n\n", gl->mySignature );


   ir.x.ax = gl->systemID;
   ir.x.bx = SYS_GETSIGNATURE;
   int86(0x2f,&ir,&or);

   if( or.x.ax == (gl->systemID ^ 0xFFFF) ){

      p1= (LPBYTE)MK_FP( or.x.cx, or.x.dx );

      if( strcmp(p1, gl->mySignature ) == 0 ){

         ir.x.ax = gl->systemID;
         ir.x.bx = SYS_GETINFO;
         int86(0x2f,&ir,&or);

         tmpgl= (LPGLOBALS)MK_FP( or.x.cx, or.x.dx );

         if( tmpgl->Resident21 == (LPBYTE)(void far *)_dos_getvect(0x21)
               &&
             tmpgl->Resident2F == (LPBYTE)(void far *)_dos_getvect(0x2f)
               &&
             tmpgl->Resident17 == (LPBYTE)(void far *)_dos_getvect(0x17) ){

            sysShutdown();
            Deinstall();

            printf("Unloaded.\n\n");
            retVal = 0;
         }
         else{
            printf("Cannot remove PSC, interrupts have been re-hooked.\n\n");
            retVal= 2;
         }
      }
      else{
         printf("Resident PSC returned descriptor [%s].  Cannot unload!\n\n", p1);
         retVal= 2;
      }
   }
   else{
      if( argc < 3 ) help(), exit(2);

      if( IPXInitialize() != SUCCESSFUL ) printf("Couldn't find IPX.\n\n"), exit(2);

      _asm call IPXGetAddr;


      if( InitConfigs( argc, argv ) ){

         sysStartup();

         p1 = ((LPBYTE)&glob) + sizeof(GLOBALS);

         tseg = GetPtrSeg( p1 );
         o = GetPtrOff( p1 );
         tseg += (o/16);

         wSize = ( tseg - gl->MyPSP ) + 1;

         printf("%s Installed; (%u Bytes)\n\n",gl->mySignature, (wSize<<4)+255 );

         _dos_freemem( GetPtrSeg( environ ) );
         _dos_keep(0,wSize);
      }
      else{
         printf("%s Not Installed.\n\n",gl->mySignature);
         retVal= 2;
      }
   }

   exit(retVal);
}






/* eof, psc.c */

