DECLARE SUB plotchar (x%, y%, ascii%, c%)
DECLARE SUB plotstring (x%, y%, text$, c%)
DECLARE FUNCTION xinkey% ()
DECLARE SUB cp (t$)
DEFINT A-Z

DIM SHARED fontdata(255) AS LONG, mask AS LONG, pixel AS LONG
filename$ = "untitled.fnt"
ascii = 65
COLOR 15, 1

CLS

DO
   LOCATE 1, 1
   cp "5x5 QBasic Font Editor v.1.1 by ntcgary@aol.com 1/29/96"
   PRINT
   PRINT "F1 New  F2 Open  F3 Save  F4 View Set in graphics mode  F10 Help  ESC Quit"
   PRINT
   PRINT "Use "; CHR$(24); ", "; CHR$(25); ", "; CHR$(27); ", and "; CHR$(26);
   PRINT " to position cursor; Space to toggle pixel on/off;"
   PRINT "PgUp and PgDn to decrement/increment ASCII code number."

   COLOR 15, 1
   LOCATE 8, 1

   filename$ = UCASE$(filename$)
   PRINT "FILE: "; filename$
   PRINT "ASCII code ="; ascii; "decimal ("; HEX$(ascii); " hex); symbol = ";
   IF ascii < 32 THEN
      PRINT "unprintable";
   ELSE
      PRINT CHR$(ascii);
   END IF
   PRINT SPACE$(10)

   PRINT "Data for this character: "; HEX$(fontdata(ascii)); " hex"; SPACE$(7)
   mask = 1
   FOR y1 = 0 TO 4
      LOCATE , 35
      FOR x1 = 0 TO 4
         IF x1 = x AND y1 = y THEN
            COLOR 31, 4
         ELSE
            COLOR 15, 1
         END IF

         IF fontdata(ascii) AND mask THEN
            PRINT "";
         ELSE
            PRINT "";
         END IF
         mask = mask * 2
      NEXT
      PRINT
   NEXT
   COLOR 15, 1

   SELECT CASE xinkey
      CASE 315: 'F1 (New)
         CLS
         INPUT "Enter filename: ", filename$
         FOR n = 0 TO 255
            fontdata(n) = 0
         NEXT
         CLS

      CASE 316: 'F2 (Open)
         CLS
         FILES "*.fnt"
         PRINT
         PRINT "This program was distributed with SAMPLE.FNT."
         PRINT "It should be stored in the same directory as FONTEDIT.BAS."
         PRINT
         DO
            INPUT "Enter filename: ", filename$
         LOOP UNTIL filename$ <> ""
         OPEN filename$ FOR BINARY AS 1
         FOR n = 0 TO 255
            GET 1, , fontdata(n)
         NEXT
         CLOSE 1
         ascii = 65
         CLS

      CASE 317: 'F3 (Save)
         CLS
         PRINT "Enter new filename (or just press enter to save as "; filename$; ")";
         INPUT ": ", x$
         IF x$ <> "" THEN filename$ = x$
         OPEN filename$ FOR BINARY AS 1
         FOR n = 0 TO 255
            PUT 1, , fontdata(n)
         NEXT
         CLOSE 1
         PRINT filename$; " has been saved."
         PRINT "Press any key to continue."
         x = xinkey
         CLS

      CASE 318: 'F4 (View set in graphics mode)
         CLS
         DO
            INPUT "Enter graphics mode number (9, 12, or 13): ", x
         LOOP UNTIL x = 9 OR x = 12 OR x = 13
         SCREEN x

         plotstring 0, 0, "THIS IS THE FONT " + filename$ + ".", 9

         FOR y2 = 0 TO 7
            FOR x2 = 0 TO 31
               plotchar 6 * x2 + 60, 10 * y2 + 30, y2 * 32 + x2, 7
            NEXT
         NEXT

         x = xinkey
         SCREEN 0
         WIDTH 80, 25
         COLOR 15, 1
         CLS

      CASE 324: 'F10 (Help)
         CLS
PRINT "This program was created by Gary Williams (ntcgary / garyew)."
PRINT
PRINT "It will allow you to create and edit tiny 5x5-pixel font files"
PRINT "for use with QBasic in low resolution graphics modes where"
PRINT "the normal IBM text is too large (i.e., mode 13). Included"
PRINT "is SAMPLE.FNT, which you may use in your own programs, along"
PRINT "with the subroutines plotchar and plotstring."
PRINT
PRINT "The fonts are stored as a simple 256-element array of long integers."
PRINT
PRINT "All I ask is that if you use any of this in your own programs,"
PRINT "please email me at ntcgary@aol.com. I'd love to hear from you."
PRINT
PRINT "Press any key to continue."
         x = xinkey
         CLS

      CASE 27: 'ESC (Quit)
         CLS
         SYSTEM

      CASE 328: 'Up
         y = y - 1

      CASE 336: 'Down
         y = y + 1

      CASE 331: 'Left
         x = x - 1

      CASE 333: 'Right
         x = x + 1

      CASE 329: 'PgUp
         ascii = ascii - 1

      CASE 337: 'PgDn
         ascii = ascii + 1

      CASE 327: 'Home
         ascii = 0

      CASE 335: 'End
         ascii = 255

      CASE 32: 'Space (toggle bit)
         mask = 2 ^ (5 * y + x)
         fontdata(ascii) = fontdata(ascii) XOR mask

   END SELECT

   IF ascii < 0 THEN ascii = 255
   IF ascii > 255 THEN ascii = 0

   IF x < 0 THEN x = 4
   IF x > 4 THEN x = 0

   IF y < 0 THEN y = 4
   IF y > 4 THEN y = 0

LOOP

SUB cp (t$)
   LOCATE , 40 - INT(LEN(t$) / 2)
   PRINT t$
END SUB

'
'X and Y are the coordinates of the top-left
'corner of the character to be plotted.
'
'Ascii is the ascii code of the character (0...255).
'
'C is the color to plot the character in (0...15 or 0...255).
'
SUB plotchar (x, y, ascii, c)
   mask = 1
   FOR y1 = 0 TO 4
      FOR x1 = 0 TO 4
         pixel = fontdata(ascii) AND mask
         IF pixel THEN
            PSET (x + x1, y + y1), c
         END IF
         mask = mask * 2
      NEXT
   NEXT
END SUB

'
'X and Y are the coordinates of the top-left
'corner of the character to be plotted.
'
'Text$ is the text string to be plotted.
'
'C is the color to plot the character in (0...15 or 0...255).
'
SUB plotstring (x, y, text$, c)
   FOR n = 1 TO LEN(text$)
      plotchar x, y, ASC(MID$(text$, n, 1)), c
      x = x + 6
   NEXT
END SUB

FUNCTION xinkey
   DO
      x$ = INKEY$
   LOOP UNTIL x$ = ""
   DO
      x$ = INKEY$
   LOOP UNTIL x$ <> ""
   xinkey = ASC(RIGHT$(x$, 1)) + 256 * (LEN(x$) - 1)
END FUNCTION

