.\" t
.\" @(#)FvwmConsoleC.pl.1x	7/16/96
.TH FvwmConsoleC.pl 1x  "July 16 1996"
.UC

.SH NAME
FvwmConsoleC.pl \- Command editor for FVWM command input interface 
.SH SYNOPSIS
FvwmConsole -e /usr/X11/lib/fvwm2/FvwmConsoleC.pl

.SH COPYRIGHT
Copyright 1996, Toshi Isogai. No guarantees or warranties are provided.
Use this program at your own risk. Permission to use this program for
any purpose is given, as long as the copyright is kept intact. 


.SH DESCRIPTION
FvwmConsoleC.pl offers editing capabilities  while  the  user  is
entering  the line.  By default, the line editing commands
are similar to those of emacs. It also offers 
.B substitution
, which replaces a pattern to a string before it sends the command.

.SH FUNCTIONS
Functions are bound to a key or key combination to be
invoked. The followings are functions available and their
default key bindings.
.RS
.IP \fBbind\fP 
\fIMeta-k, Cntl-x Cntl-b\fP
.br
.\"Bind key to function or bind pattern to string for substitution.
List up key bindings and substitutions.
.IP \fBboh\fP
.br
Move to the beginning of history.
.IP "\fBboh_ign_mode\fP  \fIEsc-<\fP"
.br
Move to the beginning of history. If it is in search mode,
continue.
.IP \fBbol\fP
\fIHome, Cntl-a\fP
.br
Move cursor to the beginning of the line.
.IP "\fBbs[(n)]\fP \fIBackSpace, Cntl-h\fP"
.br
Backspace n times. default of n is 1.
.IP \fBcancel\fP
\fICntl-x Cntl-k\fP
.br
Cancel the current input.
.IP \fBdel_back_line\fP
.br
Delete the line from the beginning to the cursor.
.IP "\fBdel_back_word\fP \fICntl-w\fP"
.br
Delete the word from the beginning to the cursor.
.IP "\fBdel_char [(n)]\fP \fIDelete, Cntl-d\fP"
Delete n characters from the cursor to the right. Default of n
is 1.
.IP "\fBdel_forw_line\fP \fICntl-k\fP"
.br
Delete the line from the cursor to the end.
.IP "\fBdel_forw_word\fP \fIMeta-d\fP"
.br
Delete the word from the cursor to the end.
.IP "\fBdel_line\fP \fICntl-u\fP"
.br
Delete the entire line.
.IP \fBenter\fP
\fIEnter, Cntl-j, Cntl-m\fP
.br
Perform substitution if applicable and send the line to Fvwm.
.IP "\fBenter_wo_subst\fP \fIMeta-Enter\fP"
.br
Send the line to Fvwm without any substitution.
.IP \fBeoh\fP
.br
Move to the end of history.
.IP "\fBeoh_ign_mode\fP \fIEsc->\fP"
.br
Move to the end of history. If it is in search mode, continue.
.IP \fBeol\fP
\fIEnd, Cntl-e\fP
.br
Move the cursor to the end of line.
.IP "\fBins_char (str)\fP"
.br
Insert string at the cursor.
.IP "\fBins_last_word\fP \fIEsc-.\fP"
.br
Insert the last argument of the previous command at the cursor.
.IP "\fBins_nth_word\fP \fIMeta-[1..9]\fP"
.br
Insert the n-th argument of the previous command at the cursor.
.IP "\fBlist_func\fP \fIMeta-l\fP"
.br
List up available editing functions.
.IP "\fBnext_char\fP \fIRight, Cntl-f\fP"
.br
Move the cursor to the next character.
.IP "\fBnext_line\fP \fIDown, Cntl-n\fP"
.br
Move to the next line in history.
.IP "\fBnext_word\fP \fIMeta-f\fP"
.br
Move the cursor to the next word.
.IP \fBprefix\fP
.br
Wait for the next character typed in  for multi-key binding. 
.IP "\fBprev_char\fP \fILeft, Cntl-b\fP"
.br
Move the cursor to the previous character.
.IP "\fBprev_line\fP \fIUp, Cntl-p\fP"
.br
Move to the previous line in history.
.IP "\fBprev_word\fP \fIMeta-b\fP"
.br
Move the cursor to the previous word.
.IP \fBquote\fP
\fICntl-q\fP
.br
Insert the next character  typed  into  the  buffer literally.
.IP \fBsearch\fP
\fICntl-s\fP
.br
Search pattern in history.
.IP "\fBsearch_rev\fP \fICntl-r\fP"
.br
Search pattern in history in reverse order.
.IP \fBsubst\fP
\fIMeta-s\fP
.br
Substitute all patterns to strings and reprint the line.
The substitutions are not nested and performed in the order
that they are defined. 
.RE

.SH CONFIGURATION
The key binding can be overridden or defined
in fvwm module configuration.

.RS
*FvwmConsoleKey \\ck prev_line
.RE

Non-space character sequence need not be quoted.
In order to undefine, omit the last argument.

.RS
*FvwmConsoleKey \ck
.RE

Note that non-meta character is case sensitive. 
\\c means control key, \\e means escape, and \\m is alt key.
.br
It also accepts Subst configuration. Users often input long fvwm command
repeatedly. Subst will replace particular input sequence to user defined
string. Example:

.RS
*FvwmConsoleSubst '^bigx' 'Exec xterm -g 120x60+0+0 -fn 10x20 -fg black -bg lemonchiffon'
.RE

Typing 'bigx<return>' in FvwmConsole will launch xterm. '^' denotes 
the beginning of line in 
.B regular expression. 
\'pl\' in the middle
of the command will not be replaced. Although the format looks different,
it takes Perl regular expression. 
It just uses single or double quote as the delimiter.
Single or double quotes have no difference, although they have to match,
and cannot include itself in the string.

.RS
*FvwmConsoleSubst '^g\\s*(\\d+)' 'Desk 0 0\\nGotoPage 0 $1\\nFocus'
.RE

Entering 'g4' or 'g  4' will jump to desk 0 page 0 4 and focus.

.SH INVOCATION
FvwmConsoleC.pl should be invoked by FvwmConsole.

.SH SEE ALSO
FvwmConsole(1x), perlre(1)

.SH AUTHOR
Toshi Isogai  
