/*
    Xunzip for Linux, handles gzip and zip files via zlib.
    Copyright (C) 1998 Tero Koskinen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
*/

// utils.h


#include <fstream.h>

#ifdef USE_GTK
#include <gtk/gtk.h>
#else
#include <qapp.h>
#include <qmsgbox.h>
#endif

#ifndef TK_ZIP_UTILS
#define TK_ZIP_UTILS

unsigned int readint(ifstream & fin);
unsigned long readlong(ifstream & fin);
void makedirs(const char *path);
void tyhjennaTaulukko(char *taulukko,int koko);
#ifdef USE_GTK
void delete_show_message (GtkWidget *widget, GtkWidget *data);
#endif
void showMessage(const char *ilmoitus);
void showError(const char *text,int size,const char *filename);

#endif
