/* $Id: mjono.hpp,v 0.7 1997/07/18 10:07:42 oh Exp $
 *
 *  Copyright (C) 1997 Tero Koskinen
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <iostream.h>
#include <string.h>

#include "mjono.h"

// Oletusmuodostin luo nollan merkin mittaisen merkkijonon
Mjono::Mjono()
{
    senMerkkijono = new char[1];
    senMerkkijono[0] = '\0';
    senPituus = 0;
    // cout << "\tMerkkijonon oletusmuodostin\n";
    // muodostinLaskuri++;
}

// Yksityinen (apu) muodostinfunktio, jota kytetn vain
// luokan metodeissa. Muodostimella tehdn halutun
// mittainen merkkijono joka on alustettu nollatavuilla
Mjono::Mjono(unsigned short pituus)
{
    senMerkkijono = new char[pituus + 1];
    for (unsigned short i = 0; i<=pituus; i++)
	senMerkkijono[i]='\0';
    senPituus=pituus;
    // cout << "\tMjono(int) muodostifunktio\n";
    // muodostinLaskuri++;
}

// Muuntaa merkkitaulukon merkkijonoksi
Mjono::Mjono(const char * const cMjono)
{
    senPituus = strlen(cMjono);
    senMerkkijono = new char[senPituus+1];
    for (unsigned short i = 0; i<senPituus; i++)
	senMerkkijono[i]=cMjono[i];
    senMerkkijono[senPituus]='\0';
    // cout << "\tMjono(char*) muodostinfunktio\n";
    // muodostinLaskuri++;
}

Mjono::Mjono(const char * const mjono,unsigned int pituus)
{
   senPituus=pituus;
   if (senPituus)
     {
	senMerkkijono=new char[pituus+1];
	if (senMerkkijono)
	  {
	     for (unsigned int a=0;a<pituus;a++)
	       senMerkkijono[a]=mjono[a];
	     senMerkkijono[senPituus]='\0';
	  }
     }
}

// Kopiomuodostin
Mjono::Mjono (const Mjono & op)
{
    senPituus=op.AnnaPituus();
    senMerkkijono = new char[senPituus+1];
    for (unsigned short i = 0; i<senPituus; i++)
	senMerkkijono[i]=op[i];
    senMerkkijono[senPituus]='\0';
    // cout << "\tMjono(Mjono&) muodostinfunktio\n";
    // muodostinLaskuri++;
}

// Tuhoajafunktio, vapautetaan varattu muisti
Mjono::~Mjono()
{
    delete [] senMerkkijono;
    senPituus = 0;
    // cout << "\tMjono tuhoajafunktio\n";
}

// Sijoitusoperaattori. Vapauttaa varatun muistin
// ja kopioi sitten merkkijonon ja pituuden
Mjono& Mjono::operator=(const Mjono& op)
{
    if (this == &op)
	  return *this;
    delete [] senMerkkijono;
    senPituus = op.AnnaPituus();
    senMerkkijono = new char[senPituus+1];
    for (unsigned short i = 0; i<senPituus; i++)
	senMerkkijono[i]=op[i];
    senMerkkijono[senPituus]='\0';
    return *this;
    // cout << "\tMjono operator=\n";
}

// indeksointioperaattori. Paluuarvo ei ole tarkoita vakiota joten
// funktio palauttaa viittauksen merkkiin, jonka avulla
// indeksoitu merkki voidaan muuttaa.
char & Mjono::operator[](unsigned short paikka)
{
    if (paikka > senPituus)
	return senMerkkijono[senPituus -1];
    else
	return senMerkkijono[paikka];
}

// indeksointioperaattori. Palauttaa vakion joten tietoa voi vain
// kysy (katso kopiomuodostin).
char Mjono::operator[](unsigned short paikka) const
{
    if (paikka > senPituus)
	return senMerkkijono[senPituus -1];
    else
	return senMerkkijono[paikka];
}

// Luo uuden merkkijonon liittmll tmn
// merkkijonon parametrimerkkijonoon
Mjono Mjono::operator+(const Mjono& op)
{
   int unsigned short i=0;
   
   unsigned short kokonaisPituus = senPituus + op.AnnaPituus();
   Mjono apu(kokonaisPituus);
   for (i = 0; i<senPituus; i++)
     apu[i] = senMerkkijono[i];
   for (unsigned short j = 0; j<op.AnnaPituus(); j++, i++)
     apu[i] = op[j];
   apu[kokonaisPituus]='\0';
   return apu;
}

// Muuttaa tt merkkijonoa, ei paluuarvoa
void Mjono::operator+=(const Mjono & op)
{
   unsigned short opPituus = op.AnnaPituus();
   unsigned short kokonaispituus = senPituus + opPituus;
   unsigned short i = 0;
   
   Mjono apu(kokonaispituus);
   for (i = 0; i<senPituus; i++)
     apu[i] = senMerkkijono[i];
   for (unsigned short j = 0; j<op.AnnaPituus(); j++, i++)
     apu[i] = op[j];
   apu[kokonaispituus]='\0';
   *this = apu;
}

int Mjono::muodostinLaskuri = 0;

