#! /bin/bash
#
# This simple script installs VICE from the binary distribution.
#

echo
echo "VICE installation script"
echo "------------------------"
echo
echo -n "Enter directory prefix [/usr/local]: "
read basedir

[ -z "$basedir" ] && basedir=/usr/local

libdir=$basedir/lib/vice
bindir=$basedir/bin
mandir=$basedir/man/man1
arch=i586-pc-linux-gnu
version=0.14.2

echo
echo "Installing VICE version $version under $libdir."
echo "Symlinks to the executables will be created in $bindir."
echo "Unix manual pages will go into $mandir."
echo
echo "Press Return to go on, C-c to abort."
read dummy
echo

# Make the directories.
install -d -m 755 $libdir $libdir/{C64,VIC20,PET,$arch,doc}
install -m 644 bin/C64/{dos1541,kernal,basic,chargen} $libdir/C64
install -m 644 bin/VIC20/{dos1541,kernal,basic,chargen} $libdir/VIC20
install -m 644 bin/PET/{pet2001,pet3032,pet4032,edit2.b,edit4.b40,edit4.b80,chargen} $libdir/PET

# Install the main binaries.
for a in x64 xvic xpet petcat c1541 ; do
    install bin/$a $libdir/$arch/$a-$version
    ln -sf $libdir/$arch/$a-$version $bindir/$a
done

# Install the utilities.
install utils/recomment $libdir/$arch/recomment-$version
ln -sf $libdir/$arch/recomment-$version $bindir/recomment

# Install the documentation.
install -m 644 README COPYING BUGS CHANGES TODO INSTALL $libdir/doc
install -m 644 doc/{64doc.txt,cbm_basic_tokens.txt,recomment.html,Evaluation,PETdoc.txt,drive_info.txt,serial.txt,mnemonics.txt,MANUAL.html} $libdir/doc
ln -sf $libdir/doc/MANUAL.html $libdir/doc/index.html

# Install the manual pages.
install -m 644 man/vice.man $mandir/vice.1
install -m 644 man/c1541.man $mandir/c1541.1
install -m 644 man/petcat.man $mandir/petcat.1
