
/*
 * The Real SoundTracker - GUI configuration dialog (header)
 *
 * Copyright (C) 1999 Michael Krause
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _ST_GUI_SETTINGS_H
#define _ST_GUI_SETTINGS_H

#include <glib.h>

typedef struct gui_prefs {
    gboolean tracker_hexmode;
    gboolean tracker_upcase;
    gboolean advance_cursor_in_fx_columns;

    gboolean gui_display_scopes;
    gboolean gui_use_backing_store;
    gboolean gui_use_aa_canvas;
    gboolean highlight_rows;
    int highlight_rows_n;

    gboolean save_settings_on_exit;

    int tracker_update_freq;
    int scopes_update_freq;
    int scopes_buffer_size;

    gboolean save_all_patterns;

    gchar loadmod_path[128];
    gchar savemod_path[128];
    gchar loadsmpl_path[128];
    gchar savesmpl_path[128];
    gchar loadinstr_path[128];
    gchar saveinstr_path[128];
} gui_prefs;

extern gui_prefs gui_settings;

void        gui_settings_dialog                   (void);

void        gui_settings_load_config              (void);
void        gui_settings_save_config              (void);
void        gui_settings_save_config_always       (void);

#endif /* _ST_GUI_SETTINGS_H */
