/*
 * The Real SoundTracker - Effects configuration dialog
 * (by gc)
 * Copyright (C) 1999 Michael Krause
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>

#include <gtk/gtk.h>
#ifdef USE_GNOME
#include <gnome.h>
#endif

#include "i18n.h"
#include "gui-subs.h"
#include "mixer.h"
#include "effectsconfig.h"

// The mixer being used - we edit effects through functions here.
extern st_mixer *mixer;

// The main window.
static GtkWidget *configwindow = NULL;
// Window is split into two halves.. effect selector at top,
// Effect dialog at bottom.
static GtkWidget *cw_vbox;

// The separate effects dialogs
static GtkWidget *reverb_dialog;

// Effects dialog is generated from an array of this struct
typedef struct effects_object {
        const char *title;
        const char *shorttitle;
        int type;
	GtkWidget **main_dialog_wid;
} effects_object;


// All effects objects declared here
static effects_object effects_objects[] = {
        { N_("Master Reverb"),
          "reverb",
          EFFECT_REVERB,
	  &reverb_dialog
        }
};
#define NUM_EFFECTS_OBJECTS (sizeof(effects_objects) / sizeof(effects_objects[0]))

/*
 * Stuff for the reverb dialog
 */
static GtkWidget *effects_reverb_adj_wid;

static void effectsconfig_reverb_changed(GtkAdjustment *adj)
{
   mixer->setreverb((int) adj->value);
   return;
}

static void effectsconfig_draw_reverb(void)
{
   GtkAdjustment *effects_reverb_adj;
   
   // Make the main reverb container
   reverb_dialog = gtk_hbox_new(FALSE, 2);
   
   // Make the adjuster
   effects_reverb_adj = GTK_ADJUSTMENT(gtk_adjustment_new(mixer->getreverb(),
                                       0, 16, 1, 1, 1));
   effects_reverb_adj_wid = gtk_hscale_new(effects_reverb_adj);
   
   // Connect the adjustment function
   gtk_signal_connect(GTK_OBJECT(effects_reverb_adj), "value_changed",
		      GTK_SIGNAL_FUNC(effectsconfig_reverb_changed), NULL);
   // Stick it all together
   gtk_box_pack_start(GTK_BOX(reverb_dialog), effects_reverb_adj_wid,
		      TRUE, TRUE, 0);
   gtk_widget_show(effects_reverb_adj_wid);
   gtk_box_pack_start(GTK_BOX(cw_vbox), reverb_dialog, TRUE, TRUE, 0);
}

/*
 * Effects dialog control functions
 */
static GtkWidget *current_dialog = NULL;

static void show_dialog_part(GtkWidget *dialog)
{
   gtk_widget_show(dialog);
   current_dialog = dialog;
}

static void hide_dialog_part_current(void)
{
   if (current_dialog) {
      gtk_widget_hide(current_dialog);      
   }
}
	
/*
 * Main window control functions
 */
static void
effectsconfig_close_requested (void)
{
   if (current_dialog) {
      gtk_widget_hide(current_dialog);
   }
   
   gtk_widget_destroy(configwindow);
   configwindow = NULL;
}

static void
effectsconfig_object_changed (void *a,
                              void *b)
{
        unsigned n = (int) b;

	hide_dialog_part_current();
        show_dialog_part(*effects_objects[n].main_dialog_wid);

        return;
}

void
effectsconfig_dialog(void)
{
        GtkWidget *mainbox, *thing;
        OptionMenuItem menu1[NUM_EFFECTS_OBJECTS];
        int i;

        if(configwindow != NULL) {
                gdk_window_raise(configwindow->window);
                return;
        }
#ifdef USE_GNOME
        configwindow = gnome_app_new("SoundTracker", _("Playback Effects Configuration"));
#else
        configwindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(configwindow), _("Playback Effects Configuration"));
#endif
        gtk_signal_connect (GTK_OBJECT (configwindow), "delete_event",
                            GTK_SIGNAL_FUNC (effectsconfig_close_requested), NULL);

        mainbox = gtk_vbox_new(FALSE, 2);
        gtk_container_border_width(GTK_CONTAINER(mainbox), 4);
#ifdef USE_GNOME
        gnome_app_set_contents(GNOME_APP(configwindow), mainbox);
#else
        gtk_container_add(GTK_CONTAINER(configwindow), mainbox);
#endif
        gtk_widget_show(mainbox);

        // Key Group Selector
        for (i = 0; i < NUM_EFFECTS_OBJECTS; i++) {
                menu1[i].name = gettext(effects_objects[i].title);
                menu1[i].func = effectsconfig_object_changed;
        }
        thing = build_option_menu(menu1, NUM_EFFECTS_OBJECTS, 0);
        gtk_widget_show(thing);
        gtk_box_pack_start(GTK_BOX(mainbox), thing, FALSE, FALSE, 0);

        cw_vbox = gtk_vbox_new(FALSE, 2);
        gtk_box_pack_start(GTK_BOX(mainbox), cw_vbox, TRUE, TRUE, 0);
        gtk_widget_show(cw_vbox);
   
   	// Get effect dialogs ready :
	effectsconfig_draw_reverb();
  
        current_dialog = NULL;
        effectsconfig_object_changed(NULL, (void*)0);

        gtk_widget_show(configwindow);
}
