
/*
 * The Real SoundTracker - main program
 *
 * Copyright (C) 1998-1999 Michael Krause
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>

#include <stdio.h>

#include <unistd.h>

#include "i18n.h"
#include "gui.h"
#include "xm.h"
#include "audio.h"
#include "keys.h"
#include "gui-settings.h"
#include "audioconfig.h"
#include "tips-dialog.h"
#include "menubar.h"
#include "track-editor.h"

#include <glib.h>
#include <gtk/gtk.h>

XM *xm = NULL;
int pipea[2], pipeb[2];

int
main (int argc,
      char *argv[])
{
    extern void
	driver_out_oss, driver_in_oss, 
#ifdef DRIVER_ALSA
	driver_out_alsa, driver_in_alsa,
#endif
#ifdef DRIVER_ESD
	driver_out_esd,
#endif
#ifndef NO_AUDIOFILE
//	driver_out_file,
#endif
#if 0
	driver_out_test,
#endif
	mixer_integer32;

    g_thread_init(NULL);

    if(pipe(pipea) || pipe(pipeb)) {
	fprintf(stderr, "Crnk. Can't pipe().\n");
	return 1;
    }

    if(!audio_init(pipea[0], pipeb[1])) {
	fprintf(stderr, "Can't init audio thread.\n");
	return 1;
    }

    /* In case we run setuid root, the main thread must not have root privileges
       -- it must be set back to the calling user ID! */
    seteuid(getuid());
    setegid(getgid());

#if ENABLE_NLS
    gtk_set_locale();
    bindtextdomain(PACKAGE, LOCALEDIR);
    textdomain(PACKAGE);
#endif

    audio_ctlpipe = pipea[1];
    audio_backpipe = pipeb[0];

    /* Mixer modules can't be changed through the GUI at the moment */
    mixer = &mixer_integer32;

#if 0
    drivers[DRIVER_OUTPUT] = g_list_append(drivers[DRIVER_OUTPUT],
					   &driver_out_test);
#endif

#ifdef DRIVER_OSS
    drivers[DRIVER_OUTPUT] = g_list_append(drivers[DRIVER_OUTPUT],
					   &driver_out_oss);
    drivers[DRIVER_INPUT] = g_list_append(drivers[DRIVER_INPUT],
					  &driver_in_oss);
#endif

#ifdef DRIVER_ALSA
    drivers[DRIVER_OUTPUT] = g_list_append(drivers[DRIVER_OUTPUT],
					   &driver_out_alsa);
    drivers[DRIVER_INPUT] = g_list_append(drivers[DRIVER_INPUT],
					   &driver_in_alsa);
#endif

#ifdef DRIVER_ESD
    drivers[DRIVER_OUTPUT] = g_list_append(drivers[DRIVER_OUTPUT],
					   &driver_out_esd);
#endif

#ifndef NO_AUDIOFILE
/*    drivers[DRIVER_OUTPUT] = g_list_append(drivers[DRIVER_OUTPUT],
					   &driver_out_file);

   This driver is not being added to the list because it's rather special
   in that it takes a filename argument each time it's called.. need to
   think about better integration perhaps.
*/
#endif

    g_assert(g_list_length(drivers[DRIVER_OUTPUT]) >= 1
	     && g_list_length(drivers[DRIVER_INPUT]) >= 1);

    gui_settings_load_config();
    tips_dialog_load_settings();

    if(gui_init(argc, argv)) {
	audioconfig_load_config();
	track_editor_load_config();

	gtk_main();

	menubar_write_accels();
	if(gui_settings.save_settings_on_exit) {
	    keys_save_config();
	    gui_settings_save_config();
	    audioconfig_save_config();
	}
	
	gui_settings_save_config_always();
	tips_dialog_save_settings();
	track_editor_save_config();

	return 0;
    } else {
	fprintf(stderr, "gui_init() failed.\n");
	return 1;
    }
}
