#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "id3tag.h"
#include "config.h"
#include "junle.h"

#ifdef DEBUG
#define DPRINT(x) puts(x)
#define DPRINTF(x,y) printf(x,y)
#else
#define DPRINT(x) 
#define DPRINTF(x,y) 
#endif

#ifdef JAPANESE
#include "label_te_j.h"
#else
#include "label_te_e.h"
#endif

GtkWidget *te_main;
GtkWidget *title_txt;
GtkWidget *artist_txt;
GtkWidget *album_txt;
GtkWidget *year_txt;
GtkWidget *comment_txt;
GtkWidget *junle_combo;
GtkWidget *status_bar;

char current_filename[1024];
unsigned char current_junle;
int context_id;

GtkWidget *init_junle_menu(void)
{
  GtkWidget* junle_menu;
  GList *Junle_List=NULL;
  int i;
  DPRINT("init_junle_menu()");
  
  junle_menu = gtk_combo_new();
  
  DPRINT("Append list");
  
  Junle_List=g_list_append(Junle_List, No_Junle );

  for(i = 0; i < junle_num; i++ ) {
    Junle_List=g_list_append(Junle_List, junle_table[i] );
  }

  DPRINT("SetPopDown");
  gtk_combo_set_popdown_strings(GTK_COMBO(junle_menu), Junle_List);
  gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(junle_menu)->entry), FALSE);
  g_list_free(Junle_List);
  
  return (junle_menu);
}

void save_mp3(void)
{
  MP3_TAG *tag;
  DPRINT("Save Entry to mp3");

  if ( current_filename[0]=='\0' ) {
    gtk_statusbar_push( GTK_STATUSBAR(status_bar), (guint) context_id, 
			status_notloaded_txt );
    return;
  }
  tag=(MP3_TAG*)malloc(sizeof(MP3_TAG));

  strncpy(tag->Title, gtk_entry_get_text( GTK_ENTRY(title_txt) ), 30);
  strncpy(tag->Artist, gtk_entry_get_text( GTK_ENTRY(artist_txt) ), 30);
  strncpy(tag->Album, gtk_entry_get_text( GTK_ENTRY(album_txt) ), 30);
  strncpy(tag->Year, gtk_entry_get_text( GTK_ENTRY(year_txt) ), 4);
  strncpy(tag->Comment, gtk_entry_get_text( GTK_ENTRY(comment_txt) ), 30);
  tag->Junle=current_junle;

  DPRINT(current_filename);
  if (Write_ID3 (current_filename, tag)==1)
    gtk_statusbar_push( GTK_STATUSBAR(status_bar), (guint) context_id, 
			status_save_txt );
  else
    gtk_statusbar_push( GTK_STATUSBAR(status_bar), (guint) context_id, 
			status_savefail_txt );    
}

void quit_func(void)
{
  gtk_widget_hide(te_main);
}

void change_junle (void)
{
  GList *sel;
  DPRINT("Change Junle");

  sel=GTK_LIST(GTK_COMBO(junle_combo)->list)->selection;
  current_junle=gtk_list_child_position(GTK_LIST(GTK_COMBO(junle_combo)->list),
					sel->data)-1;
}

void set_mp3_to_entry(char *filename)
{
  MP3_TAG *tag;
  char BUFF[255];

  gtk_entry_set_text(GTK_ENTRY(title_txt), "" );
  gtk_entry_set_text(GTK_ENTRY(artist_txt), "" );
  gtk_entry_set_text(GTK_ENTRY(album_txt), "" );
  gtk_entry_set_text(GTK_ENTRY(year_txt), "" );
  gtk_entry_set_text(GTK_ENTRY(comment_txt), "" );
  current_junle=-1;
  strcpy(current_filename, "");
  gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(junle_combo)->entry),
		     No_Junle);

  DPRINT ("set mp3 id3tag to text entry");
  tag=(MP3_TAG*)malloc(sizeof(MP3_TAG));
  switch ( read_tag(filename, tag)) {
  case 1:
    gtk_entry_set_text(GTK_ENTRY(title_txt), tag->Title);
    gtk_entry_set_text(GTK_ENTRY(artist_txt), tag->Artist);
    gtk_entry_set_text(GTK_ENTRY(album_txt), tag->Album);
    gtk_entry_set_text(GTK_ENTRY(year_txt), tag->Year);
    gtk_entry_set_text(GTK_ENTRY(comment_txt), tag->Comment);
    current_junle=tag->Junle;
    if ( current_junle != 0xff &&  current_junle < junle_num )
    gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(junle_combo)->entry),
		       (char *)junle_table[current_junle]);
    else if ( current_junle == 0xff )
    gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(junle_combo)->entry),
		       No_Junle);
    else
    gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(junle_combo)->entry),
		       "Unknown Genre");

    gtk_statusbar_push( GTK_STATUSBAR(status_bar), (guint) context_id, 
			status_load_txt );
    strcpy(current_filename, filename);
    sprintf(BUFF,"%s [ %s ]", window_main_title_txt, current_filename);
    gtk_window_set_title(GTK_WINDOW(te_main), BUFF);
    break;
  case 0:
    strcpy(current_filename, filename);
    sprintf(BUFF,"%s [ %s ]", window_main_title_txt, current_filename);
    gtk_window_set_title(GTK_WINDOW(te_main), BUFF);
    gtk_statusbar_push( GTK_STATUSBAR(status_bar), (guint) context_id, 
			status_loadenpty_txt );
    break;
  default:
    gtk_statusbar_push( GTK_STATUSBAR(status_bar), (guint) context_id, 
			status_loadfail_txt );
  }
}

GtkWidget *init_tewin(void)
{
  GtkWidget *table;
  char BUFF[1024];
  GtkWidget *label;
  GtkWidget *button;

  DPRINT("init_disp()");

  te_main=gtk_window_new(GTK_WINDOW_TOPLEVEL);
  sprintf(BUFF,"%s [ no file ]", window_main_title_txt);
  gtk_window_set_title(GTK_WINDOW(te_main), BUFF);

  table = gtk_table_new(7, 7, FALSE );
  gtk_container_add(GTK_CONTAINER(te_main), table);
  gtk_widget_show(table);

  label=gtk_label_new(label_title_txt);
  gtk_table_attach_defaults(GTK_TABLE(table),label, 0, 1, 1, 2);
  gtk_widget_show(label);
  title_txt=gtk_entry_new_with_max_length(30);
  gtk_table_attach_defaults(GTK_TABLE(table),title_txt, 1, 4, 1, 2);
  gtk_widget_show(title_txt);

  label=gtk_label_new(label_artist_txt);
  gtk_table_attach_defaults(GTK_TABLE(table),label, 0, 1, 2, 3);
  gtk_widget_show(label);
  artist_txt=gtk_entry_new_with_max_length(30);
  gtk_table_attach_defaults(GTK_TABLE(table),artist_txt, 1, 4, 2, 3);
  gtk_widget_show(artist_txt);

  label=gtk_label_new(label_album_txt);
  gtk_table_attach_defaults(GTK_TABLE(table),label, 0, 1, 3, 4);
  gtk_widget_show(label);
  album_txt=gtk_entry_new_with_max_length(30);
  gtk_table_attach_defaults(GTK_TABLE(table),album_txt, 1, 4, 3, 4);
  gtk_widget_show(album_txt);

  label=gtk_label_new(label_year_txt);
  gtk_table_attach_defaults(GTK_TABLE(table),label, 0, 1, 4, 5);
  gtk_widget_show(label);
  year_txt=gtk_entry_new_with_max_length(4);
  gtk_table_attach_defaults(GTK_TABLE(table),year_txt, 1, 2, 4, 5);
  gtk_widget_show(year_txt);

  junle_combo=init_junle_menu();
  gtk_table_attach_defaults(GTK_TABLE(table),junle_combo, 3, 4, 4, 5);
  gtk_widget_show(junle_combo);

  gtk_signal_connect_object (GTK_OBJECT (GTK_COMBO(junle_combo)->list),
			     "select_child",
                             GTK_SIGNAL_FUNC (change_junle),
                             NULL);

  label=gtk_label_new(label_comment_txt);
  gtk_table_attach_defaults(GTK_TABLE(table),label, 0, 1, 5, 6);
  gtk_widget_show(label);
  comment_txt=gtk_entry_new_with_max_length(30);
  gtk_table_attach_defaults(GTK_TABLE(table),comment_txt, 1, 4, 5, 6);
  gtk_widget_show(comment_txt);

  button=gtk_button_new_with_label(button_save_txt);
  gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                             GTK_SIGNAL_FUNC (save_mp3),
                             GTK_OBJECT (te_main));
  gtk_table_attach_defaults(GTK_TABLE(table),button, 5, 6, 2, 3);
  gtk_widget_show(button);

  button=gtk_button_new_with_label(button_quit_txt);
  gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                             GTK_SIGNAL_FUNC (quit_func),
                             GTK_OBJECT (te_main));
  gtk_table_attach_defaults(GTK_TABLE(table),button, 5, 6, 4, 5);
  gtk_widget_show(button);

  status_bar = gtk_statusbar_new();      
  gtk_table_attach_defaults(GTK_TABLE(table),status_bar, 0, 7, 6, 7);
  context_id = gtk_statusbar_get_context_id( GTK_STATUSBAR(status_bar), 
					     status_context_txt);
  gtk_widget_show (status_bar);

  /* set window event signal */
  DPRINT("set signal()");
  gtk_signal_connect (GTK_OBJECT (te_main), "destroy",
                      GTK_SIGNAL_FUNC (quit_func), NULL);
  gtk_signal_connect_object (GTK_OBJECT (te_main), "delete_event",
                             GTK_SIGNAL_FUNC (quit_func),
                             GTK_OBJECT (te_main));

  return (te_main);
}
