/*
  flyingwindows.c
  
  version 0.2
  
  Draws flying MicroSoft (tm) Windows (tm)-style logos.
  Your favorite good guy (Tux the Linux Penguin, the FreeBSD Daemon, or
  a Sun Microsystems(tm)-style UFO) appears to save the day.
  
  It can also run in non-violent mode, with X11 logos on the screen.
  
  by Bill Kendrick
  bill@newbreedsoftware.com
  http://www.newbreedsoftware.com/bill/
  
  XPM hack my Dr. George Ferguson
  ferguson@cs.rochester.edu
  
  April 17, 1999 - May 6, 1999
*/

/* Code based on the screenhack "deco": */

/* xscreensaver, Copyright (c) 1997, 1998 Jamie Zawinski <jwz@jwz.org>
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  No representations are made about the suitability of this
 * software for any purpose.  It is provided "as is" without express or 
 * implied warranty.
 *
 * Concept snarfed from Michael D. Bayne in
 * http://www.go2net.com/internet/deep/1997/04/16/body.html
 */

#include "screenhack.h"
#include <stdio.h>
#include "bitmaps/win_1.xbm"
#include "bitmaps/win_2.xbm"
#include "bitmaps/win_3.xbm"
#include "bitmaps/win_4.xbm"
#include "bitmaps/win_5.xbm"
#include "bitmaps/win_6.xbm"
#include "bitmaps/win_7.xbm"
#include "bitmaps/win_8.xbm"
#include "bitmaps/win_9.xbm"
#include "bitmaps/win_10.xbm"
#include "bitmaps/x11_1.xbm"
#include "bitmaps/x11_2.xbm"
#include "bitmaps/x11_3.xbm"
#include "bitmaps/x11_4.xbm"
#include "bitmaps/x11_5.xbm"
#include "bitmaps/x11_6.xbm"
#include "bitmaps/x11_7.xbm"
#include "bitmaps/x11_8.xbm"
#include "bitmaps/x11_9.xbm"
#include "bitmaps/x11_10.xbm"
#ifdef USE_XPM
#include <X11/xpm.h>
#include "bitmaps/tux_left.xpm"
#include "bitmaps/tux_right.xpm"
#include "bitmaps/bsd_left.xpm"
#include "bitmaps/bsd_right.xpm"
#include "bitmaps/sun.xpm"
#include "bitmaps/sgi.xpm"
#else
#include "bitmaps/tux_left.xbm"
#include "bitmaps/tux_right.xbm"
#include "bitmaps/bsd_left.xbm"
#include "bitmaps/bsd_right.xbm"
#include "bitmaps/sun.xbm"
#include "bitmaps/sgi.xbm"
#endif



#define NUM_LOGOS 15
#define MAX_EXPLOSION_BITS 100

typedef struct {
  int x, y, z, color;
} logo_type;

typedef struct {
  int x, y, xm, ym, timer;
  Pixmap left_pix, right_pix;
  int width, height;
} goodguy_type;

typedef struct {
  Pixmap pix;
  int w, h;
} logo_pixmap_type;

typedef struct {
  int alive, timer;
  int x, y, z, xm, ym, zm;
} explosion_type;

static XColor colors[255];
static int ncolors, x11, tux, bsd, sunny, sgi;
Pixmap backbuffer;
logo_type logos[NUM_LOGOS];
explosion_type explosions[MAX_EXPLOSION_BITS];
int order [NUM_LOGOS];
logo_pixmap_type window_logo[10];
GC fgc, logogc, bgc;
goodguy_type goodguy;
int fired, fire_x, fire_y, from_x, from_y;

#ifdef USE_XPM
Pixmap goodguy_left_mask, goodguy_right_mask;
#endif


/* Draws or erases a logo: */

void draw_or_erase_logo(Display * dpy, int i, int draw, int width, int height)
{
  int x, y;
  
  
  /* Calculate screen position: */
  
  x = logos[i].x / (20 - logos[i].z) + width / 2 -
    (window_logo[9 - logos[i].z / 2].w / 2);
  y = logos[i].y / (20 - logos[i].z) + height / 2 -
    (window_logo[9 - logos[i].z / 2].h / 2);
  
  
  /* Draw or erase the logo: */
  
  if (draw == 0)
    {
      XFillRectangle(dpy, backbuffer, bgc,
		     x, y,
		     window_logo[9 - logos[i].z / 2].w + 4,
		     window_logo[9 - logos[i].z / 2].h + 4);
    }
  else
    {
      XCopyPlane(dpy, window_logo[9 - logos[i].z / 2].pix,
		 backbuffer, logogc,
		 0, 0, window_logo[9 - logos[i].z / 2].w,
		 window_logo[9 - logos[i].z / 2].h,
		 x, y, 1);
    }
}


/* Draws or erases an explosion bit: */

void draw_or_erase_explosion(Display * dpy, int i, int draw,
			     int width, int height)
{
  int x1, y1, x2, y2;
  
  
  /* Find screen position of end points: */
  
  x1 = explosions[i].x / (20 - explosions[i].z) + width / 2;
  y1 = explosions[i].y / (20 - explosions[i].z) + height / 2;
  
  x2 = (explosions[i].x + explosions[i].xm) / (20 - explosions[i].z) +
    width / 2;
  y2 = (explosions[i].y + explosions[i].ym) / (20 - explosions[i].z) +
    height / 2;
      
  
  /* Draw or erase the line: */
  
  if (draw == 1)
    {
      if (!mono_p)
	XSetForeground(dpy, logogc, colors[random() % ncolors].pixel);
      
      XDrawLine(dpy, backbuffer, logogc, x1, y1, x2, y2);
    }
  else
    {
      XDrawLine(dpy, backbuffer, bgc, x1, y1, x2, y2);
    }
}


/* Positions a logo at a new spot: */

void newlogo(int i, int far, int width, int height)
{
  logos[i].x = (random() % (width * 2)) - width;
  logos[i].y = (random() % (height * 2)) - height;
  if (far == 1)
    logos[i].z = 0;
  else
    logos[i].z = random() % 20;
  logos[i].color = random() % ncolors;
}


/* Add one explosion bit: */

void addexplosion(int x, int y, int z)
{
  int i, found;
  
  
  /* Pick a slot: */
  
  found = -1;
  
  for (i = 0; i < MAX_EXPLOSION_BITS && found == -1; i++)
    {
      if (explosions[i].alive == 0)
	found = i;
    }
  
  if (found == -1)
    found = random() % MAX_EXPLOSION_BITS;
  
  
  /* Add the bit: */
  
  explosions[found].alive = 1;
  explosions[found].x = x + (random() % 16) - 8;
  explosions[found].y = y + (random() % 16) - 8;
  explosions[found].z = z;
  
  explosions[found].xm = (random() % 32) - 16;
  explosions[found].ym = (random() % 32) - 16;
  
  explosions[found].timer = (random() % 5) + 10;
}


/* Add explosion bits: */

void explode(int i)
{
  int j;
  
  for (j = 0; j < 8 + (random() % 8); j++)
    addexplosion(logos[i].x, logos[i].y, logos[i].z);
}



/* Handle the flying windows! */

static void flyingwindows(Display *dpy, Window window,
			  int width, int height)
{
  int i, j, changed, tmp, which;
  
  
  /* -- The windows logos: -- */
  
  /* Erase logos: */
  
  for (i = 0; i < NUM_LOGOS; i++)
    draw_or_erase_logo(dpy, i, 0, width, height);

  
  /* Erase explosions: */
  
  for (i = 0; i < MAX_EXPLOSION_BITS; i++)
    {
      if (explosions[i].alive == 1)
	draw_or_erase_explosion(dpy, i, 0, width, height);
    }
  
  
  /* Move logos: */
  
  for (i = 0; i < NUM_LOGOS; i++)
    {
      logos[i].z = logos[i].z + 1;
      
      if (logos[i].z >= 20)
	newlogo(i, 1, width, height);
      
      order[i] = i;
    }
  
  
  /* Move explosions: */
  
  for (i = 0; i < MAX_EXPLOSION_BITS; i++)
    {
      if (explosions[i].alive == 1)
	{
	  explosions[i].x = explosions[i].x + explosions[i].xm;
	  explosions[i].y = explosions[i].y + explosions[i].ym;
	  explosions[i].z = explosions[i].z + 1;
	  explosions[i].timer--;
	  
	  if (explosions[i].timer <= 0 || explosions[i].z >= 20)
	    explosions[i].alive = 0;
	}
    }
  
  
  /* Sort: */
  
  do
    {
      changed = 0;
      
      for (i = 0; i < NUM_LOGOS - 1; i++)
	{
	  if (logos[order[i]].z > logos[order[i + 1]].z)
	    {
	      changed = 1;
	      
	      tmp = order[i];
	      order[i] = order[i + 1];
	      order[i + 1] = tmp;
	    }
	}
    }
  while (changed == 1);
  
  
  /* Draw logos: */
  
  for (i = 0; i < NUM_LOGOS; i++)
    {
      j = order[i];
      
      if (!mono_p)
	XSetForeground(dpy, logogc, colors[logos[j].color].pixel);
      
      draw_or_erase_logo(dpy, order[i], 1, width, height);
    }
  
  
  /* Draw explosions: */
  
  for (i = 0; i < MAX_EXPLOSION_BITS; i++)
    {
      if (explosions[i].alive == 1)
	draw_or_erase_explosion(dpy, i, 1, width, height);
    }
  
  
  /* -- And now, unix: -- */
  
  if (x11 == 0)
    {
      /* Erase: */
      
      XFillRectangle(dpy, backbuffer, bgc,
		     goodguy.x, goodguy.y, goodguy.width, goodguy.height);
      
      
      /* Move: */
      
      goodguy.x = goodguy.x + goodguy.xm;
      goodguy.y = goodguy.y + goodguy.ym;
      goodguy.timer--;
      
      if (goodguy.timer <= 0 ||
	  goodguy.x < 0 || goodguy.x > width - goodguy.width ||
	  goodguy.y < 0 ||
	  (goodguy.y > height - goodguy.height && goodguy.ym > 0))
	{
	  if (goodguy.x < 0)
	    goodguy.x = 0;
	  if (goodguy.x > width - goodguy.width)
	    goodguy.x = width - goodguy.width;
	  if (goodguy.y < 0)
	    goodguy.y = 0;
	  if (goodguy.y > height - goodguy.height && goodguy.ym > 0)
	    goodguy.y = height - goodguy.height;
	  
	  goodguy.timer = (random() % 50) + 50;
	  goodguy.xm = ((random() % 17) - 8) * 4;
	  goodguy.ym = ((random() % 17) - 8) * 4;
	}
      
      
      /* Shoot at a windows icon: */
      
      if (fired == 0)
	{
	  /* Pick which to shoot...: */
	  
	  which = random() % NUM_LOGOS;
	  
	  if (((goodguy.x < width / 2 && logos[which].x >= goodguy.x) ||
	       (goodguy.x > width / 2 && logos[which].x <= goodguy.x)) &&
	      logos[which].x > -width * 2 && logos[which].x < width * 2 &&
	      logos[which].y >= -height * 2 && logos[which].y <= height * 2 &&
	      logos[which].z < 10)
	    {
	      /* Where to shoot from: */
	      
	      if (goodguy.x > width / 2 - goodguy.width / 2)
		from_x = goodguy.x;
	      else
		from_x = goodguy.x + goodguy.width;
	      
	      from_y = goodguy.y + goodguy.height / 2;
	      
	      
	      /* Where to shoot to: */
	      
	      fire_x = logos[which].x / (20 - logos[which].z) + width / 2 -
		(window_logo[9 - logos[which].z / 2].w / 2);
	      fire_y = logos[which].y / (20 - logos[which].z) + height / 2 -
		(window_logo[9 - logos[which].z / 2].h / 2);
	      
	      
	      /* Shoot it (draw laser, make new icon): */
	      
	      draw_or_erase_logo(dpy, which, 0, width, height);
	      explode(which);
	      newlogo(which, 1, width, height);
	      XDrawLine(dpy, backbuffer, fgc, from_x, from_y, fire_x, fire_y);
	      fired = 2;
	    }
	}
      else
	{
	  fired--;
	  
	  
	  /* Erase laser: */
	  
	  if (fired <= 0)
	    XDrawLine(dpy, backbuffer, bgc, from_x, from_y, fire_x, fire_y);
	}
      
      
      /* Draw: */
      
      if (goodguy.x < width / 2 - goodguy.width / 2)
	{
#ifdef USE_XPM
	  XSetClipOrigin(dpy, fgc, goodguy.x, goodguy.y);
	  XSetClipMask(dpy, fgc, goodguy_right_mask);
	  XCopyArea(dpy, goodguy.right_pix, backbuffer, fgc,
		    0, 0, goodguy.width, goodguy.height,
		    goodguy.x, goodguy.y);
	  XSetClipMask(dpy, fgc, None);
#else
	  XCopyPlane(dpy, goodguy.right_pix, backbuffer, fgc,
		     0, 0, goodguy.width, goodguy.height,
		     goodguy.x, goodguy.y, 1);
#endif
	}
      else
	{
#ifdef USE_XPM
	  XSetClipOrigin(dpy, fgc, goodguy.x, goodguy.y);
	  XSetClipMask(dpy, fgc, goodguy_left_mask);
	  XCopyArea(dpy, goodguy.left_pix, backbuffer, fgc,
		    0, 0, goodguy.width, goodguy.height,
		    goodguy.x, goodguy.y);
	  XSetClipMask(dpy, fgc, None);
#else
	  XCopyPlane(dpy, goodguy.left_pix, backbuffer, fgc,
		     0, 0, goodguy.width, goodguy.height,
		     goodguy.x, goodguy.y, 1);
#endif
	}
    }
  
  
  /* Page-flip backbuffer! */
  
  XCopyArea(dpy, backbuffer, window, fgc, 0, 0, width, height, 0, 0);
}



/* X Resource stuff: */

char *progclass = "FlyingWindows";

char *defaults [] = {
  ".background:		black",
  ".foreground:		white",
  "*ncolors:		64",
  "*delay:              50000",
  "*x11:                False",
  "*tux:                False",
  "*bsd:                False",
  "*sun:                False",
  "*version:            False",
  0
};

XrmOptionDescRec options [] = {
  {"-ncolors",	       ".ncolors",	XrmoptionSepArg, 0},
  {"-delay",           ".delay",       XrmoptionSepArg, 0},
  {"-x11",             ".x11",         XrmoptionNoArg, "True"},
  {"-tux",             ".tux",         XrmoptionNoArg, "True"},
  {"-bsd",             ".bsd",         XrmoptionNoArg, "True"},
  {"-sun",             ".sun",         XrmoptionNoArg, "True"},
  {"-sgi",             ".sgi",         XrmoptionNoArg, "True"},
  {"-version",         ".version",     XrmoptionNoArg, "True"},
  {0, 0, 0, 0}
};


/* Copy bitmap data into a logo_pixmap_type structure: */

void data_to_pixmap(Display * dpy, logo_pixmap_type * lp,
		    char * bits, int width, int height)
{
  lp->pix = XCreateBitmapFromData(dpy, backbuffer,
				  bits, width, height);
  if (lp == False)
    exit(1);
  lp->w = width;
  lp->h = height;
}


/* Screenhack function: */

void screenhack(Display *dpy, Window window)
{
  XGCValues gcv;
  XWindowAttributes xgwa;
  int delay, i, good_depth;
  Bool writable;
#ifdef USE_XPM
  XpmAttributes attrs;
#endif
  
  
  /* Version info? */
  
  if (get_boolean_resource("version", "Boolean") == 1)
    {
      printf("Usage: flyingwindows [-root] [-window] [-mono] [-install], [-noinstall]\n");
      printf("       [-visual <arg>], [-window-id <arg>], [-ncolors <arg>]\n");
      printf("       [-delay <arg>], [-x11 | -tux | -bsd | -sun | -sgi] [-version]\n\n");
      
      printf("Copyrights/trademarks: Tux the Linux Penguin - Larry Ewing\n");
      printf("                       FreeBSD Daemon - Marshal Kirk McKusic\n");
      printf("                       MicroSoft, Windows, MS - MicroSoft\n");
      printf("                       X-Window, X11 - X Consortium\n");
      printf("                       Sun - Sun Microsystems, Inc.\n");
      printf("                       Linux - Linus Torvalds\n");
      printf("                       SGI, Silicon Graphics - Silicon Graphics, Inc.\n");
      printf("Flying Windows 0.2 by Bill Kendrick <bill@newbreedsoftware.com>, 1999.\n");
      printf("XPM code provided by Dr. George Ferguson <ferguson@cs.rochester.edu>.\n");
      printf("\n");
      
      exit(0);
    }
  
  
  /* Get resources and set up X stuff: */
  
  /* Mode? Normal (MS-Windows) or X11? */
  
  x11 = get_boolean_resource("x11", "Boolean");
  
  
  /* Who's our character? */
  
  if (x11 == 0)
    {
      tux = get_boolean_resource("tux", "Boolean");
      bsd = get_boolean_resource("bsd", "Boolean");
      sunny = get_boolean_resource("sun", "Boolean");
      sgi = get_boolean_resource("sgi", "Boolean");
      
      
      /* None specified?  Pick one! */
      
      if (tux == 0 && bsd == 0 && sunny == 0 && sgi == 0)
	{
	  i = random() % 4;
	  
	  if (i == 0)
	    tux = 1;
	  else if (i == 1)
	    bsd = 1;
	  else if (i == 2)
	    sunny = 1;
	  else if (i == 3)
	    sgi = 1;
	}
    }
  
  
  /* How many colors?  Make some colors: */
  
  XGetWindowAttributes(dpy, window, &xgwa);
  
  gcv.foreground = get_pixel_resource("foreground", "Foreground",
				      dpy, xgwa.colormap);
  gcv.background = get_pixel_resource("background", "Background",
				      dpy, xgwa.colormap);
  fgc = XCreateGC(dpy, window, GCForeground | GCBackground, &gcv);
  logogc = XCreateGC(dpy, window, GCForeground | GCBackground, &gcv);
  
  
  gcv.foreground = get_pixel_resource("background", "Background",
				      dpy, xgwa.colormap);
  bgc = XCreateGC(dpy, window, GCForeground, &gcv);
  
  ncolors = get_integer_resource("ncolors", "Integer");
  writable = False;
  make_random_colormap(dpy, xgwa.visual, xgwa.colormap, colors, &ncolors,
		       False, True, &writable, True);

  if (ncolors <= 2)
    mono_p = True;
  
  
  /* Animation speed: */
  
  delay = get_integer_resource ("delay", "Integer");
  
  
  /* Init logos: */
  
  for (i = 0; i < NUM_LOGOS; i++)
    newlogo(i, 0, xgwa.width, xgwa.height);
  
  
  /* Init explosion bits: */
  
  for (i = 0; i < MAX_EXPLOSION_BITS; i++)
    explosions[i].alive = 0;
  
  
  /* Init good guy: */
  
  goodguy.x = random() % (xgwa.width - goodguy.width);
  goodguy.y = xgwa.height;
  goodguy.timer = (random() % 50) + 100;
  goodguy.xm = ((random() % 17) - 8) * 4;
  goodguy.ym = -((random() % 7) + 1) * 4;
  
  
  /* Setup backbuffer: */
  
  good_depth = DefaultDepthOfScreen(DefaultScreenOfDisplay(dpy));
  backbuffer = XCreatePixmap(dpy, window, xgwa.width, xgwa.height, good_depth);
  
  
  /* Init bitmaps: */
  
  if (x11 == 0)
    {
      /* Load MS-Windows(tm) logos: */
      
      data_to_pixmap(dpy, &window_logo[0], win_1_bits,
		     win_1_width, win_1_height);
      data_to_pixmap(dpy, &window_logo[1], win_2_bits,
		     win_2_width, win_2_height);
      data_to_pixmap(dpy, &window_logo[2], win_3_bits,
		     win_3_width, win_3_height);
      data_to_pixmap(dpy, &window_logo[3], win_4_bits,
		     win_4_width, win_4_height);
      data_to_pixmap(dpy, &window_logo[4], win_5_bits,
		     win_5_width, win_5_height);
      data_to_pixmap(dpy, &window_logo[5], win_6_bits,
		     win_6_width, win_6_height);
      data_to_pixmap(dpy, &window_logo[6], win_7_bits,
		     win_7_width, win_7_height);
      data_to_pixmap(dpy, &window_logo[7], win_8_bits,
		     win_8_width, win_8_height);
      data_to_pixmap(dpy, &window_logo[8], win_9_bits,
		     win_9_width, win_9_height);
      data_to_pixmap(dpy, &window_logo[9], win_10_bits,
		     win_10_width, win_10_height);
      
      
#ifdef USE_XPM
      attrs.valuemask = XpmSize;
#endif
      
      
      /* Load our good guy: */
      
      if (bsd == 1)
	{
#ifdef USE_XPM
	  XpmCreatePixmapFromData(dpy, backbuffer,
				  bsd_left_xpm,
				  &goodguy.left_pix,
				  &goodguy_left_mask, &attrs);
	  XpmCreatePixmapFromData(dpy, backbuffer,
				  bsd_right_xpm,
				  &goodguy.right_pix,
				  &goodguy_right_mask, NULL);
	  goodguy.width = attrs.width;
	  goodguy.height = attrs.height;
#else

	  goodguy.left_pix = XCreateBitmapFromData(dpy, backbuffer,
						   bsd_left_bits,
						   bsd_left_width,
						   bsd_left_height);
	  
	  goodguy.right_pix = XCreateBitmapFromData(dpy, backbuffer,
						    bsd_right_bits,
						    bsd_right_width,
						    bsd_right_height);
	  goodguy.width = bsd_left_width;
	  goodguy.height = bsd_left_height;
#endif
	}
      else if (sunny == 1)
	{
#ifdef USE_XPM
	  XpmCreatePixmapFromData(dpy, backbuffer,
				  sun_xpm,
				  &goodguy.left_pix,
				  &goodguy_left_mask, &attrs);
	  XpmCreatePixmapFromData(dpy, backbuffer,
				  sun_xpm,
				  &goodguy.right_pix,
				  &goodguy_right_mask, NULL);
	  goodguy.width = attrs.width;
	  goodguy.height = attrs.height;
#else
	  goodguy.left_pix = XCreateBitmapFromData(dpy, backbuffer,
						   sun_bits,
						   sun_width,
						   sun_height);
	  
	  goodguy.right_pix = XCreateBitmapFromData(dpy, backbuffer,
						    sun_bits,
						    sun_width,
						    sun_height);
	  goodguy.width = sun_width;
	  goodguy.height = sun_height;
#endif
	}
      else if (sgi == 1)
	{
#ifdef USE_XPM
	  XpmCreatePixmapFromData(dpy, backbuffer,
				  sgi_xpm,
				  &goodguy.left_pix,
				  &goodguy_left_mask, &attrs);
	  XpmCreatePixmapFromData(dpy, backbuffer,
				  sgi_xpm,
				  &goodguy.right_pix,
				  &goodguy_right_mask, NULL);
	  goodguy.width = attrs.width;
	  goodguy.height = attrs.height;
#else
	  goodguy.left_pix = XCreateBitmapFromData(dpy, backbuffer,
						   sgi_bits,
						   sgi_width,
						   sgi_height);
	  
	  goodguy.right_pix = XCreateBitmapFromData(dpy, backbuffer,
						    sgi_bits,
						    sgi_width,
						    sgi_height);
	  goodguy.width = sgi_width;
	  goodguy.height = sgi_height;
#endif
	}
      else
	{
#ifdef USE_XPM
	  XpmCreatePixmapFromData(dpy, backbuffer,
				  tux_left_xpm,
				  &goodguy.left_pix,
				  &goodguy_left_mask, &attrs);
	  XpmCreatePixmapFromData(dpy, backbuffer,
				  tux_right_xpm,
				  &goodguy.right_pix,
				  &goodguy_right_mask, NULL);
	  goodguy.width = attrs.width;
	  goodguy.height = attrs.height;
#else
	  goodguy.left_pix = XCreateBitmapFromData(dpy, backbuffer,
						   tux_left_bits,
						   tux_left_width,
						   tux_left_height);
	  
	  goodguy.right_pix = XCreateBitmapFromData(dpy, backbuffer,
						    tux_right_bits,
						    tux_right_width,
						    tux_right_height);
	  goodguy.width = tux_left_width;
	  goodguy.height = tux_left_height;
#endif
	}
    }
  else
    {
      data_to_pixmap(dpy, &window_logo[0], x11_1_bits,
		     x11_1_width, x11_1_height);
      data_to_pixmap(dpy, &window_logo[1], x11_2_bits,
		     x11_2_width, x11_2_height);
      data_to_pixmap(dpy, &window_logo[2], x11_3_bits,
		     x11_3_width, x11_3_height);
      data_to_pixmap(dpy, &window_logo[3], x11_4_bits,
		     x11_4_width, x11_4_height);
      data_to_pixmap(dpy, &window_logo[4], x11_5_bits,
		     x11_5_width, x11_5_height);
      data_to_pixmap(dpy, &window_logo[5], x11_6_bits,
		     x11_6_width, x11_6_height);
      data_to_pixmap(dpy, &window_logo[6], x11_7_bits,
		     x11_7_width, x11_7_height);
      data_to_pixmap(dpy, &window_logo[7], x11_8_bits,
		     x11_8_width, x11_8_height);
      data_to_pixmap(dpy, &window_logo[8], x11_9_bits,
		     x11_9_width, x11_9_height);
      data_to_pixmap(dpy, &window_logo[9], x11_10_bits,
		     x11_10_width, x11_10_height);
    }
  
  
  /* Main loop! */
  
  fired = 0;

  while (1)
    {
      screenhack_handle_events(dpy);
      
      XSync(dpy, False);
      screenhack_handle_events(dpy);

      flyingwindows(dpy, window, xgwa.width, xgwa.height);
      
      if (delay)
	usleep(delay);
    }
}
