#include "cthugha.h"
#include "interface.h"
#include "display.h"
#include "keys.h"
#include "imath.h"
#include "CthughaBuffer.h"

class InterfaceList : public Interface {
    static int size;
    int pos;
    CoreOption * optList;
    int nFixed;
public:
    InterfaceList(const char * title, CoreOption * ol, int p);
    virtual void display();
    virtual int do_key(int key);
};

//
// ERROR:
//
// When the OptionList changes this Interface is not updated!
// this happends when new random palettes are generated
//

InterfaceList::InterfaceList(const char * title, CoreOption * ol, int p) : 
    Interface(NULL, 0, p), pos(2), optList(ol) {

    InterfaceElement ** el = new InterfaceElement*[2 + ol->nEntries];

    el[0] = new InterfaceElementTitle(title);
    el[1] = new InterfaceElementText("---------------------------------------");

    // make the new entries
    for(int i=0; i < ol->nEntries; i++) {
	el[i+2] = new InterfaceElementOption("", &(ol->entries[i]->use));
    }

    elements = el;
    nElements = 2 + ol->nEntries;
    nFixed = 2;

    sel = 0;
    elements[sel]->selected = 1;
}

int InterfaceList::do_key(int key) {
    switch(key) {
    case CK_ENTER:
	if(sel >= nFixed) {
	    optList->entries[sel-nFixed]->use.setValue(1);	// make it usable
	    optList->setValue(sel - nFixed);			// make it active
	    optList->change(0, 0);				// validate and action
	    set(interfaces[0]);					// and close this display
	    return 0;
	} else
	    return key;
    case ' ':
	if(sel >= nFixed) {
	    optList->entries[sel-nFixed]->use.setValue(1);	// make it usable
	    optList->setValue(sel - nFixed);			// make it active
	    optList->change(0, 0);				// validate and action
	    return 0;
	} else
	    return key;
    }
    return Interface::do_key(key);
}

void InterfaceList::display() {
    int l;
    // fixed elements (title, ...)
    for(l=0; l < nFixed; l++)		
	elements[l]->display(l);

    if( nElements == nFixed)
	return;
    
    // scrolling elements
    if( sel < pos) {
	pos = max(sel, nFixed);
    }
    if( (sel-size) >= pos) {
	pos = sel;
    }
    for(int i = 0; i < size; i++) {
	int s = i + pos;
	if ( (s >= nElements) || (s < nFixed) )
	    continue;

	char str1[128];
	sprintf(str1, "%c%s",
		(s == sel) ? '>' : ' ',
		optList->entries[s-nFixed]->name);

	char str2[128];
	sprintf(str2, "%s %3s%c",
		optList->entries[s-nFixed]->desc,
		optList->entries[s-nFixed]->use.text(),
		(s == sel) ? '<' : ' ');

	char str3[128];
	sprintf(str3, "%40s", str2);

	displayDevice->print(str3, (i+l), 'l', 
			     (s==sel) ? TEXT_COLOR_HIGHLIGHT : TEXT_COLOR_NORMAL);
	displayDevice->print(str1, (i+l), 'l', 
			     (s==sel) ? TEXT_COLOR_HIGHLIGHT : TEXT_COLOR_NORMAL);
    }
}

int InterfaceList::size = 6;

//
// create dynamtically, because some entries are loaded (palettes, ...)
//
void initInterfaceLists() {
    Interface * i;	// just to avoid warnings

    i = new InterfaceList ("Display",		&screen,				 9);
    i = new InterfaceList ("Flame",		&(CthughaBuffer::buffers[0].flame),	10);
    i = new InterfaceList ("Buffer Border",	&(CthughaBuffer::buffers[0].border),	11);
    i = new InterfaceList ("Translate",		&(CthughaBuffer::buffers[0].translate),	12);
    i = new InterfaceList ("Wave",		&(CthughaBuffer::buffers[0].wave),	13);
    i = new InterfaceList ("Sound Processing",	&(CthughaBuffer::buffers[0].soundProcess),14);
    i = new InterfaceList ("Table",		&(CthughaBuffer::buffers[0].table),	15);
    i = new InterfaceList ("Wave Scaling",	&(CthughaBuffer::buffers[0].waveScale),	16);
    i = new InterfaceList ("Object",		&(CthughaBuffer::buffers[0].object),	17);
    i = new InterfaceList ("Palette",		&(CthughaBuffer::buffers[0].palette),	18);
    i = new InterfaceList ("PCX",		&(CthughaBuffer::buffers[0].pcx),	19);
    i = new InterfaceList ("Flashlight",	&(CthughaBuffer::buffers[0].flashlight),20);
}
