/***
 * CopyPolicy: GNU Public License 2 applies
 * Copyright (C) by Heiko Eissfeldt
 *
 *
 * ---------------------------------------------------------------------
 *  definitions for sun pcm output
 * ---------------------------------------------------------------------
 */

#include "byteorder.h"

typedef struct SUNHDR {
  unsigned int magic;			/* dns. a la .snd */
  unsigned int data_location;		/* offset to data */
  unsigned int size;			/* # of data bytes */
  unsigned int format;			/* format code */
  unsigned int sample_rate;		/* in Hertz */
  unsigned int channelcount;		/* 1 for mono, 2 for stereo */
  char info[8];			/* comments */
} SUNHDR;

/* Prototypes */
int InitSun __PR(( int audio, long channels, unsigned long rate,
		long nBitsPerSample, unsigned long expected_bytes));
int ExitSun __PR(( int audio, unsigned long nBytesDone ));
unsigned long GetSunHdrSize __PR(( void ));


