
/* Bluefish HTML Editor
 * images.c - anything dealing with images
 *
 * Copyright (C) 1998 Olivier Sessink and Chris Mazuc
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <gtk/gtk.h>
#include <string.h>
#include <stdlib.h>
#include <gdk/gdk.h>
#include "config.h"
#include "bluefish.h"
#include "images.h"
#include "widgets.h"
#include "html.h"
#include "init.h"

#if HAVE_LIBGDK_IMLIB
#include <gdk_imlib.h>

struct Image_Win
  {

    GtkWidget *pixwin;
    GtkWidget *pixmap;
    GtkWidget *width_entry;
    GtkWidget *height_entry;
    GtkWidget *alt_entry;
    GtkWidget *bord_entry;
    GtkWidget *location_entry;
    GtkWidget *hspace_entry;
    GtkWidget *vspace_entry;
    gchar *filename;
    GtkCombo *align_combo;
    gint tnH;
    gint tnW;
    gint h;
    gint w;
    GdkPixmap *p;
    GdkPixmap *m;
    GtkAdjustment *adjustment;
    GdkImlibImage *im;
  }
Image_Win;

void image_insert_dialog (GtkWidget * widget, gpointer data);
void image_dialog (gchar * filename, gint thumb);
void destroy_image_win (GtkWidget * w, struct Image_Win *image_win);
void image_insert_dialog_ok (GtkWidget * w, GtkFileSelection * fs);
void image_thumbnail_dialog_ok (GtkWidget * w, GtkFileSelection * fs);
void insert_img_html (GtkWidget * w, struct Image_Win *win);
void insert_thumb_html (GtkWidget * w, struct Image_Win *win);
void insert_html (struct Image_Win *win, gint thumb);
void image_thumbnail_dialog (GtkWidget * widget, gpointer data);
void image_thumb_dialog (gchar * filename);
void image_img_dialog (gchar * filename);
void adjust_changed (GtkAdjustment * adj, struct Image_Win *image_win);
void w_or_h_changed (GtkAdjustment * adj, struct Image_Win *image_win);



void
image_insert_dialog (GtkWidget * widget, gpointer data)
{

  GtkWidget *filew;

  /*
   * This is the callback function for a file open button 
   */
#ifdef DEBUG
  g_print ("image_insert_dialog, started\n");
#endif
  filew = gtk_file_selection_new ("Insert image");
  gtk_grab_add (filew);
  gtk_signal_connect (GTK_OBJECT (filew), "delete_event", GTK_SIGNAL_FUNC
		      (gtk_widget_destroy), &filew);
  gtk_signal_connect (GTK_OBJECT (filew), "destroy", GTK_SIGNAL_FUNC
		      (gtk_widget_destroy), &filew);

  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (filew)->ok_button),
		      "clicked",
		      GTK_SIGNAL_FUNC (image_insert_dialog_ok), filew);
  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION
					 (filew)->cancel_button),
			     "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT (filew));
  gtk_widget_show (filew);
#ifdef DEBUG
  g_print ("image_insert_dialog, filew=%p\n", filew);
#endif
}


void
image_dialog (gchar * filename, gint thumb)
{

  struct Image_Win *image_win;

  gfloat temp, toobig;
  GtkWidget *vbox, *vbox2, *hbox, *hbox2, *table, *label, *button_ok;
  GtkWidget *frame, *button_cancel, *scale;
  gchar *tempstr;

#ifdef DEBUG
  g_print ("image_dialog, started\n");
#endif
  image_win = (struct Image_Win *) g_malloc0 (sizeof (Image_Win));

  image_win->filename = g_malloc0 (strlen (filename) + 1);
  strncat (image_win->filename, filename, strlen (filename) + 1);
  g_free (filename);

  image_win->pixwin = gtk_window_new (GTK_WINDOW_TOPLEVEL);
#ifdef DEBUG
  g_print ("image_dialog, image_win->pixwin = %p\n", image_win->pixwin);
#endif

  if (thumb == 1)
    {
      gtk_window_set_title (GTK_WINDOW (image_win->pixwin),
			    "Insert image as thumbnail");
    }
  else
    {
      gtk_window_set_title (GTK_WINDOW (image_win->pixwin),
			    "Insert image");
    }

  gtk_container_border_width (GTK_CONTAINER (image_win->pixwin), 10);
  vbox = gtk_vbox_new (FALSE, 5);
  gtk_container_add (GTK_CONTAINER (image_win->pixwin), vbox);

  frame = gtk_frame_new (image_win->filename);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 5);
  gtk_widget_show (frame);

  vbox2 = gtk_vbox_new (FALSE, 5);
  gtk_container_add (GTK_CONTAINER (frame), vbox2);
  gtk_widget_show (vbox2);
  hbox = gtk_hbox_new (FALSE, 5);
  gtk_box_pack_start (GTK_BOX (vbox2), hbox, FALSE, FALSE, 5);


  gtk_widget_push_visual (gdk_imlib_get_visual ());
  gtk_widget_push_colormap (gdk_imlib_get_colormap ());
/*
 * Load the image specified as the first argument 
 */
  image_win->im = gdk_imlib_load_image (image_win->filename);
  if (image_win->im == NULL)
    {
      dialog = gtk_dialog_new ();
      gtk_window_set_title (GTK_WINDOW (dialog), "Insert Image");
      gtk_window_position (GTK_WINDOW (dialog), GTK_WIN_POS_MOUSE);
      gtk_widget_set_usize (dialog, 250, 150);

      okbutton = gtk_button_new_with_label ("OK");
      gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area), okbutton,
			  TRUE, TRUE, 0);
      GTK_WIDGET_SET_FLAGS (okbutton, GTK_CAN_DEFAULT);
      gtk_widget_grab_default (okbutton);
      gtk_signal_connect_object (GTK_OBJECT (okbutton), "clicked",
				 GTK_SIGNAL_FUNC (gtk_widget_destroy),
				 GTK_OBJECT (dialog));
      gtk_widget_show (okbutton);

      label = gtk_label_new ("The selected file is not a valid image");
      gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), label, TRUE,
			  TRUE, 0);
      gtk_widget_show (label);
      gtk_widget_show (dialog);
    }
  else
    {
      /*
       * Suck the image's original width and height out of the Image
       * structure 
       */
      toobig = 1;
      image_win->w = image_win->im->rgb_width;
      temp = (gfloat) image_win->w / 250;
#ifdef DEBUG
      g_print ("width, temp = %f\n", temp);
#endif
      if (temp > toobig)
	{
	  toobig = temp;
	}
      image_win->h = image_win->im->rgb_height;
      temp = (gfloat) image_win->h / 200;
#ifdef DEBUG
      g_print ("height, temp = %f\n", temp);
#endif
      if (temp > toobig)
	{
	  toobig = temp;
	}
#ifdef DEBUG
      g_print ("Image size -> width = %d, height = %d. Toobig = %f\n",
	       image_win->w, image_win->h, toobig);
#endif
      if (thumb == 1)
	{
	  image_win->adjustment = GTK_ADJUSTMENT (gtk_adjustment_new (1 /
								      toobig,
								      0.001,
								      1.1,
								      0.001,
								      0.1, 0.1));
	  /*
	   * gtk_adjustment_set_value( GTK_ADJUSTMENT(adjustment),
	   * 1/toobig ); 
	   */
	  scale = gtk_hscale_new (image_win->adjustment);
	  gtk_signal_connect (GTK_OBJECT (image_win->adjustment),
			      "value_changed",
			      GTK_SIGNAL_FUNC (adjust_changed), image_win);
	  gtk_scale_set_digits (GTK_SCALE (scale), 3);
	  gtk_range_set_update_policy (GTK_RANGE (scale), GTK_UPDATE_DISCONTINUOUS);
	  gtk_box_pack_start (GTK_BOX (vbox2), scale, FALSE, FALSE, 0);
	  gtk_widget_show (scale);
	  image_win->tnW = image_win->adjustment->value * image_win->w;
	  image_win->tnH = image_win->adjustment->value * image_win->h;

	  /*
	   * Render the original 24-bit Image data into a pixmap of size 
	   * w * h 
	   */
	  gdk_imlib_render (image_win->im, image_win->tnW, image_win->tnH);

	}
      else
	{
	  /*
	   * Render the original 24-bit Image data into a pixmap of size 
	   * w * h 
	   */
	  gdk_imlib_render (image_win->im, (image_win->w / toobig),
			    (image_win->h / toobig));
	}

/*
 * Extract the Image and mask pixmaps from the Image 
 */
      image_win->p = gdk_imlib_move_image (image_win->im);
      /*
       * The mask will be NULL if the image has no transparency 
       */
      image_win->m = gdk_imlib_move_mask (image_win->im);
      image_win->pixmap = gtk_pixmap_new (image_win->p, image_win->m);
      gtk_box_pack_start (GTK_BOX (hbox), image_win->pixmap, FALSE,
			  FALSE, 5);
      gtk_widget_show (image_win->pixmap);

      table = gtk_table_new (2, 10, FALSE);
      gtk_box_pack_end (GTK_BOX (hbox), table, FALSE, FALSE, 5);

      label = gtk_label_new ("Image location");
      image_win->location_entry = gtk_entry_new ();
      if (current_document->filename == NULL)
	{
	  tempstr = g_malloc0 (strlen (image_win->filename) + 1);
	  strcpy (tempstr, image_win->filename);
	}
      else
	{
	  tempstr = strip_common_path (image_win->filename, current_document->filename);
	}
      gtk_entry_set_text (GTK_ENTRY (image_win->location_entry), tempstr);
      g_free (tempstr);
      gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 0, 1);
      gtk_table_attach_defaults (GTK_TABLE (table),
				 image_win->location_entry, 0, 2, 1, 2);
      gtk_widget_show (label);
      gtk_widget_show (image_win->location_entry);

      label = gtk_label_new ("Width");
      image_win->width_entry = gtk_entry_new ();
      tempstr = malloc (25);
      sprintf (tempstr, "%d", image_win->w);
      gtk_entry_set_text (GTK_ENTRY (image_win->width_entry), tempstr);
      free (tempstr);
      if (thumb == 1)
	{
	  gtk_signal_connect (GTK_OBJECT (image_win->width_entry),
			      "activate",
			      GTK_SIGNAL_FUNC (w_or_h_changed), image_win);
	}
      gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 2, 3);
      gtk_table_attach_defaults (GTK_TABLE (table), image_win->width_entry,
				 0, 1, 3, 4);
      gtk_widget_show (label);
      gtk_widget_show (image_win->width_entry);

      label = gtk_label_new ("Height");
      image_win->height_entry = gtk_entry_new ();
      tempstr = malloc (25);
      sprintf (tempstr, "%d", image_win->h);
      gtk_entry_set_text (GTK_ENTRY (image_win->height_entry), tempstr);
      free (tempstr);
      if (thumb == 1)
	{
	  gtk_signal_connect (GTK_OBJECT (image_win->height_entry),
			      "activate",
			      GTK_SIGNAL_FUNC (w_or_h_changed), image_win);
	}
      gtk_table_attach_defaults (GTK_TABLE (table), label, 1, 2, 2, 3);
      gtk_table_attach_defaults (GTK_TABLE (table), image_win->height_entry,
				 1, 2, 3, 4);
      gtk_widget_show (label);
      gtk_widget_show (image_win->height_entry);

      label = gtk_label_new ("Alternate text");
      image_win->alt_entry = gtk_entry_new ();

      if (thumb == 1)
	{
	  tempstr = malloc (50);
	  sprintf (tempstr, "Click thumbnail for full size");
	  gtk_entry_set_text (GTK_ENTRY (image_win->alt_entry), tempstr);
	  free (tempstr);
	}
      gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 4, 5);
      gtk_table_attach_defaults (GTK_TABLE (table), image_win->alt_entry, 0,
				 2, 5, 6);
      gtk_widget_show (label);
      gtk_widget_show (image_win->alt_entry);

      label = gtk_label_new ("Border");
      image_win->bord_entry = gtk_entry_new ();
      tempstr = malloc (25);
      sprintf (tempstr, "0");
      gtk_entry_set_text (GTK_ENTRY (image_win->bord_entry), tempstr);
      free (tempstr);
      gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 6, 7);
      gtk_table_attach_defaults (GTK_TABLE (table), image_win->bord_entry,
				 0, 1, 7, 8);
      gtk_widget_show (label);
      gtk_widget_show (image_win->bord_entry);

      label = gtk_label_new ("Align");
      image_win->align_combo = GTK_COMBO (gtk_combo_new ());
      gtk_combo_set_popdown_strings (image_win->align_combo, positionlist);
      gtk_entry_set_text(GTK_ENTRY(image_win->align_combo), "");
      gtk_table_attach_defaults (GTK_TABLE (table), label, 1, 2, 6, 7);
      gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET
				 (image_win->align_combo), 1, 2, 7, 8);
      gtk_widget_show (label);
      gtk_widget_show (GTK_WIDGET (image_win->align_combo));

      label = gtk_label_new ("Hspace");
      image_win->hspace_entry = gtk_entry_new ();
      gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 8, 9);
      gtk_table_attach_defaults (GTK_TABLE (table), image_win->hspace_entry,
				 0, 1, 9, 10);
      gtk_widget_show (label);
      gtk_widget_show (image_win->hspace_entry);

      label = gtk_label_new ("Vspace");
      image_win->vspace_entry = gtk_entry_new ();
      gtk_table_attach_defaults (GTK_TABLE (table), label, 1, 2, 8, 9);
      gtk_table_attach_defaults (GTK_TABLE (table), image_win->vspace_entry,
				 1, 2, 9, 10);
      gtk_widget_show (label);
      gtk_widget_show (image_win->vspace_entry);

      hbox2 = gtk_hbox_new (TRUE, 5);
      gtk_box_pack_end (GTK_BOX (vbox), hbox2, FALSE, FALSE, 5);

      button_cancel = gtk_button_new_with_label ("Cancel");
      button_ok = gtk_button_new_with_label ("Ok");
      if (thumb == 1)
	{
	  gtk_signal_connect (GTK_OBJECT (button_ok), "clicked",
			      GTK_SIGNAL_FUNC (insert_thumb_html),
			      (gpointer) image_win);
	}
      else
	{
	  gtk_signal_connect (GTK_OBJECT (button_ok), "clicked",
			      GTK_SIGNAL_FUNC (insert_img_html),
			      (gpointer) image_win);
	}
      gtk_signal_connect (GTK_OBJECT (button_cancel), "clicked",
			  GTK_SIGNAL_FUNC (destroy_image_win),
			  (gpointer) image_win);
      GTK_WIDGET_SET_FLAGS (button_cancel, GTK_CAN_DEFAULT);
      GTK_WIDGET_SET_FLAGS (button_ok, GTK_CAN_DEFAULT);
      gtk_box_pack_end (GTK_BOX (hbox2), button_cancel, FALSE, TRUE, 0);
      gtk_box_pack_end (GTK_BOX (hbox2), button_ok, FALSE, TRUE, 0);
      gtk_widget_show (button_ok);
      gtk_widget_show (button_cancel);
#ifdef DEBUG
      g_print ("image_dialog, buttons ready\n");
#endif
      gtk_widget_show (hbox);
      gtk_widget_show (hbox2);
      gtk_widget_show (vbox);
      gtk_widget_show (table);
      gtk_widget_show (image_win->pixwin);
      gtk_window_set_default(GTK_WINDOW(image_win->pixwin), button_ok);
#ifdef DEBUG
      g_print ("image_dialog, end\n");
#endif
    }
}

void
destroy_image_win (GtkWidget * w, struct Image_Win *image_win)
{
#ifdef DEBUG
  g_print ("destroy_image_win, started on image_win->pixwin = %p\n", image_win->pixwin);
#endif
  gtk_signal_handlers_destroy (GTK_OBJECT (image_win->pixwin));
#ifdef DEBUG
  g_print ("destroy_image_win, signal handlers destroyed\n");
#endif
  gtk_widget_destroy (GTK_WIDGET (image_win->pixwin));
#ifdef DEBUG
  g_print ("destroy_image_win, pixwin destroyed\n");
#endif

/*
 * probably not complete, watch memory leaks here! 
 */

  gdk_imlib_destroy_image (image_win->im);
#ifdef DEBUG
  g_print ("destroy_image_win, gdk_image destroyed\n");
#endif
  g_free (image_win);
#ifdef DEBUG
  g_print ("destroy_image_win, image_win free-ed\n");
#endif
}

void
image_insert_dialog_ok (GtkWidget * w, GtkFileSelection * fs)
{
  gchar *filename;
  /*
   * This is the callback function for a file_selection for file_open 
   */
  filename = g_malloc0 (256);
  strncpy (filename, gtk_file_selection_get_filename (GTK_FILE_SELECTION
						      (fs)), 255);
#ifdef DEBUG
  g_print ("image_insert_dialog_ok, filename=%s, fs=%p\n", filename, fs);
#endif
  gtk_grab_remove (GTK_WIDGET (fs));
  gtk_widget_destroy (GTK_WIDGET (fs));
  change_dir (filename);
#ifdef DEBUG
  g_print ("image_insert_dialog_ok, filename=%s\n", filename);
#endif
  image_dialog (filename, 0);
}

void
image_thumbnail_dialog_ok (GtkWidget * w, GtkFileSelection * fs)
{
  gchar *filename;
  /*
   * This is the callback function for a file_selection for file_open 
   */
  filename = g_malloc0 (256);
  strncpy (filename, gtk_file_selection_get_filename (GTK_FILE_SELECTION
						      (fs)), 255);
  gtk_grab_remove (GTK_WIDGET (fs));
  gtk_widget_destroy (GTK_WIDGET (fs));
  image_dialog (filename, 1);
}

void
insert_img_html (GtkWidget * w, struct Image_Win *win)
{
  insert_html (win, 0);
}

void
insert_thumb_html (GtkWidget * w, struct Image_Win *win)
{
  insert_html (win, 1);
}


void
insert_html (struct Image_Win *win, gint thumb)
{
  gchar *final_string, *tempstring, *fn_to_insert;
  gchar *tnfilename = "";
  GdkImlibImage *tmp_image;

#ifdef DEBUG
  g_print ("insert_html, started\n");
#endif
  if (thumb == 1)
    {
#ifdef DEBUG
      g_print ("insert_thumbnail_html, filename = %s\n", win->filename);
#endif
      tnfilename = g_malloc (strlen (win->filename) + 8);
      bzero (tnfilename, strlen (win->filename) + 8);
      strncpy (tnfilename, win->filename, strlen (win->filename) - 4);
      strcat (tnfilename, "\0");
#ifdef DEBUG
      g_print ("insert_thumbnail_html, halfway, tnfilename = %s\n", tnfilename);
#endif
      strcat (tnfilename, "thumbnail.jpg");
#ifdef DEBUG
      g_print ("insert_thumbnail_html, final, tnfilename = %s\n", tnfilename);
#endif

      win->tnW = atoi (gtk_entry_get_text (GTK_ENTRY (win->width_entry)));
      win->tnH = atoi (gtk_entry_get_text (GTK_ENTRY (win->height_entry)));

      tmp_image = gdk_imlib_clone_scaled_image (win->im, win->tnW, win->tnH);
      gdk_imlib_save_image (tmp_image, tnfilename, NULL);
      gdk_imlib_destroy_image (tmp_image);
    }
#ifdef DEBUG
  g_print ("insert_html, thumbnail_stuff_done\n");
#endif
  tempstring = g_malloc (1024);
  final_string = g_malloc (4000);
  if (current_document->filename == NULL)
    {
      fn_to_insert = g_malloc0 (strlen (win->filename) + 1);
      strcpy (fn_to_insert, win->filename);
    }
  else
    {
      fn_to_insert = strip_common_path (win->filename, current_document->filename);
    }
  if (thumb == 1)
    {
      sprintf (final_string, "<a href=\"%s\">", fn_to_insert);
      g_free (fn_to_insert);
      if (!(current_document->filename == NULL))
	{
	  fn_to_insert = strip_common_path (tnfilename, current_document->filename);
	}
      else
	{
	  fn_to_insert = tnfilename;
	}
    }
  else
    {
      sprintf (final_string, "%s", "");
    }
  sprintf (tempstring, "<img src=\"%s\" ", fn_to_insert);
  g_free (fn_to_insert);
  strncat (final_string, tempstring, 1023);
  if (strlen (gtk_entry_get_text (GTK_ENTRY (win->width_entry))))
    {
      strcat (strncat (strcat (final_string, " width=\""),
		       gtk_entry_get_text (GTK_ENTRY (win->width_entry)), 7),
	      "\"");
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (win->height_entry))))
    {
      strcat (strncat (strcat (final_string, " height=\""),
		       gtk_entry_get_text (GTK_ENTRY (win->height_entry)), 7),
	      "\"");
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (win->alt_entry))))
    {
      strcat (strncat (strcat (final_string, " alt=\""),
		       gtk_entry_get_text (GTK_ENTRY (win->alt_entry)), 1023),
	      "\"");
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (win->bord_entry))))
    {
      strcat (strncat (strcat (final_string, " border=\""),
		       gtk_entry_get_text (GTK_ENTRY (win->bord_entry)), 7),
	      "\"");
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (win->vspace_entry))))
    {
      strcat (strncat (strcat (final_string, " vspace=\""),
		       gtk_entry_get_text (GTK_ENTRY (win->vspace_entry)), 7),
	      "\"");
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (win->hspace_entry))))
    {
      strcat (strncat (strcat (final_string, " hspace=\""),
		       gtk_entry_get_text (GTK_ENTRY (win->hspace_entry)), 7),
	      "\"");
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (win->align_combo->entry))))
    {
      strcat (strncat (strcat (final_string, " align=\""),
		       gtk_entry_get_text (GTK_ENTRY
					   (win->align_combo->entry)), 25),
	      "\"");
    }
  if (thumb == 1)
    {
      sprintf (tempstring, "></a>");
    }
  else
    {
      sprintf (tempstring, ">");
    }
  strncat (final_string, tempstring, 10);
#ifdef DEBUG
  g_print ("insert_html, ready to insert HTML in textbox\n");
#endif
  insert_text (final_string, "");
#ifdef DEBUG
  g_print ("insert_html, HTML inserted in textbox\n");
#endif
  g_free (tempstring);
  g_free (final_string);
  gtk_widget_grab_focus (GTK_WIDGET ((GtkText *) current_document->textbox));
  current_document->modified = TRUE;
  gtk_text_thaw (GTK_TEXT (current_document->textbox));
#ifdef DEBUG
  g_print ("insert_html, nearly ready\n");
#endif
  destroy_image_win (win->pixwin, win);
#ifdef DEBUG
  g_print ("insert_html, ended\n");
#endif
}

void
image_thumbnail_dialog (GtkWidget * widget, gpointer data)
{

  GtkWidget *filew;

  /*
   * This is the callback function for a file open button 
   */
  filew = gtk_file_selection_new ("Insert image as thumbnail");
  gtk_grab_add (filew);
  gtk_signal_connect (GTK_OBJECT (filew), "delete_event", GTK_SIGNAL_FUNC
		      (gtk_widget_destroy), &filew);
  gtk_signal_connect (GTK_OBJECT (filew), "destroy", GTK_SIGNAL_FUNC
		      (gtk_widget_destroy), &filew);

  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (filew)->ok_button),
		      "clicked", GTK_SIGNAL_FUNC
		      (image_thumbnail_dialog_ok), filew);
  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION
					 (filew)->cancel_button),
			     "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT (filew));
  gtk_widget_show (filew);


}

void
image_thumb_dialog (gchar * filename)
{

  image_dialog (filename, 1);

}


void
image_img_dialog (gchar * filename)
{

  image_dialog (filename, 0);

}


void
adjust_changed (GtkAdjustment * adj, struct Image_Win *image_win)
{
  gchar *tempstr;

  image_win->tnW = image_win->adjustment->value * image_win->w;
  tempstr = malloc (25);
  sprintf (tempstr, "%d", image_win->tnW);
  gtk_entry_set_text (GTK_ENTRY (image_win->width_entry), tempstr);

  image_win->tnH = image_win->adjustment->value * image_win->h;
  sprintf (tempstr, "%d", image_win->tnH);
  gtk_entry_set_text (GTK_ENTRY (image_win->height_entry), tempstr);
  free (tempstr);
  gdk_imlib_render (image_win->im, image_win->tnW, image_win->tnH);
/*
 * Extract the Image and mask pixmaps from the Image 
 */
  image_win->p = gdk_imlib_move_image (image_win->im);
  /*
   * The mask will be NULL if the image has no transparency 
   */
  image_win->m = gdk_imlib_move_mask (image_win->im);
  gtk_pixmap_set (GTK_PIXMAP (image_win->pixmap), image_win->p, image_win->m);
  gtk_widget_show (image_win->pixmap);
}

void
w_or_h_changed (GtkAdjustment * adj, struct Image_Win *image_win)
{
#ifdef DEBUG
  g_print ("w_or_h_changed, started");
#endif
  image_win->tnW = atoi (gtk_entry_get_text (GTK_ENTRY (image_win->width_entry)));
  image_win->tnH = atoi (gtk_entry_get_text (GTK_ENTRY (image_win->height_entry)));

  gdk_imlib_render (image_win->im, image_win->tnW, image_win->tnH);
/*
 * Extract the Image and mask pixmaps from the Image 
 */
  image_win->p = gdk_imlib_move_image (image_win->im);
  /*
   * The mask will be NULL if the image has no transparency 
   */
  image_win->m = gdk_imlib_move_mask (image_win->im);
  gtk_pixmap_set (GTK_PIXMAP (image_win->pixmap), image_win->p, image_win->m);
  gtk_widget_show (image_win->pixmap);
#ifdef DEBUG
  g_print ("w_or_h_changed, end");
#endif
}


#else
/*
 * touch these and I will kill you Olivier 
 * <evil laugh> 
 */

void
image_insert_dialog (GtkWidget * widget, gpointer data)
{
  GtkWidget *dialog, *vbox, *label, *button;

  dialog = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_signal_connect (GTK_OBJECT (dialog), "delete_event", GTK_SIGNAL_FUNC
		      (gtk_widget_destroy), (GtkWidget *) dialog);
  gtk_signal_connect (GTK_OBJECT (dialog), "destroy", GTK_SIGNAL_FUNC
		      (gtk_widget_destroy), (GtkWidget *) dialog);
  gtk_widget_set_usize (GTK_WIDGET (dialog), 300, 53);
  gtk_window_set_title (GTK_WINDOW (dialog), "hmmmmmm....");
  gtk_window_position (GTK_WINDOW (dialog), GTK_WIN_POS_CENTER);
  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (dialog), vbox);
  gtk_widget_show (vbox);
  label = gtk_label_new
    ("This version of Bluefish was not\ncompiled with imlib support. sorry.");
  gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, FALSE, 0);
  gtk_widget_show (label);
  button = gtk_button_new_with_label ("OK");
  gtk_signal_connect_object (GTK_OBJECT (button), "clicked", GTK_SIGNAL_FUNC
			     (gtk_object_destroy), (GtkObject *) dialog);
  gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 0);
  gtk_widget_show (button);
  gtk_widget_show (dialog);
}


void
image_thumbnail_dialog (GtkWidget * widget, gpointer data)
{
  GtkWidget *dialog, *vbox, *label, *button;

  dialog = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_signal_connect (GTK_OBJECT (dialog), "delete_event", GTK_SIGNAL_FUNC
		      (gtk_widget_destroy), (GtkWidget *) dialog);
  gtk_signal_connect (GTK_OBJECT (dialog), "destroy", GTK_SIGNAL_FUNC
		      (gtk_widget_destroy), (GtkWidget *) dialog);
  gtk_widget_set_usize (GTK_WIDGET (dialog), 300, 53);
  gtk_window_set_title (GTK_WINDOW (dialog), "hmmmmmm....");
  gtk_window_position (GTK_WINDOW (dialog), GTK_WIN_POS_CENTER);
  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (dialog), vbox);
  gtk_widget_show (vbox);
  label = gtk_label_new
    ("This version of Bluefish was not\ncompiled with imlib support. sorry.");
  gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, FALSE, 0);
  gtk_widget_show (label);
  button = gtk_button_new_with_label ("OK");
  gtk_signal_connect_object (GTK_OBJECT (button), "clicked", GTK_SIGNAL_FUNC
			     (gtk_object_destroy), (GtkObject *) dialog);
  gtk_box_pack_start (GTK_BOX (vbox), button, FALSE, FALSE, 0);
  gtk_widget_show (button);
  gtk_widget_show (dialog);
}

#endif
