
/* Bluefish HTML Editor
 * toolbars.c - the home of the many toolbars
 *
 * Copyright (C) 1998 Olivier Sessink and Chris Mazuc
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <string.h>
#include <sys/types.h>
#include <dirent.h>
#include "bluefish.h"
#include "pixmaps.h"
#include "toolbars.h"
#include "callbacks.h"
#include "html.h"
#include "interface.h"
#include "images.h"
#include "wizards.h"
#include "init.h"
#include "ref_dialog.h"
#include "configure.h"
#include "undo.h"
#include "snr.h"
#include "menu.h"

struct cust_main_menu_struct
  {
    gchar *name;
    GList *entry_list;
    GtkWidget *item;
    GtkWidget *subtree;
  }
cust_main_menu_struct;

struct cust_menu_struct
  {
    gchar *name;
    gchar *bef_html;
    gchar *aft_html;
    GtkWidget *item;
    GtkWidget *subtree;
    struct cust_main_menu_struct *main_entry;
  }
cust_menu_struct;

/* 
 * these widgets are NULL if the bars are not initialised yet,
 * they're !NULL after initialisation 
 */
GtkWidget *main_widget = NULL, *cust_widget = NULL, *html_widget = NULL;


GList *entry_list_list;
GtkWidget *entry1, *entry2, *entry3, *entry4;
struct cust_menu_struct *last_entry = NULL;
struct cust_main_menu_struct *last_main_entry = NULL;

void setup_toggle_item (GtkItemFactory * ifactory, gchar * path, gint state);
void remake_cust_menubar (void);
void make_cust_menubar (void);
static void item_response (struct cust_menu_struct *entry);
GList *parse_cust_menu_file (char *filename);
void save_cust_menu (void);
void flush_toolbar (GtkWidget * html_label, GtkWidget * html_toolbar);
void make_main_toolbar (void);
void make_html_toolbar (void);

void edit_custom_menu (GtkWidget * w, gpointer data);
void entry_new (GtkWidget * w, gpointer * tree);
void entry_update (GtkWidget * w, gpointer * tree);
void entry_del (GtkWidget * w, gpointer * tree);
void main_entry_new (GtkWidget * w, gpointer * tree);
void main_entry_update (GtkWidget * w, gpointer * tree);
void main_entry_del (GtkWidget * w, gpointer * tree);
void entry_save (GtkWidget * w, gpointer * window);

void main_entry_selected (GtkWidget * item, struct cust_main_menu_struct *main_entry);
void entry_selected (GtkWidget * item, struct cust_menu_struct *entry);


/* 
 * menu factory crap, thanks to the gtk tutorial for this
 * both the 1.0 and the 1.2 code is directly from the tutorial
 */
void
get_main_menu (GtkWidget * window, GtkWidget ** menubar)
{
  GtkItemFactory *item_factory;
  GtkAccelGroup *accel_group;
  gint nmenu_items = sizeof (menu_items) / sizeof (menu_items[0]);
  accel_group = gtk_accel_group_new ();
  item_factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>",
				       accel_group);
  gtk_item_factory_create_items (item_factory, nmenu_items, menu_items, NULL);
  gtk_accel_group_attach (accel_group, GTK_OBJECT (window));
  if (menubar)
    /* Finally, return the actual menu bar created by the item factory. */
    *menubar = gtk_item_factory_get_widget (item_factory, "<main>");
  setup_toggle_item (item_factory, "/View/Main toolbar", v_main_tb);
  setup_toggle_item (item_factory, "/View/HTML toolbar", v_html_tb);
  setup_toggle_item (item_factory, "/View/Custom toolbar", v_custom_tb);
}


/* this function gets the widget for the togglebutton, and checks the state
it is in, if not correct --> set the state */
void
setup_toggle_item (GtkItemFactory * ifactory, gchar * path, gint state)
{

  GtkWidget *toggle;

  toggle = gtk_item_factory_get_widget (ifactory, path);

  if ((GTK_CHECK_MENU_ITEM (toggle)->active) && state == 0)
    {
      GTK_CHECK_MENU_ITEM (toggle)->active = state;
      return;
    }
  if ((!GTK_CHECK_MENU_ITEM (toggle)->active) && state == 1)
    {
      GTK_CHECK_MENU_ITEM (toggle)->active = state;
      return;
    }
}





void
toggle_html_toolbar (GtkWidget * w, gpointer data)
{
  if (GTK_WIDGET_VISIBLE (html_handle_box))
    {
      hide_html_toolbar (NULL, NULL);
    }
  else
    {
      show_html_toolbar (NULL, NULL);
    }
}

void
toggle_main_toolbar (GtkWidget * w, gpointer data)
{
  if (GTK_WIDGET_VISIBLE (handle_box))
    {
      hide_main_toolbar (NULL, NULL);
    }
  else
    {
      show_main_toolbar (NULL, NULL);
    }
}

void
toggle_cust_menubar (GtkWidget * w, gpointer data)
{
  if (GTK_WIDGET_VISIBLE (cust_handle_box))
    {
      hide_cust_menubar (NULL, NULL);
    }
  else
    {
      show_cust_menubar (NULL, NULL);
    }
}

void
hide_main_toolbar (GtkWidget * w, gpointer data)
{
  gtk_widget_hide (handle_box);
}

void
hide_html_toolbar (GtkWidget * w, gpointer data)
{
  gtk_widget_hide (html_handle_box);
}

void
hide_cust_menubar (GtkWidget * w, gpointer data)
{
  gtk_widget_hide (cust_handle_box);
}

void
show_main_toolbar (GtkWidget * w, gpointer data)
{
  if (!main_widget)
    {
      make_main_toolbar ();
    }
  gtk_widget_show (handle_box);
}

void
show_html_toolbar (GtkWidget * w, gpointer data)
{
  if (!html_widget)
    {
      make_html_toolbar ();
    }
  gtk_widget_show (html_handle_box);
}


void
show_cust_menubar (GtkWidget * w, gpointer data)
{
  if (!cust_widget)
    {
      make_cust_menubar ();
    }
  gtk_widget_show (cust_handle_box);
}

void
remake_cust_menubar (void)
{
  int count, count2;
  struct cust_main_menu_struct *main_entry;
  struct cust_menu_struct *entry;

  count = g_list_length (entry_list_list) - 1;
#ifdef DEBUG
  g_print ("remake_cust_menubar, count = %d\n", count);
#endif
  while (count > 0)
    {
      main_entry = g_list_nth_data (entry_list_list, count);
      count2 = g_list_length (main_entry->entry_list) - 1;
      while (count2 > 0)
	{
	  entry = g_list_nth_data (main_entry->entry_list, count2);
#ifdef DEBUG
	  g_print ("remake_cust_menubar, pos1, count=%d\n", count);
#endif
	  g_free (entry->name);
	  g_free (entry->bef_html);
	  g_free (entry->aft_html);
#ifdef DEBUG
	  g_print ("remake_cust_menubar, pos2\n");
#endif
	  main_entry->entry_list =
	    g_list_remove (main_entry->entry_list, entry);
	  g_free (entry);
#ifdef DEBUG
	  g_print ("remake_cust_menubar, pos3\n");
#endif
	  count2--;
	}
      entry_list_list = g_list_remove (entry_list_list, main_entry);
      g_list_free (main_entry->entry_list);
      g_free (main_entry->name);
      g_free (main_entry);
#ifdef DEBUG
      g_print ("remake_cust_menubar, entry_list_list lenght = %d\n",
	       g_list_length (entry_list_list));
#endif
      count--;
    }
  g_list_free (entry_list_list);
  gtk_widget_destroy (cust_widget);
  make_cust_menubar ();
#ifdef DEBUG
  g_print ("remake_cust_menubar, finished\n");
#endif
}

void
make_cust_menubar (void)
{
  GtkWidget *menu, *item;
  int count;
  struct cust_menu_struct *entry;
  struct cust_main_menu_struct *main_entry;
  gchar dirname[256];
  gchar *tmpstring;
  DIR *dp;
  struct dirent *ep;

#ifdef DEBUG
  g_print ("make_cust_menubar, begin\n");
#endif
  entry_list_list = g_list_alloc ();
  cust_widget = gtk_menu_bar_new ();
  gtk_container_add (GTK_CONTAINER (cust_handle_box), cust_widget);
  gtk_widget_show (cust_widget);

  menu = gtk_menu_new ();
  item = gtk_menu_item_new_with_label ("edit");
  gtk_menu_append (GTK_MENU (menu), item);
  gtk_signal_connect_object (GTK_OBJECT (item), "activate",
			     GTK_SIGNAL_FUNC (edit_custom_menu), NULL);
  gtk_widget_show (item);
  item = gtk_menu_item_new_with_label ("Edit menu");
  gtk_widget_show (item);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (item), menu);
  gtk_menu_bar_append (GTK_MENU_BAR (cust_widget), item);

  strncat (strcpy (dirname, getenv ("HOME")), "/.bluefish/menu", 255);
  dp = opendir (dirname);
  if (dp != NULL)
    {
      while ((ep = readdir (dp)))
	{
#ifdef DEBUG
	  g_print ("make_cust_menubar, filename=%s\n", ep->d_name);
#endif
	  if ((strcmp (ep->d_name, "..") == 0) || (strcmp (ep->d_name,
							   ".") == 0))
	    {
#ifdef DEBUG
	      g_print ("make_cust_menubar, %s is no usable file\n", ep->d_name);
#endif
	    }
	  else
	    {
	      main_entry = (struct cust_main_menu_struct *)
		g_malloc0 (sizeof (cust_main_menu_struct));
	      menu = gtk_menu_new ();
	      /* we don't need to show the menu */
	      tmpstring = g_malloc0 (270);
	      main_entry->entry_list =
		parse_cust_menu_file (strcat (strcat (strcat (tmpstring,
							      dirname),
						      "/"), ep->d_name));
	      entry_list_list = g_list_append (entry_list_list, main_entry);
	      count = g_list_length (main_entry->entry_list) - 1;
#ifdef DEBUG
	      if (main_entry->entry_list == NULL)
		g_print ("make_cust_menubar, entry_list is NULL!!\n");
	      g_print ("make_cust_menubar, count=%d\n", count);
#endif
	      while (count > 0)
		{
#ifdef DEBUG
		  g_print ("make_cust_menubar, adding an entry, count=%d\n", count);
#endif
		  entry = g_list_nth_data (main_entry->entry_list, count);
#ifdef DEBUG
		  if (entry == NULL)
		    g_print ("make_cust_menubar, entry %d is NULL!!\n", count);
		  g_print ("make_cust_menubar, entry->name = %s\n", entry->name);
#endif
		  item = gtk_menu_item_new_with_label (entry->name);
		  gtk_menu_append (GTK_MENU (menu), item);
		  gtk_signal_connect_object (GTK_OBJECT (item),
					     "activate",
					     GTK_SIGNAL_FUNC (item_response),
					     (gpointer) entry);
		  gtk_widget_show (item);
#ifdef DEBUG
		  g_print ("make_cust_menubar, entry done\n");
#endif
		  count--;
		}
	      strcpy (tmpstring, strip_filename (ep->d_name));
	      main_entry->name = g_malloc (strlen (tmpstring + 1));
	      strcpy (main_entry->name, tmpstring);
	      item = gtk_menu_item_new_with_label (tmpstring);
	      g_free (tmpstring);
	      gtk_widget_show (item);
	      gtk_menu_item_set_submenu (GTK_MENU_ITEM (item), menu);
	      gtk_menu_bar_append (GTK_MENU_BAR (cust_widget), item);
	    }
	}
      closedir (dp);
    }
  else
    {
#ifdef DEBUG
      g_print ("make_cust_menubar, couldn't open the directory %s\n", dirname);
#endif
      return;
    }
#ifdef DEBUG
  g_print ("make_cust_menubar, finished\n");
#endif
}

static void
item_response (struct cust_menu_struct *entry)
{
#ifdef DEBUG
  g_print ("item_response, entry->bef_html=%s, entry->aft_html=%s \n",
	   entry->bef_html, entry->aft_html);
#endif
  insert_text (entry->bef_html, entry->aft_html);
}

GList *
parse_cust_menu_file (char *filename)
{

  GList *return_list;
  FILE *fd;
  gchar *tmpbuf, *tmpbuf2;
  struct cust_menu_struct *item_set;


  fd = fopen (filename, "r");
  if (fd == NULL)
    {
#ifdef DEBUG
      g_print ("parse_cust_menu_file, cannot open file %s\n", filename);
#endif
    }
  return_list = g_list_alloc ();
  tmpbuf = g_malloc0 (2045);
#ifdef DEBUG
  g_print ("parse_cust_menu_file, list lenght at start = %d\n",
	   g_list_length (return_list));
#endif
  while (fgets (tmpbuf, 2044, fd) != NULL)
    {
      item_set = (struct cust_menu_struct *) g_malloc0 (sizeof (cust_menu_struct));
      tmpbuf2 = strrchr (tmpbuf, '\n');
      strcpy (tmpbuf2, "\0");
      tmpbuf2 = strrchr (tmpbuf, ':');
      item_set->aft_html = g_malloc0 (strlen (tmpbuf2) + 1);
#ifdef DEBUG
      g_print ("parse_cust_menu_file, tmpbuf2 = %s\n", tmpbuf2);
#endif
      strcpy (item_set->aft_html, tmpbuf2 + 1);
      strcpy (tmpbuf2, "\0");
      tmpbuf2 = strrchr (tmpbuf, ':');
      item_set->bef_html = g_malloc0 (strlen (tmpbuf2) + 1);
#ifdef DEBUG
      g_print ("parse_cust_menu_file, tmpbuf2 = %s\n", tmpbuf2);
#endif
      strcpy (item_set->bef_html, tmpbuf2 + 1);
      strcpy (tmpbuf2, "\0");
      item_set->name = g_malloc0 (strlen (tmpbuf) + 1);
#ifdef DEBUG
      g_print ("parse_cust_menu_file, tmpbuf = %s\n", tmpbuf);
#endif
      strcpy (item_set->name, tmpbuf);
      return_list = g_list_append (return_list, item_set);
#ifdef DEBUG
      if (item_set == NULL)
	g_print ("parse_cust_menu_file, item_set is NULL !!\n");
      g_print
	("parse_cust_menu_file, item_set->name = %s, item_set->bef_html = %s, item_set->aft_html = %s\n",
	 item_set->name, item_set->bef_html, item_set->aft_html);
      g_print ("parse_cust_menu_file, list lenght is now = %d\n",
	       g_list_length (return_list));
#endif
    }
  g_free (tmpbuf);
  return return_list;
}

void
save_cust_menu (void)
{
  gchar *filename, *tmpstring;
  gint count, count2;
  FILE *fd;
  struct cust_main_menu_struct *main_entry;
  struct cust_menu_struct *entry;

#ifdef DEBUG
  g_print ("save_cust_menu, started\n");
#endif
  count = g_list_length (entry_list_list) - 1;
#ifdef DEBUG
  g_print ("save_cust_menu, %d entries in entry_list_list\n",
	   g_list_length (entry_list_list) - 1);
#endif
  filename = g_malloc (2044);
  tmpstring = g_malloc (2044);
  while (count > 0)
    {
      main_entry = g_list_nth_data (entry_list_list, count);
      strcat (strncat (strcpy (filename, getenv ("HOME")),
		       "/.bluefish/menu/", 255), main_entry->name);
      fd = fopen (filename, "w");
      if (fd == NULL)
	{
#ifdef DEBUG
	  g_print ("save_cust_menu, cannot open file %s\n", filename);
#endif
	  return;
	}
#ifdef DEBUG
      g_print ("save_cust_menu, filename=%s\n", filename);
      g_print ("save_cust_menu, fd=%p\n", fd);
      g_print ("save_cust_menu, list lenght in main_entry %s = %d\n",
	       filename, g_list_length (main_entry->entry_list));
#endif
      count2 = (g_list_length (main_entry->entry_list) - 1);
      while (count2 > 0)
	{
	  entry = g_list_nth_data (main_entry->entry_list, count2);
	  sprintf (tmpstring, "%s:%s:%s\n", entry->name,
		   entry->bef_html, entry->aft_html);
	  fputs (tmpstring, fd);
#ifdef DEBUG
	  g_print ("save_cust_menu, entry %d, wrote %s", count2, tmpstring);
#endif
	  count2--;
	}
      fclose (fd);
      count--;
    }
  g_free (filename);
  g_free (tmpstring);
#ifdef DEBUG
  g_print ("save_cust_menu, finished\n");
#endif
}

void
make_main_toolbar (void)
{

#ifdef DEBUG
  g_print ("make_main_toolbar, started\n");
#endif
  main_widget = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_BOTH);
  gtk_container_add (GTK_CONTAINER (handle_box), main_widget);
  gtk_toolbar_append_item (GTK_TOOLBAR (main_widget), NULL, "New", "",
			   new_pixmap (000, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (file_new), NULL);
  gtk_toolbar_append_item (GTK_TOOLBAR (main_widget), NULL, "Open", "",
			   new_pixmap (001, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (file_open), NULL);
  gtk_toolbar_append_item (GTK_TOOLBAR (main_widget), NULL, "Save", "",
			   new_pixmap (002, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (file_save), NULL);
  gtk_toolbar_append_item (GTK_TOOLBAR (main_widget), NULL, "Save As", "",
			   new_pixmap (003, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (file_save_as), NULL);
  gtk_toolbar_append_item (GTK_TOOLBAR (main_widget), NULL, "Close", "",
			   new_pixmap (004, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (file_close), NULL);
  gtk_toolbar_append_space (GTK_TOOLBAR (main_widget));
  gtk_toolbar_append_item (GTK_TOOLBAR (main_widget), NULL, "Copy", "",
			   new_pixmap (005, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (copy_callback), NULL);
  gtk_toolbar_append_item (GTK_TOOLBAR (main_widget), NULL, "Cut", "",
			   new_pixmap (006, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (cut_callback), NULL);
  gtk_toolbar_append_item (GTK_TOOLBAR (main_widget), NULL, "Paste", "",
			   new_pixmap (007, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (paste_callback), NULL);
  gtk_toolbar_append_item (GTK_TOOLBAR (main_widget), NULL, "Search", "",
			   new_pixmap (010, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (search_search_cmd_callback), NULL);
  gtk_toolbar_append_item (GTK_TOOLBAR (main_widget), NULL,
			   "Search and Replace", "", new_pixmap (011,
								 main_window->window,
								 NULL),
			   GTK_SIGNAL_FUNC (search_replace_cmd_callback), NULL);
  gtk_toolbar_append_space (GTK_TOOLBAR (main_widget));
  gtk_toolbar_append_item (GTK_TOOLBAR (main_widget), NULL, "Undo", "",
			   new_pixmap (012, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (undo_cb), NULL);
  gtk_toolbar_append_item (GTK_TOOLBAR (main_widget), NULL, "Redo", "",
			   new_pixmap (013, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (redo_cb), NULL);
  gtk_toolbar_append_space (GTK_TOOLBAR (main_widget));
  gtk_toolbar_append_item (GTK_TOOLBAR (main_widget), NULL, "Configure", "",
			   new_pixmap (014, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (configure), NULL);
  gtk_toolbar_append_item (GTK_TOOLBAR (main_widget), NULL, "Print", "",
			   new_pixmap (015, main_window->window, NULL),
			   NULL, NULL);
  gtk_toolbar_append_item (GTK_TOOLBAR (main_widget), NULL, "Spellcheck", "",
			   new_pixmap (016, main_window->window, NULL),
			   NULL, NULL);
  gtk_widget_show (main_widget);
#ifdef DEBUG
  g_print ("make_main_widget, end\n");
#endif
}

void
make_html_toolbar (void)
{

/*
 * every item with a ... in the tooltip brings up a dialog, every item
 * without the ... in the tooltip will directly insert html code
 *
 */

  GtkWidget *html_toolbar, *html_label;

#ifdef DEBUG
  g_print ("make_html_toolbar, started\n");
#endif
  html_widget = gtk_notebook_new ();
  gtk_notebook_set_tab_pos (GTK_NOTEBOOK (html_widget), GTK_POS_TOP);
  gtk_notebook_set_show_tabs (GTK_NOTEBOOK (html_widget), TRUE);
  gtk_notebook_set_show_border (GTK_NOTEBOOK (html_widget), TRUE);
  gtk_notebook_set_page (GTK_NOTEBOOK (html_widget), 0);
  gtk_container_add (GTK_CONTAINER (html_handle_box), html_widget);

  html_toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_BOTH);
  html_label = gtk_label_new (" Quick Bar ");
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "QuickStart...",
			   "", new_pixmap (100, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (quickstart), NULL);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Body...", "",
			   new_pixmap (101, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (body), NULL);
  gtk_toolbar_append_space (GTK_TOOLBAR (html_toolbar));
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Bold", "",
			   new_pixmap (102, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (general_html), (gpointer *) 1);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Italic", "",
			   new_pixmap (103, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (general_html), (gpointer *) 2);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Underline",
			   "", new_pixmap (104, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (general_html), (gpointer *) 3);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Strikeout",
			   "", new_pixmap (105, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (general_html), (gpointer *) 4);
  gtk_toolbar_append_space (GTK_TOOLBAR (html_toolbar));
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Paragraph",
			   "", new_pixmap (106, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (general_html), (gpointer *) 5);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Break", "",
			   new_pixmap (107, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (general_html), (gpointer *) 6);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL,
			   "Non-breaking space", "", new_pixmap (110,
								 main_window->window, NULL),
			   GTK_SIGNAL_FUNC (general_html), (gpointer *) 7);
  gtk_toolbar_append_space (GTK_TOOLBAR (html_toolbar));
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Anchor...",
			   "", new_pixmap (111, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (quickanchor), NULL);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Rule...",
			   "",
			   new_pixmap (112, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (quickrule), NULL);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Image...",
			   "",
			   new_pixmap (113, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (image_insert_dialog), NULL);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL,
			   "Thumbnail...",
			   "", new_pixmap (125, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (image_thumbnail_dialog), NULL);
  gtk_toolbar_append_space (GTK_TOOLBAR (html_toolbar));
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Center", "",
			   new_pixmap (114, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (general_html), (gpointer *) 8);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL,
			   "Right Justify", "", new_pixmap (115,
							    main_window->window, NULL),
			   GTK_SIGNAL_FUNC (general_html), (gpointer *) 9);
  gtk_toolbar_append_space (GTK_TOOLBAR (html_toolbar));
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Comment",
			   "",
			   new_pixmap (116, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (general_html), (gpointer *) 10);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "E-Mail...", "",
			   new_pixmap (117, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (email), NULL);
  gtk_notebook_append_page (GTK_NOTEBOOK (html_widget), html_toolbar, html_label);
  flush_toolbar (html_label, html_toolbar);

  html_toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_BOTH);
  html_label = gtk_label_new (" Fonts ");
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Font...",
			   "",
			   new_pixmap (118, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (fontdialog), NULL);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL,
			   "Base Font Size...", "", new_pixmap (119,
							     main_window->window, NULL),
			   GTK_SIGNAL_FUNC (basefont), NULL);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL,
			   "Font Size +1",
			   "", new_pixmap (120, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (general_html), (gpointer *) 11);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL,
			   "Font Size -1",
			   "", new_pixmap (121, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (general_html), (gpointer *) 12);
  gtk_toolbar_append_space (GTK_TOOLBAR (html_toolbar));
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL,
			   "Preformatted Text", "", new_pixmap (122,
								main_window->window,
								NULL),
			   GTK_SIGNAL_FUNC (general_html), (gpointer *) 13);
  gtk_toolbar_append_space (GTK_TOOLBAR (html_toolbar));
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Subscript",
			   "", new_pixmap (123, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (general_html), (gpointer *) 14);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL,
			   "Superscript",
			   "", new_pixmap (124, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (general_html), (gpointer *) 15);
  gtk_toolbar_append_space (GTK_TOOLBAR (html_toolbar));
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Strong", "",
			   new_pixmap (102, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (general_html), (gpointer *) 16);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Emphasis",
			   "",
			   new_pixmap (103, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (general_html), (gpointer *) 17);
  gtk_toolbar_append_space (GTK_TOOLBAR (html_toolbar));
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Heading 1",
			   "", new_pixmap (127, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (general_html), (gpointer *) 18);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Heading 2",
			   "", new_pixmap (128, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (general_html), (gpointer *) 19);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Heading 3",
			   "", new_pixmap (129, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (general_html), (gpointer *) 20);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Heading 4",
			   "", new_pixmap (130, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (general_html), (gpointer *) 21);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Heading 5",
			   "", new_pixmap (131, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (general_html), (gpointer *) 22);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Heading 6",
			   "", new_pixmap (132, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (general_html), (gpointer *) 23);
  gtk_notebook_append_page (GTK_NOTEBOOK (html_widget), html_toolbar, html_label);
  flush_toolbar (html_label, html_toolbar);

  html_toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_BOTH);
  html_label = gtk_label_new (" Tables ");
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL,
			   "Table Wizard...",
			   "", new_pixmap (133, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (tablewizard), NULL);
  gtk_toolbar_append_space (GTK_TOOLBAR (html_toolbar));
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Table...",
			   "",
			   new_pixmap (134, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (tabledialog), NULL);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL,
			   "Table Row...",
			   "", new_pixmap (135, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (tablerowdialog), NULL);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL,
			   "Table Header...", "", new_pixmap (136,
							      main_window->window,
							      NULL),
			   GTK_SIGNAL_FUNC (tableheaderdialog), NULL);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL,
			   "Table Data...", "", new_pixmap (137,
							    main_window->window,
							    NULL),
			   GTK_SIGNAL_FUNC (tabledatadialog), NULL);
  gtk_toolbar_append_space (GTK_TOOLBAR (html_toolbar));
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Table", "",
			   new_pixmap (138, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (general_html), (gpointer *) 24);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Table Row",
			   "", new_pixmap (139, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (general_html), (gpointer *) 25);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL,
			   "Table Header",
			   "", new_pixmap (140, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (general_html), (gpointer *) 26);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Table Data",
			   "", new_pixmap (141, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (general_html), (gpointer *) 27);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL,
			   "Table Caption", "", new_pixmap (142,
							    main_window->window,
							    NULL),
			   GTK_SIGNAL_FUNC (general_html), (gpointer *) 28);
  gtk_notebook_append_page (GTK_NOTEBOOK (html_widget), html_toolbar, html_label);
  flush_toolbar (html_label, html_toolbar);

  html_toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_BOTH);
  html_label = gtk_label_new (" Frames ");
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL,
			   "Frame Wizard...",
			   "", new_pixmap (143, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (framewizard), NULL);
  gtk_toolbar_append_space (GTK_TOOLBAR (html_toolbar));
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL,
			   "Frameset...",
			   "", new_pixmap (144, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (framesetdialog), NULL);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Frame...",
			   "",
			   new_pixmap (145, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (framedialog), NULL);
  gtk_toolbar_append_space (GTK_TOOLBAR (html_toolbar));
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Frameset",
			   "",
			   new_pixmap (146, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (general_html), (gpointer *) 29);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Frame", "",
			   new_pixmap (147, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (general_html), (gpointer *) 30);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Noframes",
			   "",
			   new_pixmap (148, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (general_html), (gpointer *) 31);
  gtk_toolbar_append_space (GTK_TOOLBAR (html_toolbar));
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL,
			   "Base Target",
			   "", new_pixmap (149, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (general_html), (gpointer *) 32);
  gtk_notebook_append_page (GTK_NOTEBOOK (html_widget), html_toolbar, html_label);
  flush_toolbar (html_label, html_toolbar);

  html_toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_BOTH);
  html_label = gtk_label_new (" Forms ");
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Form...", "",
			   new_pixmap (150, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (formdialog), NULL);
  gtk_toolbar_append_space (GTK_TOOLBAR (html_toolbar));
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Submit...", "",
			   new_pixmap (151, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (submitdialog), NULL);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Reset...", "",
			   new_pixmap (152, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (resetdialog), NULL);
  gtk_toolbar_append_space (GTK_TOOLBAR (html_toolbar));
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Text...", "",
			   new_pixmap (153, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (textdialog), NULL);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Hidden...", "",
			   new_pixmap (154, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (hiddendialog), NULL);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Textarea...",
			   "",
			   new_pixmap (155, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (textareadialog), NULL);
  gtk_toolbar_append_space (GTK_TOOLBAR (html_toolbar));
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL,
			   "Radio Button...",
			   "", new_pixmap (156, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (radiodialog), NULL);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Check Box...",
			   "", new_pixmap (157, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (checkdialog), NULL);
  gtk_toolbar_append_space (GTK_TOOLBAR (html_toolbar));
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Select...", "",
			   new_pixmap (158, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (selectdialog), NULL);
  gtk_notebook_append_page (GTK_NOTEBOOK (html_widget), html_toolbar, html_label);
  flush_toolbar (html_label, html_toolbar);

  html_toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_BOTH);
  html_label = gtk_label_new (" Lists ");
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Quick List...",
			   "", new_pixmap (159, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (quicklist), NULL);
  gtk_toolbar_append_space (GTK_TOOLBAR (html_toolbar));
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL,
			   "Unordered List", "", new_pixmap (160,
							     main_window->window,
							     NULL),
			   GTK_SIGNAL_FUNC (general_html), (gpointer *) 33);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL,
			   "Ordered List",
			   "", new_pixmap (161, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (general_html), (gpointer *) 34);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "List Item",
			   "", new_pixmap (162, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (general_html), (gpointer *) 35);
  gtk_toolbar_append_space (GTK_TOOLBAR (html_toolbar));
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL,
			   "Definition List", "", new_pixmap (163,
							      main_window->window,
							      NULL),
			   GTK_SIGNAL_FUNC (general_html), (gpointer *) 36);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL,
			   "Definition Term", "", new_pixmap (164,
							      main_window->window,
							      NULL),
			   GTK_SIGNAL_FUNC (general_html), (gpointer *)
			   (gpointer *) 37);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Definition",
			   "", new_pixmap (165, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (general_html), (gpointer *)
			   (gpointer *) 38);
  gtk_toolbar_append_space (GTK_TOOLBAR (html_toolbar));
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Menu", "",
			   new_pixmap (166, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (general_html), (gpointer *)
			   (gpointer *) 39);

  gtk_notebook_append_page (GTK_NOTEBOOK (html_widget), html_toolbar, html_label);
  flush_toolbar (html_label, html_toolbar);

  html_toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_BOTH);
  html_label = gtk_label_new (" Other ");
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Imagemap",
			   "",
			   new_pixmap (167, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (general_html), (gpointer *)
			   (gpointer *) 40);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Meta...", "",
			   new_pixmap (168, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (meta), NULL);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL, "Embed...", "",
			   new_pixmap (169, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (embed), NULL);

  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL,
			   "View in Netscape", "",
			   new_pixmap (170, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (view_in_netscape), NULL);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL,
			   "Select Colour...", "",
			   new_pixmap (171, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (sel_colour), NULL);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL,
			   "Insert Time...", "",
			   new_pixmap (172, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (insert_time), NULL);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL,
			   "PHP3 reference...", "",
			   new_pixmap (173, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (php3_dialog), NULL);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL,
			   "SSI reference...", "",
			   new_pixmap (174, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (ssi_dialog), NULL);
  gtk_toolbar_append_item (GTK_TOOLBAR (html_toolbar), NULL,
			   "RXML reference...", "",
			   new_pixmap (175, main_window->window, NULL),
			   GTK_SIGNAL_FUNC (rxml_dialog), NULL);
  gtk_notebook_append_page (GTK_NOTEBOOK (html_widget), html_toolbar, html_label);
  flush_toolbar (html_label, html_toolbar);

  gtk_widget_show (html_widget);
  gtk_widget_show (html_label);
  gtk_widget_show (html_toolbar);
#ifdef DEBUG
  g_print ("make_html_toolbar, end\n");
#endif
}


/* ------------------------------------------
 * These functions are only declared in the top of toolbars.c
 * they are only accessible from within this file
 * --------------------------------------------- */

GtkWidget *
new_pixmap (int type, GdkWindow * window, GdkColor * background)
{
  GtkWidget *wpixmap;
  GdkBitmap *mask = NULL;
  /* editor toolbar stuff */
  switch (type)
    {
    case 000:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, new_xpm);
      break;
    case 001:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, open_xpm);
      break;
    case 002:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, save_xpm);
      break;
    case 003:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, save_as_xpm);
      break;
    case 004:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, close_xpm);
      break;
    case 005:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, copy_xpm);
      break;
    case 006:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, cut_xpm);
      break;
    case 007:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, paste_xpm);
      break;
    case 010:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, search_xpm);
      break;
    case 011:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, search_replace_xpm);
      break;
    case 012:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, undo_xpm);
      break;
    case 013:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, redo_xpm);
      break;
    case 014:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, preferences_xpm);
      break;
    case 015:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, print_xpm);
      break;
    case 016:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, spellcheck_xpm);
      break;
      /* HTML toolbar stuff */
    case 100:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, quick_start_xpm);
      break;
    case 101:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, body_xpm);
      break;
    case 102:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, bold_xpm);
      break;
    case 103:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, italic_xpm);
      break;
    case 104:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, underline_xpm);
      break;
    case 105:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, strikeout_xpm);
      break;
    case 106:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, paragraph_xpm);
      break;
    case 107:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, break_xpm);
      break;
    case 110:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, nbsp_xpm);
      break;
    case 111:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, anchor_xpm);
      break;
    case 112:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, hrule_xpm);
      break;
    case 113:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, image_xpm);
      break;
    case 114:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, center_xpm);
      break;
    case 115:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, right_xpm);
      break;
    case 116:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, comment_xpm);
      break;
    case 117:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, email_xpm);
      break;
    case 118:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, font_xpm);
      break;
    case 119:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, font_base_xpm);
      break;
    case 120:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, fontp1_xpm);
      break;
    case 121:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, fontm1_xpm);
      break;
    case 122:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, fontpre_xpm);
      break;
    case 123:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, fontsub_xpm);
      break;
    case 124:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, fontsuper_xpm);
      break;
    case 125:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, thumbnail_xpm);
      break;
    case 127:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, fonth1_xpm);
      break;
    case 128:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, fonth2_xpm);
      break;
    case 129:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, fonth3_xpm);
      break;
    case 130:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, fonth4_xpm);
      break;
    case 131:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, fonth5_xpm);
      break;
    case 132:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, fonth6_xpm);
      break;
    case 133:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, tablewhiz_xpm);
      break;
    case 134:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, table_xpm);
      break;
    case 135:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, table_tr_xpm);
      break;
    case 136:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, table_th_xpm);
      break;
    case 137:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, table_td_xpm);
      break;
    case 138:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, table2_xpm);
      break;
    case 139:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, table_tr2_xpm);
      break;
    case 140:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, table_th2_xpm);
      break;
    case 141:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, table_td2_xpm);
      break;
    case 142:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, table_capt_xpm);
      break;
    case 143:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, framewhiz_xpm);
      break;
    case 144:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, frameset_xpm);
      break;
    case 145:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, frame_xpm);
      break;
    case 146:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, frameset2_xpm);
      break;
    case 147:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, frame2_xpm);
      break;
    case 148:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, frame_no_xpm);
      break;
    case 149:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, frame_base_xpm);
      break;
    case 150:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, form_xpm);
      break;
    case 151:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, form_submit_xpm);
      break;
    case 152:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, form_reset_xpm);
      break;
    case 153:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, form_text_xpm);
      break;
    case 154:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, form_hidden_xpm);
      break;
    case 155:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, form_textarea_xpm);
      break;
    case 156:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, form_radio_xpm);
      break;
    case 157:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, form_check_xpm);
      break;
    case 158:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, form_select_xpm);
      break;
    case 159:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, list_xpm);
      break;
    case 160:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, list_ul_xpm);
      break;
    case 161:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, list_ol_xpm);
      break;
    case 162:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, list_li_xpm);
      break;
    case 163:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, list_dl_xpm);
      break;
    case 164:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, list_dt_xpm);
      break;
    case 165:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, list_dd_xpm);
      break;
    case 166:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, list_menu_xpm);
      break;
    case 167:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, image_map_xpm);
      break;
    case 168:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, meta_xpm);
      break;
    case 169:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, embed_xpm);
      break;
    case 170:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, netscape_xpm);
      break;
    case 171:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, color_select_xpm);
      break;
    case 172:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, time_xpm);
      break;
    case 173:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, php3_xpm);
      break;
    case 174:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, ssi_xpm);
      break;
    case 175:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, rxml_xpm);
      break;
    case 176:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, color_select_small_xpm);
      break;
    case 177:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, open_small_xpm);
      break;
      /* everything else */
    case 200:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, help_xpm);
      break;
    case 201:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, yes_xpm);
      break;
    case 202:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, no_xpm);
      break;
    case 203:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, ok_xpm);
      break;
    case 204:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, cancel_xpm);
      break;

    case 300:
      pixm = gdk_pixmap_create_from_xpm_d (window, &mask, background, nothing_xpm);
      break;
    }

  wpixmap = gtk_pixmap_new (pixm, mask);
  gdk_pixmap_unref (pixm);
  return wpixmap;
}

void
flush_toolbar (GtkWidget * html_label, GtkWidget * html_toolbar)
{
  gtk_widget_show (html_label);
  gtk_widget_show (html_toolbar);
}


void
edit_custom_menu (GtkWidget * w, gpointer data)
{
/*
 * the custom menu is build out of a list, the entry_list_list
 * this list contains main_entry's, and every main_entry contains
 * again a list with entry's.
 * the items in the lists are crosslinked by pointers, pointing to their
 * item in the tree, the subtree they are connected to, and their main_entry.
 * 
 * The editor keeps track of the last selected entries with the pointers
 * last_entry and last_main_entry. This is very convenient when deleting
 * updating etc., you only need to check if that pointer != NULL and then
 * you can directly access all the values, and the part in the tree
 */


  GtkWidget *menu_window, *scrolled_win, *tree, *hbox, *hbox2, *vbox,
  *vbox2, *frame, *table;
  gint count, count2 = 0;
  struct cust_main_menu_struct *main_entry;
  struct cust_menu_struct *entry;
  GtkWidget *label, *but_cancel, *but_save;
  GtkWidget *but1, *but2, *but3, *but4, *but5, *but6;

  /* a generic toplevel window */
  menu_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_signal_connect (GTK_OBJECT (menu_window), "delete_event",
		      GTK_SIGNAL_FUNC (gtk_widget_destroy), menu_window);
  gtk_container_border_width (GTK_CONTAINER (menu_window), 5);

  vbox = gtk_vbox_new (FALSE, 5);
  gtk_container_add (GTK_CONTAINER (menu_window), vbox);
  gtk_widget_show (vbox);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_widget_show (hbox);

  /* A generic scrolled window */
  scrolled_win = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
				  GTK_POLICY_AUTOMATIC,
				  GTK_POLICY_AUTOMATIC);
  gtk_widget_set_usize (scrolled_win, 150, 200);
  gtk_box_pack_start (GTK_BOX (hbox), scrolled_win, FALSE, FALSE, 5);
  gtk_widget_show (scrolled_win);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), vbox2, FALSE, FALSE, 5);
  gtk_widget_show (vbox2);

  /* make main menu frame + content */
  frame = gtk_frame_new ("Menu");
  gtk_box_pack_start (GTK_BOX (vbox2), frame, TRUE, TRUE, 5);
  /* gtk_widget_set_usize(frame, 250, 200); */
  gtk_widget_show (frame);
  table = gtk_table_new (3, 2, TRUE);
  gtk_container_border_width (GTK_CONTAINER (frame), 5);
  gtk_container_add (GTK_CONTAINER (frame), table);
  label = gtk_label_new ("Name");
  entry1 = gtk_entry_new_with_max_length (200);
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (table), entry1, 1, 3, 0, 1);
  gtk_widget_show (label);
  gtk_widget_show (entry1);
  /* buttons for main menu */
  but1 = gtk_button_new_with_label ("Delete");
  gtk_table_attach_defaults (GTK_TABLE (table), but1, 0, 1, 1, 2);
  gtk_widget_show (but1);
  but2 = gtk_button_new_with_label ("Update");
  gtk_table_attach_defaults (GTK_TABLE (table), but2, 1, 2, 1, 2);
  gtk_widget_show (but2);
  but3 = gtk_button_new_with_label ("Add");
  gtk_table_attach_defaults (GTK_TABLE (table), but3, 2, 3, 1, 2);
  gtk_widget_show (but3);
  gtk_widget_show (table);

  /* make menu entry frame + content */
  frame = gtk_frame_new ("Entry");
  gtk_box_pack_start (GTK_BOX (vbox2), frame, TRUE, TRUE, 5);
  /* gtk_widget_set_usize(frame, 250, 200); */
  gtk_widget_show (frame);
  table = gtk_table_new (3, 4, TRUE);
  gtk_container_border_width (GTK_CONTAINER (frame), 5);
  gtk_container_add (GTK_CONTAINER (frame), table);
  label = gtk_label_new ("Name");
  entry2 = gtk_entry_new_with_max_length (200);
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (table), entry2, 1, 3, 0, 1);
  gtk_widget_show (label);
  gtk_widget_show (entry2);
  label = gtk_label_new ("Before");
  entry3 = gtk_entry_new_with_max_length (200);
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (table), entry3, 1, 3, 1, 2);
  gtk_widget_show (label);
  gtk_widget_show (entry3);
  label = gtk_label_new ("After");
  entry4 = gtk_entry_new_with_max_length (200);
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 2, 3);
  gtk_table_attach_defaults (GTK_TABLE (table), entry4, 1, 3, 2, 3);
  gtk_widget_show (label);
  gtk_widget_show (entry4);
  /* buttons for menu item */
  but4 = gtk_button_new_with_label ("Delete");
  gtk_table_attach_defaults (GTK_TABLE (table), but4, 0, 1, 3, 4);
  gtk_widget_show (but4);
  but5 = gtk_button_new_with_label ("Update");
  gtk_table_attach_defaults (GTK_TABLE (table), but5, 1, 2, 3, 4);
  gtk_widget_show (but5);
  but6 = gtk_button_new_with_label ("Add");
  gtk_table_attach_defaults (GTK_TABLE (table), but6, 2, 3, 3, 4);
  gtk_widget_show (but6);
  gtk_widget_show (table);

  /* Create the root tree */
  tree = gtk_tree_new ();

  /* connect all buttons */
  gtk_signal_connect (GTK_OBJECT (but1), "clicked",
		      GTK_SIGNAL_FUNC (main_entry_del),
		      (gpointer) tree);
  gtk_signal_connect (GTK_OBJECT (but2), "clicked",
		      GTK_SIGNAL_FUNC (main_entry_update),
		      (gpointer) tree);
  gtk_signal_connect (GTK_OBJECT (but3), "clicked",
		      GTK_SIGNAL_FUNC (main_entry_new),
		      (gpointer) tree);
  gtk_signal_connect (GTK_OBJECT (but4), "clicked",
		      GTK_SIGNAL_FUNC (entry_del),
		      (gpointer) tree);
  gtk_signal_connect (GTK_OBJECT (but5), "clicked",
		      GTK_SIGNAL_FUNC (entry_update),
		      (gpointer) tree);
  gtk_signal_connect (GTK_OBJECT (but6), "clicked",
		      GTK_SIGNAL_FUNC (entry_new),
		      (gpointer) tree);


  /* Add it to the scrolled window */
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (scrolled_win), tree);
  /* Set the selection mode */
  gtk_tree_set_selection_mode (GTK_TREE (tree),
			       GTK_SELECTION_SINGLE);
  /* Show it */
  gtk_widget_show (tree);


  count = g_list_length (entry_list_list) - 1;
  while (count > 0)
    {
      /* loop trough the entry_list_list */
      main_entry = g_list_nth_data (entry_list_list, count);
      main_entry->item = gtk_tree_item_new_with_label (main_entry->name);
      /* Add it to the parent tree */
      gtk_tree_append (GTK_TREE (tree), main_entry->item);
      gtk_signal_connect (GTK_OBJECT (main_entry->item), "select",
			  GTK_SIGNAL_FUNC (main_entry_selected),
			  (gpointer) main_entry);
      /* Show it - this can be done at any time */
      gtk_widget_show (main_entry->item);
      /* Create this item's subtree */
      main_entry->subtree = gtk_tree_new ();
#ifdef DEBUG
      g_print
	("edit_custom_menu, main_entry->subtree=%p,main_entry->item=%p \n",
	 main_entry->subtree, main_entry->item);
#endif
      gtk_tree_item_set_subtree (GTK_TREE_ITEM (main_entry->item), main_entry->subtree);
      count2 = g_list_length (main_entry->entry_list) - 1;
      while (count2 > 0)
	{
	  /* loop trough list of submenu's, and add them to the tree */
	  entry = g_list_nth_data (main_entry->entry_list, count2);
	  entry->item = gtk_tree_item_new_with_label (entry->name);
	  gtk_tree_append (GTK_TREE (main_entry->subtree), entry->item);
	  entry->subtree = main_entry->subtree;
	  entry->main_entry = main_entry;
	  gtk_signal_connect (GTK_OBJECT (entry->item), "select",
			      GTK_SIGNAL_FUNC (entry_selected),
			      (gpointer) entry);
	  gtk_widget_show (entry->item);
	  count2--;
	}
      count--;
    }

  hbox2 = gtk_hbox_new (TRUE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox2, FALSE, FALSE, 0);
  gtk_widget_show (hbox2);

  but_save = gtk_button_new_with_label ("Ok");
  but_cancel = gtk_button_new_with_label ("Cancel");
  gtk_signal_connect (GTK_OBJECT (but_save), "clicked",
		      GTK_SIGNAL_FUNC (entry_save),
		      (gpointer) menu_window);
  gtk_signal_connect (GTK_OBJECT (but_cancel), "clicked",
		      GTK_SIGNAL_FUNC (window_close),
		      (gpointer) menu_window);
  gtk_box_pack_start (GTK_BOX (hbox2), but_save, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (hbox2), but_cancel, TRUE, TRUE, 0);
  gtk_widget_show (but_save);
  gtk_widget_show (but_cancel);
#ifdef DEBUG
  g_print ("edit_custom_menu, window = %p\n", menu_window);
#endif
  gtk_widget_show (menu_window);
}

void
main_entry_new (GtkWidget * w, gpointer * tree)
{
  gchar *tmpstring;
  struct cust_main_menu_struct *main_entry;

#ifdef DEBUG
  g_print ("main_entry_new, entry_list_list length=%d\n", g_list_length (entry_list_list));
#endif
  tmpstring = g_malloc (254);
  strncpy (tmpstring, gtk_entry_get_text (GTK_ENTRY (entry1)), 253);
  main_entry = (struct cust_main_menu_struct *) g_malloc0 (sizeof (cust_main_menu_struct));
  main_entry->name = g_malloc (strlen (tmpstring + 1));
  main_entry->entry_list = g_list_alloc ();
  strcpy (main_entry->name, tmpstring);
  main_entry->item = gtk_tree_item_new_with_label (main_entry->name);
  /* Add it to the parent tree */
  gtk_tree_append (GTK_TREE (tree), main_entry->item);
  gtk_signal_connect (GTK_OBJECT (main_entry->item), "select",
		      GTK_SIGNAL_FUNC (main_entry_selected), (gpointer) main_entry);
  /* Show it - this can be done at any time */
  gtk_widget_show (main_entry->item);
  /* Create this item's subtree */
  main_entry->subtree = gtk_tree_new ();
  gtk_tree_item_set_subtree (GTK_TREE_ITEM (main_entry->item), main_entry->subtree);
  g_free (tmpstring);
  entry_list_list = g_list_append (entry_list_list, main_entry);
#ifdef DEBUG
  g_print ("main_entry_new, entry_list_list length=%d\n", g_list_length (entry_list_list));
#endif
}

void
entry_new (GtkWidget * w, gpointer * tree)
{
  gchar *tmpstring;
  struct cust_main_menu_struct *main_entry = NULL;
  struct cust_menu_struct *entry;
  GtkWidget *item, *add_to_item;
  GList *i;
  gint count;

  i = GTK_TREE_SELECTION (tree);
  item = GTK_WIDGET (i->data);
#ifdef DEBUG
  g_print ("entry_new, (item) i->data=%p, &i->data=%p\n", i->data, &i->data);
#endif
  g_list_free (i);
  gtk_tree_item_deselect (GTK_TREE_ITEM (item));

  /* this whole part can be replaced by using the last_entry and 
     last_main_entry pointers */
#ifdef DEBUG
  g_print ("entry_new, last_entry=%p, last_main_entry=%p\n", last_entry, last_main_entry);
#endif
  if (GTK_TREE (item->parent)->level == 0)
    {
      add_to_item = item;
#ifdef DEBUG
      g_print
	("entry_new, have the main entry in the tree add_to_item=%p\n", add_to_item);
#endif
    }
  else
    {
      add_to_item = GTK_TREE (item->parent)->tree_owner;
#ifdef DEBUG
      g_print
	("entry_new, need to use the parent as the main entry in the tree, add_to_item=%p\n", add_to_item);
#endif
    }
  /* till here replacable */

  tmpstring = g_malloc (600);
  entry = (struct cust_menu_struct *) g_malloc0 (sizeof (cust_menu_struct));
  strncpy (tmpstring, gtk_entry_get_text (GTK_ENTRY (entry2)), 599);
  entry->name = g_malloc (strlen (tmpstring + 1));
  strcpy (entry->name, tmpstring);
  strncpy (tmpstring, gtk_entry_get_text (GTK_ENTRY (entry3)), 599);
  entry->bef_html = g_malloc (strlen (tmpstring + 1));
  strcpy (entry->bef_html, tmpstring);
  strncpy (tmpstring, gtk_entry_get_text (GTK_ENTRY (entry4)), 599);
  entry->aft_html = g_malloc (strlen (tmpstring + 1));
  strcpy (entry->aft_html, tmpstring);
  g_free (tmpstring);
  count = g_list_length (entry_list_list) - 1;
  while (count > 0)
    {
      main_entry = g_list_nth_data (entry_list_list, count);
      if (main_entry->item == add_to_item)
	{
#ifdef DEBUG
	  g_print
	    ("entry_new, lenght main_entry->entry_list=%d last_main_entry=%p\n",
	     g_list_length (main_entry->entry_list), last_main_entry);
#endif
	  entry->main_entry = main_entry;
	  main_entry->entry_list =
	    g_list_append (main_entry->entry_list, entry);
	  count = 0;
#ifdef DEBUG
	  g_print ("entry_new, added to main entry %p with name = %s\n",
		   main_entry, main_entry->name);
	  g_print ("entry_new, lenght main_entry->entry_list %d\n",
		   g_list_length (main_entry->entry_list));
#endif
	}
      count--;
    }

  entry->item = gtk_tree_item_new_with_label (entry->name);
#ifdef DEBUG
  g_print ("entry_new, main_entry=%p, last_main_entry=%p\n",
	   last_main_entry, last_main_entry);
  if (GTK_IS_TREE (main_entry->subtree))
    {
      g_print ("entry_new, main_entry->subtree is a valid tree\n");
    }
#endif
  gtk_tree_append (GTK_TREE (main_entry->subtree), GTK_WIDGET (entry->item));
  entry->subtree = main_entry->subtree;
#ifdef DEBUG
  if (GTK_WIDGET_REALIZED (entry->item))
    {
      g_print ("entry_new, entry->item is realized\n");
    }
#endif
  gtk_signal_connect (GTK_OBJECT (entry->item), "select",
		      GTK_SIGNAL_FUNC (entry_selected), (gpointer) entry);
  gtk_widget_show (entry->item);
#ifdef DEBUG
  g_print ("entry_new, child position=%d\n", gtk_tree_child_position
	   (GTK_TREE (main_entry->subtree), entry->item));
  g_print ("entry_new, lenght main_entry->entry_list %d\n",
	   g_list_length (main_entry->entry_list));
  g_print ("entry_new, finished, on subtree=%p, tree=%p\n",
	   entry->subtree, tree);
#endif
}

void
main_entry_update (GtkWidget * w, gpointer * tree)
{
  gchar *tmpstring;

  if (last_main_entry != NULL)
    {
      /* free the memory of the old values */
#ifdef DEBUG
      g_print ("main_entry_update, start free-ing last_main_entry=%p\n", last_main_entry);
#endif
      g_free (last_main_entry->name);
      /* allocate the memory of the new values and insert the values */
      tmpstring = g_malloc (601);
      strncpy (tmpstring, gtk_entry_get_text (GTK_ENTRY (entry1)), 600);
      last_main_entry->name = g_malloc (strlen (tmpstring) + 1);
      strcpy (last_main_entry->name, tmpstring);
      g_free (tmpstring);
      /* update the label on the tree */
#ifdef DEBUG
      g_print ("main_entry_update, update label in item=%p\n", last_main_entry->item);
#endif
      gtk_label_set (GTK_LABEL (GTK_BIN (last_main_entry->item)->child), last_main_entry->name);
    }
}

void
entry_update (GtkWidget * w, gpointer * tree)
{
  gchar *tmpstring;

  if (last_entry != NULL)
    {
      /* free the memory of the old values */
#ifdef DEBUG
      g_print ("entry_update, start free-ing last_entry=%p\n", last_entry);
#endif
      g_free (last_entry->name);
      g_free (last_entry->bef_html);
      g_free (last_entry->aft_html);
      /* allocate the memory of the new values and insert the values */
      tmpstring = g_malloc (601);
      strncpy (tmpstring, gtk_entry_get_text (GTK_ENTRY (entry2)), 600);
      last_entry->name = g_malloc (strlen (tmpstring) + 1);
      strcpy (last_entry->name, tmpstring);
      strncpy (tmpstring, gtk_entry_get_text (GTK_ENTRY (entry3)), 600);
      last_entry->bef_html = g_malloc (strlen (tmpstring) + 1);
      strcpy (last_entry->bef_html, tmpstring);
      strncpy (tmpstring, gtk_entry_get_text (GTK_ENTRY (entry4)), 600);
      last_entry->aft_html = g_malloc (strlen (tmpstring) + 1);
      strcpy (last_entry->aft_html, tmpstring);
      g_free (tmpstring);
      /* update the label on the tree */
#ifdef DEBUG
      g_print ("entry_update, update label in item=%p\n", last_entry->item);
#endif
      gtk_label_set (GTK_LABEL (GTK_BIN (last_entry->item)->child), last_entry->name);
    }
}

void
main_entry_del (GtkWidget * w, gpointer * tree)
{
  GList *i;
  gint count2;
  struct cust_menu_struct *cur_last_entry;

  if (last_main_entry != NULL)
    {
#ifdef DEBUG
      g_print ("main_entry_del, last_main_entry=%p\n", last_main_entry);
#endif
      g_free (last_main_entry->name);
      /* remove sub menu */
      cur_last_entry = last_entry;
      count2 = g_list_length (last_main_entry->entry_list) - 1;
      while (count2 > 0)
	{
	  last_entry = g_list_nth_data (last_main_entry->entry_list, count2);
	  entry_del (w, tree);
	  count2--;
	}
      last_entry = cur_last_entry;
      entry_list_list = g_list_remove (entry_list_list, last_main_entry);
      g_list_free (last_main_entry->entry_list);
/*      gtk_tree_select_child(tree, last_main_entry->item); */
      i = GTK_TREE_SELECTION (tree);
      gtk_tree_remove_items (GTK_TREE (tree), i);
      g_free (last_main_entry);
      last_main_entry = NULL;
    }
}

void
entry_del (GtkWidget * w, gpointer * tree)
{
  GList *i;

  if (last_entry != NULL)
    {
      gtk_tree_item_select (GTK_TREE_ITEM (last_entry->item));
      g_free (last_entry->name);
      g_free (last_entry->bef_html);
      g_free (last_entry->aft_html);
      last_entry->main_entry->entry_list = g_list_remove
	(last_entry->main_entry->entry_list, last_entry);
      i = GTK_TREE_SELECTION (tree);
      gtk_tree_remove_items (GTK_TREE (tree), i);
      g_free (last_entry);
      last_entry = NULL;
    }
}

void
entry_save (GtkWidget * w, gpointer * window)
{
  save_cust_menu ();
  remake_cust_menubar ();
#ifdef DEBUG
  g_print ("entry_save, about to destroy window %p\n", window);
#endif
  gtk_signal_handlers_destroy (GTK_OBJECT (window));
  gtk_object_destroy (GTK_OBJECT (window));
#ifdef DEBUG
  g_print ("entry_save, finished\n");
#endif
}

void
entry_selected (GtkWidget * item, struct cust_menu_struct *entry)
{
  gtk_entry_set_text (GTK_ENTRY (entry2), entry->name);
  gtk_entry_set_text (GTK_ENTRY (entry3), entry->bef_html);
  gtk_entry_set_text (GTK_ENTRY (entry4), entry->aft_html);
  last_entry = entry;
#ifdef DEBUG
  g_print ("entry_selected, entry->name=%s, last_entry=%p\n",
	   entry->name, entry);
#endif
}

void
main_entry_selected (GtkWidget * item, struct cust_main_menu_struct *main_entry)
{
  gtk_entry_set_text (GTK_ENTRY (entry1), main_entry->name);
  last_main_entry = main_entry;
#ifdef DEBUG
  g_print ("main_entry_selected, main_entry->name=%s, last_main_entry=%p\n",
	   main_entry->name, main_entry);
#endif
}
