/* Bluefish HTML Editor
 * init.h --> all configurational options
 *
 * Copyright (C) 1998 Olivier Sessink and Chris Mazuc
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * these values represent the options if the users wants to see the:
 * v_html_tb: html toolbar
 * v_custom_tb: custom menubar
 * v_main_tb: main toolbar
 */
gint v_html_tb, v_custom_tb, v_main_tb;

/*
 * these values represent the command options for invoking the 
 * external programs used
 */
gchar *cfg_browser_cline;
gchar *cfg_weblint_cline;

/* assume netscape is on the path */
#define DEFAULT_BROWSER "netscape -remote OpenUrl\\(%s\\)"
#define DEFAULT_WEBLINT "weblint"
#define COMMAND_MAX 1024

/*
 * These values are pointers to the lists that are used in multiple 
 * combo widgets
 */
GList *targetlist;
GList *colorlist;
GList *fontlist;
GList *urllist;
GList *positionlist;

/*
 * these are the functions in init.c that are used to parse config files
 */

gint parse_config_files();
gint check_directories();
