/* Bluefish HTML Editor
 * init.c --> all configurational options are parsed here
 *
 * Copyright (C) 1998 Olivier Sessink and Chris Mazuc
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <gtk/gtk.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "bluefish.h"
#include "init.h"
#include "config.h"

#define DIR_MODE (S_IRWXU | S_IRGRP | S_IXGRP | S_IROTH | S_IXOTH)	/* same as 0755 */
#define FILE_MODE (S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH)	/* same as 0644 */

GList *getlist (gchar * filename, GList * which_list);
gint chk_dir(gchar * name);
gint chk_file(gchar * name, gchar *content);
gint chk_link(gchar * src_name, gchar *dst_name);

gint chk_dir(gchar * name) {
  struct stat filestat;
  if ((stat (name, &filestat) == -1) && (errno == ENOENT))
    {
#ifdef DEBUG
      g_print ("chk_dir, %s does not exist, creating\n", name);
#endif
      if (mkdir (name, DIR_MODE) != 0)
	g_print ("chk_dir, error: unable to create directory %s!\n", name);
    }
    return 1;
}

gint chk_link(gchar * src_name, gchar *dst_name) {
  struct stat filestat;
  if ((stat (src_name, &filestat) == -1) && (errno == ENOENT))
    {
#ifdef DEBUG
      g_print ("chk_link, %s does not exist, creating\n", src_name);
#endif
      if (symlink (dst_name, src_name) != 0)
	g_print ("error: unable to create symlink from %s to %s!\n",
		 dst_name, src_name);
    }
    return 1;
}

gint chk_file(gchar * name, gchar *content) {
  struct stat filestat;
  FILE *file;
  
  if ((stat (name, &filestat) == -1) && (errno
					 == ENOENT))
    {
#ifdef DEBUG
      g_print ("chk_file, %s does not exist, creating\n", name);
#endif
      file = fopen (name, "w");
      if (file == NULL)
	{
	  g_print ("chk_file, error: unable to create file %s!", name);
      } else {
          if (fputs (content, file)== EOF) {
	    g_print ("chk_file, error: unable to wrote to %s!", name);
          }
	  if (fclose (file) == EOF)
	    g_print ("chk_file, error: unable to close %s!", name);
	  }
     }
     return 1;
}

gint check_directories ()
{
  gchar *name, *name2, *homedir;
  int result = 1;

#ifdef DEBUG
  g_print ("check_directories, starting\n");
#endif
  name = g_malloc0 (1024);
  name2 = g_malloc0 (1024);
  homedir = g_get_home_dir();

  chk_dir(strncat (strcpy (name, homedir), "/.bluefish/", 1012));
  chk_dir(strncat (strcpy (name, homedir), "/.bluefish/projects/", 1012));
  chk_dir(strncat (strcpy (name, homedir), "/.bluefish/menu", 1012));
  chk_link(strncat (strcpy (name, homedir), "/.bluefish/php3_functions", 1012),
               strncat (strcpy (name2, BF_LIB_DIR), "php3_functions", 1012) );
  chk_link(strncat (strcpy (name, homedir), "/.bluefish/ssi_functions", 1012),
               strncat (strcpy (name2, BF_LIB_DIR), "ssi_functions", 1012));
  chk_link(strncat (strcpy (name, homedir), "/.bluefish/rxml_functions", 1012),
               strncat (strcpy (name2, BF_LIB_DIR), "rxml_functions", 1012) );

  chk_file(strncat (strcpy (name, homedir), "/.bluefish/projects/default", 1012), "");
  chk_file(strncat (strcpy (name, homedir), "/.bluefish/colorfile", 1012), "white\nblack\nmaroon\ngreen\nolive\nnavy\npurple\nfushia\nteal\ngray\nsilver\nred\nlime\nyellow\nblue\naqua\n");
  chk_file(strncat (strcpy (name, homedir), "/.bluefish/fontfile", 1012), "arial,helvetica\ntimes new roman, times, roman\nsans-serif\nverdana,arial,helvetica\ntahoma, verdana, arial, helvetica, sans-serif\ncourier new, courier, monaco, monospace\narial, sans-serif\n");
  chk_file(strncat (strcpy (name, homedir), "/.bluefish/targetfile", 1012), "_top\n_blank\n_self\n_parent\n");
  chk_file(strncat (strcpy (name, homedir), "/.bluefish/urlfile", 1012), "http://bluefish.linuxbox.com/\nindex.html\n");
  g_free(name);
  g_free(name2);
  g_free(homedir);
  return result;
}

gint
parse_config_files ()
{

  gchar *filename;

#ifdef DEBUG
  g_print ("parse_config_files, started\n");
#endif

/* 
 * read the data into the three lists: fonts, targets, urls and colors 
 * You need to add 1 entry to initialize the list before calling getlist()
 */
  filename = g_malloc (500);
  strncat (strcpy (filename,
		   (char *) getenv ("HOME")),
	   "/.bluefish/fontfile", 500);
  fontlist = getlist (filename, fontlist);
  strncat (strcpy (filename,
		   (char *) getenv ("HOME")),
	   "/.bluefish/targetfile", 500);
  targetlist = getlist (filename, targetlist);
  strncat (strcpy (filename,
		   (char *) getenv ("HOME")),
	   "/.bluefish/colorfile", 500);
  colorlist = getlist (filename, colorlist);
  strncat (strcpy (filename,
		   (char *) getenv ("HOME")),
	   "/.bluefish/urlfile", 500);
  urllist = getlist (filename, urllist);
  g_free (filename);
#ifdef DEBUG
  g_print
    ("parse_config_files, fontlist=%p, colorlist=%p, targetlist=%p, urllist=%p\n",
     fontlist, colorlist, targetlist, urllist);
#endif
  positionlist = g_list_append (positionlist, "top");
  positionlist = g_list_append (positionlist, "middle");
  positionlist = g_list_append (positionlist, "bottom");
  positionlist = g_list_append (positionlist, "right");
  positionlist = g_list_append (positionlist, "left");
  positionlist = g_list_append (positionlist, "texttop");
  positionlist = g_list_append (positionlist, "baseline");
  positionlist = g_list_append (positionlist, "absmiddle");
  positionlist = g_list_append (positionlist, "absbottom");
  
  /* some other options should be set, in the future out of a config file */
  v_html_tb=1;
  v_custom_tb=0;
  v_main_tb=1;
  
  return 1;
}


GList *getlist (gchar * filename, GList * which_list)
{
  char *tempstr, *tmpbuf;
  FILE *fd;
  gint count;

#ifdef DEBUG
  g_print ("getlist, started with filename=%s\n", filename);
#endif
  tmpbuf = g_malloc (1024);
  if (file_exists_and_readable (filename))
    {
#ifdef DEBUG
      g_print ("getlist, opening %s\n", filename);
#endif
      fd = fopen (filename, "r");
      if (fd == NULL)
	{
	  return NULL;
	}
      while (fgets (tmpbuf, 1023, fd) != NULL)
	{
	  for (count = 0; count <= strlen (tmpbuf); count++)
	    {
	      if (tmpbuf[count] == '\n')
		tmpbuf[count] = '\0';
	    }
	  tempstr = g_malloc (strlen (tmpbuf) + 1);
	  strcpy (tempstr, tmpbuf);
#ifdef DEBUG
	  g_print ("getlist, adding string %s to the list=%p\n", tempstr,
		   which_list);
#endif
	  which_list = g_list_append (which_list, tempstr);
	}
      fclose (fd);
    }
  g_free (tmpbuf);
  return which_list;
}
