/* Bluefish HTML Editor
 * configure.c
 *
 * Copyright (C) 1998 Olivier Sessink and Chris Mazuc
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <gtk/gtk.h>
#include "init.h"
#include <string.h>

GtkWidget *entry1, *entry2;

void apply_config (GtkWidget * button, gpointer entry);

extern void exit_modal_loop (GtkWidget * button, gpointer data);
/*************************
 * 
 * start of functions
 *
 *************************/

void
configure (GtkWidget * widget, gpointer data)
{
  /* This is the callback function for a configure button */

  /* This configuration dialog is simplistic and will probably need
     a rewrite. */

  /* declare the widgets */
  GtkWidget *dialog;		/* the dialog window */
  GtkWidget *ok;		/* the ok button */
  GtkWidget *cancel;		/* the cancel button */
  GtkWidget *vbox;		/* the hbox to contain the following: */
  GtkWidget *label1;		/*       - a label */


  /* create the widgets */
  dialog = gtk_dialog_new();
  gtk_signal_connect (GTK_OBJECT (dialog), "delete_event",
                      GTK_SIGNAL_FUNC (exit_modal_loop), NULL);
  gtk_signal_connect (GTK_OBJECT (dialog), "destroy", GTK_SIGNAL_FUNC
                      (exit_modal_loop), NULL);
  /* give the dialog a name */
  gtk_window_set_title (GTK_WINDOW (dialog), "Bluefish configuration");
  gtk_container_border_width (GTK_CONTAINER (dialog), 10);
  gtk_widget_set_usize(GTK_WIDGET(dialog), 400, 150);
  ok = gtk_button_new_with_label ("OK");
  cancel = gtk_button_new_with_label ("Cancel");

  vbox = gtk_vbox_new (TRUE, 0);
  label1 = gtk_label_new ("Browser command line");
  entry1 = gtk_entry_new ();

  /* put the current string in the entry widget */
  if (cfg_browser_cline == 0)
    {
      gtk_entry_set_text (GTK_ENTRY (entry1), DEFAULT_BROWSER);
    }
  else
    {
      gtk_entry_set_text (GTK_ENTRY (entry1), cfg_browser_cline);
    }
  gtk_widget_show (entry1);
  gtk_widget_show (label1);
  gtk_box_pack_start (GTK_BOX (vbox), label1, TRUE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), entry1, TRUE, FALSE, 3);

  label1 = gtk_label_new ("Weblint command line");
  entry2 = gtk_entry_new ();

  if (cfg_weblint_cline == 0)
    {
      gtk_entry_set_text (GTK_ENTRY (entry2), DEFAULT_WEBLINT);
    }
  else
    {
      gtk_entry_set_text (GTK_ENTRY (entry2), cfg_weblint_cline);
    }
  gtk_widget_show (label1);
  gtk_widget_show (entry2);
  gtk_box_pack_start (GTK_BOX (vbox), label1, TRUE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), entry2, TRUE, FALSE, 3);


  /* connect signals */
  gtk_signal_connect (GTK_OBJECT (ok), "clicked",
		      GTK_SIGNAL_FUNC (apply_config), dialog);
  gtk_signal_connect (GTK_OBJECT (cancel), "clicked",
		      GTK_SIGNAL_FUNC (exit_modal_loop), NULL);

  /* pack the widgets */
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area), ok,
		      TRUE, TRUE, 0);
  gtk_box_pack_end (GTK_BOX (GTK_DIALOG (dialog)->action_area), cancel,
		    TRUE, TRUE, 0);

  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), vbox, TRUE,
		      TRUE, 0);

  /* show the widgets */
  gtk_widget_show (ok);
  gtk_widget_show (cancel);
  gtk_widget_show (vbox);

  gtk_widget_show (dialog);

  gtk_grab_add (dialog);
  gtk_main ();
  gtk_grab_remove (dialog);

  gtk_object_destroy (GTK_OBJECT (dialog));

  gtk_main();
}


void
apply_config (GtkWidget * button, gpointer entry)
{
  gchar *str;

  str = strdup (gtk_entry_get_text (GTK_ENTRY (entry1)));
  if (str == NULL)
    {
      /* Ugh.  We should tell the user what went wrong... */
      return;
    }

  if (cfg_browser_cline != NULL)
    {
      g_free (cfg_browser_cline);
    }
  cfg_browser_cline = str;

  str = strdup (gtk_entry_get_text (GTK_ENTRY (entry2)));
  if (str == NULL)
    {
      /* Ugh.  We should tell the user what went wrong... */
      return;
    }

  if (cfg_weblint_cline != NULL)
    {
      g_free (cfg_weblint_cline);
    }
  cfg_weblint_cline = str;

  gtk_main_quit ();
}
