/* Bluefish HTML Editor
 * bluefish.h - global prototypes live here
 *
 * Copyright (C) 1998 Olivier Sessink and Chris Mazuc
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


/* The current version !!!!!! */
#define CURRENT_VERSION_NUMBER "0.3.2"
/* don't remove the version number out of this name again
or I'll kill you.... ;-]
*/
#define CURRENT_VERSION_NAME "Bluefish 0.3.2 HTML editor"

/* This is the type of each document */
typedef struct thefilestruct {
    gchar *filename;
    gint modified;
    unsigned del_txt_id; /* Copyright (C) 1998 Andy C. Kahn <kahn@zk3.dec.com> */
    unsigned ins_txt_id; /* undo/redo part is copied from gnotepad code */
    GList *undolist;
    GList *undotail;
    GList *redolist;
    GList *redotail;
    GtkWidget *textbox;
    GtkWidget *tab_label;
} filestruct;

/* This is always the current visible one */
filestruct *current_document;
/* The documents are now placed in a Glist */
GList *documentlist;


/* This is the current project */
struct projectstruct {
    gchar *filename;
    gchar *basedir;
    gchar *webdir;
} current_project;


void cya_later(GtkWidget * widget, gpointer data);
void startup(void);
void change_dir(gchar * filename);
char *strip_filename(gchar * string);
gchar * strip_common_path(char *image_fn, char *html_fn);
void window_close(GtkWidget * button, gpointer windowname);
gint file_exists_and_readable(gchar * filename);
void flush_queue(void);

/* list function, adds a string to a GList if it is not yet in there */
void add_to_list(GList *which_list, gchar *string);
