;
; #DEFINEs for relative calls and jumps
;

#DEFINE CALL_ROM(addr)		call $8C09 \ .dw addr
#DEFINE CALL_Z(addr)		call $8C0C \ .dw addr
#DEFINE CALL_(addr)		call $8C0F \ .dw addr
#DEFINE CALL_NZ(addr)		call $8C12 \ .dw addr
#DEFINE CALL_C(addr)		call $8C18 \ .dw addr
#DEFINE CALL_NC(addr)		call $8C1E \ .dw addr
#DEFINE JUMP_Z(addr)		call $8C24 \ .dw addr
#DEFINE JUMP_(addr)		call $8C27 \ .dw addr
#DEFINE JUMP_NZ(addr)		call $8C2A \ .dw addr
#DEFINE JUMP_C(addr)		call $8C30 \ .dw addr
#DEFINE JUMP_NC(addr)		call $8C36 \ .dw addr

;
; ZShell Specifics
;

PROGRAM_ADDR	=$8C3C	; program address
ROM_VERS	=$8C3E	; ROM version byte
ZSHELL_VER	=$8C3F	; ZShell version number
ZS_BITS		=$8C40	; bit 0 set : checksum again

;
; Call Addresses (based on ROM 3.0A)
;
LD_HL_MHL	=$0033	; HL=(HL), A=L
CP_HL_DE	=$008E	; CP HL,DE (modifies flags only)
UNPACK_HL	=$009A	; unpacks one digit of HL into %A
STORE_KEY	=$01B1	; store immediate keystroke from %A
GET_KEY		=$01BE	; get immediate keystroke into %A

; I think these are specific to verision 3.0A
; I know they don't work on 8.0
;SET_HL_0	=$2205	; make B bytes at (HL) = 0
;A_C_DIV_16	=$220B	; A = C / 16 (A = C >> 4)
;A_A_DIV_16	=$220C	; A = A / 16 (A = A >> 4)
;A_C_MUL_16	=$2213	; A = C * 16 (A = C << 4)
;A_A_MUL_16	=$2214	; A = A * 16 (A = A << 4)
;NEGATE_BC	=$300C	; HL = BC = -BC, A = 0
;LEN_ZSTR	=$307C	; find length of zero-terminated string
;COPY_ZSTR	=$308F	; copy zero-terminated string
;ADD_ZSTR	=$3097	; concatenate two zero-terminated strings
;CMP_LSTR	=$309E	; compare two length-byte strings

D_LT_STR	=$3B9E	; display length-byte normal text string
M_CHARPUT	=$3BDA	; display %A on screen, menu style
D_ZM_STR	=$3BE0	; display zero-terminated string, menu style
D_LM_STR	=$3C22	; display length-byte string, menu style
GET_T_CUR	=$3CA0	; HL = absolute address of text cursor
SCROLL_UP	=$3D90	; scroll text screen up
TR_CHARPUT	=$3DF6	; raw display of %A on screen, normal text style
CLEARLCD	=$3DFC	; clear LCD, but not text or graphics memory
D_HL_DECI	=$3E02	; disp. HL as 5-byte, right-just., blank-pad. decimal
CLEARTEXT	=$3E5C	; clear LCD and text memory (affected by 1,(IY+13))
D_ZT_STR	=$3E68	; display zero-terminated normal text string
BUSY_OFF	=$3EA4	; turn off "busy" indicator
BUSY_ON		=$3EBC	; turn on "busy" indicator
TX_CHARPUT	=$3FEE	; xlated display of %A on screen, normal text style

;
; Data Locations
;
KEY_0		=$8000	; translated scancode of last key, but 0 if gotten
KEY_1		=$8001	; translated scancode of key down now
KEY_2		=$8002	; same as 8001, but $FF if more than one key is down
KEY_STAT	=$8004	; bit 2 set = key down now
LAST_KEY	=$8006	; last key pressed
CONTRAST	=$8007	; contrast
CURSOR_ROW	=$800C	; text cursor row
CURSOR_COL	=$800D	; text cursor column
CURSOR_LET	=$800E	; letter under text cursor
BUSY_COUNTER	=$8080	; counter for busy indicator
BUSY_BITMAP	=$8081	; bitmap for busy indicator
CURR_INPUT	=$80C6	; -> current home-screen input
BYTES_USED	=$80CC	; # of used user memory (Add to 80C8 to find first 
			; byte of free memory)
TEXT_MEM	=$80DF	; text memory
CURSOR_ROW2	=$800C	; text cursor row
CURSOR_COL2	=$800D	; text cursor column
CHECKSUM	=$81BE	; memory checksum from 8BF7 to FA6F
CURSOR_X	=$8333	; x value of cursor
CURSOR_Y	=$8334	; y value of cursor
IY_TABLE	=$8346	; where IY usually points
GRAPH_MEM	=$8641	; graphics memory
TEXT_MEM2	=$8A6B	; secondary text memory
USER_MEM	=$8B1B	; -> start of user memory
;=$8B1D	; subtract (8B1B) from this to get # of free bytes
FIXED_POINT	=$8B3A	; fixed-point decimal place (FFh for floating point)
VAT_END		=$8BEB	; -> one byte before end of VAT (backwards)
VAT_START	=$FA6F	; start of VAT
VIDEO_MEM	=$FC00	; video memory