/* copyright Andreas Westfeld 1995 */
/* freeware */

#include <conio.h>
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>

#define	LPTPORT	*(unsigned int far *)0x408L
#define	TIMER	*(unsigned int far *)0x46CL
#define TIMEOUT	if (TIMER-timeout>18*4) time_out()
#define lpt_in	(lpt_out+1)

unsigned calc_type;
unsigned int lpt_out;
unsigned int last_packet_length;
unsigned int timeout;

void time_out(void)
{
	printf("I/O port 0x%04x was used.\n", lpt_out);
	printf("\nTimeout.");
	exit(1);
}

void put85(char data)
{
	int bit;

	timeout=TIMER;
	for (bit=0; bit<8; bit++) {
		if (data&1) {
			outportb(lpt_out, 2);
			while (inportb(lpt_in)&0x10)
				TIMEOUT;
			outportb(lpt_out, 3);
			while ((inportb(lpt_in)&0x10)==0x00)
				TIMEOUT;
		} else {
			outportb(lpt_out, 1);
			while (inportb(lpt_in)&0x20)
				TIMEOUT;
			outportb(lpt_out, 3);
			while ((inportb(lpt_in)&0x20)==0x00)
				TIMEOUT;
		}
		data>>=1;
	}
}

unsigned char get85(void)
{
	int bit;
	unsigned char data=0, v;

	timeout=TIMER;
	for (bit=0; bit<8; bit++) {
		while ((v=inportb(lpt_in)&0x30) == 0x30)
				TIMEOUT;
		if (v==0x10) {
			data=(data>>1)|0x80;
			outportb(lpt_out, 1);
			while ((inportb(lpt_in)&0x20)==0x00)
				TIMEOUT;
			outportb(lpt_out, 3);
		} else {
			data=data>>1;
			outportb(lpt_out, 2);
			while ((inportb(lpt_in)&0x10)==0x00)
				TIMEOUT;
			outportb(lpt_out, 3);
		}
	}
	return data;
}

unsigned char get_header(void)
{
	int r, t;

	calc_type=get85();
	r=get85();
#if 0
	t=get85();
	last_packet_length=(get85()<<8)|t;
#endif
	printf("Id byte is 0x%02x\n", calc_type);
	printf("Type byte is 0x%02x\n", r);
	return r;
}

void write_packet(char cmd)
{
	put85(calc_type);
	put85(cmd);
#if 0
	put85(len&0xff);
	put85(len>>8);
#else
	put85(0);
	put85(0);
#endif
}

void read_packet(void)
{
	unsigned int i, b, len, sum=0;

	for (i=0; i<last_packet_length; i++) {
		printf("%02X  ", b=get85());
		sum+=b;
	}
	printf("%02X  ", i=get85());
	printf("%02X  ", b=get85());
	i|=b<<8;
	if (i==sum) {
		printf("\nchecksum ok.\n");
	} else {
		printf("\nchecksum error.\n");
	}
}

void disp(void)
{
	unsigned char a, b, c, d, e;
	unsigned char far *p=(unsigned char far*)0xb8000000;
	int i, x, y;

	__emit__(0xb8, 0x04, 0x00, 0xcd, 0x10);
	printf("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");
	put85(0x05); put85(0x6d); put85(0x00); put85(0x00);
	c=get85(); c=get85(); c=get85(); c=get85();
	c=get85(); c=get85(); c=get85(); c=get85();
	p+=1448;
	for (y=0; y<64; y++) {
		for (x=0; x<16; x++) {
			c=get85(); a=b=d=e=0;
			if (c&1) e=5;
			if (c&2) e|=0x50;
			if (c&4) d=5;
			if (c&8) d|=0x50;
			if (c&0x10) b=5;
			if (c&0x20) b|=0x50;
			if (c&0x40) a=5;
			if (c&0x80) a|=0x50;
			p[0x2000] = a^0x55;
			p[0x2001] = b^0x55;
			p[0x2002] = d^0x55;
			p[0x2003] = e^0x55;
			*p++ = a^0x55;
			*p++ = b^0x55;
			*p++ = d^0x55;
			*p++ = e^0x55;
		}
		p+=(80-64);
	}
}

int main(int argc, char *argv[])
{
	if (argc==1) {
		printf("Usage: disp port_address, e. g. disp 0x278\n");
		exit(2);
	}
	sscanf(argv[1], "%i", &lpt_out);
	outportb(lpt_out, 3);	/* initialize link cable */
	disp();
	return 0;
}
