/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
#define Uses_TResourceFile
#define Uses_TStreamable
#define Uses_fpstream

#define Uses_TRect
#define Uses_TKeys
#define Uses_RawKeys
#define Uses_IDEConst

#define Uses_THintStatusLine
#define Uses_TStatusDef
#define Uses_TStatusItem

#define Uses_TMenuBar
#define Uses_TSubMenu

#define Uses_TFlagCollection
#define Uses_TFlagEntry

#define Uses_TEditor
#define Uses_TProject
#define Uses_TOptions
#define Uses_TStringCollection
#define Uses_IDEConst
#define Uses_TStreamableClass

#define Uses_TColorDialog
#define Uses_TColorGroup
#define Uses_TColorItem
#define Uses_TPalette
#define Uses_TSCollection
#define Uses_TResourceCollection
#define Uses_TColorDisplay
#define Uses_TColorSelector
#define Uses_TMonoSelector
#define Uses_TLabel
#define Uses_TButton
#define Uses_TColorItemList
#define Uses_TColorGroupList

#define Uses_TProgram
#define Uses_TVEdConstant

#define Uses_TDirListBox
#define Uses_TEditWindow
#define Uses_TFileList
#define Uses_TChDirDialog
#define Uses_TFileDialog
#define Uses_TFileInfoPane
#define Uses_LangTexte

#include <IDEClass.h>
#include "IDE.h"
#include <stdio.h>
#include <fcntl.h>
#include <inf.h>

extern char *BASENAME;

__link ( RMenuBar )
__link ( RHintStatusLine )
__link ( RResourceCollection )
__link ( RSCollection )
__link ( RColorDialog )

#ifndef ORIG_NAMES

  #define N(w,n)\
    const char * const w::name = #n;

  N(TMonoSelector,\xFE)
  N(TSCollection,\xFD)
  N(TResourceCollection,\xFC)
  N(THintStatusLine,\xFB)
  N(TMenuBar,\xFA)
  N(TColorDialog,\xF9)
  N(TColorItemList,\xF8)
  N(TColorGroupList,\xF7)
  N(TColorDisplay,\xF6)
  N(TButton,\xF5)
  N(TLabel,\xF4)
  N(TColorSelector,\xF3)

#endif

static TResourceFile *resource[LANGUAGES];
static TResourceFile *common_dlg;
char *resource_ext[LANGUAGES] = {
  "eng",
  "ger",
  "spa",
  "fre",
  "swe",
  "ita",
  "$$$",
  "dut"
};

static void AddResource(TStreamable * item,const char * key,int language)
{
  if (language < 0) common_dlg->put(item,key);
  else resource[language]->put(item,key);
}

static void CreateResource()
{
  char rname[256];
  fpstream *ofp;
  int i;
  for (i=0;i<LANGUAGES;i++)
  {
    strcpy(rname,BASENAME);
    strcat(rname,resource_ext[i]);
    remove(rname);
    ofp = new fpstream(rname,ios::out);
    resource[i] = new TResourceFile(ofp);
  }
  strcpy(rname,BASENAME);
  strcat(rname,"all");
  remove(rname);
  ofp = new fpstream(rname,ios::out);
  common_dlg = new TResourceFile(ofp);
}

static void PutResources();

void CloseResource()
{
  int i;
  for (i=0;i<LANGUAGES;i++) delete resource[i];
  delete common_dlg;
  CreateResource();
  PutResources();
  for (i=0;i<LANGUAGES;i++) delete resource[i];
  delete common_dlg;
}

Boolean InitResource()
{
  CreateResource();
  return True;
}

#define S(x,lang...) const char *x[LANGUAGES] = {##lang};
#include "StatusLine.h"
#undef S

static void PutStatusLine()
{
  int i;
  TRect r(0,0,79,1);
  TStatusLine *line;
  for (i=0;i<LANGUAGES;i++)
  {
    line = new THintStatusLine( r,
	*new TStatusDef( 0, 99 ) +
	    *new TStatusItem( NULL, kbF1, cmHelp ) +
	    *new TStatusItem( NULL, kbShiftF1, cmHelpIndex ) +
	    *new TStatusItem( SL1_1[i], kbF2, cmSave ) +
	    *new TStatusItem( SL1_2[i], kbF3, cmOpen ) +
	    *new TStatusItem( SL1_3[i], kbF5, cmZoom ) +
	    *new TStatusItem( SL1_4[i], kbF6, cmNext ) +
	    *new TStatusItem( SL1_5[i], kbAltF9, cmCompile ) +
	    *new TStatusItem( SL1_6[i], kbF10, cmMenu ) +
	    *new TStatusItem( SL1_7[i], kbAltX, cmQuit ) +
	    *new TStatusItem( NULL, kbCtrlF5, cmResize )
	+ *new TStatusDef( 100, 255) +
	    *new TStatusItem( NULL, kbF1, cmHelp ) +
	    *new TStatusItem( NULL, kbShiftF1, cmHelpIndex ) +
	    *new TStatusItem( SL2_1[i], kbF1, cmHelp ) +
	    *new TStatusItem( NULL, kbF10, cmMenu )
	+ *new TStatusDef( hcProjectListBox, hcProjectListBox ) +
	    *new TStatusItem( NULL, kbF1, cmHelp ) +
	    *new TStatusItem( NULL, kbShiftF1, cmHelpIndex ) +
	    *new TStatusItem( SL3_1[i], kbIns, cmAddProjectItem ) +
	    *new TStatusItem( SL3_2[i], kbDel, cmDelProjectItem ) +
	    *new TStatusItem( SL3_3[i], RawkbCtrlO, cmLocalOptions ) +
	    *new TStatusItem( SL3_4[i], RawkbCtrlI, cmShowIncludes ) +
	    *new TStatusItem( SL3_5[i], kbF5, cmZoom ) +
	    *new TStatusItem( SL3_6[i], kbAltF9, cmCompile ) +
	    *new TStatusItem( SL3_7[i], kbAltX, cmQuit ) +
	    *new TStatusItem( NULL, kbF10, cmMenu )
	+ *new TStatusDef(  hcMsgListBox, hcMsgListBox ) +
	    *new TStatusItem( NULL, kbF1, cmHelp ) +
	    *new TStatusItem( NULL, kbShiftF1, cmHelpIndex ) +
	    *new TStatusItem( SL4_1[i], kbEnter, cmEnter ) +
	    *new TStatusItem( SL4_2[i], kbF5, cmZoom ) +
	    *new TStatusItem( SL4_3[i], kbF6, cmNext ) +
	    *new TStatusItem( SL4_4[i], kbAltF9, cmCompile ) +
	    *new TStatusItem( SL4_5[i], kbF10, cmMenu ) +
	    *new TStatusItem( SL4_6[i], kbAltX, cmQuit )
	+ *new TStatusDef( hcOptFlagList, hcCXXFlagList ) +
	    *new TStatusItem( NULL, kbF1, cmHelp ) +
	    *new TStatusItem( NULL, kbShiftF1, cmHelpIndex ) +
	    *new TStatusItem( SL6_1[i], kbEsc, cmCancel ) +
	    *new TStatusItem( SL6_2[i], RawkbSpace, cmEnter )
	+ *new TStatusDef( hcWindowList, hcWindowList ) +
	    *new TStatusItem( NULL, kbF1, cmHelp ) +
	    *new TStatusItem( NULL, kbShiftF1, cmHelpIndex ) +
	    *new TStatusItem( SL5_1[i], kbEnter, cmSelectWindow ) +
	    *new TStatusItem( SL5_2[i], kbDel, cmDeleteWindow )
        + *new TStatusDef( hcIDEFileEditor, hcIDEFileEditor ) +
	    *new TStatusItem( NULL, kbF1, cmHelp ) +
	    *new TStatusItem( NULL, kbShiftF1, cmHelpIndex ) +
	    *new TStatusItem( NULL, kbCtrlF1, cmSyntaxHelp ) +
	    *new TStatusItem( SL1_1[i], kbF2, cmSave ) +
	    *new TStatusItem( SL1_2[i], kbF3, cmOpen ) +
	    *new TStatusItem( SL1_3[i], kbF5, cmZoom ) +
	    *new TStatusItem( SL1_4[i], kbF6, cmNext ) +
	    *new TStatusItem( SL1_5[i], kbAltF9, cmCompile ) +
	    *new TStatusItem( SL1_6[i], kbF10, cmMenu ) +
	    *new TStatusItem( SL1_7[i], kbAltX, cmQuit ) +
	    *new TStatusItem( NULL, RawkbCtrlJ, cmGotoLine )
        + *new TStatusDef( hcInfView, hcInfView ) +
	    *new TStatusItem( NULL, kbShiftF1, cmHelpIndex ) +
	    *new TStatusItem( SL7_1[i], kbAltF1, cmInfBack ) +
	    *new TStatusItem( SL7_2[i], kbF1, cmInfHelp ) +
	    *new TStatusItem( SL7_3[i], kbAltF10, cmInfControl ) +
	    *new TStatusItem( SL1_3[i], kbF5, cmZoom)
        , NULL
	);
    AddResource(line,"StatusLine",i);
    delete line;
  }
}

#define m(x,lang...) const char *x[LANGUAGES] = {##lang};
#include "MenuBar.h"
#undef m

static void PutMenuBar()
{
  TMenuBar *bar;
  TRect r(0,23,79,24);
  int i;
  for (i=0;i<LANGUAGES;i++)
  {
    TSubMenu& file_menu = *new TSubMenu( MB1[i], kbAltF ) +
	*new TMenuItem( MB1_1[i], cmOpen, kbF3, hcOpen, "F3" ) +
	*new TMenuItem( MB1_2[i], cmNew, kbNoKey, hcNew ) +
	*new TMenuItem( MB1_3[i], cmSave, kbF2, hcSave, "F2" ) +
	*new TMenuItem( MB1_4[i], cmSaveAs, kbNoKey, hcSaveAs ) +
	*new TMenuItem( MB1_5[i], cmSaveAll, kbNoKey, hcSaveAll ) +
	     newLine() +
	*new TMenuItem( MB1_6[i], cmDosShell, kbNoKey, hcDosShell ) +
	*new TMenuItem( MB1_7[i], cmQuit, kbAltX, hcQuit, "Alt+X" );

      TSubMenu& edit_menu = *new TSubMenu( MB2[i], kbAltE ) +
	*new TMenuItem( MB2_1[i], cmUndo, RawkbAltBack, hcUndo, "Alt+Backspace" ) +
	     newLine() +
	*new TMenuItem( MB2_2[i], cmCut, kbShiftDel, hcCut, "Shift+Del" ) +
	*new TMenuItem( MB2_3[i], cmCopy, kbCtrlIns, hcCopy, "Ctrl+Ins" ) +
	*new TMenuItem( MB2_4[i], cmPaste, kbShiftIns, hcPaste, "Shift+Ins" ) +
	*new TMenuItem( MB2_5[i], cmShowClip, kbNoKey, hcShowClip ) +
	     newLine() +
	*new TMenuItem( MB2_6[i], cmClear, kbCtrlDel, hcClear, "Ctrl+Del" );

      TSubMenu& search_menu = *new TSubMenu( MB3[i], kbAltS ) +
	*new TMenuItem( MB3_1[i], cmFind, kbNoKey, hcFind ) +
	*new TMenuItem( MB3_2[i], cmReplace, kbNoKey, hcReplace ) +
	*new TMenuItem( MB3_3[i], cmSearchAgain, kbNoKey, hcSearchAgain, "Ctrl+L" ) +
	*new TMenuItem( MB3_4[i], cmGotoLine, kbNoKey, hcGotoLine, "Ctrl+J" )+
             newLine() +
	*new TMenuItem( MB3_5[i], cmNextMessage, kbAltF8, hcNextMessage, "Alt+F8")+
	*new TMenuItem( MB3_6[i], cmPrevMessage, kbAltF7, hcPrevMessage, "Alt+F7");

      TSubMenu & run_menu = *new TSubMenu( MB4[i], kbAltR )+
	*new TMenuItem( MB4_1[i], cmRun, kbCtrlF9, hcRun, "Ctrl+F9") +
          *new TMenuItem( MB4_2[i], cmStep, kbF8, hcStep, "F8" )+
          *new TMenuItem( MB4_3[i], cmTrace, kbF7, hcTrace, "F7" )+
          *new TMenuItem( MB4_4[i], cmGoto, kbF4, hcGoto, "F4" )+
          *new TMenuItem( MB4_5[i], cmReset, kbCtrlF2, hcReset, "Ctrl+F2" )+
        newLine() +
	*new TMenuItem( MB4_6[i], cmProgArgs, kbNoKey, hcProgArgs);
      ;

      TSubMenu& compile_menu = *new TSubMenu( MB5[i], kbAltC ) +
	*new TMenuItem( MB5_1[i], cmCompile, kbAltF9, hcCompile, "Alt+F9" ) +
	*new TMenuItem( MB5_2[i], cmMake, kbF9, hcMake, "F9") +
	*new TMenuItem( MB5_3[i], cmLink, kbNoKey, hcLink) +
        *new TMenuItem( MB5_4[i], cmBuild, kbNoKey, hcBuild)
      ;

      TSubMenu& project_menu = *new TSubMenu( MB6[i], kbAltP )+
        *new TMenuItem( MB6_1[i], cmOpenProject, kbNoKey, hcOpenProject ) +
        *new TMenuItem( MB6_2[i], cmCloseProject, kbNoKey, hcCloseProject ) +
	*new TMenuItem( MB6_3[i], cmAddProjectItem, kbNoKey, hcAddProjectItem ) +
	*new TMenuItem( MB6_4[i], cmDelProjectItem, kbNoKey, hcDelProjectItem ) +
	*new TMenuItem( MB6_5[i], cmLocalOptions, kbNoKey, hcLocalOptions ) +
	*new TMenuItem( MB6_6[i], cmShowIncludes, kbNoKey, hcShowIncludes ) +
	     newLine() +
	*new TMenuItem( MB6_7[i], cmTargetName, kbNoKey, hcTargetName) +
	*new TMenuItem( MB6_8[i], cmClearDependencies, kbNoKey, hcClearDependencies) +
	*new TMenuItem( MB6_9[i], cmMakeClear, kbNoKey, hcMakeClear)
      ;
      
      TMenuItem &dir_sub = *new TSubMenu(MB7_1[i], kbNoKey, hcDirectories) +
	*new TMenuItem( MB7_1_1[i], cmIncludeDir, kbNoKey, hcIncludeDir ) +
	*new TMenuItem( MB7_1_2[i], cmLibDir, kbNoKey, hcLibDir ) +
	*new TMenuItem( MB7_1_3[i], cmObjDir, kbNoKey, hcObjDir ) +
	*new TMenuItem( MB7_1_4[i], cmSrcDir, kbNoKey, hcSrcDir )
	;

      TMenuItem &c_compile_sub = *new TSubMenu(MB7_2[i], kbNoKey, hcC_CXXCompiler) +
	  *new TMenuItem( MB7_2_1[i], cmWarningFlags, kbNoKey, hcWarningFlags) +
	  *new TMenuItem( MB7_2_2[i], cmOptimizationFlags, kbNoKey, hcOptimizationFlags) +
	  *new TMenuItem( MB7_2_3[i], cmDebugFlags, kbNoKey, hcDebugFlags ) +
	  *new TMenuItem( MB7_2_4[i], cmCFlags, kbNoKey, hcCFlags ) +
	  *new TMenuItem( MB7_2_5[i], cmCXXFlags, kbNoKey, hcCXXFlags)
	;

      TMenuItem &envi = *new TSubMenu(MB7_6[i], kbNoKey, hcEnvironment) +
	*new TMenuItem( MB7_6_1[i], cmColors, kbNoKey, hcColors ) +
	*new TMenuItem( MB7_6_2[i], cmPreferences, kbNoKey, hcPreferences) +
	*new TMenuItem( MB7_6_3[i], cmEditReserved, kbNoKey, hcEditReserved) +
	*new TMenuItem( MB7_6_4[i], cmEditCFlags, kbNoKey, hcEditCFlags) +
	*new TMenuItem( MB7_6_5[i], cmEditCXXFlags, kbNoKey, hcEditCXXFlags) +
	*new TMenuItem( MB7_6_6[i], cmEditWarnFlags, kbNoKey, hcEditWarnFlags) +
	*new TMenuItem( MB7_6_7[i], cmEditDebugFlags, kbNoKey, hcEditDebugFlags) +
	*new TMenuItem( MB7_6_8[i], cmEditOptFlags, kbNoKey, hcEditOptFlags)+
	*new TMenuItem( MB7_6_9[i], cmEditUserWords, kbNoKey, hcEditUserWords);

      TSubMenu& option_menu = *new TSubMenu( MB7[i], kbAltO ) +
	dir_sub + c_compile_sub +
	*new TMenuItem( MB7_3[i], cmLibraries, kbNoKey, hcLibraries ) +
	*new TMenuItem( MB7_4[i], cmLinkerOptions, kbNoKey, hcLinkerOptions ) +
	*new TMenuItem( MB7_5[i], cmCompilerOptions, kbNoKey, hcCompilerOptions ) +
	envi +
	     newLine() +
	*new TMenuItem( MB7_7[i], cmWriteMake, kbNoKey, hcWriteMake )
	;
	
      TSubMenu& window_menu = *new TSubMenu( MB8[i], kbAltW ) +
	*new TMenuItem( MB8_1[i], cmResize, kbCtrlF5, hcResize, "Ctrl+F5" ) +
	*new TMenuItem( MB8_2[i], cmZoom, kbF5, hcZoom, "F5" ) +
	*new TMenuItem( MB8_3[i], cmTile, kbNoKey, hcTile ) +
	*new TMenuItem( MB8_4[i], cmCascade, kbNoKey, hcCascade ) +
	*new TMenuItem( MB8_5[i], cmNext, kbF6, hcNext, "F6" ) +
	*new TMenuItem( MB8_6[i], cmPrev, kbShiftF6, hcPrev, "Shift+F6" ) +
	*new TMenuItem( MB8_7[i], cmClose, kbAltF3, hcClose, "Alt+F3" ) +
	*new TMenuItem( MB8_8[i], cmShowWindowList, kbAlt0, hcShowWindowList, "Alt+0" ) +
	*new TMenuItem( MB8_9[i], cmShowProject, kbNoKey, hcShowProject) +
	     newLine() +
	*new TMenuItem( MB8_10[i], cmUserScreen, kbAltF5, hcUserScreen, "Alt+F5" );

      TSubMenu& space_menu = *new TSubMenu( MB0[i], kbAltSpace ) +
	*new TMenuItem( MB0_1[i], cmAbout, kbNoKey, hcAbout ) +
	     newLine() +
	*new TMenuItem( MB0_2[i], cmFSDB, kbNoKey, hcFSDB ) +
	*new TMenuItem( MB0_3[i], cmGREP, kbShiftF2, hcGREP, "Shift+F2" ) +
	*new TMenuItem( MB0_4[i], cmGDB, kbNoKey, hcGDB ) +
	     newLine() +
	*new TMenuItem( MB0_5[i], cmRepaint, kbNoKey, hcRepaint ) +
	*new TMenuItem( MB0_6[i], cmHelp, kbF1, hcHelp );

    bar = new TMenuBar( r,
	space_menu +
	file_menu +
	edit_menu +
	search_menu +
	run_menu +
	compile_menu +
	project_menu +
        option_menu +
	window_menu );

    AddResource(bar,"MenuBar",i);
    delete bar;
  }
}

#define F(x) x,
static char *c_flags[] = {
  #include "flags/c_opt.h"
  NULL
};

static char *cxx_flags[] = {
  #include "flags/cxx_opt.h"
  NULL
};

static char *warn_flags[] = {
  #include "flags/warn_opt.h"
  NULL
};

static char *opt_flags[] = {
  #include "flags/opt_opt.h"
  NULL
};

static char * debug_flags[] = {
  #include "flags/deb_opt.h"
  NULL
};

static char *reserved[] = {
  #include "flags/reserved.h"
  NULL
};

#undef F

static void InitOptions(char *opts[],TFlagCollection * & coll)
{
  int i;
  coll = new TFlagCollection();
  i = 0;
  while (opts[i])
  {
    coll->insert(new TFlagEntry(opts[i]));
    i++;
  }
}

static void PutFlags(char *def[],const char *name)
{
  TFlagCollection *flags;
  InitOptions(def,flags);
  AddResource(flags,name,-1);
  delete flags;
}

#define df(flags,name) PutFlags(flags,name)

static void PutFlags()
{
  df(opt_flags,"OptFlags");
  df(debug_flags,"DebugFlags");
  df(warn_flags,"WarnFlags");
  df(cxx_flags,"CXXFlags");
  df(c_flags,"CFlags");
}

TFlagCollection * GetOptFlags()
{
  return NULL;
}

TFlagCollection * GetDebugFlags()
{
  return NULL;
}

TFlagCollection * GetWarnFlags()
{
  return NULL;
}

TFlagCollection * GetCXXFlags()
{
  return NULL;
}

TFlagCollection * GetCFlags()
{
  return NULL;
}

static void PutReservedWords()
{
  TStringCollection *words;
  int i;
  ccIndex index;
  words = new TStringCollection(1,1);
  i = 0;
  while (reserved[i])
  {
    if (words->search(reserved[i],index) == False)
      words->insert(newStr(reserved[i]));
    i++;
  }
  AddResource(words,"ReservedWords",-1);
  delete words;
}

TStringCollection *GetReservedWords()
{
  return NULL;
}

class TString : public TStreamable
{
public:
  char *string;
  TString(const char *s) : string(newStr(s)) {};
  TString() : string(NULL) {};
  static TStreamable * build() { return new TString(); }
  virtual ~TString() { if (string) delete string; }
  static const char * const name = "\xFF";
protected:
  virtual const char * const streamableName() const { return name;}
  virtual void write(opstream & os) { os.writeString(string); }
  virtual void * read(ipstream & is) { string = is.readString(); return this;}
};

s(String)

static const char * KeyString(const char *prefix,ushort key)
{
  static char buffer[20];
  sprintf(buffer,"%s%04X",prefix,key);
  return buffer;
}

typedef struct {
  ushort index;
  char *hints[LANGUAGES];
} HINTREC;

HINTREC HINTA;

#define h(x,lang...) {hc##x,{##lang}},

static HINTREC HINTS[] = {
  #include "Hints.h"
  HINTA
};
#undef h
#define HINTCOUNT ((sizeof(HINTS) / sizeof(struct HINTREC))-1)

static void PutStrings()
{
  int count = HINTCOUNT,j,i;
  TString *s;
  for (j=0;j<count;j++)
  {
    for (i=0;i<LANGUAGES;i++)
    {
      s = new TString(HINTS[j].hints[i]);
      AddResource(s,KeyString("",HINTS[j].index),i);
      delete s;
    }
  }
}

const char * GetHint(ushort ctx)
{
  if (!ctx) return "";
  else return "";
}

#define c(x,lang...) const char *x[LANGUAGES] = {##lang};
#include "ColorDialog.h"
#undef c
TColorDialog * GetColorDialog()
{
  return NULL;
}

static void PutColorDialog()
{
  TColorDialog *c;
  int i;
  for (i=0;i<LANGUAGES;i++)
  {
    TColorGroup &group0 =
        *new TColorGroup(CG0[i]) +
            *new TColorItem(CG0_1[i],  1);

    TColorGroup &group1 =
        *new TColorGroup(CG1[i]) +
            *new TColorItem(CG1_1[i],  2)+
            *new TColorItem(CG1_2[i],  3)+
            *new TColorItem(CG1_3[i],  4)+
            *new TColorItem(CG1_4[i],  5)+
            *new TColorItem(CG1_5[i],  6)+
            *new TColorItem(CG1_6[i],  7
        );

    TColorGroup &group2 =
	*new TColorGroup(CG2[i]) +
	    *new TColorItem(CG2_1[i],  8)+
	    *new TColorItem(CG2_2[i],  9)+
	    *new TColorItem(CG2_3[i], 10)+
	    *new TColorItem(CG2_4[i], 11)+
	    *new TColorItem(CG2_5[i], 12)+
	    *new TColorItem(CG2_6[i], 13)+
	    *new TColorItem(CG2_7[i], 14)+
	    *new TColorItem(CG2_8[i], 15);

#if 0
    TColorGroup &group3 =
	*new TColorGroup(CG3[i]) +
	    *new TColorItem(CG3_1[i], 16)+
	    *new TColorItem(CG3_2[i], 17)+
	    *new TColorItem(CG3_3[i], 18)+
	    *new TColorItem(CG3_4[i], 19)+
	    *new TColorItem(CG3_5[i], 20)+
	    *new TColorItem(CG3_6[i], 21)+
	    *new TColorItem(CG3_7[i], 22)+
	    *new TColorItem(CG3_8[i], 23);
#endif
    TColorGroup &group4 =
	*new TColorGroup(CG4[i]) +
	    *new TColorItem(CG4_1[i], 24)+
	    *new TColorItem(CG4_2[i], 25)+
	    *new TColorItem(CG4_3[i], 26)+
	    *new TColorItem(CG4_4[i], 27)+
	    *new TColorItem(CG4_5[i], 28)+
	    *new TColorItem(CG4_6[i], 29)+
	    *new TColorItem(CG4_7[i], 30)+
	    *new TColorItem(CG4_8[i], 31);

    TColorGroup &group5 =
        *new TColorGroup(CG5[i]) +
	    *new TColorItem(CG5_1[i], 32)+
            *new TColorItem(CG5_2[i], 33)+
            *new TColorItem(CG5_3[i], 34)+
            *new TColorItem(CG5_4[i], 35)+
            *new TColorItem(CG5_5[i], 36)+
            *new TColorItem(CG5_6[i], 37)+
            *new TColorItem(CG5_7[i], 38)+
            *new TColorItem(CG5_8[i], 39)+
            *new TColorItem(CG5_9[i], 40)+

            *new TColorItem(CG5_10[i],41)+
            *new TColorItem(CG5_11[i],42)+
            *new TColorItem(CG5_12[i],43)+
            *new TColorItem(CG5_13[i],44)+
            *new TColorItem(CG5_14[i],45)+
            *new TColorItem(CG5_15[i],46)+
            *new TColorItem(CG5_16[i],47)+
            *new TColorItem(CG5_17[i],48)+
            *new TColorItem(CG5_18[i],49)+

            *new TColorItem(CG5_19[i],50)+
            *new TColorItem(CG5_20[i],51)+
            *new TColorItem(CG5_21[i],52)+
            *new TColorItem(CG5_22[i],53)+
            *new TColorItem(CG5_23[i],54)+
            *new TColorItem(CG5_24[i],55)+
            *new TColorItem(CG5_25[i],56)+
            *new TColorItem(CG5_26[i],57)+
            *new TColorItem(CG5_27[i],58)+
            *new TColorItem(CG5_28[i],59)+
            *new TColorItem(CG5_29[i],60)+
            *new TColorItem(CG5_30[i],61);

    TColorGroup &group6 =
	*new TColorGroup(CG6[i]) +
	    *new TColorItem(CG6_1[i], 64)+
	    *new TColorItem(CG6_2[i], 65)+
	    *new TColorItem(CG6_3[i], 66)+
	    *new TColorItem(CG6_4[i], 67)+
	    *new TColorItem(CG6_5[i], 68)+
	    *new TColorItem(CG6_6[i], 69)+
	    *new TColorItem(CG6_7[i], 70)+
	    *new TColorItem(CG6_8[i], 71)+
	    *new TColorItem(CG6_9[i], 72)+
	    *new TColorItem(CG6_10[i],73)+
	    *new TColorItem(CG6_11[i],74)+
	    *new TColorItem(CG6_12[i],75)+
	    *new TColorItem(CG6_13[i],76)+
	    *new TColorItem(CG6_14[i],77)+
	    *new TColorItem(CG6_15[i],62);

    TColorGroup &group = group0 + group1 + group2 + 
#if 0    
                                           group3 +
#endif                                           
                                                    group4 + group5 + group6;

    c = new TColorDialog(&TProgram::application->getPalette(), &group );
    AddResource(c,"ColorDialog",i);
    delete c;
  }
}

#define L(x,lang...) {##lang},

static char *ST[LANGUAGES];

static char * STATICTEXTE[][LANGUAGES] = {
  #include "Lang.h"
  ST
};
#undef L

#define STATICCOUNT ((sizeof(STATICTEXTE) / (LANGUAGES*sizeof(char *))) -1)

static void PutStaticTexte()
{
  int i,j,count=STATICCOUNT;
  TString *s;
  for (j=0;j<count;j++)
  {
    for (i=0;i<LANGUAGES;i++)
    {
      s = new TString(STATICTEXTE[j][i]);     
      AddResource(s,KeyString("S",(ushort)j),i);
      delete s;
    }
  }
}

const char * GetLangText(LangTextType what)
{
  if (!what) return "";
  else return "";
}


#define T(x,lang...) {##lang},

static char *_LANGTEXT[LANGUAGES];

static char *LANGTEXTE[][LANGUAGES] = {
  #include "Texte.h"
  _LANGTEXT
};

#undef T

#define LANGCOUNT ((sizeof(LANGTEXTE) / (LANGUAGES*sizeof(char *))) -1)

static void PutLangTexte()
{
  int i,j,count = LANGCOUNT;
  TString *s;
  for (j=0;j<count;j++)
  {
    for (i=0;i<LANGUAGES;i++)
    {
      s = new TString(LANGTEXTE[j][i]);
      AddResource(s,KeyString("T",(ushort)j),i);
      delete s;
    }
  }
}

static void PutResources()
{
  PutMenuBar();
  PutStatusLine();
  PutFlags();
  PutReservedWords();
  PutStrings();
  PutColorDialog();
  PutLangTexte();
  PutStaticTexte();
}

