/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
#include <stdio.h>
#include <stdarg.h>
#include <sys/fsext.h>
#include <string.h>
#include <stdlib.h>
#include <go32.h>
#include <dpmi.h>
#include <sys/farptr.h>
#define Uses_TEditWindow
#define Uses_TFileEditor
#include <IDEClass.h>
#include "IDE.h"
#include "IDE21.h"
#include <ctype.h>

#define maxfiles 50
typedef TEditWindow *PEditWindow;
static PEditWindow files[maxfiles];
static long bufptr[maxfiles];
static long bufcount[maxfiles];
static int filecount = 0;
static int fds[maxfiles];
static int last_handle = 100;

#ifdef DEBUG_PIPE
char BUFFER[60000UL];
int BUFPTR = 0;
#endif

static int
mem_ioctl(__dpmi_regs *r)
{
  int i;
  if (r->h.al != 0) return 0;
  for (i=0;i<filecount;i++)
  {
    if (fds[i] == r->x.bx) break;
  }
  if (i>=filecount) return 0;
  r->x.dx = 0x60;
  r->x.flags &= 0xFFFE;
  return 1;
}

static int
mem_open(__dpmi_regs *r)
{
  char fn[PATH_MAX],*_fn;
  _fn = fn;
  *_fn = 0;
  unsigned long buffer = ((unsigned long)(r->x.ds))*16+r->x.dx;
  int handle;
  while ((*_fn++ = tolower(_farpeekb(_dos_ds,buffer++))) != 0);
  TEditWindow *found;
  found = is_on_desktop(fn);
  if (!found) return 0;
  _fn = strrchr(fn,'.');
  /* do not handle .h-files */
  if (_fn && _fn[1] == 'h' && _fn[2] == 0) return 0;
  handle = last_handle;
  last_handle++;
  filecount++;
  fds[filecount-1] = handle;
  bufptr[filecount-1] = 0;
  files[filecount-1] = found;
  bufcount[filecount-1] = found->editor->bufLen;
  r->x.ax = handle;
  r->x.flags &= 0xFFFE;
  return 1;
}

static int
mem_read(__dpmi_regs *r)
{
  int fd = r->x.bx;
  unsigned long buffer = ((unsigned long)r->x.ds)*16+r->x.dx;
  int len = r->x.cx;
  int rr = 0;
  int i;
  long aktbufptr = 0;
  long aktbuflen = 0;
  TEditor *editor;
  for (i=0;i<filecount;i++)
  {
    if (fds[i] == fd)
    {
      aktbufptr = bufptr[i];
      aktbuflen = bufcount[i];
      break;
    }
  }
  if (i >= filecount) return 0;
  editor = files[i]->editor;
  while (len && aktbufptr < aktbuflen)
  {
    unsigned char c = editor->bufChar(aktbufptr++);
    _farpokeb(_dos_ds,buffer++,c);
#ifdef DEBUG_PIPE
    BUFFER[BUFPTR++] = c;
#endif
    len--;
    rr++;
  }
  bufptr[i] = aktbufptr;
  r->x.ax = rr;
  r->x.flags &= 0xFFFE;
  return 1;
}

static int
mem_write(__dpmi_regs *r)
{
  int fd = r->x.bx;
  int i;
  for (i=0;i<filecount;i++)
  {
    if (fds[i] == fd) break;
  }
  if (i >= filecount) return 0;
  r->x.ax = 6;
  r->x.flags |= 0x0001;
  return 1;
}

static int
mem_close(__dpmi_regs *r)
{
  int fd = r->x.bx;
  int i;
  for (i=0;i<filecount;i++)
  {
    if (fds[i] == fd) break;
  }
  if (i >= filecount) return 0;
  filecount--;
  r->x.flags &= 0xFFFE;
  return 1;
}

static int mem_seek(__dpmi_regs *r)
{
  int fd = r->x.bx;
  int i,error=0;
  long new_pos,aktbufptr,aktbuflen;
  for (i=0;i<filecount;i++)
  {
    if (fds[i] == fd) break;
  }
  if (i >= filecount) return 0;
  aktbufptr = bufptr[i];
  aktbuflen = bufcount[i];
  new_pos = (((long)r->x.cx) << 16) + r->x.dx;
  if (r->h.al > 2) return 0;
  if (r->h.al == 0)
  {
    if (new_pos >= aktbuflen) error = 1;
  }
  if (r->h.al == 1)
  {
    new_pos += aktbufptr;
    if (new_pos >= aktbufptr) error = 1;
  }
  if (r->h.al == 2)
  {
    new_pos = aktbufptr - new_pos;
    if (new_pos < 0) error = 1;
  }
  if (error == 0)
  {
    bufptr[i] = new_pos;
    r->x.flags &= 0xFFFE;
    r->x.dx = new_pos >> 16;
    r->x.ax = new_pos & 0xFFFF;
  }
  else
  {
    r->x.ax = 25;
    r->x.flags |= 0x0001;
  }
  return 1;
}

void InitPipe()
{
  handle_open = mem_open;
  handle_close = mem_close;
  handle_read = mem_read;
  handle_write = mem_write;
  handle_seek = mem_seek;
  handle_ioctl = mem_ioctl;
  filecount = 0;
}

