/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
#define Uses_TDirList
#define Uses_TParamList
#define Uses_TOptions
#define Uses_TProject
#define Uses_TSCollection
#define Uses_TDepCollection

#define Uses_TProgram
#define Uses_TEditor
#define Uses_TDeskTop
#define Uses_MsgBox
#define Uses_TDialog
#define Uses_TEvent
#define Uses_TCheckBoxes
#define Uses_TSItem
#define Uses_TButton
#define Uses_TInputLine
#define Uses_TRangeValidator
#define Uses_TLabel
#define Uses_TRadioButtons
#define Uses_TScrollBar
#define Uses_TFlagEntry
#define Uses_TFlagCollection
#define Uses_TFlagListBox
#define Uses_TStringCollection
#define Uses_TScreen
#define Uses_TKeys
#define Uses_LangTexte
#define Uses_IDEConst

#include <IDEClass.h>
#include "IDE.h"
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

void InitOptions()
{
  DefaultOptFlags();
  DefaultDebugFlags();
  DefaultWarnFlags();
  DefaultCXXFlags();
  DefaultCFlags();
  DefaultReservedWords();
  AutoIndent = 1;
  CreateBackupFiles = 0;
  TEditor::editorFlags &= ~efBackupFiles;
  ShowSyntax = 1;
  OverWrite = 0;
  UseHook21 = 0;
  SaveBeforeCompiling = 1;
  TEditor::tabSize = 8;
}

ushort EditParamList(TParamList *paramlist,const char * title)
{
  ushort result;
  Boolean retval = False;
  char *tmp,temp[1000]; // 1000 should be enough
  TParamList *pl;
  paramlist->ToString(tmp);
  strcpy(temp,tmp);
  string_free(tmp);
  pl = new TParamList();
  do
  {
    result = inputBox(title,GT(LabelParameter),temp,999);
    if (result == cmOK)
    {
      retval = pl->FromString(temp);
      if (retval == False)
      {
        messageBox(GT(TextUnmatchedQuote),
          mfError | mfOKButton);
      }
    }
  } while (result == cmOK && retval == False);
  delete pl;
  if (result == cmOK) paramlist->FromString(temp);
  return result;
}

void EditDirList(TDirList *dirlist,const char * title)
{
  ushort result;
  char *tmp,temp[1000];
  dirlist->ToString(tmp);
  strcpy(temp,tmp);
  string_free(tmp);
  result = inputBox(title,GT(LabelPathlist),temp,999);
  if (result == cmOK)
  {
    BackslashToSlash(temp);
    dirlist->FromString(temp);
  }
}

static void Flags(const char *title,TFlagCollection * & coll,ushort ctx)
{
  TDialog *dialog;
  TFlagListBox *liste;
  TFlagCollection * _coll;
  TScrollBar *scrollbar;
  int i;
  ushort control;
  dialog = new TDialog(TRect(0,0,70,20),title);
  dialog->options |= ofCentered;
  dialog->helpCtx = ctx;
  scrollbar = new TScrollBar(TRect(69,1,70,16));
  liste = new TFlagListBox(TRect(1,1,69,16),1,scrollbar);

  liste->helpCtx = 0;

  dialog->insert(scrollbar);
  _coll = new TFlagCollection();
  for (i=0;i<coll->getCount();i++)
  {
    _coll->insert(new TFlagEntry((TFlagEntry *)coll->at(i)));
  }
  liste->newList(_coll);
  dialog->insert(liste);
  dialog->insert(new TButton(TRect(5,17,15,19),GT(ButtonOK),cmOK,bfDefault));
  liste->select();
  control = TProgram::deskTop->execView(dialog);
  if (control == cmOK)
  {
    delete coll;
    coll = _coll;
  }
  else delete _coll;
  delete dialog;
}    

void OptimizationFlags()
{
  Flags(GT(TitleOptFlags),Options.opt_flags,hcOptFlagList);
}

void WarningFlags(void)
{
  Flags(GT(TitleWarnFlags),Options.warn_flags,hcWarnFlagList);
}

void DebugFlags(void)
{
  Flags(GT(TitleDebFlags),Options.debug_flags,hcDebFlagList);
}

void CXXFlags(void)
{
  Flags(GT(TitleCXXFlags),Options.cxx_flags,hcCXXFlagList);
}

void CFlags(void)
{
  Flags(GT(TitleCFlags),Options.c_flags,hcCFlagList);
}

static void AddFlags(TSCollection & args,TFlagCollection * flags)
{
  int i;
  char *tmp;
  for (i=0;i<flags->getCount();i++)
  {
    tmp = ((TFlagEntry *)flags->at(i))->GetValue();
    if (tmp) args.insert(tmp);
  }
}

void AddOptimizationFlags(TSCollection & args)
{
  AddFlags(args,Options.opt_flags);
}

void AddWarningFlags(TSCollection & args)
{
  AddFlags(args,Options.warn_flags);
}

void AddDebugFlags(TSCollection & args)
{
  AddFlags(args,Options.debug_flags);
}

void AddCFlags(TSCollection & args)
{
  AddFlags(args,Options.c_flags);
}

void AddCXXFlags(TSCollection & args)
{
  AddFlags(args,Options.cxx_flags);
}

void AddLibraries(TSCollection &args)
{
  int iostr_flag = 0;
  int bison_flag = 0;
  int flex_flag = 0;
  int objc_flag = 0;
  int i;
  char *tmp;
  if (NoStdLib)
  {
    string_dup(tmp,"-nostdlib");
    args.insert(tmp);
  }
  for (i=0;i<Options.user_libs->getCount();i++)
  {
    if (Options.libs & (1<<i))
    {
      string_dup(tmp,"-l");
      string_cat(tmp,(char *)(Options.user_libs->at(i)));
      args.insert(tmp);
    }
  }
  if (ForProfile)
  {
    string_dup(tmp,"-pg");
    args.insert(tmp);
  }
  if (NoStdLib) return;
  for (i=0;i<Project.dependencies->getCount();i++)
  {
    switch (((TDependency *)Project.dependencies->at(i))->compile_id)
    {
      case COMPILE_CC:
	iostr_flag = 1;
	break;
      case COMPILE_BISON:
	bison_flag = 1;
	break;
      case COMPILE_FLEX:
	flex_flag = 1;
	break;
      case COMPILE_OBJC:
        objc_flag = 1;
      default:
        break;
    }
  }
  if (objc_flag)
  {
    string_dup(tmp,"-lobjc");
    args.insert(tmp);
  }
  if (bison_flag)
  {
    string_dup(tmp,"-lbison");
    args.insert(tmp);
  }
  if (flex_flag)
  {
    string_dup(tmp,"-lfl");
    args.insert(tmp);
  }
  if (iostr_flag)
  {
    string_dup(tmp,"-liostr");
    args.insert(tmp);
  }
}

class TArrowInputLine : public TInputLine
{
public:
  int up,down;
  TArrowInputLine(const TRect & rect,int alimit,int allowup=0,int allowdown=0) :
    TInputLine(rect,alimit), up(allowup), down(allowdown) {}
  virtual void handleEvent(TEvent &);
};

void TArrowInputLine::handleEvent(TEvent & event)
{
  TInputLine::handleEvent(event);
  switch (event.what)
  {
    case evKeyDown:
      switch (event.keyDown.keyCode)
      {
        case kbUp:
          if (up)
          {
            event.keyDown.keyCode = kbShiftTab;
            return;
          }
          break;
        case kbDown:
          if (down)
          {
            event.keyDown.keyCode = kbTab;
            return;
          }
          break;
        default:
          break;
      }
    default:
      break;
  }
}

void Libraries(void)
{
  TDialog *dialog;
  TRect r(0,0,40,23);
  TCheckBoxes *chk,*chk1;
  ushort control,flags,stdlibs;
  char data[28];
  int i,libcount=Options.user_libs->getCount();
  TInputLine *libs[16];
  dialog = new TDialog(r,GT(TitleLibraries));
  dialog->options |= ofCentered;
  r = TRect(2,1,8,17);
  chk = new TCheckBoxes(r,new TSItem("~0~",
			  new TSItem("~1~",
			  new TSItem("~2~",
			  new TSItem("~3~",
			  new TSItem("~4~",
			  new TSItem("~5~",
			  new TSItem("~6~",
			  new TSItem("~7~",
			  new TSItem("~8~",
			  new TSItem("~9~",
			  new TSItem("~A~",
			  new TSItem("~B~",
			  new TSItem("~C~",
			  new TSItem("~D~",
			  new TSItem("~E~",
			  new TSItem("~F~",NULL)))))))))))))))));
  flags = Options.libs;
  chk->setData(&flags);
  dialog->insert(chk);
  r.a.x=r.b.x;
  r.b.x=r.a.x+29;
  r.b.y=r.a.y+1;
  for (i=0;i<16;i++)
  {
    libs[i] = new TArrowInputLine(r,27,(i == 0 ? 0 : 1),(i == 15 ? 0 : 1));
    if (libcount>i)
    {
      strncpy(data,(char *)(Options.user_libs->at(i)),27);
      data[27] = EOS;
      libs[i]->setData(data);
    }
    dialog->insert(libs[i]);
    r.move(0,1);
  }

  r.a.x = 2;
  r.b.x = r.a.x + 35;
  r.b.y = r.a.y + 2;
  chk1 = new TCheckBoxes(r,new TSItem(GT(TextUseStdLibs),
                           new TSItem(GT(TextForProfile),NULL)));
  stdlibs = NoStdLib ? 0 : 1;
  if (ForProfile) stdlibs |= 2;
  chk1->setData(&stdlibs);
  dialog->insert(chk1);
  
  r.move(0,3);
  r.a.x = 2;
  r.b.x = r.a.x+14;
  r.b.y = r.a.y+2;
  dialog->insert(new TButton(r,GT(ButtonOK),cmOK,bfDefault));
  r.move(10,0);
  libs[0]->select();
  control = TProgram::deskTop->execView(dialog);
  if (control == cmOK)
  {
    char *tmp;
    chk1->getData(&stdlibs);
    if (stdlibs & 1) NoStdLib = 0;
    else NoStdLib = 1;
    if (stdlibs & 2) ForProfile = 1;
    else ForProfile = 0;
    Options.user_libs->freeAll();
    for (i=0;i<16;i++)
    {
      libs[i]->getData(data);
      string_dup(tmp,data);
      Options.user_libs->insert(tmp);
    }
    chk->getData(&flags);
    Options.libs = flags;
  }
  delete dialog;
}

void LinkerOptions()
{
  EditParamList(Options.link_opt,GT(TitleExtraLinkOpt));
}

void CompilerOptions()
{
  EditParamList(Options.comp_opt,GT(TitleExtraCOpt));
}

static void AddParams(TSCollection &args,TParamList *params)
{
  int i;
  char *tmp;
  for (i=0;i<params->getCount();i++)
  {
    string_dup(tmp,(char *)(params->at(i)));
    args.insert(tmp);
  }
}

void AddLinkerOptions(TSCollection &args)
{
  int i;
  char *tmp;
  for (i=0;i<Options.link_opt->getCount();i++)
  {
    string_dup(tmp,"-Xlinker");
    args.insert(tmp);
    string_dup(tmp,(char *)(Options.link_opt->at(i)));
    args.insert(tmp);
  }
}

void AddCompilerOptions(TSCollection &args)
{
  AddParams(args,Options.comp_opt);
}

void AddLocalOptions(TSCollection &args,TDependency *dep)
{
  if (dep->local_options->getCount() == 0) return;
  AddParams(args,dep->local_options);
}
  
void Preferences()
{
  TDialog *dialog;
  TCheckBoxes *cluster;
  TInputLine *tab;
  TRadioButtons *radio;
  TInputLine *usermode;
  char tabstring[10];
  ushort radiodata,oldmode;
  ushort options = Options.debug_level;
  int do_it;
  dialog = new TDialog(TRect(0,0,60,19),GT(TitleEnvOpt));
  cluster = new TCheckBoxes(TRect(3,3,33,13),
                   new TSItem(GT(ItemHook),
		   new TSItem(GT(ItemBackup),
		   new TSItem(GT(ItemSyntax),
		   new TSItem(GT(ItemSaveBefore),
		   new TSItem(GT(ItemAutoIndent),
		   new TSItem(GT(ItemOverWrite),
		   new TSItem(GT(ItemStderr),
		   new TSItem(GT(ItemStdout),
		   new TSItem(GT(ItemShowDoing),
		   new TSItem(GT(ItemShowMem),
		 NULL)))))))))));
  radio = new TRadioButtons(TRect(35,3,55,10),new TSItem(GT(Item80x25),
  					     new TSItem(GT(Item80x28),
  					     new TSItem(GT(Item80x35),
  					     new TSItem(GT(Item80x40),
  					     new TSItem(GT(Item80x43),
  					     new TSItem(GT(Item80x50),
  					     new TSItem(GT(ItemUserMode),
  					     NULL))))))));
  usermode = new TInputLine(TRect(35,10,55,11),6);
  radiodata = 0;
  switch ((oldmode = TScreen::getCrtMode()))
  {
    case 0x503: radiodata++;
    case 0x403: radiodata++;
    case 0x303: radiodata++;
    case 0x203: radiodata++;
    case 0x103: radiodata++;
    case 0x003:
      break;
    default:
      radiodata = 6;
      break;
  }
  sprintf(tabstring,"0x%x",oldmode);
  radio->setData(&radiodata);
  usermode->setData(tabstring);
  sprintf(tabstring,"%d",TEditor::tabSize);
  dialog->insert(new TLabel(TRect(3,2,20,3),GT(LabelOptions),cluster));
  dialog->insert(cluster);
  cluster->setData(&options);
  
  dialog->insert(new TLabel(TRect(35,2,55,3),GT(LabelScreenMode),radio));
  dialog->insert(radio);
  dialog->insert(usermode);

  tab = new TInputLine(TRect(13,14,19,15),4);
  tab->setData(tabstring);
  tab->SetValidator(new TRangeValidator(1,100));
  dialog->insert(tab);
  dialog->insert(new TLabel(TRect(3,14,11,15),GT(LabelTabSize),tab));

  dialog->insert(new TButton(TRect(3,16,18,18),GT(ButtonOK),cmOK,bfDefault));
  dialog->insert(new TButton(TRect(21,16,36,18),GT(ButtonCancel),cmCancel,bfNormal));

  dialog->options |= ofCentered;
  cluster->select();
  do_it = 1;
  while (do_it && TProgram::deskTop->execView(dialog) == cmOK)
  {
    int syntax = ShowSyntax;
    uint32 old_tabsize = TEditor::tabSize;
    int must_redraw = 0;
    ushort rdata;
    do_it = 0;
    radio->getData(&rdata);
    radiodata = 0x003;
    switch (rdata)
    {
      case 5: radiodata += 0x100;
      case 4: radiodata += 0x100;
      case 3: radiodata += 0x100;
      case 2: radiodata += 0x100;
      case 1: radiodata += 0x100;
        break;
      case 6:
      {
        int mode;
        usermode->getData(tabstring);
        sscanf(tabstring,"%d",&mode);
        if (mode == 0) sscanf(tabstring,"0x%x",&mode);
        if (mode == 0) sscanf(tabstring,"0x%X",&mode);
        if (mode == 0) mode = oldmode;
        radiodata = mode;
        break;
      }
      default:
        radiodata = 0x003;
        break;
    }
    cluster->getData(&options);
    tab->getData(tabstring);
    sscanf(tabstring,"%d",&TEditor::tabSize);
    if (old_tabsize != TEditor::tabSize) must_redraw = 1;
    Options.debug_level = options;
    if (CreateBackupFiles)
    {
      TEditor::editorFlags |= efBackupFiles;
    }
    else
    {
      TEditor::editorFlags &= ~efBackupFiles;
    }
    if (syntax && !ShowSyntax || !syntax && ShowSyntax) must_redraw = 1;
    if (oldmode != radiodata)
    {
      TProgram::application->setScreenMode(radiodata);
      must_redraw = 1;
    }
    if (must_redraw)
    {
      Repaint();
    }
    if (TScreen::getCrtMode() != radiodata)
    {
      messageBox(mfError | mfOKButton,
                 "This video mode (0x%03x) is not supported by the "
                 "Turbo Vision library",radiodata);
      do_it = 1;
      usermode->select();
    }
  }
  delete(dialog);
}

class MyDialog : public TDialog
{
public:
  MyDialog(const char *,Boolean);
  virtual void handleEvent(TEvent &);
};

const ushort
  cmAddEntry = 9999,
  cmDelEntry = 9998,
  cmEditEntry = 9997,
  cmDefaultEntry = 9996;

MyDialog::MyDialog(const char *tit,Boolean with_default) :
  TDialog(TRect(0,0,60,21),tit),
  TWindowInit(MyDialog::initFrame)
{
  TRect r;
  options |= ofCentered;
  r = getExtent();
  r.a.x += 3;
  r.b.x = r.a.x + 10;
  r.b.y -= 3;
  r.a.y = r.b.y - 2;
  insert(new TButton(r,GT(ButtonOK),cmOK,bfNormal));
  r.move(11,0);
  insert(new TButton(r,GT(ButtonAdd),cmAddEntry,bfNormal));
  r.move(11,0);
  insert(new TButton(r,GT(ButtonDel),cmDelEntry,bfNormal));
  r.move(11,0);
  insert(new TButton(r,GT(ButtonEdit),cmEditEntry,bfDefault));
  r.move(11,0);
  insert(new TButton(r,GT(ButtonCancel),cmCancel,bfNormal));
  r.move(-22,2);
  if (with_default == True)
    insert(new TButton(r,GT(ButtonDefault),cmDefaultEntry,bfNormal));
}

void MyDialog::handleEvent(TEvent &event)
{
  TDialog::handleEvent(event);
  if (event.what == evCommand)
  {
    switch (event.message.command)
    {
      case cmAddEntry:
      case cmDelEntry:
      case cmEditEntry:
      case cmDefaultEntry:
        endModal(event.message.command);
        clearEvent(event);
        return;
      default:
        break;
    }
  }
}

static void UpdateListBox(TListBox *box,TCollection *list)
{
  ccIndex Count;
  Count = list->getCount();
  box->setRange(Count);
  if (box->focused >= Count)
  {
    if (Count > 0) box->focusItem(Count-1);
  }
  else
  {
    box->focusItem(box->focused);
  }
  box->drawView();
}

static ushort EditStringList(const char *title,TSCollection *list,
				Boolean with_default = True)
{
  MyDialog *dialog;
  TListBox *box;
  TScrollBar *scrollbar;
  TRect r;
  ushort result;
  char buffer[256];
  dialog = new MyDialog(title,with_default);
  r = dialog->getExtent();
  r.a.x = r.b.x-1;
  r.a.y++;
  r.b.y -= 6;
  scrollbar = new TScrollBar(r);
  r = dialog->getExtent();
  r.grow(-1,-1);
  r.b.y -= 5;
  box = new TListBox(r,1,scrollbar);
  box->newList(list);
  dialog->insert(scrollbar);
  dialog->insert(box);
  TProgram::deskTop->insert(dialog);
  do
  {
    dialog->setState(sfModal,True);
    result = dialog->execute();
    switch (result)
    {
      case cmDelEntry:
        if (list->getCount() == 0) break;
        list->atFree(box->focused);
        UpdateListBox(box,list);
        break;
      case cmAddEntry:
        buffer[0] = 0;
        if (inputBox(GT(TitleNewValue),GT(LabelNewValue),buffer,255) == cmOK)
        {
          if (list->getCount() == 0) list->insert(newStr(buffer));
          else list->atInsert(box->focused,newStr(buffer));
          UpdateListBox(box,list);
        }
        break;
      case cmEditEntry:
        if (list->getCount() == 0) break;
        strcpy(buffer,(char *)(list->at(box->focused)));
        if (inputBox(GT(TitleNewValue),GT(LabelNewValue),buffer,255) == cmOK)
        {
          int foc = box->focused;
          delete list->at(foc);
          list->atPut(foc,newStr(buffer)); 
          UpdateListBox(box,list);
        }
        break;
      default:
        break;
    }
  } while (result != cmCancel && result != cmOK && result != cmDefaultEntry);
  TProgram::deskTop->remove(dialog);
  delete dialog;
  return result;
}

void EditReserved()
{
  TSCollection *list;
  int i;
  ushort result;
  do
  {
    list = new TSCollection();
    for (i=0;i<ReservedWords->getCount();i++)
    {
      list->insert(newStr((char *)(ReservedWords->at(i))));
    }
    result = EditStringList(GT(TitleReservedWords),list);
    if (result == cmOK)
    {
      ReservedWords->freeAll();
      for (i=0;i<list->getCount();i++)
      {
        ReservedWords->insert(newStr((char *)(list->at(i))));
      }
      Repaint();
    }
    delete list;
    if (result == cmDefaultEntry)
    {
      DefaultReservedWords();
    }
  } while (result == cmDefaultEntry);
}

void EditUserWords()
{
  TSCollection *list;
  int i;
  ushort result;
  list = new TSCollection();
  for (i=0;i<UserWords->getCount();i++)
  {
    list->insert(newStr((char *)(UserWords->at(i))));
  }
  result = EditStringList(GT(TitleReservedWords),list,False);
  if (result == cmOK)
  {
    UserWords->freeAll();
    for (i=0;i<list->getCount();i++)
    {
      UserWords->insert(newStr((char *)(list->at(i))));
    }
    Repaint();
  }
}

static TSCollection *BuildStringList(TFlagCollection &coll)
{
  int i;
  TSCollection *list;
  list = new TSCollection();
  for (i=0;i<coll.getCount();i++)
  {
    list->insert(((TFlagEntry *)(coll.at(i)))->GetControlString());
  }
  return list;
}

static void BuildFlagList(TFlagCollection &coll,TSCollection *list)
{
  int i;
  coll.freeAll();
  for (i=0;i<list->getCount();i++)
  {
    coll.insert(new TFlagEntry((char *)(list->at(i))));
  }
}

static void EditFlags(const char *title,TFlagCollection & coll,
               void (*default_function)())
{
  TSCollection *list;
  ushort result;
  do
  {
    list = BuildStringList(coll);
    result = EditStringList(title,list);
    if (result == cmOK)
    {
      BuildFlagList(coll,list);
    }
    delete list;
    if (result == cmDefaultEntry)
    {
      default_function();
    }
  } while (result == cmDefaultEntry);
}

void EditCFlags()
{
  EditFlags(GT(TitleCFlags),*(Options.c_flags),DefaultCFlags);
}

void EditCXXFlags()
{
  EditFlags(GT(TitleCXXFlags),*(Options.cxx_flags),DefaultCXXFlags);
}

void EditDebugFlags()
{
  EditFlags(GT(TitleDebFlags),*(Options.debug_flags),DefaultDebugFlags);
}

void EditWarnFlags()
{
  EditFlags(GT(TitleWarnFlags),*(Options.warn_flags),DefaultWarnFlags);
}

void EditOptFlags()
{
  EditFlags(GT(TitleOptFlags),*(Options.opt_flags),DefaultOptFlags);
}

