/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
#define Uses_TParamList
#define Uses_TSCollection
#define Uses_TProject
#define Uses_TMsgCollection
#define Uses_LangTexte
#define Uses_TOptions
#define Uses_TDirList
#define Uses_MsgBox
#include <IDEClass.h>
#include "IDE.h"
#include <stdio.h>
#include <string.h>
#include <ctype.h>

void FSDB()
{
  TSCollection args;
  if (project_name)
  {
    char *path;
    Options.SrcDirs->ToString(path);
    if (*path)
    {
      AINSERT("-p");
      args.insert(path);
    }
    else
    {
      string_free(path);
    }
    AINSERT(Project.dest_name);
    AddProgArgs(args);
  }
  RunProgram("fsdb",args,False,False,False,True);
}

void GDB()
{
  TSCollection args;
  if (project_name)
  {
    int i;
    for (i=0;i<Options.SrcDirs->getCount();i++)
    {
      AINSERT("-d");
      AINSERT((char *)(Options.SrcDirs->at(i)));
    }
    AINSERT(Project.dest_name);
  }
  RunProgram("gdb",args,False,False,False,True);
}

static void CheckGrepMsg(const char *fname,const char *errname,TMsgCollection *msgs)
{
  char buffer[1000];
  int lineno;
  char *line,*message;
  FILE *f = fopen(fname,"r");
  while (fgets(buffer,999,f))
  {
    buffer[strlen(buffer)-1] = 0;
    line = strchr(buffer,':');
    if (!isdigit(line[1])) line = strchr(line+1,':');
    *line = 0;
    line++;
    message = strchr(line,':');
    *message = 0;
    message++;
    sscanf(line,"%d",&lineno);
    msgs->insert(new msg_rec(buffer,message,msgMessage,lineno));
  }
  fclose(f);
  f = fopen(errname,"r");
  while (fgets(buffer,999,f))
  {
    buffer[strlen(buffer)-1] = 0;
    msgs->insert(new msg_rec(NULL,buffer));
  }
  fclose(f);
}

void GREP()
{
  TParamList *params;
  TSCollection args;
  TMsgCollection *msgs;
  int i;
  params = new TParamList();
  if (EditParamList(params,GT(TitleGrep)) != cmOK)
  {
    delete params;
    return;
  }
  AINSERT("-n");
  for (i=0;i<params->getCount();i++)
  {
    AINSERT((char *)(params->at(i)));
  }
  delete params;
  msgs = new TMsgCollection();
  msgs->insert(new msg_rec(NULL,"running GREP:"));
  ShowMessages(msgs,True);
  RunProgram("grep",args,True,True,False,False);
  msgs = new TMsgCollection();
  CheckGrepMsg(cpp_outname,cpp_errname,msgs);
  if (!debug_tempfiles)
  {
    remove(cpp_outname);
    remove(cpp_errname);
  }
  ShowMessages(msgs,False);
}

void GPROF()
{
  TSCollection args;
  if (project_name)
  {
    char *point;
    point = strchr(Project.dest_name,'.');
    if (point != NULL)
    {
      messageBox("Because GPROF cannot read .exe files, you "
                 "must set up the main targetname without extension",
                 mfError | mfOKButton);
      return;
      
    }
  }
}

