/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
#define Uses_TProject
#define Uses_TProgram
#define Uses_TDeskTop
#define Uses_TEditWindow
#define Uses_TIDEFileEditor
#define Uses_TOptions
#define Uses_TDirList
#include <IDEClass.h>
#include "IDE.h"
#include <stdio.h>
#include <stdlib.h>
#ifdef INTERNAL_DEBUGGER
#include <libtvdebug.h>
#else

void (*select_source_line)(char *,int);

void handle_gdb_command(char *x)
{
  if (!x) return;
  return;
}

void init_gdb(char *x)
{
  if (!x) return;
  return;
}

void done_gdb()
{
}

void reset_gdb_output()
{
}

void reset_gdb_error()
{
}
#endif

int debugger_started = 0;

#define COMMAND(x) \
do {\
  handle_gdb_command(x);\
  reset_gdb_output();\
  reset_gdb_error();\
} while (0)

static void set_source_directories()
{
  int i;
  char command[1000];
  for (i=0;i<Options.SrcDirs->getCount();i++)
  {
    strcpy(command,"directory ");
    strcat(command,(char *)Options.SrcDirs->at(i));
    COMMAND(command);
  }
}

extern "C" void IDE_select_source_line(char *fname,int line)
{
fprintf(stdout,"(%s):%d\n",fname,line);
  TEditWindow *ew = OpenEditor(fname,True);
  goto_line(ew->editor,line);
}

static void INIT()
{
  init_gdb(Project.dest_name);
  set_source_directories();
  select_source_line = IDE_select_source_line;
}

void Goto()
{
  int line;
  const char *file;
  char *dir,*name,*ext;
  TEditWindow *ew = (TEditWindow *)TProgram::deskTop->current;
  if (!ew) return;
  TEvent event;
  char command[256];
  event.what = evCommand;
  event.message.command = cmEditorAnswer;
  ew->handleEvent(event);
  if (event.what != evNothing) return;
  file = ew->getTitle(100);
  split_fname(file,dir,name,ext);
  string_cat(name,ext);
  string_free(dir);
  string_free(ext);
  line = ew->editor->curPos.y+1;
  if (!debugger_started)
  {
    if (Make() == False) return;
    INIT();
  }
  sprintf(command,"break %s:%d",name,line);
  COMMAND(command);
  if (!debugger_started) COMMAND("run");
  else COMMAND("continue");
  sprintf(command,"clear %s:%d",name,line);
  COMMAND(command);
  string_free(name);
  debugger_started = 1;
}  
    
void Step()
{
  if (!debugger_started)
  {
    if (Make() == False) return;
    INIT();
    COMMAND("break main");
    COMMAND("run");
    COMMAND("clear main");
    debugger_started = 1;
  }
  else
  {
    COMMAND("next");
  }
}

void Trace()
{
  if (!debugger_started)
  {
    if (Make() == False) return;
    INIT();
    COMMAND("break main");
    COMMAND("run");
    COMMAND("clear main");
    debugger_started = 1;
  }
  else
  {
    COMMAND("step");
  }
}

void Reset()
{
  if (!debugger_started) return;
  done_gdb();
  debugger_started = 0;
}

void Continue()
{
  COMMAND("continue");
}

extern "C" void *mmalloc(void *ptr,size_t size)
{
  ptr = malloc(size);
fprintf(stdout,"mmalloc(%08x) ==> %08x\n",(unsigned)size,(unsigned)ptr);
  return ptr;
}

extern "C" void *mrealloc(void *ptr1,void *ptr2,size_t size)
{
  ptr1 = realloc(ptr2,size);
fprintf(stdout,"realloc(%08x,%08x) ==> %08x\n",(unsigned)ptr2,(unsigned)size,(unsigned)ptr1);
  return ptr1;
}

extern "C" void mfree(void *ptr1,void *ptr2)
{
  ptr1 = ptr2;
  free(ptr2);
fprintf(stdout,"mfree(%08x)\n",(unsigned)ptr1);
}

