/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
#if (__GNUC_MINOR__ < 7)
#pragma interface
#endif
#if !defined( __IDECLASS_H__ )
#define __IDECLAS_H__

#if defined (Uses_RawKeys)
#include "RawKeys.h"
#endif

#if !defined( __COMPILE_ID__ )
typedef enum {
  COMPILE_C,
  COMPILE_CC,
  COMPILE_ASM,
  COMPILE_FLEX,
  COMPILE_BISON,
  COMPILE_LINK,
  COMPILE_ARCHIVE,
  COMPILE_UNKNOWN,
  COMPILE_NONE,
  COMPILE_OBJC,
  COMPILE_FLEX_TO_C,
  COMPILE_FLEX_TO_CC,
  COMPILE_BISON_TO_C,
  COMPILE_BISON_TO_CC,
  COMPILE_PROJECT
} COMPILE_ID;

typedef enum {
  FILE_C_SOURCE,
  FILE_CC_SOURCE,
  FILE_FLEX_SOURCE,
  FILE_BISON_SOURCE,
  FILE_ASM_SOURCE,
  FILE_OBJECT,
  FILE_LIBRARY,
  FILE_COFF,
  FILE_HEADER,
  FILE_UNKNOWN,
  FILE_EXE,
  FILE_OBJC_SOURCE,
  FILE_PROJECT
} FILE_TYPE;
#define __COMPILE_ID__
#endif

#define IDE_CLASS_HC_BASE 2000
#define IDE_CLASS_CM_BASE 2000

const unsigned short
	hcFlagListBox		= IDE_CLASS_HC_BASE,
	hcWindowList		= IDE_CLASS_HC_BASE+1,
	hcProjectWindow		= IDE_CLASS_HC_BASE+2,
	hcProjectListBox	= IDE_CLASS_HC_BASE+3,
	hcMsgListBox		= IDE_CLASS_HC_BASE+4,
	hcIDEEditWindow		= IDE_CLASS_HC_BASE+5,
	hcIDEFileEditor		= IDE_CLASS_HC_BASE+6,
	hcNextMsg		= IDE_CLASS_HC_BASE+7,
	hcPrevMsg		= IDE_CLASS_HC_BASE+8,
	
        IDE_CLASS_LAST_HC	= IDE_CLASS_HC_BASE+9;

const unsigned short
	cmSelectWindow		= IDE_CLASS_CM_BASE,
	cmDeleteWindow		= IDE_CLASS_CM_BASE+1,
	cmEditorAnswer		= IDE_CLASS_CM_BASE+2,
	cmGotoEditorLine	= IDE_CLASS_CM_BASE+3,
	cmRedraw		= IDE_CLASS_CM_BASE+4,
	cmNextMsg		= IDE_CLASS_CM_BASE+5,
	cmPrevMsg		= IDE_CLASS_CM_BASE+6,
	cmSelectProject		= IDE_CLASS_CM_BASE+7,

	IDE_CLASS_LAST_CM	= IDE_CLASS_CM_BASE+8;

#define Uses_TStreamable
#define Uses_ipstream
#define Uses_opstream

#define s(TYPE)\
  TStreamableClass R##TYPE( T##TYPE::name, T##TYPE::build, __DELTA(T##TYPE));

#define n(TYPE)\
  const char * const T##TYPE::name = "T"#TYPE;

#if defined( Uses_THintStatusLine )
#define Uses_TStatusLine
#define __INC_THINTSTA__
#endif

#if defined( Uses_TMemInfo )
#define Uses_TView
#define __INC_TMEMINFO__
#endif

#if defined( Uses_TWindowList )
#define Uses_TListBox
#define __INC_TWINDOWL__
#endif

#if defined( Uses_TProjectWindow )
#define Uses_TDialog
#define __INC_TPRJWIND__
#endif

#if defined( Uses_TProjectListBox )
#define Uses_TSortedListBox
#define __INC_TPRJLIST__
#endif

#if defined( Uses_TProject )
#define Uses_TDependency
#define __INC_TPROJECT__
#endif

#if defined( Uses_TDepCollection )
#define Uses_TSortedCollection
#define __INC_TDEPENDE__
#endif

#if defined( Uses_TDirList )
#define Uses_TCollection
#define __INC_TDIRLIST__
#endif

#if defined( Uses_TParamList )
#define Uses_TCollection
#define __INC_TPARAMLI__
#endif

#if defined( Uses_TMsgCollection )
#define Uses_TCollection
#define __INC_TMSGCOLL__
#endif

#if defined( Uses_TMsgListBox )
#define Uses_TListBox
#define __INC_TMSGLIST__
#endif

#if defined( Uses_TDependency )
#define Uses_TObject
#define __INC_TDEPENDE__
#endif

#if defined( Uses_TOptions )
#define Uses_TObject
#define __INC_TOPTIONS__
#endif

#if defined( Uses_TSCollection )
#define Uses_TCollection
#define __INC_TSCOLLEC__
#endif

#if defined( Uses_TFlagListBox )
#define Uses_TListBox
#define __INC_TFLAGLIS__
#endif

#if defined( Uses_TFlagCollection )
#define Uses_TCollection
#define __INC_TFLAGCOL__
#endif

#if defined( Uses_TFlagEntry )
#define Uses_TObject
#define __INC_TFLAGENT__
#endif

#if defined( Uses_TIDEEditWindow )
#define Uses_TEditWindow
#define __INC_TIDEEDIT__
#endif

#if defined( Uses_TIDEFileEditor )
#define Uses_TFileEditor
#define __INC_TIDEFILE__
#endif

#include <tv.h>
#include "Utils.h"

#if defined( __INC_TMEMINFO__ )
#include "TMemInfo.h"
#endif

#if defined( __INC_TFLAGENT__ )
#include "TFlagEntry.h"
#endif

#if defined( __INC_TFLAGCOL__ )
#include "TFlagCollection.h"
#endif

#if defined( __INC_TFLAGLIS__ )
#include "TFlagListBox.h"
#endif

#if defined( __INC_TSCOLLEC__ )
#include "TSCollection.h"
#endif

#if defined( __INC_TOPTIONS__ )
#include "TOptions.h"
#endif

#if defined( __INC_TDEPENDE__ )
#include "TDependency.h"
#endif

#if defined( __INC_TDIRLIST__ )
#include "TDirList.h"
#endif

#if defined( __INC_TPARAMLI__ )
#include "TParamList.h"
#endif

#if defined( __INC_TPROJECT__ )
#include "TProject.h"
#endif

#if defined( __INC_TPRJLIST__ )
#include "TPrjListBox.h"
#endif

#if defined( __INC_TMSGCOLL__ )
#include "TMsgCollection.h"
#endif

#if defined( __INC_TMSGLIST__ )
#include "TMsgListBox.h"
#endif

#if defined( __INC_TPRJWIND__ )
#include "TPrjWindow.h"
#endif

#if defined( __INC_TWINDOWL__ )
#include "TWindowList.h"
#endif

#if defined( __INC_TIDEEDIT__ )
#include "TIDEEditWindow.h"
#endif

#if defined( __INC_TIDEFILE__ )
#include "TIDEFileEditor.h"
#endif

#if defined( __INC_THINTSTA__ )
#include "THintStatusLine.h"
#endif

#if defined( Uses_TEditWindow )

TEditWindow * OpenEditor(const char *,Boolean); // User have to define this
TEditWindow * is_on_desktop(const char *,Boolean is_full_name = False);

#endif

#endif
