/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
#define Uses_TEditWindow
#define Uses_TFileEditor
#include "IDEClass.h"
#include <string.h>
#include <sys/stat.h>
#include <ctype.h>
#include <dos.h>
#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>
#include <libc/dosio.h>
#include <sys/stat.h>

void split_fname(const char * filename,char * & dir,char * & file,char * & ext)
{
  char drive[3];
  char _dir[MAXLFN];
  char _name[MAXLFN];
  char _ext[MAXLFN];
  fnsplit(filename,drive,_dir,_name,_ext);
  string_dup(dir,drive);
  string_cat(dir,_dir);
  string_dup(file,_name);
  string_dup(ext,_ext);
}

extern "C" time_t _file_time_stamp(unsigned int);

long time_of_file(const char * fname)
{
  long retval;
#ifdef USE_STAT
  struct stat s;
  if (stat(fname,&s) == 0) retval = s.st_atime;
  else retval = 0;
#else
  struct ftime ft;
  int handle;
  handle = open(fname,O_RDONLY);
  if (handle < 0) retval = 0;
  else
  {
    getftime(handle,&ft);
    close(handle);
    retval = (long)_file_time_stamp(*((unsigned *)(&ft)));
  }
#endif
  return retval;
}

void string_dup(char * & dest,const char * src)
{
  int l = strlen(src);
  dest = new char[l+1];
  strcpy(dest,src);
}

void string_cat(char * & dest,const char * src)
{
  int l = strlen(dest)+strlen(src);
  char * tmp = new char[l+1];
  strcpy(tmp,dest);
  strcat(tmp,src);
  string_free(dest);
  dest = tmp;
}

void string_free(char * & dest)
{
  if (dest) delete dest;
  dest = NULL;
}

void string_down(char * dest)
{
  while (*dest) *dest = tolower(*dest++);
}

FILE_TYPE get_file_type(const char * ext)
{
  if (!ext) return FILE_UNKNOWN;
  if (!strcmp(ext,".c")) return FILE_C_SOURCE;
  if (!strcmp(ext,".i")) return FILE_C_SOURCE;
  if (!strcmp(ext,".cc")) return FILE_CC_SOURCE;
  if (!strcmp(ext,".cpp")) return FILE_CC_SOURCE;
  if (!strcmp(ext,".cxx")) return FILE_CC_SOURCE;
  if (!strcmp(ext,".ii")) return FILE_CC_SOURCE;
  if (!strcmp(ext,".C")) return FILE_CC_SOURCE; // note: capital C
  if (!strcmp(ext,".o")) return FILE_OBJECT;
  if (!strcmp(ext,".s")) return FILE_ASM_SOURCE;
  if (!strcmp(ext,".S")) return FILE_ASM_SOURCE;
  if (!strcmp(ext,".l")) return FILE_FLEX_SOURCE;
  if (!strcmp(ext,".y")) return FILE_BISON_SOURCE;
  if (!strcmp(ext,".a")) return FILE_LIBRARY;
  if (!strcmp(ext,".exe")) return FILE_EXE;
  if (!strcmp(ext,".h")) return FILE_HEADER;
  if (!strcmp(ext,".m")) return FILE_OBJC_SOURCE;
  if (!stricmp(ext,".gpr")) return FILE_PROJECT; // ignore case
  if (!*ext) return FILE_COFF;
  return FILE_UNKNOWN;
}

void BaseName(const char * name,char * & bname)
{
  char *dir,*ext;
  split_fname(name,dir,bname,ext);
  string_cat(bname,ext);
  string_free(dir);
  string_free(ext);
}

void BackslashToSlash(char *name)
{
  char *tmp;
  if (!name || !*name) return;
  while ((tmp = strchr(name,'\\')) != NULL) *tmp = '/';
}

void FExpand(char * & name)
{
  char fname[512];
  _fixpath(name,fname);
  string_free(name);
  string_dup(name,fname);
  if (!_USE_LFN) string_down(name);
}

COMPILE_ID how_to_compile(const char * ext_from,const char * ext_to)
{
  FILE_TYPE from=get_file_type(ext_from),to=get_file_type(ext_to);
  switch (from)
  {
    case FILE_PROJECT:
      switch (to)
      {
        case FILE_LIBRARY:
          return COMPILE_PROJECT;
        default:
          return COMPILE_UNKNOWN;
      }
    case FILE_FLEX_SOURCE:
      switch (to)
      {
        case FILE_OBJECT:
          return COMPILE_FLEX;
        case FILE_C_SOURCE:
          return COMPILE_FLEX_TO_C;
        case FILE_CC_SOURCE:
          return COMPILE_FLEX_TO_CC;
        default:
          return COMPILE_UNKNOWN;
      }
    case FILE_BISON_SOURCE:
      switch (to)
      {
        case FILE_OBJECT:
          return COMPILE_BISON;
        case FILE_C_SOURCE:
          return COMPILE_BISON_TO_C;
        case FILE_CC_SOURCE:
          return COMPILE_BISON_TO_CC;
        default:
          return COMPILE_UNKNOWN;
      }
    case FILE_OBJC_SOURCE:
      switch (to)
      {
        case FILE_OBJECT:
          return COMPILE_OBJC;
        default:
          return COMPILE_UNKNOWN;
      }
    case FILE_CC_SOURCE:
      switch (to)
      {
	case FILE_OBJECT:
	  return COMPILE_CC;
	default:
	  return COMPILE_UNKNOWN;
      }
    case FILE_C_SOURCE:
      switch (to)
      {
	case FILE_OBJECT:
	  return COMPILE_C;
	default:
	  return COMPILE_UNKNOWN;
      }
    case FILE_ASM_SOURCE:
      switch (to)
      {
	case FILE_OBJECT:
	  return COMPILE_ASM;
	default:
	  return COMPILE_UNKNOWN;
      }
    case FILE_UNKNOWN:
      switch (to)
      {
	case FILE_COFF:
	case FILE_EXE:
	  return COMPILE_LINK;
	case FILE_LIBRARY:
	  return COMPILE_ARCHIVE;
	default:
	  return COMPILE_UNKNOWN;
      }
    default:
      return COMPILE_UNKNOWN;
  }
}

