/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
#define Uses_TWindowList
#define Uses_TKeys
#define Uses_TEvent
#define Uses_TWindow
#define Uses_TCollection
#include "IDEClass.h"
#include <string.h>

void TWindowList::handleEvent(TEvent & event)
{
  TListBox::handleEvent(event);
  switch (event.what)
  {
    case evCommand:
      switch (event.message.command)
      {
	case cmSelectWindow:
	case cmDeleteWindow:
	  endModal(event.message.command);
	  clearEvent(event);
	  break;
	default:
	  break;
      }
      break;
    default:
      break;
  }
}

void TWindowList::newList(TCollection *coll)
{
  if (list() == NULL) TListBox::newList(coll);
  else
  {
    if (coll != 0)
    {
      setRange(coll->getCount());
      if (focused < range) focusItem(focused);
      else if (range > 0) focusItem(range-1);
    }
    else
    {
      setRange(0);
    }
    drawView();
  }
}

void TWindowList::getText(char *dest,ccIndex item,short maxlen)
{
  if (list() == NULL) strcpy(dest," ");
  else
  {
    TWindow *window = ((DeskTopWindow *)list()->at(item))->window;
    if (window->number != wnNoNumber)
    {
      *dest = '0' + window->number;
    }
    else *dest = '>';
    dest[1] = ' ';
    strcpy(dest+2,window->getTitle(68));
  }
}
