/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
#pragma implementation "TParamList.h"
#define Uses_TParamList
#define Uses_TStreamable

#include "IDEClass.h"
#include <string.h>
#include <stdio.h>

TStreamable *TParamList::build()
{
  return new TParamList( streamableInit );
}

Boolean TParamList::FromString(const char * liste)
{
  char *tmp,temp[256];
  int in_string,temp_pos,liste_pos=0;
  freeAll();
  if (!liste || !*liste) return True;
  string_dup(tmp,liste);
  temp_pos = 0;
  do
  {
    while (liste[liste_pos] && liste[liste_pos] == ' ') liste_pos++;
    if (!liste[liste_pos]) return True;
    temp_pos = 0;
    in_string = 0;
    while (1)
    {
      if (!liste[liste_pos])
      {
        if (in_string) return False;
        temp[temp_pos] = 0;
        break;
      }
      if (liste[liste_pos] == '\\' && liste[liste_pos+1] == '\'')
      {
        liste_pos++;
        temp[temp_pos++] = liste[liste_pos++];
        continue;
      }
      if (liste[liste_pos] == ' ')
      {
        if (!in_string)
        {
          temp[temp_pos] = 0;
          break;
        }
      }
      if (liste[liste_pos] == '\'')
      {
        in_string ^= 1;
        liste_pos++;
        continue;
      }
      temp[temp_pos++] = liste[liste_pos++];
    }
    string_dup(tmp,temp);
    insert(tmp);
  } while (1);
}

TParamList::TParamList(const char * liste) : TCollection(10,1)
{
  FromString(liste);
}

void TParamList::ToString(char * & result)
{
  int i;
  char *tmp;
  char temp[256];
  int temp_pos,tmp_pos,need_quote;
  string_dup(result,"");
  for (i=0;i<count;i++)
  {
    if (i != 0) string_cat(result," ");
    tmp = (char *)at(i);
    tmp_pos = temp_pos = 0;
    need_quote = 0;
    do
    {
      if (tmp[tmp_pos] == '\'')
      {
        temp[temp_pos++] = '\\';
      }
      if (tmp[tmp_pos] == ' ')
      {
        need_quote = 1;
      }
      temp[temp_pos++] = tmp[tmp_pos];
    } while (tmp[tmp_pos++]);
    if (need_quote)
    {
      string_cat(result,"'");
      string_cat(result,temp);
      string_cat(result,"'");
    }
    else
    {
      string_cat(result,temp);
    }
  }
}

void *TParamList::readItem(ipstream & is)
{
  return is.readString();
}

void TParamList::writeItem(void *data,opstream & os)
{
  os.writeString((const char *)data);
}

