/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
#define Uses_TMsgListBox
#define Uses_TMsgCollection
#define Uses_TEvent
#define Uses_TEditWindow
#define Uses_TIDEFileEditor
#define Uses_TKeys
#include "IDEClass.h"
#include <stdio.h>

static void selectMsg(msg_rec *rec)
{
  TEditWindow *ewindow;
  ewindow = is_on_desktop(rec->filename);
  if (!ewindow)
  {
    ewindow = OpenEditor(rec->filename,False);
    goto_line(ewindow->editor,rec->lineno);
  }
  ewindow->select();
}

void TMsgListBox::handleEvent(TEvent &event)
{
  msg_rec *rec;
  ccIndex index;
  TListBox::handleEvent(event);
  if (!list()) return;
  switch (event.what)
  {
#if 0
    case evKeyDown:
      switch (event.keyDown.keyCode)
      {
        case kbEnter:
          rec = (msg_rec *)list()->at(focused);
          if (rec->filename)
          {
            selectMsg(rec);
            clearEvent(event);
          }
          break;
        default:
          break;
      }
      break;
#endif
    case evCommand:
      switch (event.message.command)
      {
        case cmNextMsg:
          for (index=focused+1;index<range;index++)
          {
            rec = (msg_rec *)list()->at(index);
            if (rec->filename && rec->lineno > 0)
            {
              focusItem(index);
              selectMsg(rec);
              clearEvent(event);
              break;
            }
          }
          break;
        case cmPrevMsg:
          for (index=focused-1;index>=0;index--)
          {
            rec = (msg_rec *)list()->at(index);
            if (rec->filename && rec->lineno > 0)
            {
              focusItem(index);
              selectMsg(rec);
              clearEvent(event);
              break;
            }
          }
          break;
        default:
          break;
      }
    default:
      break;
  }
}

void TMsgListBox::focusItem(ccIndex item)
{
  TEditWindow *ewindow;
  msg_rec *rec = (msg_rec *)list()->at(item);
  TListBox::focusItem(item);
  if (!rec->filename) return;
  ewindow = is_on_desktop(rec->filename);
  if (!ewindow) return;
  if (rec->lineno > 0 ) goto_line(ewindow->editor,rec->lineno);
}

void TMsgListBox::selectItem(ccIndex item)
{
  TListBox::selectItem(item);
  msg_rec *rec = (msg_rec *)list()->at(focused);
  if (rec->filename) selectMsg(rec);
}

void TMsgListBox::getText(char *dest, ccIndex item, short maxLen)
{
#define LEN maxLen-strlen(dest)
  char temp[10];
  char tmp[1000];
  strcpy(tmp," ");
  if (!list()) return;
  msg_rec *rec = (msg_rec *)list()->at(item);
  if (!rec->filename)
  {
    strcpy(tmp,rec->msg);
  }
  else
  {
    if (rec->lineno > 0)
    {
      strcpy(tmp,rec->filename);
      strcat(tmp,"(");
      sprintf(temp,"%d",rec->lineno);
      strcat(tmp,temp);
      strcat(tmp,") ");
      switch (rec->type)
      {
        case msgError:
          strcat(tmp,"Error: ");
          break;
        case msgWarning:
          strcat(tmp,"Warning: ");
          break;
        default:
          break;
      }
    }
    else
    {
      *tmp = 0;
    }
    strcat(tmp,rec->msg);
  }
#undef LEN
  strncpy(dest,tmp,maxLen);
  dest[maxLen] = EOS;
}

