/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
#define Uses_TIDEFileEditor
#define Uses_TEvent
#define Uses_TStreamableClass
#define Uses_MsgBox
#define Uses_TKeys
#define Uses_TEditWindow
#define Uses_TPalette
#define Uses_TFileDialog
#define Uses_TProgram
#define Uses_TDeskTop
#define Uses_MsgBox
#include "IDEClass.h"
#include <utime.h>
#include <sys/stat.h>
#include <sys/timeb.h>
#include <stdio.h>

#define cpIDEFileEditor "\x06\x07\x08\x09\x0A\x0B\x0C\x0D\x0E\x0F\x10"\
			"\x11\x12\x13\x14"
/* colors for the editor
  0 : normal text
  1 : marked text
  2 : comment
  3 : reserved word
  4 : identifier
  5 : symbol
  6 : string
  7 : integer
  8 : float
  9 : octal
 10 : hex
 11 : character
 12 : preprocessor
 13 : illegal char
 14 : user defined word
*/

#define ID_Poner 0
#define ID_IrA   1

TPalette & TIDEFileEditor::getPalette() const
{
  static TPalette palette(cpIDEFileEditor, sizeof(cpIDEFileEditor)-1);
  return palette;
}

void * TIDEFileEditor::read(ipstream & is)
{
  struct stat st;
  TFileEditor::read(is);
  is.readBytes(Marcas,sizeof(Marcas));
  if (stat(fileName,&st) == 0)
  {
    edittime = st.st_atime;
  }
  else
  {
    struct timeb tb;
    ftime(&tb);
    edittime = tb.time;
  }
  return this;
}

TIDEFileEditor::TIDEFileEditor(const TRect & rect,TScrollBar *ahscrollbar,
				TScrollBar *avscrollbar,TIndicator *aindicator,
				const char *afilename) :
  TFileEditor(rect,ahscrollbar,avscrollbar,aindicator,afilename)
{
  struct stat st;
  if (stat(fileName,&st) == 0)
  {
    edittime = st.st_atime;
  }
  else
  {
    struct timeb tb;
    ftime(&tb);
    edittime = tb.time;
  }
  helpCtx = hcIDEFileEditor;
  memset(Marcas,0xff,sizeof(Marcas));
}

TStreamable *TIDEFileEditor::build()
{
  return new TIDEFileEditor(streamableInit);
}

TIDEFileEditor::TIDEFileEditor(StreamableInit) :
  TFileEditor(streamableInit)
{
}

void TIDEFileEditor::Marcar(int Accion, int Marca)
{
 if (Accion==ID_Poner)
   {
    Marcas[Marca]=curPtr;
   }
 else
   {
    if (Marcas[Marca]!=0xFFFFFFFF)
      {
       lock();
       setCurPtr(Marcas[Marca],0);
       update(ufView);
       trackCursor(True);
       //setSelect(selstart,selend,True);
       unlock();
      }
   }
}

static void readBlock(TEditor *editor)
{
  char fname[MAXLFN];
  strcpy(fname,"*.*");
  TFileDialog *d = new TFileDialog("*.*", "Read from file",
       "~N~ame", fdOpenButton, 100 );
  d->setData(fname);
  if ( TProgram::deskTop->execView( d ) != cmCancel )
  {
    uint32 c = editor->curPtr;
    d->getData(fname);
    TFileEditor *feditor = new TFileEditor(TRect(0,0,1,1),NULL,NULL,NULL,fname);
    editor->insertBuffer(feditor->buffer,feditor->bufPtr(0),feditor->bufLen,True,False);
    delete feditor;
    editor->setCurPtr(c,smExtend);
    editor->update(ufView);
  }
  delete d;
}

static void writeBlock(TEditor *editor)
{
  char fname[MAXLFN];
  TFileDialog *d;
  if (editor->selStart >= editor->selEnd) return;
  strcpy(fname,"*.*");
  d = new TFileDialog("*.*", "Write to file",
       "~N~ame", fdOpenButton, 100 );
  d->setData(fname);
  if ( TProgram::deskTop->execView( d ) != cmCancel )
  {
    FILE *f;
    d->getData(fname);
    delete d;
    f = fopen(fname,"rb");
    if (f)
    {
      fclose(f);
      if (messageBox(mfYesButton | mfNoButton | mfCancelButton | mfWarning,
                     "File %s exist. Overwrite ?",fname) != cmYes) return;
    }
    f = fopen(fname,"w+b");
    fwrite(editor->buffer+editor->selStart,1,editor->selEnd-editor->selStart,f);
    fclose(f);
    return;
  }
  delete d;
}

void TIDEFileEditor::handleEvent(TEvent & event)
{
  int savecmd = 0;
  Boolean old_modified = modified;

  if (event.what == evCommand &&
      event.message.command == cmSave &&
      modified == False)
  {
    clearEvent(event);
    return;
  }
  modified = False;
  if (event.what == evCommand &&
       ( event.message.command == cmSave ||
         event.message.command == cmSaveAs )) savecmd = 1;
  TFileEditor::handleEvent(event);
  if (event.what == evCommand)
    {
     switch (event.message.command)
       {
        case cmReadBlock:
          readBlock(this);
          clearEvent(event);
          break;
        case cmWriteBlock:
          writeBlock(this);
          clearEvent(event);
          break;
        case cmPonerMarca0:
        case cmPonerMarca1:
        case cmPonerMarca2:
        case cmPonerMarca3:
        case cmPonerMarca4:
        case cmPonerMarca5:
        case cmPonerMarca6:
        case cmPonerMarca7:
        case cmPonerMarca8:
        case cmPonerMarca9:
             Marcar(ID_Poner,event.message.command-cmPonerMarca0);
             clearEvent(event);
             break;
        case cmVaAMarca0:
        case cmVaAMarca1:
        case cmVaAMarca2:
        case cmVaAMarca3:
        case cmVaAMarca4:
        case cmVaAMarca5:
        case cmVaAMarca6:
        case cmVaAMarca7:
        case cmVaAMarca8:
        case cmVaAMarca9:
             Marcar(ID_IrA,event.message.command - cmVaAMarca0);
             clearEvent(event);
             break;
        case cmGotoEditorLine:
             int line = event.message.infoLong;
             int curline;
             uint32 selstart,selend;
             if (line < 0) line = 0;
             if (line > limit.y) line = limit.y;
             if (line == 0)
             {
               selstart = selend = 0;
             }
             else
             {
               curline = curPos.y+1;
               selstart = lineStart(lineMove(curPtr,line-curline));
               selend = lineEnd(selstart);
             }
             lock();
             setCurPtr(selstart,0);
             update(ufView);
             trackCursor(True);
             setSelect(selstart,selend,True);
             unlock();
             clearEvent(event);
             break;
       }
    }
  if (savecmd && modified == False)
  {
    struct utimbuf ut;
    ut.modtime = edittime;
    utime(fileName,&ut);
  }
  if (modified == True)
  {
    struct timeb tb;
    ftime(&tb);
    edittime = tb.time;
    update(ufView);
  }
  else if (!savecmd && old_modified == True)
  {
    modified = old_modified;
    update(ufUpdate);
  }
  if (event.what == evBroadcast && event.message.command == cmRedraw)
  {
    update(ufView);
  }
}

Boolean TIDEFileEditor::valid( ushort command )
{
    Boolean retval;
    struct utimbuf ut;
    if( command == cmValid )
        return isValid;
    else
        {
        if( modified == True )
            {
            int d;
            if( *fileName == EOS )
                d = edSaveUntitled;
            else
                d = edSaveModify;

            switch( editorDialog( d, fileName ) )
                {
                case cmYes:
                    retval = save();
                    if (retval == True)
                    {
                      ut.modtime = edittime;
                      utime(fileName,&ut);
                    }
                    return retval;
                case cmNo:
                    modified = False;
                    return True;
                case cmCancel:
                    return False;
                }
            }
        }
    return True;
}

void TIDEFileEditor::formatLine(void *Buffer,uint32 offset,int Width,ushort Colors)
{
  TFileEditor::formatLine(Buffer,offset,Width,Colors);
  if (formatline != NULL)
    formatline(this,Buffer,offset,Width,Colors);
}

formatlineProc TIDEFileEditor::formatline = NULL;

void goto_line(TFileEditor *editor,int line)
{
  TEvent ev;
  ev.what = evCommand;
  ev.message.command = cmGotoEditorLine;
  ev.message.infoLong = line;
  editor->handleEvent(ev);
}

void TIDEFileEditor::write( opstream& os )
{
    TFileEditor::write( os );
    os.writeBytes(Marcas,sizeof(Marcas));
}

