/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
/*       
  These strings are used for showing short hints in the statusline,
  when walking through the menu.
  The syntax is very simple. Each group of strings begins with
  'h(...' where the three dots stand for the help context number.
  The maximal length of a string should not exceed 65 characters.
  After the 'h(...' there is for each language the corresponding
  string preceded by a comma on a seperate line. At this time the
  following languages are supported:

    1. line   : English  (maintened by Robert Hhne)
         email: robert.hoehne@mathematik.tu-chemnitz.de
         
    2. line   : German   (maintened by Robert Hhne)
         email: robert.hoehne@mathematik.tu-chemnitz.de
         
    3. Line   : Spanish  (maintened by Salvador Eduardo Tropea (SET))
         email: ice@inti.edu.ar
         
    4. Line   : Frensh   (maintened by Eric Nicolas)
         email: nicolas@dsys.ceng.cea.fr
         
    5. Line   : Swedish  (maintened by Christian Axbrink)
         email: sa9471@ida.utb.hb.se
         
    6. Line   : Italian  (maintened by Normando Marcolongo)
         email: i094968@spv.ing.uniroma1.it
      
    7. Line   : Portuguese  (maintened by Goncalo Farias)
         email: mad@telepac.pt

    8. Line   : Dutch  (maintened by Martijn Laan)
         email: mlaan@cs.vu.nl

*/

  /* menu system */
h(About
/*eng*/,"show information about RHIDE"
/*ger*/,"zeigt Informationen ber RHIDE"
/*spa*/,"muestra la informacin acerca de RHIDE"
/*fre*/,"Informations sur RHIDE"
/*swe*/,"visa information om RHIDE"
/*ita*/,"Mostra informazioni su RHIDE"
/*por*/,"???"
/*dut*/,"toont informatie over RHIDE"
)
h(FSDB
/*eng*/,"Start the FSDB debugger"   
/*ger*/,"Started den debugger FSDB"   
/*spa*/,"Inicia el debugger (FSDB)"   
/*fre*/,"Dmarre le dbugger FSDB"
/*swe*/,"starta FSDB avlusare (debugger)"
/*ita*/,"Attiva il debugger FSDB"
/*por*/,"???"
/*dut*/,"start de FSDB debugger"
)
h(GREP
/*eng*/,"Running GREP (arguments are prompted)"
/*ger*/,"Startet GREP (Argumente werden abgefragt)"
/*spa*/,"Ejecutando GREP (se pedirn los parmetros)"
/*fre*/,"Excute GREP (Les arguments sont demands)"
/*swe*/,"kr GREP (argument efterfrgas)"
/*ita*/,"Esegue GREP (gli argomenti verranno richiesti)"
/*por*/,"???"
/*dut*/,"start GREP (na invoer parameters)"
)
h(Repaint
/*eng*/,"repaints the desktop"
/*ger*/,"zeichnet den Arbeitsbereich neu"
/*spa*/,"redibuja el Escritorio (Desktop)"
/*fre*/,"Redessine le bureau"
/*swe*/,"uppdaterar skrivbordet"
/*ita*/,"Ridisegna il desktop"
/*por*/,"???"
/*dut*/,"ververst het bureaublad"
)
h(GDB
/*eng*/,"Start the GDB debugger"   
/*ger*/,"Started den debugger GDB"   
/*spa*/,"Inicia el debugger (GDB)"   
/*fre*/,"Dmarre le dbugger GDB"
/*swe*/,"starta GDB avlusare (debugger)"
/*ita*/,"Attiva il debugger GDB"
/*por*/,"???"
/*dut*/,"start de GDB debugger"
)
  /* menu File */
h(Open
/*eng*/,"opens a file in the editor"
/*ger*/,"ffnet eine Datei in ein neues Editorfenster"
/*spa*/,"abre un archivo en el editor"
/*fre*/,"Ouvre un fichier dans l'diteur"
/*swe*/,"ppna en fil i ett nytt editorfnster"
/*ita*/,"Apre un file nell'editor"
/*por*/,"???"
/*dut*/,"opent een bestand in een nieuw tekstvenster"
)
h(New
/*eng*/,"create a new editor window"
/*ger*/,"erstellt ein neues Editorfenster"
/*spa*/,"crea una ventana nueva"
/*fre*/,"Cre une nouvelle fentre diteur"
/*swe*/,"skapa ett nytt editorfnster"
/*ita*/,"Crea una nuova finestra di edit"
/*por*/,"???"
/*dut*/,"opent een nieuw tekstvenster"
)
h(Save
/*eng*/,"save the current editor to disk (if modified)"
/*ger*/,"speichert das aktuelle Editorfenster (falls gendert)"
/*spa*/,"graba el contenido de la ventana actual (si fue modificada)"
/*fre*/,"Sauve l'diteur courant sur disque (si modifi)"
/*swe*/,"spara det aktiva editorfnstret till disk (om den ndrats)"
/*ita*/,"Salva il file nella finestra corrente (se modificato)"
/*por*/,"???"
/*dut*/,"slaat het huidige tekstvenster op (indien gewijzigd)"
)
h(SaveAs
/*eng*/,"save the current editor under a different name to disk"
/*ger*/,"speichert das aktuelle Editorfenster unter einem anderen Namen"
/*spa*/,"graba el contenido de la ventana actual con un nombre distinto"
/*fre*/,"Sauve l'diteur courant sur disque, sous un nouveau nom"
/*swe*/,"spara det aktiva editorfnstret med ett annat namn till disk"
/*ita*/,"Salva il file nella finestra corrente con un nome differente"
/*por*/,"???"
/*dut*/,"slaat het huidige tekstvenster op onder een nieuwe naam"
)
h(SaveAll
/*eng*/,"save all opened editors to disk (if modified)"
/*ger*/,"speichert alle geffneten Editorfenster (falls gendert)"
/*spa*/,"graba todas las ventanas modificadas"
/*fre*/,"Sauve tous les diteurs ouverts sur disque (si modifis)"
/*swe*/,"spara alla ppna editorfnster till disk (om de ndrats)"
/*ita*/,"Salva tutti gli editor aperti (se modificati)"
/*por*/,"???"
/*dut*/,"slaat alle geopende tekstvensters op (indien gewijzigd)"
)
h(DosShell
/*eng*/,"switch to DOS (call of %COMSPEC%, return with EXIT)"
/*ger*/,"geht zu MSDOS (Aufruf von %COMSPEC%, Rckkehr mit EXIT)"
/*spa*/,"sale a DOS (llama a %COMSPEC%, retorna con EXIT)"
/*fre*/,"Session DOS (appel de %COMSPEC%, retour en tapant EXIT)"
/*swe*/,"g tillflligt ver till DOS (anropar %COMSPEC%, tervnd med EXIT)"
/*ita*/,"Apre una sessione DOS (chiama %COMSPEC%, ritorna con EXIT)"
/*por*/,"???"
/*dut*/,"aktiveert DOS (roept %COMSPEC% aan en keert terug na EXIT)"
)
h(Quit
/*eng*/,"quits the IDE"
/*ger*/,"Beendet die IDE"
/*spa*/,"Abandona el programa"
/*fre*/,"Quitte RHIDE"
/*swe*/,"avslutar den integrerade programmeringsmiljn"
/*ita*/,"Esci da RHIDE"
/*por*/,"???"
/*dut*/,"beindigt RHIDE"
)
    
    /* menu Edit */
h(Undo
/*eng*/,"undoes the last edit command (no cursor moving)"
/*ger*/,"macht das letzte Editierkommando rckgngig (keine Cursorbewegung)"
/*spa*/,"deshace el ltimo comando de edicin (no los movimientos de cursor)"
/*fre*/,"Annule la dernire commande"
/*swe*/,"ngra det senaste editeringskommandot (ingen markrfrflyttning)"
/*ita*/,"Annulla l'ultimo comando (non i movimenti del cursore)"
/*por*/,"???"
/*dut*/,"maakt het laatste commando ongedaan (geen cursorbeweging)"
)
h(Cut
/*eng*/,"move the selected text to the clipboard"
/*ger*/,"verschiebt den ausgewhlten Text in die Zwischenablage"
/*spa*/,"mueve el texto seleccionado al portapapeles (clipboard)"
/*fre*/,"Dplace le texte slectionn vers le presse papier"
/*swe*/,"flytta den valda texten till klippbordet"
/*ita*/,"Muove la selezione corrente alla clipboard"
/*por*/,"???"
/*dut*/,"verplaatst de geselecteerde tekst naar het klembord"
)
h(Copy
/*eng*/,"copy the selected text to the clipboard"
/*ger*/,"kopiert den ausgewhlten Text in die Zwischenablage"
/*spa*/,"copia el texto seleccionado al portapapeles (clipboard)"
/*fre*/,"Copie le texte slectionn vers le presse papier"
/*swe*/,"kopiera den valda texten till klippbordet"
/*ita*/,"Copia la selezione corrente alla clipboard"
/*por*/,"???"
/*dut*/,"kopieert de geselecteerde tekst naar het klembord"
)
h(Paste
/*eng*/,"insert the selected text from the clipboard"
/*ger*/,"fgt den ausgewhlten Text aus der Zwischenablage ein"
/*spa*/,"inserta texto desde el portapapeles (clipboard)"
/*fre*/,"Insre la slection du presse papier  la position courante"
/*swe*/,"infoga den valda texten frn klippbordet"
/*ita*/,"Inserisce il testo dalla clipboard"
/*por*/,"???"
/*dut*/,"kopieert de in het klembord geselecteerde tekst"
)
h(ShowClip
/*eng*/,"shows the clipboard"
/*ger*/,"zeigt die Zwischenablage"
/*spa*/,"muestra el portapapeles (clipboard)"
/*fre*/,"Affiche le contenu du presse papier"
/*swe*/,"visa klippbordet"
/*ita*/,"Mostra il contenuto della clipboard"
/*por*/,"???"
/*dut*/,"toont het klembord"
)
h(Clear
/*eng*/,"delete the selected text "
/*ger*/,"lscht den ausgewhlten Text"
/*spa*/,"borra el texto seleccionado"
/*fre*/,"Efface le texte slectionn"
/*swe*/,"radera den valda texten"
/*ita*/,"Cancella il testo selezionato"
/*por*/,"???"
/*dut*/,"verwijdert de geselecteerde tekst"
)

    /* menu Search */
h(Find
/*eng*/,"find a string in the current editor"
/*ger*/,"sucht eine Zeichenkette im aktuellen Editorfenster"
/*spa*/,"busca palabras en la ventana actual"
/*fre*/,"Recherche une chane dans l'diteur actif"
/*swe*/,"hitta en textstrng i det aktuella editorfnstret"
/*ita*/,"Cerca una stringa nell'editor corrente"
/*por*/,"???"
/*dut*/,"zoekt een string in het huidige tekstvenster"
)
h(Replace
/*eng*/,"find and replace a string in the current editor"
/*ger*/,"sucht und ersetzt eine Zeichenkette im aktuellen Editorfenster"
/*spa*/,"busca y reemplaza palabras en la ventana actual"
/*fre*/,"Recherche et remplace une chane dans l'diteur actif"
/*swe*/,"hitta och erstt en textstrng i det aktuella editorfnstret"
/*ita*/,"Cerca e sostiuisce una stringa nell'editor corrente"
/*por*/,"???"
/*dut*/,"zoekt en vervangt een string in het huidige tekstvenster"
)
h(SearchAgain
/*eng*/,"repeat the last find- or replace-operation"
/*ger*/,"wiederholt die letzte Such- oder Ersetz-Operation"
/*spa*/,"repite la ltima operacin de bsqueda o reemplazo"
/*fre*/,"Recommence la dernire recherche ou recherche/remplacement"
/*swe*/,"upprepa den senaste hitta- eller erstt-operationen"
/*ita*/,"Ripete l'ultima operazione di ricerca o di sostituzione"
/*por*/,"???"
/*dut*/,"herhaalt de laatste zoek- of vervangoperatie"
)
h(GotoLine
/*eng*/,"go to line number (after prompting)"
/*ger*/,"gehe zur Zeilennummer (nach Abfrage)"
/*spa*/,"salta a la lnea que usted desee"
/*fre*/,"Se dplace directement  la ligne..."
/*swe*/,"g till viss rad (efter frga om radnummer)"
/*ita*/,"Salta ad una linea nell'editor (verr richiesta)"
/*por*/,"???"
/*dut*/,"gaat naar regelnummer (na invoer)"
)
h(NextMessage
/*eng*/,"select next message"
/*ger*/,"whle nchste Meldung aus"
/*spa*/,"selecciona el prximo mensaje"
/*fre*/,"Message suivant"
/*swe*/,"vlj nsta meddelande"
/*ita*/,"Seleziona prossimo messaggio"
/*por*/,"???"
/*dut*/,"springt naar de volgende mededeling"
)
h(PrevMessage
/*eng*/,"select previous message"
/*ger*/,"whle vorhergehende Meldung aus"
/*spa*/,"selecciona el mensaje anterior"
/*fre*/,"Message prcdent"
/*swe*/,"vlj fregende meddelande"
/*ita*/,"Seleziona messaggio precedente"
/*por*/,"???"
/*dut*/,"springt naar de vorige mededeling"
)
    /* menu Run */
h(Run
/*eng*/,"run the project-target (if executable after doing a make)"
/*ger*/,"fhrt das erzeugte Programm aus (falls ausfhrbar nach Make)"
/*spa*/,"ejecuta el .EXE generado (si es que pudo crearse)"
/*fre*/,"Excute la cible du project (s'il s'agit d'un excutable)"
/*swe*/,"kr projektets mlfil (om det gr efter att ha gjort en make)"
/*ita*/,"Esegue il .EXE (se si pu creare)"
/*por*/,"???"
/*dut*/,"start het programma (indien uitvoerbaar na Make)"
)
h(ProgArgs
/*eng*/,"enter commandline arguments for your program"
/*ger*/,"angeben der Kommandozeilenargumente fr das Programm"
/*spa*/,"permite ingresar la lnea de parmetros de su programa"
/*fre*/,"Entre des arguments de la ligne de commande pour la cible"
/*swe*/,"skriv in argument till kommandoraden fr ditt program "
/*ita*/,"Specifica la linea di comando per il tuo programma"
/*por*/,"???"
/*dut*/,"de commandline parameters van het programma instellen"
)
    /* menu Compile */
h(Compile
/*eng*/,"compile the current editor or the selected project-item"
/*ger*/,"bersetzt das aktuelle Editorfenster oder das ausgewhlte Projekt-Element"
/*spa*/,"compila la ventana actual o el item seleccionado en el proyecto"
/*fre*/,"Compile l'diteur courant ou l'lment de projet slectionn"
/*swe*/,"kompilera aktivt editorfnster eller vald delfil i projektet"
/*ita*/,"Compila il l'editor corrente o l'elemento del progetto selezionato"
/*por*/,"???"
/*dut*/,"compileert het huidige tekstvenster of het aktieve project"
)
h(Make
/*eng*/,"make the project (with checking auto-dependencies)"
/*ger*/,"fhrt ein Make zur Erzeugung des Programms (Bibliothek) durch"
/*spa*/,"hace el proyecto (crea el .EXE chequeando las dependencias)"
/*fre*/,"Construit le projet (avec auto-dpendances)"
/*swe*/,"skapa projektets mlfil (kontrollera beroenden mellan delfiler)"
/*ita*/,"Costruisce il progetto (crea il .EXE e controlla le dipendenze)"
/*por*/,"???"
/*dut*/,"voert Make uit voor het aktieve project"
)
h(Link
/*eng*/,"link the project or create the library"
/*ger*/,"linkt oder erzeugt nur das Programm/die Bibliothek"
/*spa*/,"linkea el proyecto o crea la librera"
/*fre*/,"Lie le projet ou cre la librairie"
/*swe*/,"lnka samman projektets mlfil eller skapa biblioteket"
/*ita*/,"Esegue il link del progetto o crea la libreria"
/*por*/,"???"
/*dut*/,"linkt of genereert het programma/de bibliotheek"
)
h(Build
/*eng*/,"build the project completely new"
/*ger*/,"erzeugt das Programm/die Bibliothek komplett neu"
/*spa*/,"rehace todo el proyecto de nuevo"
/*fre*/,"Reconstruit entirement le projet"
/*swe*/,"kompilera om alla delfiler och bygg projektet helt frn grunden"
/*ita*/,"Ricostruisce totalmente il progetto"
/*por*/,"???"
/*dut*/,"compileert alle items in het huidige project opnieuw"
)

    /* menu Project */
h(OpenProject
/*eng*/,"open a project"
/*ger*/,"ffnet ein Projekt"
/*spa*/,"abre un proyecto"
/*fre*/,"Ouvre un projet"
/*swe*/,"ppna ett projekt"
/*ita*/,"Apre un progetto"
/*por*/,"???"
/*dut*/,"opent een project"
)
h(CloseProject
/*eng*/,"close the current project"
/*ger*/,"schliet das aktuelle Projekt"
/*spa*/,"cierra el proyecto en curso"
/*fre*/,"Ferme le projet courant"
/*swe*/,"stng det aktiva projektet"
/*ita*/,"Chiude il progetto corrente"
/*por*/,"???"
/*dut*/,"sluit het huidige project"
)
h(AddProjectItem
/*eng*/,"add an item to the project"
/*ger*/,"hinzufgen von Dateien zum Projekt"
/*spa*/,"agrega un elemento al proyecto"
/*fre*/,"Ajoute un lement au projet"
/*swe*/,"lgg till en fil i projektet"
/*ita*/,"Aggiunge un elemento al progetto"
/*por*/,"???"
/*dut*/,"voegt een item toe aan het huidige project"
)
h(DelProjectItem
/*eng*/,"remove the selected item from the project"
/*ger*/,"entfernt das ausgewhlte Element aus dem Projekt"
/*spa*/,"quita el elemento seleccionado del proyecto"
/*fre*/,"enlve l'lment de projet slectionn"
/*swe*/,"ta bort den valda filen frn projektet"
/*ita*/,"Elimina un elemento dal progetto"
/*por*/,"???"
/*dut*/,"verwijdert een item uit het huidige project"
)
h(LocalOptions
/*eng*/,"enter local commandline options for compiling this item"
/*ger*/,"lokale Kommandozeilenargumente fr das bersetzen"
/*spa*/,"ingresa parmetros especiales para compilar este elemento en particular"
/*fre*/,"Entre des options locales pour la compilation de cet lment"
/*swe*/,"skriv in extra kompileringsvxlar srskilt fr denna delfil"
/*ita*/,"Inserisce opzioni locali di linea per compilare questo elemento"
/*por*/,"???"
/*dut*/,"de lokale compilatieopties voor het geselecteerde item instellen"
)
h(ShowIncludes
/*eng*/,"show the dependencies for the selected item"
/*ger*/,"zeigt die Abhngigkeiten (Include-Dateien) fr dieses Element"
/*spa*/,"muestra las dependencvas del elemento seleccionado"
/*fre*/,"Affiche les dpendences de l'lment de projet slectionn"
/*swe*/,"visa beroenden fr den valda filen"
/*ita*/,"Mostra le dipendenze per l'elemento selezionato"
/*por*/,"???"
/*dut*/,"toont de include-bestanden voor het geselecteerde item"
)
h(TargetName
/*eng*/,"change the name of the project-target"
/*ger*/,"ndert den Namen des erzeugten Programmes (Bibliothek)"
/*spa*/,"cambia el nombre del programa, o biblioteca, a generar"
/*fre*/,"Change le nom de la cible pour ce projet"
/*swe*/,"ndra namnet fr projektets mlfil"
/*ita*/,"Cambia il nome del risultato del progetto (.EXE o lib.)"
/*por*/,"???"
/*dut*/,"verandert de naam van het projectprogramma (of bibliotheek)"
)
    
    /* menu Windows */
h(Resize
/*eng*/,"resize/move the current window"
/*ger*/,"vergrert/verschiebt das aktuelle Fenster"
/*spa*/,"Ajustar el tamao o mover la ventana actual"
/*fre*/,"Change la taille/position de la fentre courante"
/*swe*/,"ndra storlek p/flytta det aktiva fnstret"
/*ita*/,"Ridimensiona/muove la finestra attuale"
/*por*/,"???"
/*dut*/,"het huidige venster schalen/verplaatsen"
)
h(Zoom
/*eng*/,"toggles between full size and previous size of the current window"
/*ger*/,"schaltet zwischen voller und vorhergehender Gre des Fensters um"
/*spa*/,"lleva a pantalla completa o a tamao normal la ventana en uso"
/*fre*/,"Bascule entre plein cran et taille normale pour la fentre courante"
/*swe*/,"skiftar mellan maximal och freg. storlek p det aktiva fnstret"
/*ita*/,"Sceglie tra finestra a dim. massima e dimensione precedente"
/*por*/,"???"
/*dut*/,"schakelt tussen maximale en vorige grootte van het venster"
)
h(Tile
/*eng*/,"show all editor windows simultaniously"
/*ger*/,"zeigt alle Editorfenster gleichzeitig"
/*spa*/,"ajusta el tamao de las ventanas para que se vean todas a la vez"
/*fre*/,"Montre tous les diteurs juxtaposs"
/*swe*/,"visa alla editorfnster samtidigt, sida vid sida"
/*ita*/,"Mostra tutti gli editor simultaneamente"
/*por*/,"???"
/*dut*/,"rangschikt alle venster op de voorgrond"
)
h(Cascade
/*eng*/,"show from each editor the title"
/*ger*/,"zeigt von jedem Editorfenster mindestens den Titel"
/*spa*/,"ajusta las ventanas para que se vean los ttulos de todas"
/*fre*/,"Montre tous les diteurs dcals"
/*swe*/,"visa alla editorfnster samtidigt, verlappande"
/*ita*/,"Mostra tutti gli editor simulataneamente in cascata"
/*por*/,"???"
/*dut*/,"rangschikt alle venster overlappend"
)
h(Next
/*eng*/,"switch to the next window on the desktop"
/*ger*/,"wechselt zum nchsten Fenster"
/*spa*/,"pasa a la prxima ventana en el escritorio (desktop)"
/*fre*/,"Bascule vers la fentre suivante"
/*swe*/,"skifta till nsta fnster p skrivbordet"
/*ita*/,"Passa alla prossima finestra nel desktop"
/*por*/,"???"
/*dut*/,"schakelt naar het volgende venster"
)
h(Prev
/*eng*/,"switch to the previous window on the desktop"
/*ger*/,"wechselt zum vorhergehenden Fenster"
/*spa*/,"pasa a la ventana anterior en el escritorio (desktop)"
/*fre*/,"Bascule vers la fentre prcdente"
/*swe*/,"skifta till fregende fnster p skrivbordet"
/*ita*/,"Passa alla finestra precedente nel desktop"
/*por*/,"???"
/*dut*/,"schakelt naar het vorige venster"
)
h(Close
/*eng*/,"close the current window"
/*ger*/,"schliet das auktuelle Fenster"
/*spa*/,"cierra la ventana en uso"
/*fre*/,"Ferme la fentre courante"
/*swe*/,"stng det aktiva fnstret"
/*ita*/,"Chiude la finestra attuale"
/*por*/,"???"
/*dut*/,"sluit het huidige venster"
)
h(ShowWindowList
/*eng*/,"show a list of all windows on the desktop"
/*ger*/,"zeigt eine Liste aller Fenster an"
/*spa*/,"muestra una lista de todas las ventanas del escritorio (desktop)"
/*fre*/,"Affiche la liste des fentres"
/*swe*/,"visa en lista ver alla fnster p skrivbordet"
/*ita*/,"Mostra la liste delle finestre presenti sul desktop"
/*por*/,"???"
/*dut*/,"toont een lijst met alle vensters"
)
h(ShowProject
/*eng*/,"show the project window"
/*ger*/,"zeigt das Projekt-Fenster"
/*spa*/,"muestra la ventana del proyecto"
/*fre*/,"Affiche la fentre de projet"
/*swe*/,"visa projektfnstret"
/*ita*/,"Mostra la finestra di progetto"
/*por*/,"???"
/*dut*/,"toont het projectvenster"
)
h(UserScreen
/*eng*/,"show the user screen"
/*ger*/,"zeigt den Nutzer-Bildschirm"
/*spa*/,"muestra la pantalla generada por nuestro programa"
/*fre*/,"Affiche l'cran utilisateur"
/*swe*/,"visa skrmbild med utmatning frn anvndarens program"
/*ita*/,"Mostra l'output del programma"
/*por*/,"???"
/*dut*/,"toont het gebruikersscherm"
)

    /* menu Options */
h(Directories
/*eng*/,"set various search paths for finding the files"
/*ger*/,"einstellen der Suchpfade"
/*spa*/,"permite indicar los caminos (paths) donde se buscarn los archivos"
/*fre*/,"Modifie les diffrents chemins de recherche de fichiers"
/*swe*/,"stll in diverse skvgar fr att hitta filerna"
/*ita*/,"Specifica percorsi di ricerca per i files"
/*por*/,"???"
/*dut*/,"de zoekpaden voor diverse bestanden instellen"
)
h(C_CXXCompiler
/*eng*/,"customize various options for the C/C++-compiler"
/*ger*/,"verschiedene Optionen fr den C/C++-Compiler"
/*spa*/,"ajusta varios parmetros del compilador de C/C++"
/*fre*/,"Ajuste les diffrentes options de compilation C/C++"
/*swe*/,"gr instllningar fr C/C++ kompilatorn"
/*ita*/,"Personalizza varie opzioni per il compilatore C/C++"
/*por*/,"???"
/*dut*/,"de opties van de C/C++ compiler instellen"
)
h(Libraries
/*eng*/,"set which libraries to be linked with the program"
/*ger*/,"welche Bibliotheken sollen hinzugelinkt werden"
/*spa*/,"para indicar que libreras sern enlazadas con el programa"
/*fre*/,"Spcifie les librairies  inclure dans le projet"
/*swe*/,"stll in vilka bibliotek som skall lnkas in i programmet"
/*ita*/,"Specifica quali librerie vanno linkate al programma"
/*por*/,"???"
/*dut*/,"de mee te linken bibliotheken instellen"
)
h(LinkerOptions
/*eng*/,"set additional flags to the linker"
/*ger*/,"spezielle Optionen fr den Linker"
/*spa*/,"ajusta parmetros adicionales del linker"
/*fre*/,"Ajuste les options du linker"
/*swe*/,"stll in ytterligare vxlar fr lnkaren"
/*ita*/,"Specifica opzioni addizionali per il Linker"
/*por*/,"???"
/*dut*/,"de speciale linkeropties instellen"
)
h(CompilerOptions
/*eng*/,"set addition flags to the compiler (defines, ...)"
/*ger*/,"zustzliche Optionen fr den Compiler (Defines, ...)"
/*spa*/,"ajusta parmetros adicionales del Compilador (#defines, ...)"
/*fre*/,"Ajuste les paramtres additionels du compilateur (#defines...)"
/*swe*/,"stll in ytterligare vxlar fr kompilatorn (defines, ...)"
/*ita*/,"Specifica opzioni addizionali per il compilatore (#define, ecc.)"
/*por*/,"???"
/*dut*/,"de speciale compileropties instellen (#defines, enz.)"
)
h(Environment
/*eng*/,"customize the IDE"
/*ger*/,"spezielle Optionen der IDE"
/*spa*/,"ajusta el aspecto de este programa"
/*fre*/,"Personalise RHIDE"
/*swe*/,"anpassa den integrerade programmeringsmiljn"
/*ita*/,"Personalizza la IDE"
/*por*/,"???"
/*dut*/,"de RHIDE opties instellen"
)
h(WriteMake
/*eng*/,"write a makefile for this project"
/*ger*/,"erzeugt ein Makefile zur Erzeugung des Projektes mit GNU-Make"
/*spa*/,"crea un 'makefile' a partir del proyecto (para el GNU make)"
/*fre*/,"Cre un fichier makefile  partir de ce projet"
/*swe*/,"skriv en makefil (GNU Make) fr detta projekt"
/*ita*/,"Scrive il 'makefile' per il progetto"
/*por*/,"???"
/*dut*/,"genereert een makefile voor het huidige project"
)

    /* menu Options|C/C++-compiler */
h(WarningFlags
/*eng*/,"customize the generating of warnings"
/*ger*/,"einstellen der Warnungsoptionen"
/*spa*/,"ajusta cuales advertencias (warnings) son reportadas"
/*fre*/,"Modifie les options pour les Warnings"
/*swe*/,"anpassa rapporteringen av varningar"
/*ita*/,"Personalizza la generazione dei warnings"
/*por*/,"???"
/*dut*/,"de waarschuwingsopties instellen"
)
h(OptimizationFlags
/*eng*/,"costumize, how to optimize the code"
/*ger*/,"einstellen der Optimierungsoptionen"
/*spa*/,"ajusta como ser optimizado el cdigo"
/*fre*/,"Modifie les options pour l'optimisation"
/*swe*/,"anpassa optimering av kod"
/*ita*/,"Personalizza l'ottimizzazione del codice"
/*por*/,"???"
/*dut*/,"de optimalisatieopties instellen"
)
h(DebugFlags
/*eng*/,"costumize the generating of debugging information"
/*ger*/,"einstellen der Debugoptionen"
/*spa*/,"ajusta que informacin de depuracin (debug) ser generada"
/*fre*/,"Modifie les options pour le debugging"
/*swe*/,"anpassa skapandet av information fr avlusning (debugging)"
/*ita*/,"Personalizza la generazione delle informazioni di debug"
/*por*/,"???"
/*dut*/,"de debugopties instellen"
)
h(CFlags
/*eng*/,"costumize C-compiler specific flags"
/*ger*/,"spezielle Optionen nur fr den C-Compiler"
/*spa*/,"ajusta parmetros especficos del compilador de C"
/*fre*/,"Modifie les options du compilateur C"
/*swe*/,"gr instllningar srskilt fr C-kompilatorn"
/*ita*/,"Personalizza opzioni specifiche del compilatore C"
/*por*/,"???"
/*dut*/,"de specifieke C-compileropties instellen"
)
h(CXXFlags
/*eng*/,"costumize C++-compiler specific flags"
/*ger*/,"spezielle Optione nur fr den C++-Compiler"
/*spa*/,"ajusta parmetros especficos del compilador de C++"
/*fre*/,"Modifie les options du compilateur C++"
/*swe*/,"gr instllningar srskilt fr C++ kompilatorn"
/*ita*/,"Personalizza opzioni specifiche del compilatore C++"
/*por*/,"???"
/*dut*/,"de specifieke C++-compiler opties instellen"
)

    /* menu Options|Directories */
h(IncludeDir
/*eng*/,"set where to search for include files"
/*ger*/,"Suchpfad fr Include-Dateien"
/*spa*/,"para indicar donde se buscarn los include (.h,.hpp)"
/*fre*/,"Modifie les chemins de recherche d'includes"
/*swe*/,"stll in skvg fr inkluderingsfiler (.h,.hpp)"
/*ita*/,"Specifica dove cercare i file da includere"
/*por*/,"???"
/*dut*/,"de zoekpaden voor include-bestanden instellen"
)
h(LibDir
/*eng*/,"set where to search for libraries"
/*ger*/,"Suchpfad fr Bibliotheken"
/*spa*/,"para indicar donde se buscarn las libreras (.a)"
/*fre*/,"Modifie les chemins de recherche des librairies"
/*swe*/,"stll in skvg fr bibliotek (.a)"
/*ita*/,"Specifica dove cercare le librerie"
/*por*/,"???"
/*dut*/,"de zoekpaden voor bibliotheken instellen"
)
h(ObjDir
/*eng*/,"set where to search for object files"
/*ger*/,"Suchpfad fr Object-Dateien"
/*spa*/,"para indicar donde se buscarn los object (.o)"
/*fre*/,"Modifie les chemins de recherche des fichiers objet .o"
/*swe*/,"stll in skvg fr objektkodsfiler (.o)"
/*ita*/,"Specifica dove cercare i file oggetto"
/*por*/,"???"
/*dut*/,"de zoekpaden voor objecten instellen"
)
h(SrcDir
/*eng*/,"set where to search for source files"
/*ger*/,"Suchpfad fr Quelldateien"
/*spa*/,"para indicar donde se buscarn los fuentes (.cc,.c,.cpp)"
/*fre*/,"Modifie les chemins de recherche des fichiers source"
/*swe*/,"stll in skvg fr kllkodsfiler (.cc,.c,.cpp)"
/*ita*/,"Specifica dove cercare i file sorgente"
/*por*/,"???"
/*dut*/,"de zoekpaden voor bronbestanden instellen"
)

    /* menu Options|Environment */
h(Colors
/*eng*/,"costumize the colors of the IDE"
/*ger*/,"einstellen der Farben der IDE"
/*spa*/,"ajusta los colores"
/*fre*/,"Ajuste les couleurs de RHIDE"
/*swe*/,"anpassa frgerna i programmeringsmiljn"
/*ita*/,"Personalizza i colori della IDE"
/*por*/,"???"
/*dut*/,"de kleuren van RHIDE instellen"
)
h(Preferences
/*eng*/,"set basic options for the IDE"
/*ger*/,"grundlegende Optionen der IDE"
/*spa*/,"ajusta las opciones bsicas"
/*fre*/,"Ajuste les options de base de RHIDE"
/*swe*/,"gr grundlggande instllningar fr programmeringsmiljn"
/*ita*/,"Personalizza opzioni base per la IDE"
/*por*/,"???"
/*dut*/,"de basisopties van RHIDE instellen"
)
h(EditReserved
/*eng*/,"edit the list of reserved words"
/*ger*/,"ndert die Liste der reservierten Wrter"
/*spa*/,"edita la lista de palabras reservadas"
/*fre*/,"Modifie la liste des mots rservs"
/*swe*/,"ndra i listan ver reserverade ord"
/*ita*/,"Edita la lista delle parole riservate"
/*por*/,"???"
/*dut*/,"de lijst met gereserveerde woorden bewerken"
)
h(EditCFlags
/*eng*/,"edit the list of flags for the C-compiler"
/*ger*/,"ndert die Liste der C-spezifischen Optionen"
/*spa*/,"edita la lista del parmetros del compilador de C"
/*fre*/,"Edite la liste des switchs pour le compilateur C"
/*swe*/,"ndra i listan ver giltiga vxlar till C-kompilatorn"
/*ita*/,"Edita la lista delle opzioni per il compilatore C"
/*por*/,"???"
/*dut*/,"de lijst met specifieke C-compiler opties bewerken"
)
h(EditCXXFlags
/*eng*/,"edit the list of flags for the C++-compiler"
/*ger*/,"ndert die Liste der C++-spezifischen Optionen"
/*spa*/,"edita la lista del parmetros del compilador de C++"
/*fre*/,"Edite la liste des switchs pour le compilateur C++"
/*swe*/,"ndra i listan ver giltiga vxlar till C++ kompilatorn"
/*ita*/,"Edita la lista delle opzioni per il compilatore C++"
/*por*/,"???"
/*dut*/,"de lijst met specifieke C++-compiler opties bewerken"
)
h(EditWarnFlags
/*eng*/,"edit the list of flags for warnings"
/*ger*/,"ndert die Liste der Warnungsoptionen"
/*spa*/,"edita la lista de parmetros de advertencia (warnings)"
/*fre*/,"Edite la liste des switchs pour les warnings"
/*swe*/,"ndra i listan ver varningsvxlar"
/*ita*/,"Edita la lista delle opzioni per i warnings"
/*por*/,"???"
/*dut*/,"de lijst met waarschuwingsopties bewerken"
)
h(EditDebugFlags
/*eng*/,"edit the list of flags for debugging"
/*ger*/,"ndert die Liste der Debugoptionen"
/*spa*/,"edita la lista de parmetros de depuracin (debug)"
/*fre*/,"Edite la liste des switchs pour le debugging"
/*swe*/,"ndra i listan ver vxlar fr avlusning (debug)"
/*ita*/,"Edita la lista delle opzioni per il debugging"
/*por*/,"???"
/*dut*/,"de lijst met debugopties bewerken"
)
h(EditOptFlags
/*eng*/,"edit the list of optimization flags"
/*ger*/,"ndert die Liste der Optimierungsoptionen"
/*spa*/,"edita la lista de parmetros de optimizacin"
/*fre*/,"Edite la liste des switchs pour l'optimisation"
/*swe*/,"ndra i listan ver optimeringsvxlar"
/*ita*/,"Edita la lista delle opzioni per l'ottimizzazione"
/*por*/,"???"
/*dut*/,"de lijst met optimalisatieopties bewerken"
)
h(EditUserWords
/*eng*/,"edit the list of user defined words (for syntaxhighlight)"
/*ger*/,"ndert die Liste der nutzerspez. Wrter (fr Syntaxhervorhebung)"
/*spa*/,"edita la lista de palabras del usuario para ser resaltadas"
/*fre*/,"Edit la liste des mots rservs \"user-defined\""
/*swe*/,"ndra i listan ver anvndardefinierade ord (fr syntaxupplysning)"
/*ita*/,"Edita la lista delle parole definite dall'utente"
/*por*/,"???"
/*dut*/,"de lijst met user defined woorden bewerken"
)
h(Help
/*eng*/,"opens the Info Viewer"
/*ger*/,"ffnet den Info Betrachter"
/*spa*/,"abre el Visor de .INFs (formato de Info)"
/*fre*/,"ouvre le viewer 'Info'"
/*swe*/,"ppnar Infogranskaren"
/*ita*/,"Apre visore 'INFO'"
/*por*/,"???"
/*dut*/,"start de InfoViewer"
)
h(ClearDependencies
/*eng*/,"remove the list of automaticly generated dependencies"
/*ger*/,"lscht die Liste der automatisch erzeugten Abhngkeiten"
/*spa*/,"borra la lista de dependencias generadas automaticamente"
/*fre*/,"efface la liste de toutes les dependances generees automatiquement"
/*swe*/,"ta bort listan ver automatiskt skapade beroenden"
/*ita*/,"remove the list of automaticly generated dependencies"
/*por*/,"???"
/*dut*/,"remove the list of automaticly generated dependencies"
)
h(MakeClear
/*eng*/,"remove all files, which can be rebuild with this project"
/*ger*/,"lscht alle Dateien, die mit diesem Project erzeugt werden knnen"
/*spa*/,"borra todos los archivos que pueden rehacerse con este proyecto"
/*fre*/,"efface tous les fichiers qui peuvent etre reconstruits"
/*swe*/,"ta bort alla filer som terskapas inom detta projekt"
/*ita*/,"remove all files, which can be rebuild with this project"
/*por*/,"???"
/*dut*/,"remove all files, which can be rebuild with this project"
)
