/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
/***************************************************************

   (c) 1996 by Salvador Eduardo Tropea (SET).
   e-mail: salvador@inti.edu.ar

   You can use this code for any purpose if you don't remove the
original copyright.

 Filename -       InfBase.cpp

 Functions
                  Member functions of following classes
                      TInfTopic
                      TInfIndex
                      TInfFile

***************************************************************/


#ifdef __GNUC__
#include <unistd.h>
#endif

#define Uses_TStreamableClass
#define Uses_TPoint
#define Uses_TStreamable
#define Uses_TRect
#define Uses_MsgBox
#include <tv.h>

#if !defined( __STDLIB_H )
#include <stdlib.h>
#endif // __STDLIB_H

#if !defined( __Inf_H )
#include "InfBase.h"
#endif  // __Inf_H

#if !defined( __UTIL_H )
#include "Util.h"
#endif  // __UTIL_H

#if !defined( __STRING_H )
#include <string.h>
#endif  // __STRING_H

#if !defined( __LIMITS_H )
#include <limits.h>
#endif  // __LIMITS_H

#if !defined( __STAT_H )
#include <sys\stat.h>
#endif  // __STAT_H

#if !defined( __CTYPE_H )
#include <ctype.h>
#endif  // __CTYPE_H

#if !defined( __IO_H )
#include <io.h>
#endif  // __IO_H

#pragma warn -dsz

#define DEBUG
#ifdef DEBUG
#include <conio.h>
#define Clava(a) { printf(a); getch(); exit(1); }
#else
#define Clava(a) exit(1)
#endif
/*
void *operator new(size_t size)
{
 void * p;

 size = size ? size : 1;
 p = malloc(size);
 if (p==NULL)
   {
    printf("Error Memoria AGOTADA!!!\n");
    getch();
    exit(1);
   }
 memset(p,1,size);

 return p;
}

void operator delete(void *p)
{
 if (p==NULL)
   {
    printf("Error Liberando un NULL!!!\n");
    getch();
    long pp=((long *)p)[0];
    printf("%lX\n",pp);
   }
 else
 free(p);
}
*/
// TInfTopic

void *TInfTopic::Read( TInfFile &File )
{
 FILE *f=File.stream;

 ReadNodeInfo(File);
 if (!Status)
   {
    ReadText(f);
    ReadCrossRefs();
   }
 width = 0;
 lastLine = INT_MAX;
 return this;
}


static void CopiarDatosDe(char *Tipo,char *Dest,char *Ori)
{
 char *pos,*s;
 int largo;

 if ((pos=strstr(Ori,Tipo))!=NULL)
   {
    pos+=strlen(Tipo)+2;
    for (s=pos,largo=0; *s && *s!='\n' && *s!='\r' && *s!=','; s++,largo++);
    *s=0;
    if (largo>MAX_NODE_NAME)
       Dest[0]=0;
    else
       strcpy(Dest,pos);
    *s=',';
   }
 else
   Dest[0]=0;
}

void TInfTopic::ReadNodeInfo(TInfFile &File)
{
 char Buf[256];
 FILE *f=File.stream;
 long Pos=ftell(f);

 do
   { fgets(Buf,256,f); }
 while(Buf[0]==31 || isspace(Buf[0]));
 if (strncmp(Buf,"File",4)==0)
   {
    CopiarDatosDe("Node",Node,Buf);
    CopiarDatosDe("Next",Next,Buf);
    CopiarDatosDe("Prev",Prev,Buf);
    CopiarDatosDe("Up",Up,Buf);
   }
 else
   {
    if (Buf[strlen(Buf)-2]=='\r')
      {
       if (messageBox("Attention !! this file is in DOS format,"
           " Do you want convert it?,"
           " Make a backup first !!", mfError | mfYesButton | mfNoButton)
           ==cmYes)
         {
          if (!File.ConvertIt(Pos))
            {
             Status=True;
             return;
            }
          ReadNodeInfo(File);
          return;
         }
       Status=True;
       return;
      }
    messageBox("Error: can't find the Node info",mfError | mfOKButton);
    Status=True;
    return;
   }
}

TInfTopic::TInfTopic( )
{
 numRefs = 0;
 crossRefs = 0;
 width = 0;
 lastOffset = 0;
 lastLine = INT_MAX;
 Text = NULL;
 Node[0]=Next[0]=Prev[0]=Up[0]=0;
 Status=False; // OK
};

void TInfTopic::ReadText( FILE *f )
{
 char Buf[256];
 char *s,*d;
 int i;
 int lWidth;

 // Primera pasada: mide
 long Pos=ftell(f);
 lSize=0;
 iLines=0;
 fgets(Buf,256,f);
 maxLineWidth = 0;
 do
  {
   lWidth = strlen(Buf);
   if (lWidth>maxLineWidth)
      maxLineWidth = lWidth;
   lSize+=lWidth;
   iLines++;
   fgets(Buf,256,f);
   for (s=Buf;*s;s++)
       if (*s=='\t')
          lSize+=6;
  }
 while (Buf[0]!=31 && !feof(f));

 // Arriba
 #ifndef __GNUC__
 if (lSize>60000L) Clava("TInfTopic::ReadText: Super los 60Kb\n");
 fseek(f,Pos,SEEK_SET);
 Text = new char[(size_t)lSize+1];
 #else
 fseek(f,Pos,SEEK_SET);
 Text = new char[lSize+1];
 #endif
 for (i=iLines, d=Text; i; --i)
    {
     fgets(Buf,256,f);
     for (s=Buf;*s;s++)
         if (*s=='\t')
            for (int j=7;j;--j) *d++=' ';
         else
           if (*s!='\r')
              *d++=*s;
    }
 *d=0;
}


static int IsDelimiterDeXX( int Val )
{
 return Val==' ' || Val=='\r' || Val=='\t' || Val=='\n' || Val=='.' ||
        Val==0  || Val==',' || Val==';' || Val==')'  || Val=='(';
}

static void TakeName(char *Buf,char *Nom,int &ini,int &largo,int &Linea, int &linebreak)
{
 char *s,*ori;
 int CruzaLin,OffEnProxLin=0,EnParentesis;

 ini+=1;
 largo=0;
 CruzaLin=0;
 // Quitar espacios indeceables
 for (ori=Buf+1; isspace(*ori) && *ori; ori++)
    {
     if (*ori=='\n')
       {
        // Opss se cay
        Linea++;
        ini=0;
       }
     else
        ini++;
    }
 // El primer : puesto ac no cuenta
 if (*ori==':')
   {
    ori++;
    ini++;
   }
 for (s=Nom; *ori; s++,ori++)
    {
     if (*ori==':')
       {
        if (!isalpha(ori[1]) || ( ori[1]==':' && IsDelimiterDeXX(ori[2]) ) )
           break;
        *s++=*ori++;
        largo++;
       }
     if (*ori=='\n')
       {
        *s++=' ';
        ori++;
        for (OffEnProxLin=0;*ori && isspace(*ori); ori++,OffEnProxLin++,largo++);
        CruzaLin=1;
        largo++;
       }
     else
       {
        if (CruzaLin)
           OffEnProxLin++;
        largo++;
       }
     *s=*ori;
    }
 *s=0;
 ori++;
 linebreak=OffEnProxLin;
 if (*ori==':') return;
 if (CruzaLin)
   {
    CruzaLin=0;
    Linea++;
    ini=++OffEnProxLin;
    OffEnProxLin=0;
   }
 else
    ini+=largo;
 largo=0;
 for (ini++;*ori && isspace(*ori); ori++,ini++)
    {
     if (*ori=='\n')
       {
        Linea++;
        ini=-1;
       }
    }
 EnParentesis=0;
 for (s=Nom; *ori && *ori!=':' && (*ori!='.' || EnParentesis) && *ori!=','; s++,ori++)
    {
     if (*ori=='\n')
       {
        *s++=' ';
        ori++;
        for (OffEnProxLin=0;*ori && isspace(*ori); ori++,OffEnProxLin++,largo++);
        CruzaLin=1;
        largo++;
       }
     else
       {
        if (CruzaLin)
           OffEnProxLin++;
        largo++;
        if (*ori=='(')
           EnParentesis=1;
        else
          if (EnParentesis && *ori==')')
             EnParentesis=0;
       }
     *s=*ori;
    }
 *s=0;
 linebreak=OffEnProxLin;
}

void TInfTopic::ReadCrossRefs( void )
{
 CrossRef *crossRefPtr;
 char Buf[256];
 int Linea,LineaMenu=0,iMenues;
 int OffInLine,Length,OffInThisLine,LineOfNote;
 // Para los notes
 char *cpPos,*cpFin,*cpMenu;
 int iNotes,iNAdd=0,iRAdd,iMAdd;

 // Barrer el texto buscando todos los *?ote y * Menu
 iNotes=0;
 cpMenu=cpFin=Text+(int)lSize-6;
 cpPos=Text;
 Linea=1;
 while (cpPos<cpFin)
    {
     if (*cpPos=='*' && cpPos[2]=='o' && cpPos[3]=='t'
         && cpPos[4]=='e' && isspace(cpPos[5]) )
       {
        iNotes++;
        cpPos+=4;
       }
     else
       if (!LineaMenu && *cpPos=='*' && cpPos[1]==' ' && cpPos[2]=='M'
           && cpPos[3]=='e' && cpPos[4]=='n' && cpPos[5]=='u')
         {
          cpMenu=cpPos;
          cpPos+=4;
          LineaMenu=Linea;
         }
       else
         if (*cpPos=='\n')
            Linea++;
     cpPos++;
    }

 // Medir el men
 Linea=LineaMenu+2;
 iMenues=0;
 do
  {
   cpPos=getLine(Linea++);
   if (*cpPos=='*')
      iMenues++;
  }
 while(Linea<iLines && (*cpPos=='*' || isspace(*cpPos) || *cpPos==0));

 numRefs=iMenues+iNotes;

 if (numRefs)
   {
    crossRefs = new CrossRef[numRefs];
    // Agregar todas las Note antes del men
    cpPos=Text;
    Linea=1;
    iRAdd=0;
    OffInThisLine=0;
    if (iNotes)
      {
       for (iNAdd=0; iNAdd<iNotes && cpPos<cpMenu; )
          {
           if (*cpPos=='*' && cpPos[2]=='o' && cpPos[3]=='t'
               && cpPos[4]=='e' && isspace(cpPos[5]))
             {
              cpPos+=4;
              OffInThisLine+=4;
              crossRefPtr = (CrossRef *)crossRefs + iRAdd;
              LineOfNote=Linea;
              OffInLine=OffInThisLine-1;
              TakeName(cpPos,Buf,OffInLine,Length,LineOfNote,crossRefPtr->linebreak);
              strcpy(crossRefPtr->Name,Buf);
              crossRefPtr->offset=OffInLine;
              crossRefPtr->line=LineOfNote;
              crossRefPtr->length=Length;
              iNAdd++;
              iRAdd++;
             }
           else
             if (*cpPos=='\n')
               {
                Linea++;
                OffInThisLine=0;
               }
           cpPos++;
           OffInThisLine++;
          }
      }
    if (iMenues)
      {
       Linea=LineaMenu+2;
       iMAdd=0;
       do
        {
         cpPos=getLine(Linea);
         if (*cpPos=='*')
           {
            crossRefPtr = (CrossRef *)crossRefs + iRAdd;
            LineOfNote=Linea;
            OffInLine=0;
            TakeName(cpPos,Buf,OffInLine,Length,LineOfNote,crossRefPtr->linebreak);
            strcpy(crossRefPtr->Name,Buf);
            crossRefPtr->offset=OffInLine;
            crossRefPtr->line=LineOfNote;
            crossRefPtr->length=Length;
            iMAdd++;
            iRAdd++;
           }
         Linea++;
        }
       while(iMAdd<iMenues);
      }
    // Agregar las que estn atrs del men
    if (iNotes && iNAdd<iNotes)
      {
       cpPos=cpMenu;
       Linea=LineaMenu;
       OffInThisLine=0;
       for (; iNAdd<iNotes && cpPos<cpFin; )
          {
           if (*cpPos=='*' && cpPos[2]=='o' && cpPos[3]=='t'
               && cpPos[4]=='e' && isspace(cpPos[5]))
             {
              cpPos+=4;
              OffInThisLine+=4;
              crossRefPtr = (CrossRef *)crossRefs + iRAdd;
              LineOfNote=Linea;
              OffInLine=OffInThisLine-1;
              TakeName(cpPos,Buf,OffInLine,Length,LineOfNote,crossRefPtr->linebreak);
              strcpy(crossRefPtr->Name,Buf);
              crossRefPtr->offset=OffInLine;
              crossRefPtr->line=LineOfNote;
              crossRefPtr->length=Length;
              iNAdd++;
              iRAdd++;
             }
           else
             if (*cpPos=='\n')
               {
                Linea++;
                OffInThisLine=0;
               }
           cpPos++;
           OffInThisLine++;
          }
      }
   }
}

TInfTopic::~TInfTopic()
{
 if (crossRefs != 0)
    delete crossRefs;
 if (Text!=NULL)
    delete Text;
}

void TInfTopic::getCrossRef( int i, TPoint& loc, uchar& length, char *& ref,
                             int &pl )
{
 CrossRef *crossRefPtr;

 crossRefPtr = crossRefs + i;
 loc.x = crossRefPtr->offset;
 loc.y = crossRefPtr->line;
 length = crossRefPtr->length;
 ref = crossRefPtr->Name;
 pl = crossRefPtr->linebreak;
}

char *TInfTopic::getLine( int line )
{
    int offset, i;
    char buffer[256];
    char *s;

    if (lastLine < line)
        {
        i = line;
        line -= lastLine;
        lastLine = i;
        offset = lastOffset;
        }
    else
        {
        offset = 0;
        lastLine = line;
        }
    buffer[0] = 0;
    while (offset < lSize)
    {
     --line;
     if (line == 0)
       {
        char *dest=buffer;
        // Barrer buscando el fin de lnea y copiando
        for (s=Text+offset; *s && *s!='\n'; s++,offset++,dest++) *dest=*s;
        if (*s=='\n')
          {
           offset++;
           *dest++=0;
          }
        lastOffset = offset;
        return buffer;
       }
     else
       {
        // Barrer buscando el fin de lnea
        for (s=Text+offset; *s && *s!='\n'; s++,offset++);
        if (*s=='\n') offset++;
       }
    }
    buffer[0] = 0;
    return buffer;
}

static int MatchFirstLet(char *s,int Val)
{
 for (;*s && !isalpha(*s);s++);
 return (toupper(*s)==Val);
}


int TInfTopic::SearchNextWith(int Key,int &selected)
{
 int i,j;

 if (selected<numRefs)
   {
    for (i=selected; i<numRefs; i++)
       {
        if (MatchFirstLet(crossRefs[i].Name,Key))
          {
           selected=i+1;
           return 1;
          }
       }
   }
 if (numRefs)
   {
    for (j=selected-1,i=0; i<j; i++)
       {
        if (MatchFirstLet(crossRefs[i].Name,Key))
          {
           selected=i+1;
           return 1;
          }
       }
   }
 return 0;
}


int TInfTopic::selBestMatch(char *match,int &PerfectMatch)
{
 PerfectMatch=0;
 if (match==0 || numRefs==0) return 0;

 int i,j,BestPoints=0,BestPos=-1;
 char Buf[MAX_NODE_NAME];
 char *s1,*s2;
 strupr(match);
 for (i=numRefs-1; i>=0; --i)
    {
     // Copy & struppr
     for (s1=crossRefs[i].Name, s2=Buf; *s1; s1++,s2++) *s2=toupper(*s1); *s2=0;
     // Compare
     for (s1=Buf, s2=match, j=0; *s1==*s2 && *s1; s1++,s2++,j++);
     if (j>BestPoints)
       {
        BestPoints=j;
        BestPos=i;
       }
    }
 PerfectMatch=((int)strlen(match)==BestPoints);
 return BestPos+1;
}

// TInfIndex
TInfIndex::~TInfIndex()
{
 if (Names!=NULL)
    delete Names;
 if (Offsets!=NULL)
    delete Offsets;
 if (IndOffsets!=NULL)
    delete IndOffsets;
 Names=NULL;
 Offsets=NULL;
 IndOffsets=NULL;
}


TInfIndex::TInfIndex( TInfFile& o, int Indirect )
{
 size = 0;
 indirects=0;
 Names=NULL;
 Offsets=NULL;
 IndOffsets=NULL;

 FILE *f=o.stream;
 Status = False; // OK

 // Indirecta => varios archivos
 long PosStream = ftell(f);
 if (Indirect)
   {
    // Medir
    do
     {
      o.GetLine();
      if (o.Buffer[0]==31) break;
      indirects++;
     }
    while (!feof(f));
    fseek(f,PosStream,SEEK_SET);
    // Cargar
    IndOffsets=new IndirectIndex[indirects];
    indirects=0;
    do
     {
      char *s,*ori;

      o.GetLine();
      if (o.Buffer[0]==31) break;
      s=IndOffsets[indirects].Name;
      ori=o.Buffer;
      for (;*ori && *ori!=':'; s++,ori++) *s=*ori;
      *s=0;
      ori++;
      IndOffsets[indirects].lPos=atol(ori);
      indirects++;
     }
    while (!feof(f));

    // Ir al ndice
    do
     {
      o.GetLine();
      if (strncmp(o.Buffer,"Tag Table",9)==0) break;
      o.SkipNode();
     }
    while(!feof(f));
    if (feof(f))
      {
       Status=True;
       return;
      }
    o.GetLine();
   }

 PosStream = ftell(f);
 // Primer pasada para ver la cantidad de elementos
 size=0;
 do
  {
   o.GetLine();
   if (o.Buffer[0]==31) break;
   if (strncmp(o.Buffer,"Node:",5)!=0)
     {
      Status=True;
      return;
     }
   size++;
  }
 while (!feof(f));

 fseek(f,PosStream,SEEK_SET);
 Names = new NameOfNode[size];
 Offsets = new long[size];
 if (Names==NULL || Offsets==NULL)
   {
    Status=True;
    return;
   }

 for (int i=0; i<size; i++)
    {
     char *Pos;

     o.GetLine();
     Pos=strchr(o.Buffer+5,127);
     if (Pos==NULL)
       {
        Status=True;
        return;
       }
     *Pos++=0;
     strcpy(Names[i],o.Buffer+6);
     Offsets[i]=atol(Pos);
    }
}

long TInfIndex::position(int i)
{
 if (i<size && !Status)
    return Offsets[i];
 return -1;
}

int TInfIndex::WhatIndex(char *Nom)
{
 int i;

 for (i=0; i<size; i++)
    {
     if (strcmp(Nom,Names[i])==0)
        return i;
    }
 return size+1;
}

int TInfIndex::SearchFirstWith(int Key,int &selected)
{
 int i;

 for (i=0; i<size; i++)
    {
     if (toupper(Names[i][0])==Key)
       {
        selected=i+1;
        return 1;
       }
    }
 return 0;
}



// TInfFile

void TInfFile::DoAll( char *Nombre, int Verbose )
{
 int Indirect=0;
 index=NULL;
 strcpy(NameOfFile,Nombre);
 // Volarle la extensin
 char *s;
 if ((s=strchr(NameOfFile,'.'))!=NULL) *s=0;
 Status=False; // OK

 stream=fOpen(Nombre);
 if (stream==NULL)
   {
    if (Verbose)
       messageBox("Attention can't open the file.", mfError | mfOKButton);
    Status=True;
    return;
   }

 // Buscar el Index
 do
  {
   GetLine();
   if (strncmp(Buffer,"Tag Table",9)==0) break;
   if (strncmp(Buffer,"Indirect:",9)==0) { Indirect=1; break; }
   SkipNode();
  }
 while(!feof(stream));

 // Si fall lola
 if (feof(stream))
   {
    Status=True;
    return;
   }

 // Levantarlo a RAM
 index=new TInfIndex(*this,Indirect);
 Status=index->Status;

 if (Indirect && !Status)
   { // Abrir la primera
    fclose(stream);
    iFile=0;
    stream=fOpen(index->IndOffsets[0].Name);
    if (stream==NULL)
      {
       Status=True;
       return;
      }
   }
}

int TInfFile::ExpandName(char *Buf, char *Nombre, int iExt)
{
 char *s=getenv("DJGPP");
 if (s==NULL)
   {
    Status=True;
    return 1;
   }
 strcpy(Buf,s);
 strupr(Buf);
 for (s=Buf; *s; s++) if (*s=='/') *s='\\';
 s=strstr(Buf,"DJGPP.ENV");
 if (s==NULL)
   {
    Status=True;
    return 1;
   }
 s[0]='I';s[1]='N';s[2]='F';s[3]='O';s[4]='\\';
 char *s2=Nombre;
 for (s+=5; *s2; s++,s2++) *s=*s2; *s=0;
 if (iExt && strchr(Nombre,'.')==NULL && access(Buf,0)!=0)
    s[0]='.';s[1]='I';s[2]='N';s[3]='F';s[4]=0;
 return 0;
}

FILE *TInfFile::fOpen(char *Nombre)
{
 char Buf[256];
 if (ExpandName(Buf,Nombre,1))
    return NULL;
 return fopen(Buf,"rb");
}

TInfFile::~TInfFile(void)
{
    if (index!=NULL)
       delete index;
    if (stream!=NULL)
       fclose(stream);
}

void TInfFile::SkipNode(void)
{
 do
  {
   GetLine();
  }
 while(Buffer[0]!=31 && !feof(stream));
}

int TInfFile::fSeek(long Pos)
{
 if (index->indirects)
   {
    int i;
    for (i=0; i<index->indirects && Pos>=index->IndOffsets[i].lPos; i++);
    if (--i!=iFile)
      {
       if (i==-1) return 1;
       iFile=i;
       if (stream!=NULL)
          fclose(stream);
       stream=fOpen(index->IndOffsets[i].Name);
       if (stream==NULL)
          return 1;
      }
    Pos=Pos-index->IndOffsets[i].lPos+index->IndOffsets[0].lPos;
   }
 return fseek(stream,Pos,SEEK_SET);
}


TInfTopic *TInfFile::getTopic( char *NameOri, int Verbose )
{
 long pos;
 char cFile[MAX_NODE_NAME];
 char *Name;
 int  WatchDog=MAX_NODE_NAME-1;

 Name=NameOri;
 // Ver de que archivo es
 if (Name[0]=='(')
   {
    char *s=Name+1,*s2=cFile;

    for (;*s!=')' && WatchDog;s++,s2++,WatchDog--) *s2=*s; *s2=0;
    if (!WatchDog)
      {
       printf("Guau ... guau!!");
       getch();
      }
    Name=s+1;

    if (strcmp(NameOfFile,cFile)!=0)
      { // Se pudri
       if (index!=NULL)
          delete index;
       if (stream!=NULL)
          fclose(stream);
       DoAll(cFile,Verbose);
       if (index==NULL)
          return(invalidTopic());
      }
   }
 if (Name[0]==0)
   {
    strcpy(NameOri,"(");
    strcat(NameOri,NameOfFile);
    strcat(NameOri,")Top");
    Name=strchr(NameOri,')')+1;
   }
 pos = index->position(index->WhatIndex(Name));
 if (pos > 0 )
     {
      fSeek(pos);
      TInfTopic *topic = new TInfTopic();
      topic->Read(*this);
      if (topic->Status)
        {
         delete topic;
         return(invalidTopic());
        }
      return topic;
     }
 else return(invalidTopic());
}

TInfTopic *TInfFile::invalidTopic()
{
    TInfTopic *topic;
    char invalidText[] = "\n Sorry i can't find this link (press ALT-F1).\n";

    topic =  new TInfTopic();
    topic->Text = newStr(invalidText);
    topic->lSize = strlen(invalidText);
    topic->iLines = 2;

    return topic;
}

int TInfFile::ConvertIt(long Pos)
{
 int ret=0,i;
 char *s;
 FILE *f;
 char Tempo[256],Ori[256];

 if (stream!=NULL)
    fclose(stream);
 i=0;
 do
   {
    if (i==index->indirects)
       ExpandName(Ori,NameOfFile,1);
    else
       ExpandName(Ori,index->IndOffsets[i].Name,1);
    stream=fopen(Ori,"rb");
    ExpandName(Tempo,"__infv__",0);
    f=fopen(Tempo,"wb");
    if (stream==NULL || f==NULL) return ret;
    do
     {
      GetLine();
      for (s=Buffer; *s; s++);
      if (*(s-2)=='\r')
        {
         *(s-2)='\n';
         *(s-1)=0;
        }
      fputs(Buffer,f);
     }
    while (!feof(stream));
    fclose(f);
    fclose(stream);
    remove(Ori);
    rename(Tempo,Ori);
    i++;
   }
 while (i<=index->indirects);

 // Test if convertion succesfull
 stream=fOpen(NameOfFile);
 if (stream==NULL) return ret;
 iFile++; // force reopen
 fSeek(Pos);
 return 1;
}


