/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
/***************************************************************

   (c) 1996 by Salvador Eduardo Tropea (SET).
   e-mail: salvador@inti.edu.ar, ice@inti.edu.ar

   You can use this code for any purpose if you don't remove the
original copyright.

 Filename -       InfBase.h

 Functions
                  Member functions of following classes
                      TInfTopic
                      TInfIndex
                      TInfFile

***************************************************************/

#ifndef __InfBase_H
#define __InfBase_H

#define cInfColor      "\x37\x3F\x3A\x13\x13\x30\x3E\x1E\x4E\x2E"
#define cInfBlackWhite "\x07\x0F\x07\x70\x70\x07\x0F\x70\x0F\x70"
#define cInfMonochrome "\x07\x0F\x07\x70\x70\x07\x0F\x70\x0F\x70"
#define cInfViewer     "\x06\x07\x08\x09"
#define cInfWindow     "\x40\x41\x42\x43\x44\x45\x46\x47\x48\x49"

#ifndef __STDIO_H
#include <stdio.h>
#endif //__STDIO_H


#define MAX_NODE_NAME 80


// structure CrossRef

struct CrossRef
{
 char Name[MAX_NODE_NAME];
 int offset;
 int line;
 int linebreak;
 uchar length;
};


// structure IndirectIndex

typedef struct
{
 long lPos;
 char Name[MAX_NODE_NAME];
} IndirectIndex;


// TInfTopic

class TInfFile;

class TInfTopic
{

public:

    TInfTopic( );
    virtual ~TInfTopic();

    void getCrossRef( int i, TPoint& loc, uchar& length, char *& ref, int &pl );
    char *getCrossRef( int i ) { return crossRefs[i].Name; };
    char *getLine( int line );
    int getNumCrossRefs() { return numRefs; };
    int numLines() { return iLines; };
    int maxWidth() { return maxLineWidth; };
    void setWidth( int aWidth ) { width = aWidth; };

    int selBestMatch(char *match,int &PerfectMatch);

    int numRefs;
    CrossRef *crossRefs;

    Boolean Status;

    void *Read( TInfFile& File  );

    // Lo que contiene
    char *Text;
    int  iLines;
    int  maxLineWidth;
    long lSize;

    char Node[MAX_NODE_NAME];
    char Next[MAX_NODE_NAME];
    char Prev[MAX_NODE_NAME];
    char Up[MAX_NODE_NAME];

    int SearchNextWith(int Key,int &selected);

    void ReadNodeInfo(TInfFile &File);

private:

    void ReadText( FILE *f );
    void ReadCrossRefs( void );
    int width;

    // Usadas por getLine
    int lastOffset;
    int lastLine;

};

// TInfIndex

typedef char NameOfNode[MAX_NODE_NAME];

class TInfIndex
{
public:

    TInfIndex( TInfFile& o, int Indirect );
    virtual ~TInfIndex();

    long position( int );
    int WhatIndex(char *Nom);

    int size;
    NameOfNode *Names;
    long *Offsets;
    IndirectIndex *IndOffsets;
    int indirects;
    Boolean Status;

    int SearchFirstWith(int Key,int &selected);
};


// TInfFile

class TInfFile
{

public:

    TInfFile( char *s ) { DoAll(s,1); };
    virtual ~TInfFile();
    void DoAll(char *s, int Verbose=0 );

    TInfTopic *getTopic( char *, int Verbose=1 );
    TInfTopic *invalidTopic();

    FILE *stream;
    Boolean Status;

    TInfIndex *index;
    long indexPos;
    int  iFile;

    char Buffer[256];
    void GetLine(void) { fgets(Buffer,256,stream); };
    void SkipNode(void);

    // Special I/O for multi-file
    int  fSeek(long Pos);
    FILE *fOpen(char *Nombre);

    char NameOfFile[MAX_NODE_NAME];

    int ConvertIt(long Pos);

private:
    int ExpandName(char *Buf, char *Nombre, int iExt);

};

#endif // __InfBase_H


