/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
/***************************************************************

   (c) 1996 by Salvador Eduardo Tropea (SET).
   e-mail: salvador@inti.edu.ar, ice@inti.edu.ar

   You can use this code for any purpose if you don't remove the
original copyright.

 Filename -       Inf.h

 Functions
                  Member functions of following classes
                      THelpControlDialog
                      TCollectionNoSort
                      TStrListBox

***************************************************************/

#if !defined( __Inf_H )
#define __Inf_H

#define Uses_TStreamable
#define Uses_TObject
#define Uses_TPoint
#define Uses_TRect
#define Uses_TEvent
#define Uses_TScroller
#define Uses_TScrollBar
#define Uses_TWindow
#define Uses_TCollection
#define Uses_TListBox
#include <tv.h>

#include "Infbase.h"

#define MAX_HIST_DEEP 40
#define MAX_NODE_NAME 80


const hcInfView=0x2100;
const cmInfHelp    = 0x2100,
      cmInfControl = 0x2101,
      cmInfBack    = 0x2102;

typedef struct
{
 char Name[MAX_NODE_NAME];
 TPoint HisPos;
 int HisSel;
} stHisto;


/***************************************************************

 class TCollectionNoSort

 Una TCollection pero instanciable.
 It's a TCollection but not pure vitual.

***************************************************************/

class TCollectionNoSort : public TCollection
{

public:

    TCollectionNoSort( short aLimit, short aDelta ) :
         TCollection(aLimit, aDelta) {};

private:

    virtual void freeItem( void *item )
        { delete item; }
    virtual const char *streamableName() const
        { return name; }
    virtual void *readItem( ipstream& is )
        { return is.readString(); }
    virtual void writeItem( void *obj, opstream& os )
        { os.writeString( (const char *)obj ); }

protected:

    TCollectionNoSort( StreamableInit ) : TCollection ( streamableInit ) {};

public:

    static const char * const near name;
    static TStreamable *build() {return new TCollectionNoSort( streamableInit );};

};

inline ipstream& operator >> ( ipstream& is, TCollectionNoSort& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TCollectionNoSort*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TCollectionNoSort& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TCollectionNoSort* cl )
    { return os << (TStreamable *)cl; }


// TInfIndicator

const infiLargo=80;

class TInfIndicator : public TView
{

public:

    TInfIndicator( const TRect& );

    virtual void draw();
    virtual TPalette& getPalette() const;
    virtual void setState( ushort, Boolean );
    void setValue( char *File, char *Node );

private:

    static const char near dragFrame;
    static const char near normalFrame;

    virtual const char *streamableName() const
        { return name; }
    char Cont[infiLargo];

protected:

    TInfIndicator( StreamableInit ) : TView( streamableInit ) {};

public:

    static const char * const near name;
    static TStreamable *build()
    { return new TInfIndicator( streamableInit ); };

};

inline ipstream& operator >> ( ipstream& is, TInfIndicator& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TInfIndicator*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TInfIndicator& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TInfIndicator* cl )
    { return os << (TStreamable *)cl; }



// TStrListBox

class TStrListBox : public TListBox
{
 public:
 TStrListBox(const TRect& r,ushort l,TScrollBar *a) : TListBox(r,l,a) {};
 void handleEvent(TEvent& event);
};

const cmStrChoose=8090;



// THelpControlDialog

const chcdNext=100,
      chcdPrev=101,
      chcdUp=102,
      chcdPrevH=103,
      chcdHide=104,
      chcdHistSel=200;

class THelpControlDialog : public TDialog
{
 public:
 THelpControlDialog(TCollectionNoSort *oCol);
 void handleEvent(TEvent& event);
 void getData(void *rec) { *(int *)rec=Comando; };
 void setData(void *rec) { Comando=*(int *)rec; };

 private:
 int Comando;
};




// TInfViewer

class TInfViewer : public TScroller
{
public:

    TInfViewer( const TRect&, TScrollBar*, TScrollBar*, TInfFile*, char *,
                TInfIndicator *,char *match );
    ~TInfViewer();

    virtual void changeBounds( const TRect& );
    virtual void draw();
    virtual void scrollDraw();
    virtual void resetCursor();
    virtual TPalette& getPalette() const;
    virtual void handleEvent( TEvent& );
    void makeSelectVisible();
    void makeVisible(TPoint&,int largo);

    void switchToTopic( char *, TPoint );
    void switchToTopic( char * );
    void switchToTopic( stHisto *h );

    TInfFile *hFile;
    TInfTopic *topic;
    int selected;

    // Search stuff
    void find();
    void makeSearch();
    int  searchInCurrentTopic(int Linea,int Col,int largo);
    int searchInCurrentFile(int Linea,int Col,int largo);
    int LineStartSelect;
    int LineEndSelect;
    int ColStartSelect;
    int ColEndSelect;
    char *lastSearch;
    char findStr[80];
    ushort findType;
    ushort findWhere;
    int    TopicInSearch;
    int    FileInSearch;
    Boolean TextSelected;
    stHisto OriginalPlace;
    int OpenVerbose;       // 1 normally, 0 if no warning on open (search)


private:
    TCollectionNoSort *History;
    int HistPoint;
    void  AddToHistory(char *);
    char *TakeFromHistory(TPoint& Pos);
    TInfIndicator *Indic;

};

const fitWWord=2, fitCaseSens=1;
const fitInTopic=0, fitInFile=1, fitInDir=2;
const fitNotInTopic=-1;


// TInfWindow

class TInfWindow : public TWindow
{
public:

    TInfWindow( TInfFile*, char *context, char *match=0 );

    virtual TPalette& getPalette() const;
};

// Structure to hold the info returned by the dialog
struct TFindInfDialogRec
{
 TFindInfDialogRec(char *findStr, ushort flags1, ushort flags2)
  {
   strcpy(find,findStr);
   options=flags1;
   ops2=flags2;
  }
 char find[80];  // for TInputLine of 80
 ushort options; // for TCheckBoxes   Type
 ushort ops2;    // for TRadioButtons Where
};

TDialog *createGoToDialog();

#endif  // __Inf_H
